<?php

/**
 * Element Controls
 */
 
 
// forms list
pc_reg_form_ct();
$reg_forms = get_terms('pc_reg_form', 'hide_empty=0&order=DESC');	

$reg_form_array = array();
foreach($reg_forms as $rf) {
	$reg_form_array[] = array(
		'value' => $rf->term_id,
		'label' => $rf->name
	);
}
 
 

/* FIELDS */
$fields = array(
	'fid' => array(
		'type'    => 'select',
		'ui' => array(
			'title'   => __('Which form to use?', 'pc_ml'),
			'tooltip' => '',
		),
		'options' => array(
			'choices' => $reg_form_array
		),
	),
	
	'layout' => array(
		'type'    => 'select',
		'ui' => array(
			'title'   => __('Layout', 'pc_ml'),
			'tooltip' => '',
		),
		'options' => array(
			'choices' => array(
				array('value' => '', 		'label' => __('Default one', 'pc_ml')),
				array('value' => 'one_col', 'label' => __('Single column', 'pc_ml')),
				array('value' => 'fluid',	'label' => __('Fluid (multi column)', 'pc_ml')),
			)
		)
	),
		
	'custom_categories' => array(
		'type'    => 'multi-choose',
		'ui' => array(
			'title'   => __('Custom categories assignment (ignored if field is in form)', 'pc_ml'),
			'tooltip' => '',
		),
		'options' => array(
			'choices' => (array)pc_cs_uc_array(false)
		)
	),
	
	'redirect' => array(
		'type'  => 'text',
		'ui' 	=> array(
			'title'   => __('Custom redirect (use a valid URL)', 'mg_ml'),
			'tooltip' => '',
		)
	),
	
	'align' => array(
		'type'    => 'select',
		'ui' => array(
			'title'   => __('Alignment', 'pc_ml'),
			'tooltip' => '',
		),
		'options' => array(
			'choices' => array(
				array('value' => 'center', 	'label' => __('Center', 'pc_ml')),
				array('value' => 'left', 	'label' => __('Left', 'pc_ml')),
				array('value' => 'right',	'label' => __('Right', 'pc_ml')),
			)
		)
	),
	
);


return $fields;
