<?php

class Wordpress_Print_Posts_Widget extends WP_Widget
{
    /**
     * Register Print Posts / Pages Widget
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://woocommerce.db-dzine.de
     */
    public function __construct()
    {
        $options = array( 
            'classname' => 'wordpress_print_posts',
            'description' => __('This will show print links to current post / page.', 'wordpress-print-posts'),
        );

        parent::__construct('wordpress_print_posts', __('Print Posts / Pages', 'wordpress-print-posts'), $options);
    }

    /**
     * Widget output
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://woocommerce.db-dzine.de
     * @param   [type]                         $args     [description]
     * @param   [type]                         $instance [description]
     * @return  [type]                                   [description]
     */
    public function widget($args, $instance)
    {
        global $wordpress_print_posts_options;

        $this->options = $wordpress_print_posts_options;

        if( is_category() || is_singular('product') || is_author() || is_tag()) {
            return FALSE;
        }

        $this->post_url = get_permalink();

        extract($instance);

        $html = $args['before_widget'];
        if ( ! empty( $instance['title'] ) ) {
            $html .= $args['before_title'] . apply_filters( 'widget_title', $title ). $args['after_title'];
        }

        if ( ! empty( $instance['text'] ) ) {
            $html .= '<p>' . $text . '</p>';
        }

        $html .= '<div class="wordpress-print-posts link-wrapper">';

        $html .= $this->get_pdf_link();
        $html .= $this->get_word_link();
        $html .= $this->get_print_link();
                
        $html .= '</div>';
        
        $html .= $args['after_widget'];

        echo $html;
    }

    private function get_pdf_link()
    {
        if(!$this->get_option('enablePDF')) return FALSE;

        return '<a href="' . $this->post_url . '?print-posts=pdf'.'" target="_blank"><i class="fa fa-file-pdf-o ' . $this->get_option('iconSize') . '"></i></a>';
    }

    private function get_word_link()
    {
        if(!$this->get_option('enableWord')) return FALSE;

        return '<a href="' . $this->post_url . '?print-posts=word'.'" target="_blank"><i class="fa fa-file-word-o ' . $this->get_option('iconSize') . '"></i></a>';
    }

    private function get_print_link()
    {
        if(!$this->get_option('enablePrint')) return FALSE;

        return '<a href="#"
        onclick="print(); return false;" target="_blank"><i class="fa fa-print ' . $this->get_option('iconSize') . '"></i></a>
        <script>
            function print() {
                var w = window.open("' . $this->post_url . '?print-posts=print");
            }
        </script>';
    }

    /**
     * Save widget options
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://woocommerce.db-dzine.de
     * @param   [type]                         $new_instance [description]
     * @param   [type]                         $old_instance [description]
     * @return  [type]                                       [description]
     */
    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['text'] = ( ! empty( $new_instance['text'] ) ) ? strip_tags( $new_instance['text'] ) : '';

        return $instance;
    }

    /**
     * Output admin widget options form
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://woocommerce.db-dzine.de
     * @param   [type]                         $instance [description]
     * @return  [type]                                   [description]
     */
    public function form($instance)
    {
        // Title
        $title = ! empty( $instance['title'] ) ? $instance['title'] : __( 'Title', 'wordpress-print-posts' );
        $text = ! empty( $instance['text'] ) ? $instance['text'] : __( 'Text Before Links', 'wordpress-print-posts' );
        ?>
        <p>
        <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label> 
        <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
        </p>
        <?php 
        // Text
        ?>
        <p>
        <label for="<?php echo $this->get_field_id( 'text' ); ?>"><?php _e( 'Select Your Country:' ); ?></label> 
        <input class="widefat" id="<?php echo $this->get_field_id( 'text' ); ?>" name="<?php echo $this->get_field_name( 'text' ); ?>" type="text" value="<?php echo esc_attr( $text ); ?>">
        </p>
        <?php 
    }

    /**
     * Gets options
     *
     * @since    1.0.0
     */
    private function get_option($option)
    {
        if(!is_array($this->options)) {
            return false;
        }
        
        if(!array_key_exists($option, $this->options))
        {
            return false;
        }
        return $this->options[$option];
    }
}
