<?php

    /**
     * For full documentation, please visit: http://docs.reduxframework.com/
     * For a more extensive sample-config file, you may look at:
     * https://github.com/reduxframework/redux-framework/blob/master/sample/sample-config.php
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = "wordpress_print_posts_options";

    // Get Custom Meta Keys for post
    global $wpdb;
    $sql = "SELECT DISTINCT meta_key
                    FROM " . $wpdb->postmeta . "
                    INNER JOIN  " . $wpdb->posts . " 
                    ON post_id = ID
                    WHERE post_type <> 'product' AND post_type <> 'product_variation'
                    ORDER BY meta_key ASC";

    $meta_keys = $wpdb->get_results( $sql, 'ARRAY_A' );
    $meta_keys_to_exclude = array('_crosssell_ids', '_children', '_default_attributes', '_height', '_length', '_max_price_variation_id', '_max_regular_price_variation_id', '_max_sale_price_variation_id', '_max_variation_price', '_max_variation_regular_price', '_max_variation_sale_price', '_min_price_variation_id', '_min_regular_price_variation_id', '_min_sale_price_variation_id', '_min_variation_price', '_min_variation_regular_price', '_min_variation_sale_price', '_price', '_post_attributes', '_post_image_gallery', '_sku', '_regular_price', '_sale_price', '_sale_price_dates_from', '_sale_price_dates_to', '_sku', '_upsell_ids', '_thumbnail_id', '_weight', '_width');

    $temp = array(
                array(
                    'id'       => 'exclusions',
                    'type'     => 'section',
                    'title'    => __( 'Custom Post Fields', 'wordpress-pdf-catalog' ),
                    'subtitle' => __( 'With the below settings you can show custom post meta keys for the posts.', 'wordpress-pdf-catalog' ),
                    'indent'   => false,
                ),
    );

    foreach ($meta_keys as $key => $meta_key) {
        $meta_key = preg_replace('/[^\w-]/', '', $meta_key['meta_key']);

        if(in_array($meta_key, $meta_keys_to_exclude) || (substr( $meta_key, 0, 7 ) === "_oembed")) {
            continue;
        }
        $temp[$meta_key] = $meta_key;

        $temp[] = 
            array(
                'id'       => 'showCustomMetaKey_' . $meta_key,
                'type'     => 'checkbox',
                'title'    => __( 'Show Custom Meta Key ' . $meta_key, 'wordpress-print-posts' ),
                'default'   => 0,
            );

        $temp[] = 
            array(
                'id'       => 'showCustomMetaKeyText_' . $meta_key,
                'type'     => 'text',
                'title'    => __( 'Text before Custom Meta Key ' . $meta_key, 'wordpress-print-posts' ),
                'default'   => $meta_key,
                'required' => array('showCustomMetaKey_' . $meta_key, 'equals' , '1'),
            );
    }

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        'opt_name' => 'wordpress_print_posts_options',
        'use_cdn' => TRUE,
        'dev_mode' => FALSE,
        'display_name' => 'WordPress Print Posts',
        'display_version' => '1.1.6',
        'page_title' => 'WordPress Print Posts',
        'update_notice' => TRUE,
        'intro_text' => '',
        'footer_text' => '&copy; '.date('Y').' weLaunch',
        'admin_bar' => TRUE,
        'menu_type' => 'submenu',
        'menu_title' => 'Print Posts',
        'allow_sub_menu' => TRUE,
        'page_parent' => 'edit.php',
        'page_parent_post_type' => 'your_post_type',
        'customizer' => FALSE,
        'default_mark' => '*',
        'hints' => array(
            'icon_position' => 'right',
            'icon_color' => 'lightgray',
            'icon_size' => 'normal',
            'tip_style' => array(
                'color' => 'light',
            ),
            'tip_position' => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect' => array(
                'show' => array(
                    'duration' => '500',
                    'event' => 'mouseover',
                ),
                'hide' => array(
                    'duration' => '500',
                    'event' => 'mouseleave unfocus',
                ),
            ),
        ),
        'output' => TRUE,
        'output_tag' => TRUE,
        'settings_api' => TRUE,
        'cdn_check_time' => '1440',
        'compiler' => TRUE,
        'page_permissions' => 'manage_options',
        'save_defaults' => TRUE,
        'show_import_export' => TRUE,
        'database' => 'options',
        'transient_time' => '3600',
        'network_sites' => TRUE,
    );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */

    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'help-tab',
            'title'   => __( 'Information', 'wordpress-print-posts' ),
            'content' => __( '<p>Need support? Please use the comment function on codecanyon.</p>', 'wordpress-print-posts' )
        ),
    );
    Redux::setHelpTab( $opt_name, $tabs );

    // Set the help sidebar
    // $content = __( '<p>This is the sidebar content, HTML is allowed.</p>', 'wordpress-print-posts' );
    // Redux::setHelpSidebar( $opt_name, $content );


    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    global $wpdb;
    $post_types = array();
    $res = $wpdb->get_results("SELECT DISTINCT post_type FROM `{$wpdb->prefix}posts`", ARRAY_A);
    if(!empty($res)) {
        foreach ($res as $key => $value) {
            $post_types[] = $value['post_type'];
        }
    }
    $post_types = array_combine($post_types, $post_types);


    Redux::setSection( $opt_name, array(
        'title'  => __( 'Print Posts', 'wordpress-print-posts' ),
        'id'     => 'general',
        'desc'   => __( 'Need support? Please use the comment function on codecanyon.', 'wordpress-print-posts' ),
        'icon'   => 'el el-home',
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'General', 'wordpress-print-posts' ),
        // 'desc'       => __( '', 'wordpress-print-posts' ),
        'id'         => 'general-settings',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'enable',
                'type'     => 'checkbox',
                'title'    => __( 'Enable', 'wordpress-print-posts' ),
                'subtitle' => __( 'Enable Print Posts to use the options below', 'wordpress-print-posts' ),
                'default' => 1,
            ),
            array(
                'id'       => 'enablePDF',
                'type'     => 'checkbox',
                'title'    => __( 'Enable PDF', 'wordpress-print-posts' ),
                'default' => 1,
            ),
            array(
                'id'       => 'PDFDownload',
                'type'     => 'checkbox',
                'title'    => __( 'Download PDF instead of Inline View', 'wordpress-print-posts' ),
                'default' => 0,
                'required' => array('enablePDF','equals','1'),
            ),
            array(
                'id'       => 'enableWord',
                'type'     => 'checkbox',
                'title'    => __( 'Enable Word', 'wordpress-print-posts' ),
                'default' => 1,
            ),
            array(
                'id'       => 'enablePrint',
                'type'     => 'checkbox',
                'title'    => __( 'Enable Print', 'wordpress-print-posts' ),
                'default' => 1,
            ),
            array(
                'id'       => 'iconPosition',
                'type'     => 'select',
                'title'    => __( 'Icon position', 'wordpress-print-posts' ),
                'subtitle' => __( 'Choose the position of the icons on the post page.', 'wordpress-print-posts' ),
                'options'  => array(
                    'none' => __('None (for Sidebar or custom Code)', 'wordpress-print-posts'),
                    'before_content' => __('Before Content', 'wordpress-print-posts'),
                    'after_content' => __('After Content', 'wordpress-print-posts'),
                ),
                'default' => 'before_content',
            ),
            array(
                'id'       => 'iconPostTypes',
                'type'     => 'select',
                'multi' => true,
                'title'    => __( 'Show on Post Types', 'wordpress-print-posts' ),
                'subtitle' => __( 'Choose post types where the icons should appear.', 'wordpress-print-posts' ),
                'options'  => $post_types,
                'default' => array(
                    'post',
                    'page'
                ),
            ),
            array(
                'id'       => 'iconSize',
                'type'     => 'select',
                'title'    => __( 'Icon Size', 'wordpress-print-posts' ),
                'subtitle' => __( 'Choose the icon size.', 'wordpress-print-posts' ),
                'options'  => array(
                    'fa-lg' => __('Large', 'wordpress-print-posts' ),
                    'fa-2x' => __('2x larger', 'wordpress-print-posts' ),
                    'fa-3x' => __('3x larger', 'wordpress-print-posts' ),
                    'fa-4x' => __('4x larger', 'wordpress-print-posts' ),
                    'fa-5x' => __('5x larger', 'wordpress-print-posts' ),
                    //'postAttribute' => __('Show best Selling Posts', 'wordpress-custom-tabs' ),
                ),
                 'default' => 'fa-2x',
            ),
            array(
                'id'       => 'iconDisplay',
                'type'     => 'select',
                'title'    => __( 'Icon Display', 'wordpress-print-posts' ),
                'subtitle' => __( 'Choose how the icons should appear.', 'wordpress-print-posts' ),
                'options'  => array(
                    'horizontal' => __('Horizontal', 'wordpress-print-posts' ),
                    'vertical' => __('Vertical', 'wordpress-print-posts' ),
                ),
                'default' => 'horizontal'
            ),
            array(
                'id'     =>'excludePostCategories',
                'type' => 'select',
                'data' => 'categories',
                'args' => array('taxonomy' => array('category')),
                'multi' => true,
                'title' => __('Exclude Post Categories', 'wordpress-print-posts'), 
                'subtitle' => __('Which post categories should be excluded by the catalog mode.', 'wordpress-print-posts'),
            ),            
            array(
                'id'       => 'excludePostCategoriesRevert',
                'type'     => 'checkbox',
                'title'    => __( 'Revert Categories Exclusion', 'wordpress-print-posts' ),
                'subtitle' => __( 'Instead of exclusion it will include.', 'wordpress-print-posts' ),
            ),
            array(
                'id'     =>'excludePosts',
                'type' => 'select',
                'data' => 'posts',
                'args' => array('post_type' => array('post'), 
                'posts_per_page' => -1),
                'multi' => true,
                'title' => __('Exclude Posts', 'wordpress-print-posts'), 
                'subtitle' => __('Which posts should be excluded by the catalog mode.', 'wordpress-print-posts'),
            ),
            array(
                'id'       => 'excludePostsRevert',
                'type'     => 'checkbox',
                'title'    => __( 'Revert Posts Exclusion', 'wordpress-print-posts' ),
                'subtitle' => __( 'Instead of exclusion it will include.', 'wordpress-print-posts' ),
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Header', 'wordpress-print-posts' ),
        // 'desc'       => __( '', 'wordpress-print-posts' ),
        'id'         => 'header',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'enableHeader',
                'type'     => 'checkbox',
                'title'    => __( 'Enable', 'wordpress-print-posts' ),
                'subtitle' => __( 'Enable header', 'wordpress-print-posts' ),
                'default' => '1',
            ),
            array(
                'id'     =>'headerBackgroundColor',
                'type' => 'color',
                'title' => __('Header background color', 'wordpress-print-posts'), 
                'validate' => 'color',
                'required' => array('enableHeader','equals','1'),
                'default' => '#222222',
            ),
            array(
                'id'     =>'headerTextColor',
                'type'  => 'color',
                'title' => __('Header text color', 'wordpress-print-posts'), 
                'validate' => 'color',
                'required' => array('enableHeader','equals','1'),
                'default' => '#FFFFFF',
            ),
            array(
                'id'     =>'headerLayout',
                'type'  => 'select',
                'title' => __('Header Layout', 'wordpress-print-posts'), 
                'required' => array('enableHeader','equals','1'),
                'options'  => array(
                    'oneCol' => __('1/1', 'wordpress-print-posts' ),
                    'twoCols' => __('1/2 + 1/2', 'wordpress-print-posts' ),
                    'threeCols' => __('1/3 + 1/3 + 1/3', 'wordpress-print-posts' ),
                ),
                'default' => 'twoCols',
            ),
            array(
                'id'     =>'headerTopMargin',
                'type'     => 'spinner', 
                'title'    => __('Header Margin', 'wordpress-print-posts'),
                'default'  => '20',
                'min'      => '1',
                'step'     => '1',
                'max'      => '200',
            ),
            array(
                'id'     =>'headerHeight',
                'type'     => 'spinner', 
                'title'    => __('Header Height', 'wordpress-print-posts'),
                'default'  => '40',
                'min'      => '1',
                'step'     => '1',
                'max'      => '200',
            ),
            array(
                'id'     =>'headerVAlign',
                'type'  => 'select',
                'title' => __('Vertical Align', 'wordpress-print-posts'), 
                'required' => array('enableHeader','equals','1'),
                'options'  => array(
                    'top' => __('Top', 'wordpress-print-posts' ),
                    'middle' => __('Middle', 'wordpress-print-posts' ),
                    'bottom' => __('Bottom', 'wordpress-print-posts' ),
                ),
                'default' => 'middle',
            ),
            array(
                'id'     =>'headerTopLeft',
                'type'  => 'select',
                'title' => __('Top Left Header', 'wordpress-print-posts'), 
                'required' => array('enableHeader','equals','1'),
                'options'  => array(
                    'none' => __('None', 'wordpress-print-posts' ),
                    'bloginfo' => __('Blog information', 'wordpress-print-posts' ),
                    'text' => __('Custom text', 'wordpress-print-posts' ),
                    'pagenumber' => __('Pagenumber', 'wordpress-print-posts' ),
                    'postinfo' => __('Post info', 'wordpress-print-posts' ),
                    'image' => __('Image', 'wordpress-print-posts' ),
                    'exportinfo' => __('Export Information', 'wordpress-print-posts' ),
                    'qr' => __('QR-Code', 'wordpress-print-posts' ),
                ),
                'default' => 'bloginfo',
            ),
            array(
                'id'     =>'headerTopLeftText',
                'type'  => 'editor',
                'title' => __('Top Left Header Text', 'wordpress-print-posts'), 
                'required' => array('headerTopLeft','equals','text'),
                'args'   => array(
                    'teeny'            => false,
                )
            ),
            array(
                'id'     =>'headerTopLeftImage',
                'type' => 'media',
                'url'      => true,
                'title' => __('Top Left Header Image', 'wordpress-print-posts'), 
                'required' => array('headerTopLeft','equals','image'),
                'args'   => array(
                    'teeny'            => false,
                )
            ),
            array(
                'id'     =>'headerTopMiddle',
                'type'  => 'select',
                'title' => __('Top Middle Header', 'wordpress-print-posts'), 
                'required' => array('headerLayout','equals','threeCols'),
                'options'  => array(
                    'none' => __('None', 'wordpress-print-posts' ),
                    'bloginfo' => __('Blog information', 'wordpress-print-posts' ),
                    'text' => __('Custom text', 'wordpress-print-posts' ),
                    'pagenumber' => __('Pagenumber', 'wordpress-print-posts' ),
                    'postinfo' => __('Post info', 'wordpress-print-posts' ),
                    'image' => __('Image', 'wordpress-print-posts' ),
                    'exportinfo' => __('Export Information', 'wordpress-print-posts' ),
                    'qr' => __('QR-Code', 'wordpress-print-posts' ),
                ),
                'default' => 'pagenumber',
            ),
            array(
                'id'     =>'headerTopMiddleText',
                'type'  => 'editor',
                'title' => __('Top Middle Header Text', 'wordpress-print-posts'), 
                'required' => array('headerTopMiddle','equals','text'),
                'args'   => array(
                    'teeny'            => false,
                )
            ),
            array(
                'id'     =>'headerTopMiddleImage',
                'type' => 'media',
                'url'      => true,
                'title' => __('Top Middle Header Image', 'wordpress-print-posts'), 
                'required' => array('headerTopMiddle','equals','image'),
                'args'   => array(
                    'teeny'            => false,
                )
            ),
            array(
                'id'     =>'headerTopRight',
                'type'  => 'select',
                'title' => __('Top Right Header', 'wordpress-print-posts'), 
                'required' => array('headerLayout','equals',array('threeCols','twoCols')),
                'options'  => array(
                    'none' => __('None', 'wordpress-print-posts' ),
                    'bloginfo' => __('Blog information', 'wordpress-print-posts' ),
                    'text' => __('Custom text', 'wordpress-print-posts' ),
                    'pagenumber' => __('Pagenumber', 'wordpress-print-posts' ),
                    'postinfo' => __('Post info', 'wordpress-print-posts' ),
                    'image' => __('Image', 'wordpress-print-posts' ),
                    'exportinfo' => __('Export Information', 'wordpress-print-posts' ),
                    'qr' => __('QR-Code', 'wordpress-print-posts' ),
                ),
                'default' => 'postinfo',
            ),
            array(
                'id'     =>'headerTopRightText',
                'type'  => 'editor',
                'title' => __('Top Right Header Text', 'wordpress-print-posts'), 
                'required' => array('headerTopRight','equals','text'),
                'args'   => array(
                    'teeny'            => false,
                )
            ),
            array(
                'id'     =>'headerTopRightImage',
                'type' => 'media',
                'url'      => true,
                'title' => __('Top Right Header Image', 'wordpress-print-posts'), 
                'required' => array('headerTopRight','equals','image'),
                'args'   => array(
                    'teeny'            => false,
                )
            ),
            array(
                'id'     =>'headerTextAfterHeader',
                'type'  => 'editor',
                'title' => __('Text after Header', 'wordpress-print-posts'),
                'args'   => array(
                    'teeny'            => false,
                )
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Layout', 'wordpress-print-posts' ),
        'id'         => 'layout',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'layout',
                'type'     => 'image_select',
                'title'    => __( 'Select Layout', 'wordpress-print-posts' ),
                'options'  => array(
                    '1'      => array(
                        'img'   => plugin_dir_url( __FILE__ ) . 'img/1.png'
                    ),
                    '2'      => array(
                        'img'   => plugin_dir_url( __FILE__ ). 'img/2.png'
                    ),
                ),
                'default' => '2'
            ),
            array(
                'id'      => 'informationOrder',
                'type'    => 'sorter',
                'title'   => 'Reorder / Disable some blocks.',
                'options' => array(
                    'enabled'  => array(
                        'pagebreak-1' => 'Pagebreak',
                        'description' => 'Description',
                        'pagebreak-2' => 'Pagebreak',
                        'comments' => 'Comments',
                    ),
                    'disabled' => array(
                        'pagebreak-3' => 'Pagebreak',
                        'pagebreak-4' => 'Pagebreak',
                    )
                ),
            ),
            array(
                'id'     =>'backgroundColor',
                'type'  => 'color',
                'title' => __('Background color', 'wordpress-print-posts'), 
                'validate' => 'color',
                'default' => '#FFFFFF',
            ),
            array(
                'id'     =>'textColor',
                'type'  => 'color',
                'title' => __('Text Color', 'wordpress-print-posts'), 
                'validate' => 'color',
                'default' => '#000000',
            ),
            array(
                'id'     =>'linkColor',
                'type'  => 'color',
                'title' => __('Link Color', 'wordpress-print-posts'), 
                'validate' => 'color',
                'default' => '#d35400',
            ),
            array(
                'id'     =>'textAlign',
                'type'  => 'select',
                'title' => __('Text Align', 'wordpress-print-posts'), 
                'options'  => array(
                    'left' => __('Left', 'wordpress-print-posts' ),
                    'center' => __('Center', 'wordpress-print-posts' ),
                    'right' => __('Right', 'wordpress-print-posts' ),
                ),
                'default' => 'left'
            ),
            array(
                'id'     =>'fontFamily',
                'type'  => 'select',
                'title' => __('Default Font', 'wordpress-print-posts'), 
                'options'  => array(
                    'dejavusans' => __('Sans', 'wordpress-print-posts' ),
                    'dejavuserif' => __('Serif', 'wordpress-print-posts' ),
                    'dejavusansmono' => __('Mono', 'wordpress-print-posts' ),
                    'droidsans' => __('Droid Sans', 'wordpress-print-posts'),
                    'droidserif' => __('Droid Serif', 'wordpress-print-posts'),
                    'lato' => __('Lato', 'wordpress-print-posts'),
                    'lora' => __('Lora', 'wordpress-print-posts'),
                    'merriweather' => __('Merriweather', 'wordpress-print-posts'),
                    'montserrat' => __('Montserrat', 'wordpress-print-posts'),
                    'opensans' => __('Open sans', 'wordpress-print-posts'),
                    'opensanscondensed' => __('Open Sans Condensed', 'wordpress-print-posts'),
                    'oswald' => __('Oswald', 'wordpress-print-posts'),
                    'ptsans' => __('PT Sans', 'wordpress-print-posts'),
                    'sourcesanspro' => __('Source Sans Pro', 'wordpress-print-posts'),
                    'slabo' => __('Slabo', 'wordpress-print-posts'),
                    'raleway' => __('Raleway', 'wordpress-print-posts'),
                ),
                'default' => 'raleway',
            ),
            array(
                'id'     =>'fontSize',
                'type'     => 'spinner', 
                'title'    => __('Default font size', 'wordpress-print-posts'),
                'default'  => '12',
                'min'      => '1',
                'step'     => '1',
                'max'      => '40',
            ),
            array(
                'id'     =>'fontLineHeight',
                'type'     => 'spinner', 
                'title'    => __('Default line height', 'wordpress-print-posts'),
                'default'  => '16',
                'min'      => '1',
                'step'     => '1',
                'max'      => '40',
            ),
            array(
                'id'     =>'headingAlign',
                'type'  => 'select',
                'title' => __('Heading Align', 'wordpress-print-posts'), 
                'options'  => array(
                    'left' => __('Left', 'wordpress-print-posts' ),
                    'center' => __('Center', 'wordpress-print-posts' ),
                    'right' => __('Right', 'wordpress-print-posts' ),
                ),
                'default' => 'center'
            ),
            array(
                'id'     =>'headingFontFamily',
                'type'  => 'select',
                'title' => __('Heading Font', 'wordpress-print-posts'), 
                'options'  => array(
                    'dejavusans' => __('Sans', 'wordpress-print-posts' ),
                    'dejavuserif' => __('Serif', 'wordpress-print-posts' ),
                    'dejavusansmono' => __('Mono', 'wordpress-print-posts' ),
                    'droidsans' => __('Droid Sans', 'wordpress-print-posts'),
                    'droidserif' => __('Droid Serif', 'wordpress-print-posts'),
                    'lato' => __('Lato', 'wordpress-print-posts'),
                    'lora' => __('Lora', 'wordpress-print-posts'),
                    'merriweather' => __('Merriweather', 'wordpress-print-posts'),
                    'montserrat' => __('Montserrat', 'wordpress-print-posts'),
                    'opensans' => __('Open sans', 'wordpress-print-posts'),
                    'opensanscondensed' => __('Open Sans Condensed', 'wordpress-print-posts'),
                    'oswald' => __('Oswald', 'wordpress-print-posts'),
                    'ptsans' => __('PT Sans', 'wordpress-print-posts'),
                    'sourcesanspro' => __('Source Sans Pro', 'wordpress-print-posts'),
                    'slabo' => __('Slabo', 'wordpress-print-posts'),
                    'raleway' => __('Raleway', 'wordpress-print-posts'),
                ),
                'default' => 'oswald',
            ),
            array(
                'id'     =>'headingFontSize',
                'type'     => 'spinner', 
                'title'    => __('Heading font size', 'wordpress-print-posts'),
                'default'  => '22',
                'min'      => '1',
                'step'     => '1',
                'max'      => '100',
            ),
            array(
                'id'     =>'headingLineHeight',
                'type'     => 'spinner', 
                'title'    => __('Headings line height', 'wordpress-print-posts'),
                'default'  => '26',
                'min'      => '1',
                'step'     => '1',
                'max'      => '100',
            ),

        )
    ) );

    $dataToShow = 
        array(
            array(
                'id'       => 'showImage',
                'type'     => 'checkbox',
                'title'    => __( 'Show Image', 'wordpress-print-posts' ),
                'default'   => 1,
            ),
                array(
                    'id'     =>'showImageSize',
                    'type'     => 'spinner', 
                    'title'    => __('Post Image Size', 'wordpress-print-posts'),
                    'default'  => '350',
                    'min'      => '1',
                    'step'     => '1',
                    'max'      => '99999',
                    'required' => array('showImage','equals','1'),
                ),            
            array(
                'id'       => 'showTitle',
                'type'     => 'checkbox',
                'title'    => __( 'Show Title', 'wordpress-print-posts' ),
                'default'   => 1,
            ),
            array(
                'id'       => 'showExcerpt',
                'type'     => 'checkbox',
                'title'    => __( 'Show Excerpt', 'wordpress-print-posts' ),
                'default'   => 1,
            ),
                array(
                    'id'       => 'showExcerptStripImages',
                    'type'     => 'checkbox',
                    'title'    => __( 'Strip Short Description Images?', 'wordpress-print-posts' ),
                    'default'   => 0,
                    'required' => array('showExcerpt','equals','1'),
                ),
            array(
                'id'       => 'showMetaFreetext',
                'type'     => 'checkbox',
                'title'    => __( 'Show Meta Free Text', 'wordpress-print-posts' ),
                'default'   => 0,
            ),
                array(
                    'id'       => 'metaFreeText',
                    'type'  => 'editor',
                    'title' => __('Meta Free Text', 'wordpress-print-posts'),
                    'args'   => array(
                        'teeny'            => false,
                    ),
                    'required' => array('showMetaFreetext','equals','1'),
                ),
            array(
                'id'       => 'showAuthor',
                'type'     => 'checkbox',
                'title'    => __( 'Show Author', 'wordpress-print-posts' ),
                'default'   => 1,
            ),
            array(
                'id'       => 'showDate',
                'type'     => 'checkbox',
                'title'    => __( 'Show Date', 'wordpress-print-posts' ),
                'default'   => 1,
            ),
            array(
                'id'       => 'showCategories',
                'type'     => 'checkbox',
                'title'    => __( 'Show Categories', 'wordpress-print-posts' ),
                'default'   => 1,
            ),
            array(
                'id'       => 'showTags',
                'type'     => 'checkbox',
                'title'    => __( 'Show Tags', 'wordpress-print-posts' ),
                'default'   => 1,
            ),
            array(
                'id'       => 'showQR',
                'type'     => 'checkbox',
                'title'    => __( 'Show QR-Code', 'wordpress-print-posts' ),
                'default'   => 1,
            ),
            array(
                'id'       => 'showDescription',
                'type'     => 'checkbox',
                'title'    => __( 'Show Description', 'wordpress-print-posts' ),
                'default'   => 1,
            ),
                array(
                    'id'       => 'showDescriptionStripImages',
                    'type'     => 'checkbox',
                    'title'    => __( 'Strip Description Images?', 'wordpress-print-posts' ),
                    'default'   => 0,
                    'required' => array('showDescription','equals','1'),
                ),
                array(
                    'id'       => 'visualComposerSupport',
                    'type'     => 'checkbox',
                    'title'    => __( 'Visual Composer Support', 'wordpress-print-posts' ),
                    'default'   => 1,
                    'required' => array('showDescription','equals','1'),
                ),
                
        );
    
    $dataToShow = array_merge($dataToShow, $temp);
    

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Data to show', 'wordpress-print-posts' ),
        'id'         => 'data',
        'subsection' => true,
        'fields'     => $dataToShow
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Footer', 'wordpress-print-posts' ),
        // 'desc'       => __( '', 'wordpress-print-posts' ),
        'id'         => 'footer',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'enableFooter',
                'type'     => 'checkbox',
                'title'    => __( 'Enable', 'wordpress-print-posts' ),
                'subtitle' => __( 'Enable footer', 'wordpress-print-posts' ),
                'default'   => 1,
            ),
            array(
                'id'     =>'footerBackgroundColor',
                'type' => 'color',
                'url'      => true,
                'title' => __('Footer background color', 'wordpress-print-posts'), 
                'validate' => 'color',
                'required' => array('enableFooter','equals','1'),
                'default'   => '#222222',
            ),
            array(
                'id'     =>'footerTextColor',
                'type'  => 'color',
                'url'      => true,
                'title' => __('Footer text color', 'wordpress-print-posts'), 
                'validate' => 'color',
                'required' => array('enableFooter','equals','1'),
                'default'   => '#FFFFFF',
            ),
            array(
                'id'     =>'footerLayout',
                'type'  => 'select',
                'title' => __('Footer Layout', 'wordpress-print-posts'), 
                'required' => array('enableFooter','equals','1'),
                'options'  => array(
                    'oneCol' => __('1/1', 'wordpress-print-posts' ),
                    'twoCols' => __('1/2 + 1/2', 'wordpress-print-posts' ),
                    'threeCols' => __('1/3 + 1/3 + 1/3', 'wordpress-print-posts' ),
                ),
                'default' => 'oneCol',
            ),
            array(
                'id'     =>'footerTopMargin',
                'type'     => 'spinner', 
                'title'    => __('Footer Margin', 'wordpress-print-posts'),
                'default'  => '55',
                'min'      => '1',
                'step'     => '1',
                'max'      => '200',
            ),
            array(
                'id'     =>'footerHeight',
                'type'     => 'spinner', 
                'title'    => __('Footer Height', 'wordpress-print-posts'),
                'default'  => '40',
                'min'      => '1',
                'step'     => '1',
                'max'      => '200',
            ),
            array(
                'id'     =>'footerVAlign',
                'type'  => 'select',
                'title' => __('Vertical Align', 'wordpress-print-posts'), 
                'required' => array('enableFooter','equals','1'),
                'options'  => array(
                    'top' => __('Top', 'wordpress-print-posts' ),
                    'middle' => __('Middle', 'wordpress-print-posts' ),
                    'bottom' => __('Bottom', 'wordpress-print-posts' ),
                ),
                'default' => 'middle',
            ),
            array(
                'id'     =>'footerTopLeft',
                'type'  => 'select',
                'title' => __('Top Left Footer', 'wordpress-print-posts'), 
                'required' => array('enableFooter','equals','1'),
                'options'  => array(
                    'none' => __('None', 'wordpress-print-posts' ),
                    'bloginfo' => __('Blog information', 'wordpress-print-posts' ),
                    'text' => __('Custom text', 'wordpress-print-posts' ),
                    'pagenumber' => __('Pagenumber', 'wordpress-print-posts' ),
                    'postinfo' => __('Post info', 'wordpress-print-posts' ),
                    'image' => __('Image', 'wordpress-print-posts' ),
                    'exportinfo' => __('Export Information', 'wordpress-print-posts' ),
                    'qr' => __('QR-Code', 'wordpress-print-posts' ),
                ),
                'default'   => 'pagenumber',
            ),
            array(
                'id'     =>'footerTopLeftText',
                'type'  => 'editor',
                'title' => __('Top Left Footer Text', 'wordpress-print-posts'), 
                'required' => array('footerTopLeft','equals','text'),
                'args'   => array(
                    'teeny'            => false,
                )
            ),
            array(
                'id'     =>'footerTopLeftImage',
                'type' => 'media',
                'url'      => true,
                'title' => __('Top Left Footer Image', 'wordpress-print-posts'), 
                'required' => array('footerTopLeft','equals','image'),
                'args'   => array(
                    'teeny'            => false,
                )
            ),
            array(
                'id'     =>'footerTopMiddle',
                'type'  => 'select',
                'title' => __('Top Middle Footer', 'wordpress-print-posts'), 
                'required' => array('footerLayout','equals','threeCols'),
                'options'  => array(
                    'none' => __('None', 'wordpress-print-posts' ),
                    'bloginfo' => __('Blog information', 'wordpress-print-posts' ),
                    'text' => __('Custom text', 'wordpress-print-posts' ),
                    'pagenumber' => __('Pagenumber', 'wordpress-print-posts' ),
                    'postinfo' => __('Post info', 'wordpress-print-posts' ),
                    'image' => __('Image', 'wordpress-print-posts' ),
                    'exportinfo' => __('Export Information', 'wordpress-print-posts' ),
                    'qr' => __('QR-Code', 'wordpress-print-posts' ),
                ),
                'default'   => 'exportinfo',
            ),
            array(
                'id'     =>'footerTopMiddleText',
                'type'  => 'editor',
                'title' => __('Top Middle Footer Text', 'wordpress-print-posts'), 
                'required' => array('footerTopMiddle','equals','text'),
                'args'   => array(
                    'teeny'            => false,
                )
            ),
            array(
                'id'     =>'footerTopMiddleImage',
                'type' => 'media',
                'url'      => true,
                'title' => __('Top Middle Footer Image', 'wordpress-print-posts'), 
                'required' => array('footerTopMiddle','equals','image'),
                'args'   => array(
                    'teeny'            => false,
                )
            ),
            array(
                'id'     =>'footerTopRight',
                'type'  => 'select',
                'title' => __('Top Right Footer', 'wordpress-print-posts'), 
                'required' => array('footerLayout','equals',array('threeCols','twoCols')),
                'options'  => array(
                    'none' => __('None', 'wordpress-print-posts' ),
                    'bloginfo' => __('Blog information', 'wordpress-print-posts' ),
                    'text' => __('Custom text', 'wordpress-print-posts' ),
                    'pagenumber' => __('Pagenumber', 'wordpress-print-posts' ),
                    'postinfo' => __('Post info', 'wordpress-print-posts' ),
                    'image' => __('Image', 'wordpress-print-posts' ),
                    'exportinfo' => __('Export Information', 'wordpress-print-posts' ),
                    'qr' => __('QR-Code', 'wordpress-print-posts' ),
                ),
                'default'   => 'pagenumber',
            ),
            array(
                'id'     =>'footerTopRightText',
                'type'  => 'editor',
                'title' => __('Top Right Footer Text', 'wordpress-print-posts'), 
                'required' => array('footerTopRight','equals','text'),
                'args'   => array(
                    'teeny'            => false,
                )
            ),
            array(
                'id'     =>'footerTopRightImage',
                'type' => 'media',
                'url'      => true,
                'title' => __('Top Right Footer Image', 'wordpress-print-posts'), 
                'required' => array('footerTopRight','equals','image'),
                'args'   => array(
                    'teeny'            => false,
                )
            ),
            array(
                'id'     =>'foooterTextBeforeFooter',
                'type'  => 'editor',
                'title' => __('Text before Footer', 'wordpress-print-posts'),
                'args'   => array(
                    'teeny'            => false,
                )
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Limit Access', 'wordpress-print-posts' ),
        // 'desc'       => __( '', 'wordpress-print-posts' ),
        'id'         => 'limit-access-settings',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'enableLimitAccess',
                'type'     => 'checkbox',
                'title'    => __( 'Enable', 'wordpress-print-posts' ),
                'subtitle' => __( 'Enable the limit access. This will activate the below settings.', 'wordpress-print-posts' ),
            ),
            array(
                'id'     =>'role',
                'type' => 'select',
                'data' => 'roles',
                'title' => __('User Role', 'wordpress-print-posts'),
                'subtitle' => __('Select a custom user Role (Default is: administrator) who can use this plugin.', 'wordpress-print-posts'),
                'multi' => true,
                'default' => 'administrator',
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Advanced settings', 'wordpress-print-posts' ),
        'desc'       => __( 'Custom stylesheet / javascript.', 'wordpress-print-posts' ),
        'id'         => 'advanced',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'removeShortcodes',
                'type'     => 'checkbox',
                'title'    => __( 'Remove / Strip Shortcodes', 'wordpress-print-posts' ),
                'subtitle' => __( 'This will remove shortcodes, that are not executed, but can cause issues when you use [] in plain text.', 'wordpress-print-posts' ),
                'default'   => 1,
            ),
            array(
                'id'       => 'debugMode',
                'type'     => 'checkbox',
                'title'    => __( 'Enable Debug Mode', 'wordpress-print-posts' ),
                'subtitle' => __( 'This stops creating the PDF and shows the plain HTML.', 'wordpress-print-posts' ),
                'default'   => 0,
            ),
            array(
                'id'       => 'debugMPDF',
                'type'     => 'checkbox',
                'title'    => __( 'Enable MPDF Debug Mode', 'woocommerce-print-products' ),
                'subtitle' => __( 'Show image , font or other errors in the PDF Rendering engine.', 'woocommerce-print-products' ),
                'default'   => 0,
            ),
            array(
                'id'       => 'customCSS',
                'type'     => 'ace_editor',
                'mode'     => 'css',
                'title'    => __( 'Custom CSS', 'wordpress-print-posts' ),
                'subtitle' => __( 'Add some stylesheet if you want.', 'wordpress-print-posts' ),
            ),
            array(
                'id'       => 'customJS',
                'type'     => 'ace_editor',
                'mode'     => 'javascript',
                'title'    => __( 'Custom JS', 'wordpress-print-posts' ),
                'subtitle' => __( 'Add some javascript if you want.', 'wordpress-print-posts' ),
            ),
        )
    ));

    /*
     * <--- END SECTIONS
     */
