<?php
/*
* Define class pspGoogleEnhancements
* Make sure you skip down to the end of this file, as there are a few
* lines of code that are very important.
*/
!defined('ABSPATH') and exit;
if (class_exists('pspGoogleEnhancements') != true) {
	class pspGoogleEnhancements
	{
		/*
		* Some required plugin information
		*/
		const VERSION = '1.0';

		/*
		* Store some helpers config
		*
		*/
		public $cfg = array();

		/*
		* Store some helpers config
		*/
		public $the_plugin = null;

		private $module_folder = '';
		private $module = '';

		private $settings = array();

		static protected $_instance;
		
		/**
    	* Singleton pattern
    	*
    	* @return pspGoogleAuthorship Singleton instance
    	*/
		static public function getInstance()
		{
			if (!self::$_instance) {
				self::$_instance = new self;
			}
			 
			return self::$_instance;
		}

		/*
		* Required __construct() function that initalizes the AA-Team Framework
		*/
		public function __construct()
		{
			global $psp;
			
			$this->the_plugin = $psp; 
			$this->module_folder = $this->the_plugin->cfg['paths']['plugin_dir_url'] . 'modules/google_enhancements/';
			$this->module = $this->the_plugin->cfg['modules']['google_enhancements'];

			if ( $this->the_plugin->is_admin !== true ) {
				$this->settings = $this->the_plugin->getAllSettings( 'array', 'google_enhancements' );
			}
   		
			add_action( 'premiumseo_head', array( $this, 'the_header' ), 11 );
		}
		
		public function generate_social_profile_urls($social_networks) {
			$social_urls = array();
			foreach( $social_networks as $social_network ) {
				if( isset($this->settings['social_' . $social_network]) && trim($this->settings['social_' . $social_network]) != '')
				$social_urls[] = '"' . $this->settings['social_' . $social_network] . '"';
			}
			
			return implode(',', $social_urls);
		}
		
		/**
		 * Frontend
		 */
		public function the_header() {
			$html = array();
			$social_networks = array('facebook','twitter','googleplus','instagram','youtube','linkedin','myspace','pinterest','soundcloud','tumblr');
			$social_profile_urls = $this->generate_social_profile_urls($social_networks);
			
			if( isset($this->settings['type']) && trim($this->settings['type']) != '' &&
				isset($this->settings['name']) && trim($this->settings['name']) != '' &&
				trim($social_profile_urls) != ''
			) {
				$html[] = '<script type="application/ld+json">';
				$html[] = '{';
				  $html[] = '"@context": "http://schema.org",';
				  $html[] = '"@type": "' . ( $this->settings['type'] ) . '",';
				  $html[] = '"name": "' . ( $this->settings['name'] ) . '",';
				  $html[] = '"url": "' . ( home_url() ) . '",';
				  $html[] = '"sameAs": [' . $social_profile_urls . ']';
				$html[] = '}';
				$html[] = '</script>' . "\n";
			}
			  
			if( isset($this->settings['sitelinks_searchbox']) && $this->settings['sitelinks_searchbox'] == 'on' && is_front_page() ) {
				$html[] = '<link rel="canonical" href="' . ( home_url() ) . '">';
				$html[] = '<script type="application/ld+json">';
				$html[] = '{';
				$html[] = '"@context": "http://schema.org",';
				$html[] = '"@type": "WebSite",';
				$html[] = '"url": "' . ( home_url() ) . '",';
				$html[] = '"potentialAction": {';
				$html[] = '	"@type": "SearchAction",';
				$html[] = '	"target": "' . ( home_url('?s={search_term_string}') ) . '",';
				$html[] = '	"query-input": "required name=search_term_string"';
				$html[] = '}';
				$html[] = '}';
				$html[] = '</script>' . "\n";
			}
			
			if( count($html) > 0 ) {
				echo implode("\n", $html);
			}
		}
		
		/**
	  	 * Hooks
	   	 */
		static public function adminMenu()
		{
	       self::getInstance()->_registerAdminPages();
		}

		/**
    	* Register plug-in module admin pages and menus
    	*/
		protected function _registerAdminPages()
		{
			if ( $this->the_plugin->capabilities_user_has_module('google_enhancements') ) {
				add_submenu_page(
					$this->the_plugin->alias,
					$this->the_plugin->alias . " " . __('Google Enhancements', 'psp'),
					__('Google Enhancements', 'psp'),
					'read',
					$this->the_plugin->alias . "_google_enhancements",
					array($this, 'display_index_page')
				);
			}

			return $this;
		}
	}
}
// Initialize pspGoogleEnhancements
$pspGoogleEnhancements = pspGoogleEnhancements::getInstance();