<?php
! defined( 'ABSPATH' ) and exit;

if ( !function_exists('array_replace_recursive') ) {
		function array_replace_recursive( $base, $replacements )
		{
				foreach (array_slice(func_get_args(), 1) as $replacements) {
						$bref_stack = array(&$base);
						$head_stack = array($replacements);

						do {
								end($bref_stack);

								$bref = &$bref_stack[key($bref_stack)];
								$head = array_pop($head_stack);

								unset($bref_stack[key($bref_stack)]);

								foreach (array_keys($head) as $key) {
										if (isset($key, $bref, $bref[$key], $head[$key]) && is_array($bref[$key]) && is_array($head[$key])) {
												$bref_stack[] = &$bref[$key];
												$head_stack[] = $head[$key];
										} else {
												$bref[$key] = $head[$key];
										}
								}
						} while(count($head_stack));
				}

				return $base;
		}
}

if ( !function_exists('psp') ) {
	function psp() {
		global $psp;
		return $psp;
	}
}

if ( !function_exists('psp_get_plugin_data') ) {
	function psp_get_plugin_data( $path='' ) {
		if ( empty($path) ) {
			$path = str_replace('aa-framework/', '', plugin_dir_path( (__FILE__) )) . "plugin.php";
		}
  
		$source = file_get_contents( $path );
		$tokens = token_get_all( $source );
		$data   = array();
		if( trim($tokens[1][1]) != "" ){
			$__ = explode("\n", $tokens[1][1]);
			foreach ($__ as $key => $value) {
				$___ = explode(": ", $value);
				if( count($___) == 2 ){
					$data[trim(strtolower(str_replace(" ", '_', $___[0])))] = trim($___[1]);
				}
			}               
		}
  
		// For another way to implement it:
		//      see wp-admin/includes/update.php function get_plugin_data
		//      see wp-includes/functions.php function get_file_data
		return $data;  
	}
}

if ( !function_exists('hash_equals') ) {
	function hash_equals( $a, $b ) {
		$a_len = strlen($a);
		$b_len = strlen($b);
		if ( $b_len !== $a_len ) {
			return false;
		}

		$res = 0;
		for ($i = 0; $i < $a_len; $i++) {
			$res |= ord( $a[ $i ] ) ^ ord( $b[ $i ] );
		}
		return 0 === $res;
	}
}

if ( !function_exists('psp_hash_rand') ) {
	//returns a 40 characters long code
	function psp_hash_rand() {
		if ( function_exists( 'openssl_random_pseudo_bytes' ) ) {
			return bin2hex( openssl_random_pseudo_bytes( 20 ) );
		}
		else {
			return sha1( wp_rand() );
		}
	}
}

if ( !function_exists('psp_hash_api') ) {
	function psp_hash_api( $data ) {
		return hash_hmac( 'sha256', $data, 'psp-api' );
	}
}

if ( !function_exists('psp_asset_path') ) {
	function psp_asset_path( $asset_type='css', $path='', $is_wp_enqueue=false, $pms=array() ) {
		global $psp;
		return $psp->plugin_asset_get_path( $asset_type, $path, $is_wp_enqueue, $pms );
	}
}

if ( !function_exists('psp_asset_version') ) {
	function psp_asset_version( $asset_type='css', $pms=array() ) {
		global $psp;
		return $psp->plugin_asset_get_version( $asset_type, $pms );
	}
}