-- --------------------------------------------------------

--
-- Table structure for table `{wp_prefix}psp_alexa_rank`
--

CREATE TABLE IF NOT EXISTS `{wp_prefix}psp_alexa_rank` (
	`id` INT(10) NOT NULL AUTO_INCREMENT,
	`domain` VARCHAR(50) NOT NULL DEFAULT '0',
	`global_rank` INT(10) NOT NULL DEFAULT '0',
	`rank_delta` VARCHAR(150) NOT NULL DEFAULT '0',
	`country_rank` INT(10) NOT NULL DEFAULT '0',
	`country_code` VARCHAR(4) NOT NULL DEFAULT '0',
	`country_name` VARCHAR(50) NOT NULL DEFAULT '0',
	`update_date` DATE NOT NULL,
	PRIMARY KEY (`id`),
	UNIQUE INDEX `update_date` (`update_date`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

-- --------------------------------------------------------

--
-- Table structure for table `{wp_prefix}psp_post_planner_cron`
--

CREATE TABLE IF NOT EXISTS `{wp_prefix}psp_post_planner_cron` (
	`id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
	`id_post` BIGINT(20) NOT NULL,
	`post_to` TEXT NULL,
	`post_to-page_group` VARCHAR(255) NULL DEFAULT NULL,
	`post_privacy` VARCHAR(255) NULL DEFAULT NULL,
	`email_at_post` ENUM('off','on') NOT NULL DEFAULT 'off',
	`status` SMALLINT(1) NOT NULL DEFAULT '0',
	`response` TEXT NULL,
	`started_at` TIMESTAMP NULL DEFAULT NULL,
	`ended_at` TIMESTAMP NULL DEFAULT NULL,
	`run_date` DATETIME NULL DEFAULT NULL,
	`repeat_status` ENUM('off','on') NOT NULL DEFAULT 'off' COMMENT 'one-time | repeating',
	`repeat_interval` INT(11) NULL DEFAULT NULL COMMENT 'minutes',
	`timestamp` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	`attempts` SMALLINT(6) NOT NULL,
	`deleted` TINYINT(1) NOT NULL DEFAULT '0',
	PRIMARY KEY (`id`),
	UNIQUE INDEX `id_post` (`id_post`),
	INDEX `status` (`status`),
	INDEX `deleted` (`deleted`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

-- --------------------------------------------------------

--
-- Table structure for table `{wp_prefix}psp_web_directories`
--

CREATE TABLE IF NOT EXISTS `{wp_prefix}psp_web_directories` (
	`id` INT(11) NOT NULL AUTO_INCREMENT,
	`directory_name` VARCHAR(255) NULL DEFAULT NULL,
	`submit_url` VARCHAR(255) NULL DEFAULT NULL,
	`pagerank` DOUBLE NULL DEFAULT NULL,
	`alexa` DOUBLE NULL DEFAULT NULL,
	`status` SMALLINT(1) NULL DEFAULT '0',
	PRIMARY KEY (`id`),
	UNIQUE INDEX `submit_url` (`submit_url`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;