<?php

/**
 * PAPRO License API.
 */
namespace PremiumAddonsPro\License;

use PremiumAddonsPro\Admin\Includes\Admin_Helper;

class API {

    /**
     * PAPRO Activate License
     *
     * Handles license activation
     *
     * @since 1.0.0
     * @access public
     *
     * @return void
     */
    public static function papro_activate_license( $license_key ) {
        update_option( 'papro_license_key', $license_key );
        update_option( 'papro_license_status', 'valid' );
        wp_redirect( "admin.php?page=premium-addons#tab=license" );
        exit();
    }

    /**
     * PAPRO Deactivate License
     *
     * Handles license deactivation
     *
     * @since 1.0.0
     * @access public
     *
     * @return void
     */
    public static function papro_deactivate_license( $license_key ){
        delete_option( 'papro_license_status' );
        delete_option( 'papro_license_key' );
        wp_redirect( "admin.php?page=premium-addons#tab=license" );
        exit();
    }

    /**
     * Get Plugin Package URL
     *
     * @param string $version plugin version
     *
     * @since 2.0.7
     * @access public
     *
     */
    public static function get_plugin_package_url( $version ) {
        return new \WP_Error( 'no_json', __( 'An error occurred, please try again', 'premium-addons-pro' ) );
	}
    
    /**
     * Call Custom API
     * 
     * @since 1.0.0
     * @access public
     *
     * @param string $url URL to retrieve
     * @param array $args request paramters
     * 
     */
    public static function call_custom_api( $url, $args ) {
        
        $response = wp_remote_post(
            $url,
            array(
                'timeout' => 40,
                'sslverify' => false,
                'body' => $args
            )
        );
        
        return $response;
    }
    
}