<?php
/**
 * Plugin Name: Post Auto Share
 * Plugin URI: http://makewebbetter.com
 * Description: Post Auto Share shares link of new published Posts on social media like Facebook, Twitter, Linkedin, Pinterest and Tumblr when you add new post on your website.
 * Version: 1.0.2
 * Author: پرشین اسکریپت
 * Author URI: http://www.persianscript.ir
 * Text Domain: post-auto-share
 * Domain Path: /language/
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

	//define constants

define('mwb_pas_graph_url','https://graph.facebook.com/v2.10');
define('MWB_PAS_PATH', plugin_dir_path( __FILE__ ));
define('MWB_PAS_URL', plugin_dir_url( __FILE__ ));
define('MWB_PAS_PREFIX', 'mwb_pas_');

	//include files

require_once( dirname( __FILE__ ) . '/includes/share/class-mwb-pas-share-fb.php' );
require_once( dirname( __FILE__ ) . '/includes/mwb-pas-settings.php' );
require_once( dirname( __FILE__ ) . '/includes/class-mwb-pas-bulkshare.php' );
require_once( dirname( __FILE__ ) . '/includes/class-mwb-pas-gift-product.php' );
require_once( dirname( __FILE__ ) . '/includes/share/class-mwb-pas-share-pin.php' );
require_once( dirname( __FILE__ ) . '/includes/share/class-mwb-pas-share-link.php' );
require_once( dirname( __FILE__ ) . '/includes/share/class-mwb-pas-share-tweet.php' );
require_once( dirname( __FILE__ ) . '/includes/share/class-mwb-pas-tumblr.php' );
require_once( dirname( __FILE__ ) . '/includes/view/mwb_pas_msgmetabox.php' );


class post_auto_share {
	/**
	  * This function is construct function for class.
	  * @name __construct()
	  * @author makewebbetter <webmaster@makewebbetter.com>
	  * @link http://makewebbetter.com/
	  */
	function __construct() {

		$enable_share_post_on_update = get_option('mwb_pas_gen_settings',false);
		
		if( isset($enable_share_post_on_update['all_post_share_on_update']) && $enable_share_post_on_update['all_post_share_on_update'] == 1 ){

			add_action('transition_post_status', array( $this,MWB_PAS_PREFIX.'update_post_share'), 10, 3);
		}
		elseif( isset($enable_share_post_on_update['all_product_share_on_update']) && $enable_share_post_on_update['all_product_share_on_update'] == 1 ){

			add_action('transition_post_status', array( $this,MWB_PAS_PREFIX.'update_gift_product_share'), 10, 3);
		}
		elseif( isset($enable_share_post_on_update['all_coupons_share_on_update']) && $enable_share_post_on_update['all_coupons_share_on_update'] == 1 ){

			add_action('transition_post_status', array( $this,MWB_PAS_PREFIX.'update_coupons_share'), 10, 3);
		}
		elseif( isset($enable_share_post_on_update['all_wooproduct_share_on_update']) && $enable_share_post_on_update['all_wooproduct_share_on_update'] == 1 )
		{

			add_action('transition_post_status', array( $this,MWB_PAS_PREFIX.'update_woocommerce_product'), 10, 3);
		}


		add_action( 'init', array( $this,MWB_PAS_PREFIX.'addScripts') );
		add_filter( 'post_updated_messages',array( $this,MWB_PAS_PREFIX.'custom_message'),11 );
		add_action( 'add_meta_boxes',array( $this,MWB_PAS_PREFIX.'fb_reviews_post') );

		if(get_option("mwb_pas_Fb_error") != "" || get_option("mwb_pas_pint_error") != "" || get_option("mwb_pas_tweet_error") != "" || get_option("mwb_pas_link_error") != "" || get_option("mwb_pas_tumblr_error") != ""){
			add_action('admin_notices',array($this,MWB_PAS_PREFIX.'share_error'));
		}
		add_action( 'init', array($this,MWB_PAS_PREFIX.'start_session'));
		add_action( 'plugins_loaded', array ( $this, MWB_PAS_PREFIX.'load_textdomain') );
		add_filter( 'plugin_row_meta', array ( $this,MWB_PAS_PREFIX.'row_meta'), 10, 2 );
		add_filter( 'plugin_action_links_' . plugin_basename(__FILE__), array ( $this,MWB_PAS_PREFIX.'action_links'));
		add_action('wp_ajax_mwb_pas_save_text', array ( $this,MWB_PAS_PREFIX.'save_text'));
		add_action( 'wp_ajax_nopriv_mwb_pas_save_text', array ( $this,MWB_PAS_PREFIX.'save_text'));
		
		$woo=new mwb_pas_bulkshare();
		register_activation_hook(__FILE__,array($this,'mwb_pas_activation'));

	}


	function mwb_pas_update_woocommerce_product($new_status,$old_status,$post){

		$post_ID = $post->ID;
		$post = get_post($post_ID );
		$link = get_permalink($post->ID);
		$product = wc_get_product($post->ID);

		$fb_share = get_post_meta($post_ID,'mwb_pas_fb_postid',true);
		$tweet_share = get_post_meta($post_ID,'mwb_pas_tweet_postid',true);
		$linkedin_share = get_post_meta($post_ID,'mwb_pas_linkedpost_id',true);
		$pinterest_share = get_post_meta($post_ID,'mwb_pas_pint_id',true);
		$mail_share  = get_post_meta($post_ID,'mwb_pas_mail',true);
		$tumblr_share = get_post_meta($post_ID,'mwb_pas_tumblr',true);
		$enable_share_post_on_update = get_option('mwb_pas_gen_settings',false);


		if((get_option("mwb_pas_gen_settings")['mwb_fb'] =="facebook"))
		{
			if( isset($product) && !empty($product) && ( $product->get_type() == 'simple' ))
			{
				$fbshare = new mwb_pas_fbshare();				
				$fbshare->mwb_pas_shareonfb($link, $product->get_id());
			}
			elseif(isset($product) && !empty($product) && ( $product->get_type() == 'variable' )){
				$fbshare = new mwb_pas_fbshare();				
				$fbshare->mwb_pas_shareonfb($link, $product->get_id());
			}
		}
		if((get_option("mwb_pas_gen_settings")['mwb_tweet'] =="twiter"))
		{
			if( isset($product) && !empty($product) && ( $product->get_type() == 'simple' ))
			{
				$tweet = new mwb_pas_share_tweet();
				$tweet->mwb_pas_tweet($link, $product->get_id());
			}
			elseif(isset($product) && !empty($product) && ( $product->get_type() == 'variable' )){
				$tweet = new mwb_pas_share_tweet();
				$tweet->mwb_pas_tweet($link, $product->get_id());
			}

		}
		if((get_option("mwb_pas_gen_settings")['mwb_pint'] =="pinterest"))
		{
			if( isset($product) && !empty($product) && ( $product->get_type() == 'simple' ))
			{
				$pin = new mwb_pas_share_pin();
				$pin->mwb_pas_pinthis($link, $product->get_id());
			}
			elseif(isset($product) && !empty($product) && ( $product->get_type() == 'variable' )){
				$pin = new mwb_pas_share_pin();
				$pin->mwb_pas_pinthis($link, $product->get_id());
			}
		}
		if((get_option("mwb_pas_gen_settings")['mwb_LinkedIn'] =="LinkedIn"))
		{
			if( isset($product) && !empty($product) && ( $product->get_type() == 'simple' ))
			{
				$linkshare = new mwb_pas_link_share();
				$linkshare->mwb_pas_share_on_linkedin($link, $product->get_id());
			}
			elseif(isset($product) && !empty($product) && ( $product->get_type() == 'variable' )){
				$linkshare = new mwb_pas_link_share();
				$linkshare->mwb_pas_share_on_linkedin($link, $product->get_id());
			}

		}
		if((get_option("mwb_pas_gen_settings")['mwb_tumblr'] =="tumblr"))
		{
			if( isset($product) && !empty($product) && ( $product->get_type() == 'simple' ))
			{

				$tumblrShare = new mwb_pas_tumblr();
				$tumblrShare->mwb_pas_tumblrshare($link, $product->get_id());
			}
			elseif(isset($product) && !empty($product) && ( $product->get_type() == 'variable' )){
				$tumblrShare = new mwb_pas_tumblr();
				$tumblrShare->mwb_pas_tumblrshare($link, $product->get_id());
			}
		}
	}


	/**
	  * This function is for sharing post while updating.
	  * @name mwb_pas_update_post_share()
	  * @author makewebbetter <webmaster@makewebbetter.com>
	  * @link http://makewebbetter.com/
	  */
	function mwb_pas_update_post_share($new_status, $old_status, $post)
	{
		$post_ID = $post->ID;
		$post = get_post($post_ID );
		$link = get_permalink($post->ID);
		
		$fb_share = get_post_meta($post_ID,'mwb_pas_fb_postid',true);
		$tweet_share = get_post_meta($post_ID,'mwb_pas_tweet_postid',true);
		$linkedin_share = get_post_meta($post_ID,'mwb_pas_linkedpost_id',true);
		$pinterest_share = get_post_meta($post_ID,'mwb_pas_pint_id',true);
		$mail_share  = get_post_meta($post_ID,'mwb_pas_mail',true);
		$tumblr_share = get_post_meta($post_ID,'mwb_pas_tumblr',true);
		$enable_share_post_on_update = get_option('mwb_pas_gen_settings',false);

		if(isset($post_ID) && get_post_type($post_ID) == 'post'){

			if((get_option("mwb_pas_gen_settings")['mwb_fb'] =="facebook"))
			{
				$fbshare = new mwb_pas_fbshare();				
				$fbshare->mwb_pas_shareonfb( $link,$post->ID );
			}
			if((get_option("mwb_pas_gen_settings")['mwb_tweet'] =="twiter"))
			{
				$tweet = new mwb_pas_share_tweet();
				$tweet->mwb_pas_tweet($link,$post->ID);

			}
			if((get_option("mwb_pas_gen_settings")['mwb_pint'] =="pinterest"))
			{

				$pin = new mwb_pas_share_pin();
				$pin->mwb_pas_pinthis($link,$post->ID);

			}
			if((get_option("mwb_pas_gen_settings")['mwb_LinkedIn'] =="LinkedIn"))
			{
				$linkshare = new mwb_pas_link_share();
				$linkshare->mwb_pas_share_on_linkedin($link,$post->ID);

			}
			if((get_option("mwb_pas_gen_settings")['mwb_tumblr'] =="tumblr"))
			{
				$tumblrShare = new mwb_pas_tumblr();
				$tumblrShare->mwb_pas_tumblrshare($link, $post->ID);
			}
		}
	}


	/**
	  * This function is for sharing coupons while updating.
	  * @name mwb_pas_update_coupons_share()
	  * @author makewebbetter <webmaster@makewebbetter.com>
	  * @link http://makewebbetter.com/
	  */
	function mwb_pas_update_coupons_share($new_status, $old_status, $post)
	{
		$post_ID = $post->ID;
		$post = get_post($post_ID );
		$link = get_permalink($post->ID);

		$fb_share = get_post_meta($post_ID,'mwb_pas_fb_postid',true);
		$tweet_share = get_post_meta($post_ID,'mwb_pas_tweet_postid',true);
		$linkedin_share = get_post_meta($post_ID,'mwb_pas_linkedpost_id',true);
		$pinterest_share = get_post_meta($post_ID,'mwb_pas_pint_id',true);
		$mail_share  = get_post_meta($post_ID,'mwb_pas_mail',true);
		$tumblr_share = get_post_meta($post_ID,'mwb_pas_tumblr',true);
		$enable_share_post_on_update = get_option('mwb_pas_gen_settings',false);

		if(isset($post_ID) && get_post_type($post_ID) == 'shop_coupon'){
			if((get_option("mwb_pas_gen_settings")['mwb_fb'] =="facebook"))
			{
				$fbshare = new mwb_pas_fbshare();				
				$fbshare->mwb_pas_shareonfb( $link,$post->ID );
			}
			if((get_option("mwb_pas_gen_settings")['mwb_tweet'] =="twiter"))
			{
				$tweet = new mwb_pas_share_tweet();
				$tweet->mwb_pas_tweet($link,$post->ID);

			}
			if((get_option("mwb_pas_gen_settings")['mwb_pint'] =="pinterest"))
			{

				$pin = new mwb_pas_share_pin();
				$pin->mwb_pas_pinthis($link,$post->ID);

			}
			if((get_option("mwb_pas_gen_settings")['mwb_LinkedIn'] =="LinkedIn"))
			{
				$linkshare = new mwb_pas_link_share();
				$linkshare->mwb_pas_share_on_linkedin($link,$post->ID);

			}
			if((get_option("mwb_pas_gen_settings")['mwb_tumblr'] =="tumblr"))
			{
				$tumblrShare = new mwb_pas_tumblr();
				$tumblrShare->mwb_pas_tumblrshare($link, $post->ID);
			}
		}
	}

	/**
	  * This function is for sharing giftcard product while updating.
	  * @name mwb_pas_update_gift_product_share()
	  * @author makewebbetter <webmaster@makewebbetter.com>
	  * @link http://makewebbetter.com/
	  */
	function mwb_pas_update_gift_product_share($new_status, $old_status, $post)
	{
		$post_ID = $post->ID;
		$post = get_post($post_ID );
		$link = get_permalink($post->ID);
		$mwb_pas_active_woocommerce = get_option('active_plugins',false);
		if(in_array('woocommerce/woocommerce.php',$mwb_pas_active_woocommerce)){
			$product = wc_get_product($post->ID);
		}

		$fb_share = get_post_meta($post_ID,'mwb_pas_fb_postid',true);
		$tweet_share = get_post_meta($post_ID,'mwb_pas_tweet_postid',true);
		$linkedin_share = get_post_meta($post_ID,'mwb_pas_linkedpost_id',true);
		$pinterest_share = get_post_meta($post_ID,'mwb_pas_pint_id',true);
		$mail_share  = get_post_meta($post_ID,'mwb_pas_mail',true);
		$tumblr_share = get_post_meta($post_ID,'mwb_pas_tumblr',true);
		$enable_share_post_on_update = get_option('mwb_pas_gen_settings',false);

		if((get_option("mwb_pas_gen_settings")['mwb_fb'] =="facebook"))
		{
			if( isset($product) && !empty($product) && ( $product->get_type() != 'simple' ))
			{
				if($product->get_type() != 'variable' && (isset($enable_share_post_on_update['all_product_share_on_update']) && $enable_share_post_on_update['all_product_share_on_update'] == 1))
				{
					$fbshare = new mwb_pas_fbshare();				
					$fbshare->mwb_pas_shareonfb( $link,$post->ID );
				}
			}
		}
		if((get_option("mwb_pas_gen_settings")['mwb_tweet'] =="twiter"))
		{
			if( isset($product) && !empty($product) && ( $product->get_type() != 'simple' ))
			{
				if($product->get_type() != 'variable' && (isset($enable_share_post_on_update['all_product_share_on_update']) && $enable_share_post_on_update['all_product_share_on_update'] == 1))
				{
					$tweet = new mwb_pas_share_tweet();
					$tweet->mwb_pas_tweet($link,$post->ID);
				}
			}

		}
		if((get_option("mwb_pas_gen_settings")['mwb_pint'] =="pinterest"))
		{
			if( isset($product) && !empty($product) && ( $product->get_type() != 'simple' ))
			{
				if($product->get_type() != 'variable' && (isset($enable_share_post_on_update['all_product_share_on_update']) && $enable_share_post_on_update['all_product_share_on_update'] == 1))
				{
					$pin = new mwb_pas_share_pin();
					$pin->mwb_pas_pinthis($link,$post->ID);
				}
			}

		}
		if((get_option("mwb_pas_gen_settings")['mwb_LinkedIn'] =="LinkedIn"))
		{
			if( isset($product) && !empty($product) && ( $product->get_type() != 'simple' ))
			{
				if($product->get_type() != 'variable' && (isset($enable_share_post_on_update['all_product_share_on_update']) && $enable_share_post_on_update['all_product_share_on_update'] == 1))
				{
					$linkshare = new mwb_pas_link_share();
					$linkshare->mwb_pas_share_on_linkedin($link,$post->ID);
				}
			}

		}
		if((get_option("mwb_pas_gen_settings")['mwb_tumblr'] =="tumblr"))
		{
			if( isset($product) && !empty($product) && ( $product->get_type() != 'simple' ))
			{
				if($product->get_type() != 'variable' && (isset($enable_share_post_on_update['all_product_share_on_update']) && $enable_share_post_on_update['all_product_share_on_update'] == 1))
				{
					$tumblrShare = new mwb_pas_tumblr();
					$tumblrShare->mwb_pas_tumblrshare($link, $post->ID);
				}
			}
		}
	}

	/**
	  * This function is for enqueue scripts and style.
	  * @name mwb_pas_addScripts()
	  * @author makewebbetter <webmaster@makewebbetter.com>
	  * @link http://makewebbetter.com/
	  */
	function mwb_pas_addScripts(){

		wp_register_script("task", plugins_url( 'assets/js/task.js', __FILE__ ));
		wp_enqueue_script( 'task', plugins_url( 'assets/js/task.js', __FILE__ ),array('jquery'),1.5,true);	
		wp_localize_script('task', 'id', array('ced_apin_auth_message'=> __('Click the link to redirect on Pintrest','post-auto-share'),'ced_click_event'=>__('click Here','post-auto-share') ,'ajax_url' => admin_url('admin-ajax.php'),'mwb_pas_nonce'=>wp_create_nonce( "mwb-pas-verify-nonce" ),'id'=> get_option( 'mwb_fb_sharepro_appid' )));
		
		wp_register_style("style_share", plugins_url( 'assets/css/style_share.css', __FILE__ ));
		wp_enqueue_style( 'style_share', plugins_url( 'assets/css/style_share.css', __FILE__ ),1,true);

	}
	/**
	 * This function is for loading textdomain.
	 * @name mwb_pas_load_textdomain()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	function mwb_pas_load_textdomain(){
		$domain = "post-auto-share";
		$locale = apply_filters( 'plugin_locale', get_locale(), $domain );
		load_textdomain( $domain, MWB_PAS_PATH .'language/'.$domain.'-' . $locale . '.mo' );
		$var = load_plugin_textdomain( 'post-auto-share', false, plugin_basename( dirname( __FILE__ ) ) . '/language' );	
		
	}
	
	
	/**
	  * This function is for calling the share functions when a post is added.
	  * @name mwb_pas_new_post_share($new_status, $old_status, $post)
	  * @author makewebbetter <webmaster@makewebbetter.com>
	  * @link http://makewebbetter.com/
	  */
	function mwb_pas_new_post_share($new_status, $old_status, $post) 
	{
		if( ( $new_status == 'publish' && !empty($post->ID) && get_post_type($post) != 'shop_coupon' ))
		{
			global $post;
			$post_ID = $post->ID;
			$post = get_post($post_ID );
			$link = get_permalink($post->ID);
			$mwb_pas_active_woocommerce = get_option('active_plugins',false);
			if(in_array('woocommerce/woocommerce.php',$mwb_pas_active_woocommerce)){
				$product = wc_get_product($post->ID);
			}

			$fb_share = get_post_meta($post_ID,'mwb_pas_fb_postid',true);
			$tweet_share = get_post_meta($post_ID,'mwb_pas_tweet_postid',true);
			$linkedin_share = get_post_meta($post_ID,'mwb_pas_linkedpost_id',true);
			$pinterest_share = get_post_meta($post_ID,'mwb_pas_pint_id',true);
			$mail_share  = get_post_meta($post_ID,'mwb_pas_mail',true);
			$tumblr_share = get_post_meta($post_ID,'mwb_pas_tumblr',true);
			$enable_share_post_on_update = get_option('mwb_pas_gen_settings',false);

			if((get_option("mwb_pas_gen_settings")['mwb_fb'] =="facebook"))
			{
				if( isset($product) && !empty($product) && ( $product->get_type() != 'simple' ))
				{
					if($product->get_type() != 'variable')
					{
						$fbshare = new mwb_pas_fbshare();				
						$fbshare->mwb_pas_shareonfb( $link,$post->ID );
					}
				}
				else
				{
					$fbshare = new mwb_pas_fbshare();				
					$fbshare->mwb_pas_shareonfb( $link,$post->ID );
				}
			}
			if((get_option("mwb_pas_gen_settings")['mwb_tweet'] =="twiter"))
			{
				
				if( isset($product) && !empty($product) && ( $product->get_type() != 'simple' ))
				{
					if($product->get_type() != 'variable')
					{
						$tweet = new mwb_pas_share_tweet();
						$tweet->mwb_pas_tweet($link,$post->ID);
					}
				}
				else
				{
					$tweet = new mwb_pas_share_tweet();
					$tweet->mwb_pas_tweet($link,$post->ID);
				}
			}
			if((get_option("mwb_pas_gen_settings")['mwb_pint'] =="pinterest"))
			{

				if( isset($product) && !empty($product) &&( $product->get_type() != 'simple' ))
				{
					if($product->get_type() != 'variable')
					{
						$pin = new mwb_pas_share_pin();
						$pin->mwb_pas_pinthis($link,$post->ID);
					}
				}
				else
				{
					$pin = new mwb_pas_share_pin();
					$pin->mwb_pas_pinthis($link,$post->ID);
				}
			}
			if((get_option("mwb_pas_gen_settings")['mwb_LinkedIn'] =="LinkedIn"))
			{
				if( isset($product) && !empty($product) && ( $product->get_type() != 'simple' ))
				{
					if($product->get_type() != 'variable')
					{
						$linkshare = new mwb_pas_link_share();
						$linkshare->mwb_pas_share_on_linkedin($link,$post->ID);
					}
				}
				else
				{
					$linkshare = new mwb_pas_link_share();
					$linkshare->mwb_pas_share_on_linkedin($link,$post->ID);
				}
			}
			if((get_option("mwb_pas_gen_settings")['mwb_tumblr'] =="tumblr"))
			{
				if( isset($product) && !empty($product) && ( $product->get_type() != 'simple' ))
				{
					if($product->get_type() != 'variable')
					{
						$tumblrShare = new mwb_pas_tumblr();
						$tumblrShare->mwb_pas_tumblrshare($link, $post->ID);
					}
				}
				else
				{
					$tumblrShare = new mwb_pas_tumblr();
					$tumblrShare->mwb_pas_tumblrshare($link, $post->ID);
				}
			}
		}
		elseif($new_status == 'publish' && get_post_type($post) == 'shop_coupon')
		{
			
			$post_ID = $post->ID;
			$post = get_post($post_ID );
			$link = get_permalink($post->ID);
			update_post_meta($post_ID,'mwb_pas_saved_coupon_data',$_POST);

			$fb_share = get_post_meta($post_ID,'mwb_pas_fb_postid',true);
			$tweet_share = get_post_meta($post_ID,'mwb_pas_tweet_postid',true);
			$linkedin_share = get_post_meta($post_ID,'mwb_pas_linkedpost_id',true);
			$pinterest_share = get_post_meta($post_ID,'mwb_pas_pint_id',true);
			$mail_share  = get_post_meta($post_ID,'mwb_pas_mail',true);
			$tumblr_share = get_post_meta($post_ID,'mwb_pas_tumblr',true);

			if((get_option("mwb_pas_gen_settings")['mwb_fb'] =="facebook")){

				$fbshare = new mwb_pas_fbshare();				
				$fbshare->mwb_pas_shareonfb( $link,$post->ID );

			}
			if((get_option("mwb_pas_gen_settings")['mwb_tweet'] =="twiter")){
				$tweet = new mwb_pas_share_tweet();
				$tweet->mwb_pas_tweet($link,$post->ID);
			}
			if((get_option("mwb_pas_gen_settings")['mwb_pint'] =="pinterest")){

				$pin = new mwb_pas_share_pin();
				$pin->mwb_pas_pinthis($link,$post->ID);
			}
			if((get_option("mwb_pas_gen_settings")['mwb_LinkedIn'] =="LinkedIn")){
				$linkshare = new mwb_pas_link_share();
				$linkshare->mwb_pas_share_on_linkedin($link,$post->ID);
			}
			
			if((get_option("mwb_pas_gen_settings")['mwb_tumblr'] =="tumblr")){
				$tumblrShare = new mwb_pas_tumblr();
				$tumblrShare->mwb_pas_tumblrshare($link, $post->ID);
			}
		}

	}

	/**
	  * This function is for adding custom message when post is updated.
	  * @name mwb_pas_custom_message($messages)
	  * @param messages
	  * @author makewebbetter <webmaster@makewebbetter.com>
	  * @link http://makewebbetter.com/
	*/	
	function mwb_pas_custom_message($messages){	

		global $post, $post_ID;

		$mwb_pas_activated_social_media = get_option( "mwb_pas_gen_settings",false );

		$enable_share_post_on_update = get_option('mwb_pas_gen_settings',false);
		$post_type = get_post_type($post_ID);

		$fb_share = get_post_meta($post_ID,'mwb_pas_fb_postid',true);
		$fb_page_share = get_post_meta($post_ID,'mwb_pas_fbpage_postid',true);
		$tweet_share = get_post_meta($post_ID,'mwb_pas_tweet_postid',true);
		$linkedin_share = get_post_meta($post_ID,'mwb_pas_linkedpost_id',true);
		$pinterest_share = get_post_meta($post_ID,'mwb_pas_pint_id',true);
		$tumblr_share = get_post_meta($post_ID,'mwb_pas_tumblr',true);

		$fb_error = get_option("mwb_pas_Fb_error");
		$pint_error = get_option("mwb_pas_pint_error");
		$tweet_error = get_option("mwb_pas_tweet_error");
		$link_error  = get_option("mwb_pas_link_error");
		$tumblr_error  = get_option("mwb_pas_tumblr_error");
		$share_msg = "and shared on ";
		
		$mwb_pas_active_woocommerce = get_option('active_plugins',false);
		if(in_array('woocommerce/woocommerce.php',$mwb_pas_active_woocommerce)){
			$product = wc_get_product($post->ID);
		}

		if(is_array($mwb_pas_activated_social_media) && !empty($mwb_pas_activated_social_media))
		{

			if ($mwb_pas_activated_social_media['mwb_pint'] == 'pinterest' && empty($pint_error) ) {
				
				$share_msg .= ' Pinterest ' ;
			}
			if ( $mwb_pas_activated_social_media['mwb_LinkedIn'] == 'LinkedIn' && empty($link_error )) {
				$share_msg .= 'Linkedin ' ;
			}

			if ( $mwb_pas_activated_social_media['mwb_fb'] == 'facebook' && empty($fb_error)) {
				if( $fb_page_share != "" && $fb_share != ""  ){
					$share_msg .= 'Facebook page and profile ';
				}elseif($fb_page_share != ""){
					$share_msg .= 'Facebook page ';
				}else{
					$share_msg .= 'Facebook profile ' ;
				}
			}
			if ( $mwb_pas_activated_social_media['mwb_tweet'] == 'twiter' && empty($tweet_error)) {
				$share_msg .= ' Twitter' ;
			}
			if( $mwb_pas_activated_social_media['mwb_tumblr'] == 'tumblr' && empty($tumblr_error)){
				$share_msg .= ' Tumblr Blog' ;
			}
		}
		if($post_type == 'shop_coupon')
		{
			if( $share_msg == "and shared on " && $enable_share_post_on_update['all_coupons_share_on_update'] == 1)
			{
				$share_msg = __(' but some credentials not authorized ','post-auto-share');
				$messages['shop_coupon'] = array(
					1 =>sprintf( __( 'Coupon updated ','post-auto-share').'%s',$share_msg ),	
					6 => sprintf( __( 'Coupon published ','post-auto-share').'%s.',$share_msg),
					);
			}
			elseif( $share_msg != "and shared on " && $enable_share_post_on_update['all_coupons_share_on_update'] == 1)
			{
				$messages['shop_coupon'] = array(
					1 =>sprintf( __( 'Coupon updated ','post-auto-share').'%s', $share_msg),	
					6 => sprintf( __( 'Coupon published ','post-auto-share').'%s.', $share_msg ),
					);
			}
			else
			{
				$share_msg = __('but sharing of post on update is not enable ','post-auto-share');
				$messages['shop_coupon'] = array(
					1 =>sprintf( __( 'Coupon updated ','post-auto-share').'%s', $share_msg ),
					);
			}
		}
		else
		{
			if($post_type == 'post'){
				if( $share_msg == "and shared on " && $enable_share_post_on_update['all_post_share_on_update'] == 1){

					$share_msg = __(' but some credentials not authorized ','post-auto-share');
					$messages['post'] = array(
						1 =>sprintf( __( 'Post updated ','post-auto-share').'%s'.' <a href="%s">'.__('View Post','post-auto-share').'</a>', $share_msg,esc_url( get_permalink( $post_ID ) ) ),	
						6 => sprintf( __( 'Post published ','post-auto-share').'%s.'.' <a href="%s">'.__('View Post','post-auto-share').'</a>', $share_msg,esc_url( get_permalink( $post_ID ) ) ),
						);
					
				}
				elseif($share_msg != "and shared on " && $enable_share_post_on_update['all_post_share_on_update'] == 1){

					$messages['post'] = array(
						1 =>sprintf( __( 'Post updated ','post-auto-share').'%s'.' <a href="%s">'.__('View Post','post-auto-share').'</a>', $share_msg,esc_url( get_permalink( $post_ID ) ) ),	
						6 => sprintf( __( 'Post published ','post-auto-share').'%s.'.' <a href="%s">'.__('View Post','post-auto-share').'</a>', $share_msg,esc_url( get_permalink( $post_ID ) ) ),
						);
					
				}
				else
				{
					$share_msg = __('but sharing of post on update is not enable ','post-auto-share');

					$messages['post'] = array(
						1 =>sprintf( __( 'Post updated ','post-auto-share').'%s'.' <a href="%s">'.__('View Post','post-auto-share').'</a>', $share_msg,esc_url( get_permalink( $post_ID ) ) ),
						);
				}
			}
			elseif($post_type == 'product')
			{
				if( $share_msg == "and shared on " && $enable_share_post_on_update['all_product_share_on_update'] == 1){

					$share_msg = __(' but some credentials not authorized ','post-auto-share');
					if($post_type == 'product'){
						$messages['product'] = array(
							1 =>sprintf( __( 'Product updated ','post-auto-share').'%s'.' <a href="%s">'.__('View Product','post-auto-share').'</a>', $share_msg,esc_url( get_permalink( $post_ID ) ) ),	
							6 => sprintf( __( 'Product published ','post-auto-share').'%s.'.' <a href="%s">'.__('View Product','post-auto-share').'</a>', $share_msg,esc_url( get_permalink( $post_ID ) ) ),
							);
					}
				}
				elseif($share_msg != "and shared on " && $enable_share_post_on_update['all_product_share_on_update'] == 1){

					if($post_type == 'product'){
						$messages['product'] = array(
							1 =>sprintf( __( 'Product updated ','post-auto-share').'%s'.' <a href="%s">'.__('View Product','post-auto-share').'</a>', $share_msg,esc_url( get_permalink( $post_ID ) ) ),	
							6 => sprintf( __( 'Product published ','post-auto-share').'%s.'.' <a href="%s">'.__('View Product','post-auto-share').'</a>', $share_msg,esc_url( get_permalink( $post_ID ) ) ),
							);
					}
				}
				elseif($share_msg == "and shared on " && isset($enable_share_post_on_update['all_wooproduct_share_on_update']) && $enable_share_post_on_update['all_wooproduct_share_on_update'] == 1){
					$share_msg = __(' but some credentials not authorized ','post-auto-share');
					if($post_type == 'product'){
						$messages['product'] = array(
							1 =>sprintf( __( 'Product updated ','post-auto-share').'%s'.' <a href="%s">'.__('View Product','post-auto-share').'</a>', $share_msg,esc_url( get_permalink( $post_ID ) ) ),	
							6 => sprintf( __( 'Product published ','post-auto-share').'%s.'.' <a href="%s">'.__('View Product','post-auto-share').'</a>', $share_msg,esc_url( get_permalink( $post_ID ) ) ),
							);
					}
				}
				elseif($share_msg != "and shared on " && isset($enable_share_post_on_update['all_wooproduct_share_on_update']) && $enable_share_post_on_update['all_wooproduct_share_on_update'] == 1){
					if($post_type == 'product'){
						$messages['product'] = array(
							1 =>sprintf( __( 'Product updated ','post-auto-share').'%s'.' <a href="%s">'.__('View Product','post-auto-share').'</a>', $share_msg,esc_url( get_permalink( $post_ID ) ) ),	
							6 => sprintf( __( 'Product published ','post-auto-share').'%s.'.' <a href="%s">'.__('View Product','post-auto-share').'</a>', $share_msg,esc_url( get_permalink( $post_ID ) ) ),
							);
					}
				}
				else
				{
					$share_msg = __('but sharing of post on update is not enable ','post-auto-share');
					if($post_type == 'product'){
						$messages['product'] = array(
							1 =>sprintf( __( 'Product updated ','post-auto-share').'%s'.' <a href="%s">'.__('View Post','post-auto-share').'</a>', $share_msg,esc_url( get_permalink( $post_ID ) ) ),
							);
					}
				}
			}
		}
		return apply_filters("pas_custom_publish_msg",$messages); 	
	}
	
	
	/**
	  * This function is for adding error message when there is error in sharing.
	  * @name mwb_pas_share_error()
	  * @author makewebbetter <webmaster@makewebbetter.com>
	  * @link http://makewebbetter.com/
	  */	
	function mwb_pas_share_error(){
		global $post;
		if(!isset($_GET['post'])){
			return;
		}
		?>	
		<div class="notice notice-error is-dismissible">
			<?php
			$fb_error = get_option("mwb_pas_Fb_error");
			$pint_error = get_option("mwb_pas_pint_error");
			$tweet_error = get_option("mwb_pas_tweet_error");
			$link_error  = get_option("mwb_pas_link_error");
			$tumblr_error  = get_option("mwb_pas_tumblr_error");


			if($fb_error != ''){
				?>
				<p> <?php  _e("Facebook API Error: ".$fb_error,"post-auto-share")?></p>
				<?php }?>
				<?php if($pint_error != ''){?>
				<p> <?php  _e("Pinterest API Error: ".$pint_error,"post-auto-share")?></p>
				<?php }?>
				<?php if($tweet_error != ''){?>
				<p> <?php  _e("Twitter API Error: ".$tweet_error,"post-auto-share")?></p>
				<?php }?>
				<?php if($link_error != ''){?>
				<p> <?php  _e("Linkedin API Error: ".$link_error,"post-auto-share")?></p>
				<?php }?>	
				<?php if($tumblr_error != ''){?>
				<p> <?php  _e("Tumblr API Error: ".$tumblr_error,"post-auto-share")?></p>
				<?php }?>			
			</div>
			<?php
			delete_option("mwb_pas_Fb_error");
			delete_option("mwb_pas_pint_error");
			delete_option("mwb_pas_tweet_error");
			delete_option("mwb_pas_link_error");
			delete_option("mwb_pas_tumblr_error");

		}

	/**
	  * This function is for starting the session.
	  * @name mwb_pas_start_session()
	  * @author makewebbetter <webmaster@makewebbetter.com>
	  * @link http://makewebbetter.com/
	  */	
	function mwb_pas_start_session(){
		if (session_status() == PHP_SESSION_NONE) {
			session_start();
		}
	}
	
	
	
	
	/**
	 * This function is for adding plugin row meta.
	 * @name mwb_pas_row_meta()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	function mwb_pas_row_meta( $links, $file ) {
		if ( strpos( $file, 'mwb-share-post.php' ) !== false ) {
			$new_links = array();
			$links = array_merge( $links, $new_links );
		}
		return $links;
	}
	
	/**
	 * This function is for adding plugin action link.
	 * @name mwb_pas_action_links()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */

	function mwb_pas_action_links( $links ) {
		$link[] = '<a href="'. esc_url( get_admin_url(null, 'admin.php?page=share-post-settings') ) .'">Settings</a>';
		return array_merge($link,$links);
	}

	 /**
	  * This function is for adding facebook review metabox on post type post.
	  * @name mwb_pas_fb_reviews_post($param)
	  * @param 
	  * @author makewebbetter <webmaster@makewebbetter.com>
	  * @link http://makewebbetter.com/
	  */
	 function mwb_pas_fb_reviews_post($param) {	
	 	global $post;
	 	$addmetabox = new mwb_pas_msg_metabox();


	 	if(isset($post) && get_post_type($post) == 'product')
	 	{
	 		$mwb_pas_product_type = wp_get_object_terms( $post->ID, 'product_type' );

	 		if(isset($mwb_pas_product_type[0]))
	 		{
	 			$mwb_pas_product_type = $mwb_pas_product_type[0]->slug;
	 			if($mwb_pas_product_type == 'wgm_gift_card')
	 			{

	 				add_meta_box('mwb_pas_meta',__('Post Auto Share','post-auto-share'), array($addmetabox,'add_meta_box'),'product', 'side', 'high' );
	 			}
	 		}
	 		add_meta_box('mwb_pas_meta',__('Post Auto Share','post-auto-share'), array($addmetabox,'add_meta_box'),'product', 'side', 'high' );
	 	}
	 	elseif(isset($post) && get_post_type($post) == 'shop_coupon')
	 	{
	 		$mwb_pas_wuc = get_option('active_plugins');
	 		if( in_array('woocommerce-ultimate-coupons/woocommerce-ultimate-coupons.php',$mwb_pas_wuc))
	 		{

	 			$havemeta = metadata_exists('post', $post->ID, 'mwb_wuc_coupon_type');
	 			if($havemeta)
	 			{

	 				add_meta_box('mwb_pas_meta',__('Post Auto Share','post-auto-share'), array($addmetabox,'add_meta_box'),'shop_coupon', 'side', 'high' );
	 			}

	 		}
	 		else
	 		{
	 			delete_post_meta($post->ID,'mwb_wuc_coupon_type');
	 			
	 		}

	 	}
	 	else
	 	{
	 		add_meta_box('mwb_pas_meta',__('Post Auto Share','post-auto-share'), array($addmetabox,'add_meta_box'),'post', 'side', 'high' );
	 	}
	 	if(get_option('mwb_pas_gen_settings')['mwb_fb_reviews'] == "on")
	 	{			
	 		add_meta_box('fb_meta',__('Facebook Page Reviews','post-auto-share'), array($this,'mwb_pas_fb_comments'));	
	 	}
	 }

	 
	 /**
	  * This function is for saving post message.
	  * @name mwb_pas_save_text
	  * @author makewebbetter <webmaster@makewebbetter.com>
	  * @link http://makewebbetter.com/
	  */
	 function mwb_pas_save_text(){
	 	if ( ! wp_verify_nonce( $_POST['nonce'], 'mwb_pas' ) )
	 		die ( 'Busted!');
	 	$data =	sanitize_text_field($_POST['text']);
	 	$post_id = $_POST['post_id'];
		//update_option('mwb_pas_custom_msg', $data);
	 	update_post_meta($post_id,'mwb_pas_custom_msg',$data);
	 }

	/**
	  * This function is for getting facebook comments.
	  * @name mwb_pas_fb_comments()
	  * @author makewebbetter <webmaster@makewebbetter.com>
	  * @link http://makewebbetter.com/
	  */
	function mwb_pas_fb_comments(){
		global $post;

		$app_id= get_option( 'mwb_fb_sharepro_appid' );
		$app_secret= get_option( 'mwb_fb_sharepro_appsec' );
		$access_token= get_option('mwb_pas_fbpage_token');
		$page = get_option('sharepro_pageid');
		$post_fbshare = get_post_meta($post->ID, 'mwb_pas_fbpage_postid', true );
		
		$comments_url = mwb_pas_graph_url.'/'.$post_fbshare.'?fields=comments&access_token='.$access_token;

		$response = wp_remote_get($comments_url);
		
		$params1=$response['body']; 
		$params=json_decode($params1,true); 
		
		if(isset($params) && !empty($params))
		{
			foreach ($params as $key=>$value){

				if($key=="comments"){
					if(is_array($value)){
						foreach ($value as $key1=>$val){

							foreach ($val as $key2=>$val1) {


								$pic = mwb_pas_graph_url.'/'.$val1['from']['id']."/picture?type=square";
								
								echo "<div class=div12><div class=div14><img width=32 height=32 class=avatar avatar-32 photo height=25px width=25px src=$pic></div>";
								echo "<div class=div13><strong>&nbsp".$val1['from']['name']."</strong>";

								echo "<p>&nbsp&nbsp".$val1['message']."</p></div></div>";

							}
							break;
						}

					}
				}
				elseif($key == "error")
				{
					$message = __('No Reviews on this post','post-auto-share');
					echo "<div class=no_comments><p>&nbsp".$message."</p>";
				}
			}
		}
	}	

	public function mwb_pas_activation()
	{
		$mwb_pas_existing_time = get_option('mwb_pas_activation_date_time','');
		if(isset($mwb_pas_existing_time) && ( $mwb_pas_existing_time == '' || $mwb_pas_existing_time == null)){
			$mwb_pas_current_datetime = current_time('timestamp');
			update_option('mwb_pas_activation_date_time',$mwb_pas_current_datetime);
		}
		else
		{
			$mwb_pas_current_datetime = get_option('mwb_pas_activation_date_time',false);
		}
		$mwb_pas_current_dir = MWB_PAS_PATH.'includes/images';
		$mwb_pas_path = wp_upload_dir();         
		$mwb_pas_new_dirNew = $mwb_pas_path['basedir'];

		$value = $this->copyimages($mwb_pas_current_dir,$mwb_pas_new_dirNew); //$dir -  source path, $dirNew – destination path
	}

	public function copyimages($mwb_pas_current_dir,$mwb_pas_new_dirNew)
	{

		if (is_dir($mwb_pas_current_dir)) {

			if ($mwb_pas_dh = opendir($mwb_pas_current_dir)) {

				while(($file = readdir($mwb_pas_dh)) !== false) {
					if($file == '.') continue;
					if($file == '..') continue;
					copy("$mwb_pas_current_dir/$file","$mwb_pas_new_dirNew/$file");

				}

				closedir($mwb_pas_dh);

			}
		}
		return true;
	}
}
new post_auto_share();
