<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
require (MWB_PAS_PATH.'/Apis/tumblr/mwbtumblrPHP.php');
class mwb_pas_tumblr {
	/**
	 * This function is for sharing on tumblr.
	 * @name mwb_pas_tumblrshare($link,$postid)
	 * @param1  link
	 * @param2 postid
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	function mwb_pas_tumblrshare($link,$postid){


		$app_id= get_option('mwb_pas_tumblr_settings')['mwb_tumblr_app_id'];
		if($app_id == ""){
			return false;
		}
		$app_id = get_option('mwb_pas_tumblr_settings')['mwb_tumblr_app_id'];
		$app_secret	= get_option('mwb_pas_tumblr_settings')['mwb_tumblr_app_sec'];
		$accessToken    =  get_option('mwb_pas_tumblr_settings')['mwb_tumblr_access'];
		$accessTokenSecret	= get_option('mwb_pas_tumblr_settings')['mwb_tumblr_access_sec'];
		$blogUrl = get_option('mwb_pas_tumblr_settings')['mwb_tumblr_blog_url'];
		

		$post = get_post($postid);
		if(isset($post) && !empty($post) && $post->post_type == 'shop_coupon')
		{
			$couponsobj =  get_post_meta($postid,'mwb_pas_saved_coupon_data',true);

			if(is_array($couponsobj) && !empty($couponsobj))
			{
				// $imgurl =  MWB_PAS_URL.'includes/images/banner-button.jpg';
				$uploadpath = wp_upload_dir();
				$uploadpath = $uploadpath['baseurl'];
				$imgurl =  $uploadpath.'/banner-button.jpg';
				
				$mwb_pas_currency_symbol = get_woocommerce_currency_symbol();
				$msg = 'Coupon Tiltle - '.html_entity_decode($couponsobj['post_title'],ENT_COMPAT,'UTF-8');
				$msg .="\n".'Coupon Description - '.html_entity_decode($couponsobj['excerpt'],ENT_COMPAT,'UTF-8');
				$msg .="\n".'Coupon Amount - '.html_entity_decode($couponsobj['coupon_amount'],ENT_COMPAT,'UTF-8').html_entity_decode($mwb_pas_currency_symbol,ENT_COMPAT,'UTF-8');

				if(isset($couponsobj['expiry_date']) && ($couponsobj['expiry_date'] != '' || !empty($couponsobj['expiry_date'])))
				{
					$msg .="\n".'expires on - '.html_entity_decode($couponsobj['expiry_date'],ENT_COMPAT,'UTF-8');
				}
				else
				{
					$ExpMessage = __('NO Expiry','post-auto-share');
					$msg .="\n".'expires on - '.$ExpMessage;	
				}

				$tms=get_post_meta($postid,'mwb_pas_custom_msg',true);
				$tumb_link = get_home_url();

				$params = array(
					'type'=>"link",
					'url'=> $tumb_link,
					'title'=>$msg,
					'description'=> html_entity_decode($tms,ENT_COMPAT,'UTF-8'),
					'thumbnail'=> $imgurl
					// 'thumbnail'=> 'https://scontent.cdninstagram.com/t51.2885-15/s640x640/sh0.08/e35/13261069_260805300940423_546170553_n.jpg?ig_cache_key=MTI2MDM2OTU4ODQzMTI2ODg3OA%3D%3D.2'
					);

				try 
				{

					$tumblr = new Tumblr( $app_id,$app_secret, $accessToken,$accessTokenSecret);
					$response = $tumblr->oauth_post("/blog/".$blogUrl."/post",$params);		

					if($response->meta->status == 201)
					{
						$postId = $response->response->id;			
						update_post_meta($postid,'mwb_pas_tumblr',$postId);
						if(get_option("mwb_pas_tumblr_error") != "")
						{
							delete_option("mwb_pas_tumblr_error");
						}
						set_transient( 'mwb-admin-notice-panel', true, 5 );
						return true ;
					}
					elseif($response->meta->status == 403)
					{
						update_option("mwb_pas_tumblr_error",$response->response);
						set_transient( 'mwb-admin-notice-panel', true, 5 );
						return false;
					}
					else
					{		
						$errormsg = $response->meta->msg.__(': can not share on tumblr please provide image','post-auto-share');
						update_option("mwb_pas_tumblr_error",$errormsg);
						set_transient( 'mwb-admin-notice-panel', true, 5 );
						return false;
					}
				} 
				catch (Exception $e) 
				{			
					update_option("mwb_pas_tumblr_error",$e->getMessage());
					return false;
				}			

			}
		}
		else
		{
			
			$imgurl = wp_get_attachment_url( get_post_thumbnail_id($postid));				
			$msg = get_the_title($postid);
			$tms = get_post_meta($postid,'mwb_pas_custom_msg',true);

			$params = array(
				'type'=>"link",
				'url'=> $link,
				'title'=>html_entity_decode($msg, ENT_COMPAT, 'UTF-8'),
				'description'=>html_entity_decode($tms, ENT_COMPAT, 'UTF-8'),
				'thumbnail'=> $imgurl
				// 'thumbnail'=> 'https://www.nasa.gov/sites/default/files/styles/image_card_4x3_ratio/public/thumbnails/image/36782365195_b7fcd1480c_o.jpg'
				);

			try {

				
				$tumblr = new Tumblr( $app_id,$app_secret, $accessToken,$accessTokenSecret);
				$response = $tumblr->oauth_post("/blog/".$blogUrl."/post",$params);		
           
				if($response->meta->status == 201){
					$postId = $response->response->id;			
					update_post_meta($postid,'mwb_pas_tumblr',$postId);
					if(get_option("mwb_pas_tumblr_error") != ""){
						delete_option("mwb_pas_tumblr_error");
					}
					set_transient( 'mwb-admin-notice-panel', true, 5 );
					return true ;
				}elseif($response->meta->status == 403){
					update_option("mwb_pas_tumblr_error",$response->response);
					set_transient( 'mwb-admin-notice-panel', true, 5 );
					return false;
				}
				else{		
					$errormsg = $response->meta->msg.__(': can not share on tumblr please provide image','post-auto-share');
					update_option("mwb_pas_tumblr_error",$errormsg);
					set_transient( 'mwb-admin-notice-panel', true, 5 );
					return false;
				}
			} catch (Exception $e) {			
				update_option("mwb_pas_tumblr_error",$e->getMessage());
				return false;
			}
		}
		
	}
}
