<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
require_once(MWB_PAS_PATH.'/Apis/tmhOAuth.php');
class mwb_pas_share_tweet {
	/**
	  * This function is for sharing on Twiiter.
	  * @name mwb_pas_tweet($link,$postid)
	  * @param1 postlink 
	  * @param2 postid
	  * @author makewebbetter <webmaster@makewebbetter.com>
	  * @link http://makewebbetter.com/
	  */
	function mwb_pas_tweet($link,$postid){
		$app_id= get_option('mwb_pas_twitter_settings')['mwb_twitter_app_id'];		
		if($app_id == ""){
			return;
		}
		$settings = array(
			'consumer_key' => get_option('mwb_pas_twitter_settings')['mwb_twitter_app_id'],
			'consumer_secret' => get_option('mwb_pas_twitter_settings')['mwb_twitter_app_sec'],
			'user_token' => get_option('mwb_pas_twitter_settings')['mwb_twitter_access'],
			'user_secret' => get_option('mwb_pas_twitter_settings')['mwb_twitter_access_sec'],
			'curl_ssl_verifypeer'   => false
			);

		
		$twit = new tmhOAuth($settings);

		// for shop coupons
		$post = get_post($postid);
		if(isset($post) && !empty($post) && $post->post_type == 'shop_coupon')
		{
			$couponsobj =  get_post_meta($postid,'mwb_pas_saved_coupon_data',true);

			if(is_array($couponsobj) && !empty($couponsobj))
			{
				$mwb_pas_currency_symbol = get_woocommerce_currency_symbol();
				$msg = 'Coupon Tiltle - '.html_entity_decode($couponsobj['post_title'],ENT_COMPAT,'UTF-8');
				$msg .="\n".'Coupon Description - '.html_entity_decode($couponsobj['excerpt'],ENT_COMPAT,'UTF-8');
				$msg .="\n".'Coupon Amount - '.html_entity_decode($couponsobj['coupon_amount'],ENT_COMPAT,'UTF-8').html_entity_decode($mwb_pas_currency_symbol,ENT_COMPAT,'UTF-8');

				if(isset($couponsobj['expiry_date']) && ($couponsobj['expiry_date'] != '' || !empty($couponsobj['expiry_date'])))
				{
					$msg .="\n".'expires on - '.html_entity_decode($couponsobj['expiry_date'],ENT_COMPAT,'UTF-8');
				}
				else
				{
					$ExpMessage = __('NO Expiry','post-auto-share');
					$msg .="\n".'expires on - '.$ExpMessage;	
				}


				$msg .= "\n".get_post_meta($postid,'mwb_pas_custom_msg',true);
				
				$uploadpath = wp_upload_dir();
				$uploadpath = $uploadpath['baseurl'];
				$imgurl =  $uploadpath.'/banner-button.jpg';

				$postfields = array();

				$arrContextOptions=array(
					"ssl"=>array(
						"verify_peer"=>false,
						"verify_peer_name"=>false,
						),
					);  
				
				if(isset($imgurl) && $imgurl != "")
				{
					$imageurl = file_get_contents($imgurl,false,stream_context_create($arrContextOptions));
				}

				$tweet_link = get_home_url();
				if($imgurl != ""){
					$postfields = array(
						'status' => $msg."\n".$tweet_link,
						'media[]'  => $imageurl

						);
				}
				
				$tmh = 'https://api.twitter.com/1.1/statuses/update_with_media.json';
				try{
					$response=$twit->request('POST',$tmh,$postfields,true,true);

					if($response == 200){
						update_post_meta($postid,'mwb_pas_tweet_postid',$response);

						if(get_option("mwb_pas_tweet_error") != ""){
							delete_option("mwb_pas_tweet_error");
						}
					}

					elseif($imgurl == ""){
						update_option('mwb_pas_tweet_error', "You did't provide image of post to tweet please set featured image");
						return false;	
					}
					else{
						update_option('mwb_pas_tweet_error', "Some error occured with tweet please verify your Api keys.");
						return  false;
					}
					set_transient( 'mwb-admin-notice-panel', true, 5 );
					return true;
				}catch(Exception $e){
					update_option('mwb_pas_tweet_error', "Some error occured with tweet please verify your Api keys.");
					return  false;
				}

			}
		}
		else
		{

			$imgurl = wp_get_attachment_url( get_post_thumbnail_id($postid) );
			$postfields = array();
			$msg = html_entity_decode(get_the_title($postid), ENT_COMPAT, 'UTF-8');

			$msg .= "\n".get_post_meta($postid,'mwb_pas_custom_msg',true);

			$arrContextOptions=array(
				"ssl"=>array(
					"verify_peer"=>false,
					"verify_peer_name"=>false,
					),
				);  
			if(isset($imgurl) && $imgurl != "")
			{

				$imgurl = file_get_contents($imgurl,false,stream_context_create($arrContextOptions));
			}
			
			if($imgurl != ""){
				$postfields = array(
					'status' => $msg."\n".$link,
					'media[]'  => $imgurl

					);
			}


			$tmh = 'https://api.twitter.com/1.1/statuses/update_with_media.json';
			try{
      
				$response=$twit->request('POST',$tmh,$postfields,true,true);

				if($response == 200){
					update_post_meta($postid,'mwb_pas_tweet_postid',$response);

					if(get_option("mwb_pas_tweet_error") != ""){
						delete_option("mwb_pas_tweet_error");
					}
				}
				elseif($imgurl == ""){
					update_option('mwb_pas_tweet_error', "You did't provide image of post to tweet please set featured image");
					return false;	
				}
				else{
					update_option('mwb_pas_tweet_error', "Some error occured with tweet please verify your Api keys.");
					return  false;
				}
				set_transient( 'mwb-admin-notice-panel', true, 5 );
				return true;
			}catch(Exception $e){
				update_option('mwb_pas_tweet_error', "Some error occured with tweet please verify your Api keys.");
				return  false;
			}
		}

	}
}
