<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

require_once( MWB_PAS_PATH . '/Apis/pin_it.php' );
class mwb_pas_share_pin {
	/**
	  * This function is for sharing on pinterest.
	  * @name mwb_pas_pinthis($link, $id)
	  * @param1 link 
	  * @param2 id
	  * @author makewebbetter <webmaster@makewebbetter.com>
	  * @link http://makewebbetter.com/
	  */
	function mwb_pas_pinthis( $link, $id ) {
		$app_id = get_option( "mwb_sharepro_pin_appid" );

		if( $app_id == "" ) {
			return false;
		}

		$pin 		=  new pin( get_option( "mwb_sharepro_pin_appid" ), get_option( "mwb_sharepro_pin_appsec" ) );
		$board_id 	= get_option( 'mwb_sharepro_pin_pageid' );
		$pin->set_token( get_option( "mwb_sharepro_pin_acctoken" ) );	
		
		$post = get_post($id);
		if(isset($post) && !empty($post) && $post->post_type == 'shop_coupon')
		{
			$couponsobj =  get_post_meta($id,'mwb_pas_saved_coupon_data',true);

			if(is_array($couponsobj) && !empty($couponsobj))
			{
				$mwb_pas_currency_symbol = get_woocommerce_currency_symbol();
				$msg = 'Coupon Tiltle - '.html_entity_decode($couponsobj['post_title'],ENT_COMPAT,'UTF-8');
				$msg .="\n".'Coupon Description - '.html_entity_decode($couponsobj['excerpt'],ENT_COMPAT,'UTF-8');
				$msg .="\n".'Coupon Amount - '.html_entity_decode($couponsobj['coupon_amount'],ENT_COMPAT,'UTF-8').html_entity_decode($mwb_pas_currency_symbol,ENT_COMPAT,'UTF-8');

				if(isset($couponsobj['expiry_date']) && ($couponsobj['expiry_date'] != '' || !empty($couponsobj['expiry_date'])))
				{
					$msg .="\n".'expires on - '.html_entity_decode($couponsobj['expiry_date'],ENT_COMPAT,'UTF-8');
				}
				else
				{
					$ExpMessage = __('NO Expiry','post-auto-share');
					$msg .="\n".'expires on - '.$ExpMessage;	
				}


				
				$msg .="\n".get_post_meta($id,'mwb_pas_custom_msg',true); 

				$uploadpath = wp_upload_dir();
				$uploadpath = $uploadpath['baseurl'];
				$image_url =  $uploadpath.'/banner-button.jpg';

				try
				{
					$pin->set_token( get_option( "mwb_sharepro_pin_acctoken" ) );

					$pin_link = get_home_url();
					$result 	= $pin->pinit($board_id, $msg, $image_url, $pin_link);
					$new_pin 	= json_decode( $result, true);

					if( isset( $new_pin['data']['id'] ) ) 
					{
						update_post_meta( $id, 'mwb_pas_pint_id', $new_pin['data']['id'] );	
						if( get_option( "mwb_pas_pint_error" ) != "" ) 
						{
							delete_option( "mwb_pas_pint_error" );
						}
					} 
					else
					{
						$error = $new_pin['message'];

						update_option( "mwb_pas_pint_error", $error );
						return false;
					}
					set_transient( 'mwb-admin-notice-panel', true, 5 );
					return true;
				} 
				catch( Exception $e ) 
				{ 

					update_option( "mwb_pas_pint_error", $e->getMessage() );
					return false;
				}

			}
		}
		else
		{

			$note = get_the_title($id)."\n".get_post_meta($id,'mwb_pas_custom_msg',true);
			
			$image_url 	= wp_get_attachment_url( get_post_thumbnail_id( $id ) );
		
			$arrContextOptions=array(
				"ssl"=>array(
					"verify_peer"=>false,
					"verify_peer_name"=>false,
					),
				);  
			
			if($image_url != ''){

				$image = file_get_contents($image_url, false, stream_context_create($arrContextOptions));
			}
			else
			{
				$image = '';
			}


			try {
				$pin->set_token( get_option( "mwb_sharepro_pin_acctoken" ) );

				if($image_url != '')
				{

					$result 	= $pin->pinit($board_id,$note,$image_url,$link);
					$new_pin 	= json_decode( $result, true);

				}
				else
				{
					$error = __('Image Missing, Please attach Post Image','post-auto-share');
					update_option( "mwb_pas_pint_error", $error );
					return false;
				}

				if( isset( $new_pin['data']['id'] ) ) {
					update_post_meta( $id, 'mwb_pas_pint_id', $new_pin['data']['id'] );	

					if( get_option( "mwb_pas_pint_error" ) != "" ) {
						delete_option( "mwb_pas_pint_error" );
					}
				} else {
					$error = $new_pin['message'];

					update_option( "mwb_pas_pint_error", $error );
					return false;
				}
				set_transient( 'mwb-admin-notice-panel', true, 5 );
				return true;
			} catch( Exception $e ) { 

				update_option( "mwb_pas_pint_error", $e->getMessage() );
				return false;
			}
		}
	}
}
