<?php
if ( ! defined( 'ABSPATH' ) ) {
        exit; // Exit if accessed directly
      }
      require_once(MWB_PAS_PATH.'/Apis/Linkedin.php');
      class mwb_pas_link_share{

        /**
         * This function is for sharing on linkedin.
         * @name mwb_pas_share_on_linkedin($param1,$param2)
         * @param1 postlink
         * @param2 postid
         * @author makewebbetter <webmaster@makewebbetter.com>
         * @link http://makewebbetter.com/
         */
        function mwb_pas_share_on_linkedin($param1,$param2)
        {

          $app_id = get_option("mwb_linked_settings")['mwb_linkedin_apiid'];
          if($app_id == ""){
            return;
          }
          $config = array(
            'api_key' => get_option("mwb_linked_settings")['mwb_linkedin_apiid'],
            'api_secret' => get_option("mwb_linked_settings")['mwb_linkedin_appsec'],
            'callback_url' => get_admin_url()."admin.php?page=share-post-settings&tab=linkedin"
            );

            // for shop coupons
          $post = get_post($param2);
          if(isset($post) && !empty($post) && $post->post_type == 'shop_coupon')
          {
            $couponsobj =  get_post_meta($param2,'mwb_pas_saved_coupon_data',true);

            if(is_array($couponsobj) && !empty($couponsobj))
            {
              $mwb_pas_currency_symbol = get_woocommerce_currency_symbol();
              $msg = 'Coupon Tiltle - '.html_entity_decode($couponsobj['post_title'],ENT_COMPAT,'UTF-8');
              $msg .="\n".'Coupon Description - '.html_entity_decode($couponsobj['excerpt'],ENT_COMPAT,'UTF-8');
              $msg .="\n".'Coupon Amount - '.html_entity_decode($couponsobj['coupon_amount'],ENT_COMPAT,'UTF-8').html_entity_decode($mwb_pas_currency_symbol,ENT_COMPAT,'UTF-8');


              if(isset($couponsobj['expiry_date']) && ($couponsobj['expiry_date'] != '' || !empty($couponsobj['expiry_date'])))
              {
                $msg .="\n".'expires on - '.html_entity_decode($couponsobj['expiry_date'],ENT_COMPAT,'UTF-8');
              }
              else
              {
                $ExpMessage = __('NO Expiry','post-auto-share');
                $msg .="\n".'expires on - '.$ExpMessage;  
              }

              $tms=get_post_meta($param2,'mwb_pas_custom_msg',true);
              $tms=html_entity_decode($tms, ENT_COMPAT, 'UTF-8');

              $uploadpath = wp_upload_dir();
              $uploadpath = $uploadpath['baseurl'];
              $image_url =  $uploadpath.'/banner-button.jpg';
              $tumb_link = get_home_url();
              $array = array(
               'comment' => $msg,
               'content' => array(
                'title' =>  $msg,
                'description' => $tms,
                'submitted-url' => $tumb_link,
                'submitted-image-url'=>$image_url,
                ),
               'visibility' => array(
                 'code' => 'anyone'
                 )
               );

              $access_token = get_option('mwb_pas_linked_token',false);

              try
              {

                $linked     = new LinkedIn($config);
                $linked->setAccessToken($access_token);
                $res=$linked->post('/people/~/shares',$array);

                if(isset($res['updateKey']))
                {
                  update_post_meta($param2,'mwb_pas_linkedpost_id',$res['updateKey']);
                  if(get_option("mwb_pas_link_error") != "")
                  {
                    delete_option("mwb_pas_link_error");
                  }
                }
                else
                {
                  update_option("mwb_pas_link_error","Some thing went wrong with Linkedin post. Please update your API keys and access token.");
                  return false;
                }
                set_transient( 'mwb-admin-notice-panel', true, 5 );
                return true ;
              }
              catch(Exception $e)
              {

                update_option("mwb_pas_link_error","Some thing went wrong with Linkedin post. Please update your API keys and access token.");
                return false;
              }

            }
          }
          else
          {


            $image_url  = wp_get_attachment_url( get_post_thumbnail_id($param2) );
          
            $msg = get_the_title($param2);
            $msg = html_entity_decode($msg, ENT_COMPAT, 'UTF-8');
            $tms=get_post_meta($param2,'mwb_pas_custom_msg',true);
            $tms=html_entity_decode($tms, ENT_COMPAT, 'UTF-8');

            $array = array(
             'comment' => $msg,
             'content' => array(
              'title' =>  $msg,
              'description' => $tms,
              'submitted-url' => $param1,
              'submitted-image-url'=>$image_url,
              ),
             'visibility' => array(
               'code' => 'anyone'
               )
             );
            
            $access_token = get_option('mwb_pas_linked_token',false);
            try{

              $linked     = new LinkedIn($config);
              $linked->setAccessToken($access_token);
              $res=$linked->post('/people/~/shares',$array);
              
              if(isset($res['updateKey'])){
                update_post_meta($param2,'mwb_pas_linkedpost_id',$res['updateKey']);
                if(get_option("mwb_pas_link_error") != ""){
                  delete_option("mwb_pas_link_error");
                }
              }
              else{
                update_option("mwb_pas_link_error","Some thing went wrong with Linkedin post. Please update your API keys and access token.");
                return false;
              }
              set_transient( 'mwb-admin-notice-panel', true, 5 );
              return true ;
            }
            catch(Exception $e){

              update_option("mwb_pas_link_error","Some thing went wrong with Linkedin post. Please update your API keys and access token.");
              return false;
            }
          }
        }
        
      }
