<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
require (MWB_PAS_PATH.'/Apis/Facebook/autoload.php');
class mwb_pas_fbshare{
	
	/**
	  * This function is for sharing on Facebook.
	  * @name mwb_pas_shareonfb($link,$postid)
	  * @param1  link 
	  * @param2 postid
	  * @author makewebbetter <webmaster@makewebbetter.com>
	  * @link http://makewebbetter.com/
	  */
	function mwb_pas_shareonfb($link,$postid){

		$app_id= get_option( 'mwb_fb_sharepro_appid' );
		$app_secret= get_option( 'mwb_fb_sharepro_appsec' );
		
		if($app_id == ""){
			return false;
		}

		$access_token= get_option('mwb_fb_sharepro_acctoken');

		$page_access_token = get_option('mwb_pas_fbpage_token');
		$shareOnprofile = get_option('mwb_pas_FBShare_on_prof');
		$shareonpage  = get_option('mwb_pas_FBShare_on_page');
		$page = get_option('mwb_pas_fb_pageid');

		$post = get_post($postid);
		if(isset($post) && !empty($post) && $post->post_type == 'shop_coupon')
		{
			$couponsobj =  get_post_meta($postid,'mwb_pas_saved_coupon_data',true);

			if(is_array($couponsobj) && !empty($couponsobj))
			{


				$mwb_pas_currency_symbol = get_woocommerce_currency_symbol();
				$msg = get_home_url();
				$msg .= "\n".'Coupon Tiltle - '.html_entity_decode($couponsobj['post_title'],ENT_COMPAT,'UTF-8');
				$msg .= "\n".'Coupon Description - '.html_entity_decode($couponsobj['excerpt'],ENT_COMPAT,'UTF-8');
				$msg .= "\n".'Coupon Amount - '.html_entity_decode($couponsobj['coupon_amount'],ENT_COMPAT,'UTF-8').html_entity_decode($mwb_pas_currency_symbol,ENT_COMPAT,'UTF-8');
				
				if(isset($couponsobj['expiry_date']) && ($couponsobj['expiry_date'] != '' || !empty($couponsobj['expiry_date'])))
				{
					$msg .="\n".'expires on - '.html_entity_decode($couponsobj['expiry_date'],ENT_COMPAT,'UTF-8');
				}
				else
				{
					$ExpMessage = __('NO Expiry','post-auto-share');
					$msg .= "\n".'expires on - '.$ExpMessage;	
				}

				$msg.= "\n".get_post_meta($postid,'mwb_pas_custom_msg',true);

				$uploadpath = wp_upload_dir();
				$uploadpath = $uploadpath['baseurl'];
				$imgurl =  $uploadpath.'/banner-button.jpg';
		
				$fb = new Facebook\Facebook([
					'app_id' => $app_id,
					'app_secret' => $app_secret,
					'default_graph_version' => 'v2.10',
					]);

				try {

					if($shareonpage == "FBShare_on_page")
					{ 
						$mwb_pas_existing_album_id = get_option('mwb_pas_fb_album_id');
						$param = array ('source' => $fb->fileToUpload($imgurl),'no_story'=>true);

						try 
						{
							$response = $fb->post(
								'/'.$mwb_pas_existing_album_id.'/photos',
								$param,
								"$page_access_token"
								);
						} 
						catch(Facebook\Exceptions\FacebookResponseException $e) 
						{
							$error = __('Graph returned an error: No album select for sharing of post','post-auto-share');
							echo $error;
							exit;
						}
						catch(Facebook\Exceptions\FacebookSDKException $e) {
							echo 'Facebook SDK returned an error: ' . $e->getMessage();
							exit;
						}
						$pagebody=$response->getDecodedBody();
						$pagebody=$pagebody['id'];

						$onpost= '/'.$page.'/feed';	
						$linkData = [
						'message' => $msg,
						'object_attachment'=>$pagebody
						];

						$pageRequestfeed = $fb->post($onpost,$linkData ,$page_access_token);		
						$pagebodyfeed = $pageRequestfeed->getDecodedBody();
						update_post_meta($postid,'mwb_pas_fbpage_postid',$pagebodyfeed['id']);

						if(get_option("mwb_pas_Fb_error") != ""){
							delete_option("mwb_pas_Fb_error");
						}
					}
					if($shareOnprofile == "FBShare_on_prof")
					{

						$mwb_pas_fbprofile_album_id = get_option('mwb_pas_fb_profile_album_id',false);
						
						$param = array ('source' => $fb->fileToUpload($imgurl),'no_story'=>true);
						try 
						{
							$response = $fb->post(
								'/me/photos',
								$param,
								"$access_token"
								);
						} 
						catch(Facebook\Exceptions\FacebookResponseException $e) 
						{
							$error = __('Graph returned an error: No album select for sharing of post','post-auto-share');
							echo $error;
							exit;
						}
						catch(Facebook\Exceptions\FacebookSDKException $e) {
							echo 'Facebook SDK returned an error: ' . $e->getMessage();
							exit;
						}


						$pagebody=$response->getDecodedBody();

						$pagebody=$pagebody['id'];

						$linkData = [
						'message' => $msg,
						'object_attachment'=>$pagebody
						];


						$response = $fb->post('/me/feed',$linkData ,$access_token);
						$body=$response->getDecodedBody();

						update_post_meta($postid,'mwb_pas_fb_postid',$body['id']);
						$mwb_bulk_share_object = new mwb_pas_bulkshare();
						$mwb_bulk_share_object->mwb_pas_bulk_admin_notices();
						if(get_option("mwb_pas_Fb_error") != ""){
							delete_option("mwb_pas_Fb_error");
						}				
					}
					set_transient( 'mwb-admin-notice-panel', true, 5 );
					return true ;
				} catch(Facebook\Exceptions\FacebookResponseException $e) {

					update_option("mwb_pas_Fb_error",$e->getMessage());	
					return false;

				} catch(Facebook\Exceptions\FacebookSDKException $e) {

					update_option("mwb_pas_Fb_error",$e->getMessage());
					return false;
				}

			}
		}
		else
		{

			$msg = get_the_title($postid);
			$imgurl = wp_get_attachment_url( get_post_thumbnail_id($postid) );


			$msg .= "\n".get_post_meta($postid,'mwb_pas_custom_msg',true);
			$msg = $link."\n".html_entity_decode($msg, ENT_COMPAT, 'UTF-8');



			$fb = new Facebook\Facebook([
				'app_id' => $app_id,
				'app_secret' => $app_secret,
				'default_graph_version' => 'v2.10',
				]);
			
			try 
			{

				if($shareonpage == "FBShare_on_page")
				{ 

					$mwb_pas_existing_album_id = get_option('mwb_pas_fb_album_id');
					
					$param = array ('source' => $fb->fileToUpload($imgurl),'no_story'=>true);

					try 
					{
						$response = $fb->post(
							'/'.$mwb_pas_existing_album_id.'/photos',
							$param,
							"$page_access_token"
							);
					} 
					catch(Facebook\Exceptions\FacebookResponseException $e) 
					{
						$error = __('Graph returned an error: No album select for sharing of post','post-auto-share');
						echo $error;
						exit;
					}
					catch(Facebook\Exceptions\FacebookSDKException $e) {
						echo 'Facebook SDK returned an error: ' . $e->getMessage();
						exit;
					}
					$pagebody=$response->getDecodedBody();
					$pagebody=$pagebody['id'];

					$onpost= '/'.$page.'/feed';	
					$linkData = [
					'message' => $msg,
					'object_attachment'=>$pagebody
					];


					$pageRequestfeed = $fb->post($onpost,$linkData ,$page_access_token);		
					$pagebodyfeed = $pageRequestfeed->getDecodedBody();
					update_post_meta($postid,'mwb_pas_fbpage_postid',$pagebodyfeed['id']);

					if(get_option("mwb_pas_Fb_error") != ""){
						delete_option("mwb_pas_Fb_error");
					}
				}

				if($shareOnprofile == "FBShare_on_prof")
				{

					$mwb_pas_fbprofile_album_id = get_option('mwb_pas_fb_profile_album_id',false);
		
					$param = array ('source' => $fb->fileToUpload($imgurl),'no_story'=>true);

					try 
					{
						$response = $fb->post(
							'/me/photos',
							$param,
							"$access_token"
							);
					} 
					catch(Facebook\Exceptions\FacebookResponseException $e) 
					{
						$error = __('Graph returned an error: No album select for sharing of post','post-auto-share');
						echo $error;
						exit;
					}
					catch(Facebook\Exceptions\FacebookSDKException $e) {
						echo 'Facebook SDK returned an error: ' . $e->getMessage();
						exit;
					}


					$pagebody=$response->getDecodedBody();
					$pagebody=$pagebody['id'];

					$linkData = [
					'message' => $msg,
					'object_attachment'=>$pagebody
					];

					$response = $fb->post('/me/feed',$linkData ,$access_token);

					$body=$response->getDecodedBody();

					update_post_meta($postid,'mwb_pas_fb_postid',$body['id']);
					$mwb_bulk_share_object = new mwb_pas_bulkshare();
					$mwb_bulk_share_object->mwb_pas_bulk_admin_notices();
					if(get_option("mwb_pas_Fb_error") != ""){
						delete_option("mwb_pas_Fb_error");
					}				
				}

				set_transient( 'mwb-admin-notice-panel', true, 5 );
				return true ;
			} 
			catch(Facebook\Exceptions\FacebookResponseException $e) 
			{

				update_option("mwb_pas_Fb_error",$e->getMessage());	
				return false;

			}
			catch(Facebook\Exceptions\FacebookSDKException $e) 
			{

				update_option("mwb_pas_Fb_error",$e->getMessage());
				return false;
			}
		}
	}	
	
	/**
	 * This function is for getting Facebook accounts.
	 * @name mwb_pas_get_facebook_accounts()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	
	function mwb_pas_get_facebook_accounts(){

		$app_id= get_option( 'mwb_fb_sharepro_appid' );
		$app_secret= get_option( 'mwb_fb_sharepro_appsec' );
		if($app_id == ""){
			return false;
		}
		$access_token= get_option('mwb_fb_sharepro_acctoken');	
		$fb = new Facebook\Facebook([
			'app_id' => $app_id,
			'app_secret' => $app_secret,
			'default_graph_version' => 'v2.5',
			]);
		$response = $fb->get('/me?fields=accounts,name,email',$access_token);
		$graphObject = $response->getDecodedBody();
		$pages       = $graphObject['accounts'];
		foreach ($pages as $page){
			if(is_array($page)){
				foreach ($page as $page1)
				{
					$pic = mwb_pas_graph_url.$page1['id']."/picture?type=square";
					echo "<img src=".$pic.">";
					echo "<br>";
				}
			}
		}
		
	}
	
}