<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
//This file is to include setting panels
global $current_user;
add_action('admin_menu', "mwb_pas_settingpage");

	/**
	 * This function is for creating setting menu.
	 * @name mwb_pas_settingpage()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	function mwb_pas_settingpage(){	

		add_menu_page('Post Auto Share Settings', 'Post Auto Share ', 'manage_options', 'share-post-settings', 'mwb_pas_settings_func');
		add_submenu_page( 'share-post-settings', 'Post Auto Share', __('Share Post','post-auto-share'), 'manage_options', 'pas_post', 'mwb_pas_posts' );
		add_submenu_page( 'share-post-settings', 'Post Auto Share', __('Share Woocommerce Product','post-auto-share'), 'manage_options', 'mwb_pas_woo_products', 'mwb_pas_woocommerce_product' );
		add_submenu_page( 'share-post-settings', 'Post Auto Share', __('Share Gift Card Product','post-auto-share'), 'manage_options', 'mwb_pas_gift_product', 'mwb_pas_gift_card_product' );
		add_submenu_page( 'share-post-settings', 'Post Auto Share', __('Share Ultimate Coupons','post-auto-share'), 'manage_options', 'mwb_pas_coupons', 'mwb_pas_woo_coupons' );
		
	}

	/**
	 * This function is for including setting template.
	 * @name mwb_pas_settings_func()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	function mwb_pas_settings_func(){
		require_once( 'view/setting_template.php' );
	}
	
	/**
	 * This function is for including setting bulkshare.
	 * @name mwb_pas_posts()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	
	function mwb_pas_posts () {

		require_once( MWB_PAS_PATH.'assets/class-loader.php' );
		$loader = new mwb_pas_loader();
		$loader->loader();
		$header = add_query_arg( 
			array(
				'post_type' => 'post',
				'mwb_pas' => 'true'
				), 
			admin_url( 'edit.php' ) 
			);
		wp_localize_script( 'task', 'replace', array( 'url' => $header ) );
	}

	/**
	 * This function is for including setting bulkshare for giftcard product.
	 * @name mwb_pas_gift_card_product()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	function mwb_pas_gift_card_product()
	{
		require_once( MWB_PAS_PATH.'assets/class-loader.php' );
		$loader = new mwb_pas_loader();
		if(isset($_GET['page'])  && $_GET['page'] == 'mwb_pas_gift_product')
		{
			require_once MWB_PAS_PATH.'includes/class-mwb-pas-gift-product.php';
			$mwb_pas_giftcard_product = new mwb_pas_share_gift_card_product();
			?>
			<form id="mwb-pas-giftcard-share" method="post">
				<input type="hidden" name="page" value="<?php echo $_REQUEST['page'] ?>" />
				<?php
				$mwb_pas_giftcard_product->search_box('search', 'search_id');
				$mwb_pas_giftcard_product->display(); 
				?>
			</form>
			<?php
		}
	}

	/**
	 * This function is for including setting bulkshare for ultimate coupons.
	 * @name mwb_pas_woo_coupons()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	function mwb_pas_woo_coupons()
	{
		require_once(MWB_PAS_PATH.'assets/class-loader.php');
		$loader = new mwb_pas_loader();
		if(isset($_GET['page']) && $_GET['page'] == 'mwb_pas_coupons')
		{
			require_once(MWB_PAS_PATH.'includes/class-mwb-pas-coupons.php');
			$mwb_pas_woo_all_coupons = new mwb_pas_share_woo_coupons();
			?>
			<form id="mwb-pas-all-coupons" method="post">
				<input type="hidden" name="page" value="<?php echo $_REQUEST['page']; ?>">
				<?php
				$mwb_pas_woo_all_coupons->search_box('search','search_id');
				$mwb_pas_woo_all_coupons->display();
				?>
			</form>
			<?php
		}
	}

	/**
	 * This function is for including setting bulkshare for woocommerce products.
	 * @name mwb_pas_woocommerce_product()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	function mwb_pas_woocommerce_product(){
		
		require_once(MWB_PAS_PATH.'assets/class-loader.php');
		$loader = new mwb_pas_loader();
		if(isset($_GET['page']) && $_GET['page'] == 'mwb_pas_woo_products'){

			require_once(MWB_PAS_PATH.'includes/class-mwb-pas-woo-products.php');
			$mwb_pas_woocommerce_product = new mwb_pas_share_woocommerce_product();
			?>
			<form id="mwb-pas-all-coupons" method="post">
				<input type="hidden" name="page" value="<?php echo $_REQUEST['page']; ?>">
				<?php
				$mwb_pas_woocommerce_product->search_box('search','search_id');
				$mwb_pas_woocommerce_product->display();
				?>
			</form>
			<?php
		}
	}
