<?php
if( ! defined('ABSPATH'))
{
	exit;
}
if( ! class_exists('WP_List_Table')){

	require_once ABSPATH.'wp-admin/includes/class-wp-list-table.php';
}
require_once( 'share/class-mwb-pas-share-fb.php' );
require_once('share/class-mwb-pas-share-link.php' );
require_once('share/class-mwb-pas-share-pin.php' );
require_once('share/class-mwb-pas-share-tweet.php' );
require_once('share/class-mwb-pas-tumblr.php' );
global $current_user;

// defined class that extends wp-list-table class
class mwb_pas_share_woocommerce_product extends WP_List_Table
{
	public $mwb_pas_woo_product_value;
	/**
	 * This function is construct function for class.
	 * @name __construct()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	*/
	function __construct()
	{
		parent::__construct(array(
			'singular' => 'singular_form',
			'plural' => 'plural_form',
			'ajax' => true,
			'screen' =>null
			));
		$this->prepare_items();
		$this->screen_option();


	}
	
	public function screen_option() {

		$option = 'per_page';
		$args   = [
		'label'   => 'Customers',
		'default' => 5,
		];

		add_screen_option( $option, $args );
	}

	/**
	 * This function is constructing custom post coloumn for class.
	 * @name get_columns()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	function get_columns()
	{
		$columns = [
		'cb' 		=> "<input type='checkbox'>",	
		'name'		=> "Name<input type='hidden' name='mwb_pas' value='true'/>",	
		'mwb_fb_share'	=> "<img width = 40px src=".plugins_url()."/post-auto-share/assets/images/facebook.png>",
		'mwb_tweet'		=> "<img width = 40px src=".plugins_url()."/post-auto-share/assets/images/twitter.png>",
		'mwb_link'  	=>  "<img width = 40px src=".plugins_url()."/post-auto-share/assets/images/linkedin.png>",
		'mwb_pint'		=> "<img width = 40px src=".plugins_url()."/post-auto-share/assets/images/pint.png>",
		'mwb_tumblr'   	=> "<img width = 40px src=".plugins_url()."/post-auto-share/assets/images/tumblr.png>",
		];
		return $columns;
	}


	function prepare_items() {


		$columns = $this->get_columns();
		$hidden = $this->get_hidden_columns();
		$sortable = $this->get_sortable_columns();
		$this->_column_headers = array(
			$columns,
			$hidden,
			$sortable
			);
		$this->views();
		// Process bulk action 
		$value = $this->process_bulk_action();

		$mwb_pas_woocommerce_products = $this->mwb_pas_for_woo_product();

		if(isset($mwb_pas_woocommerce_products) && !empty($mwb_pas_woocommerce_products))
		{
			$mwb_pas_wooproduct_posts = $mwb_pas_woocommerce_products;
			$this->mwb_pas_woo_product_value = $mwb_pas_wooproduct_posts;
			$mwb_pas_woocommerce_product_data = $this->mwb_pas_woo_product_value;

			if(is_array($mwb_pas_woocommerce_product_data) && !empty($mwb_pas_woocommerce_product_data))
			{
				foreach ($mwb_pas_woocommerce_product_data as $productkey => $productvalue) 
				{
					if($productvalue != '' || !empty($productvalue))
					{
						$mwb_pas_woocommerce_product_sort_name = array('name'=> $productvalue->post_title);
					}
					else
					{
						$mwb_pas_woocommerce_product_sort_name = array('name'=> '');
					}
				}
			}
			else
			{
				$mwb_pas_woocommerce_product_sort_name = array('name'=> '');
			}
			usort($mwb_pas_woocommerce_product_sort_name, array($this, 'mwb_pas_usort_reorder'));

			$per_page = $this->get_items_per_page('records_per_page', 10);
			$current_page = $this->get_pagenum();
			$total_items = count($mwb_pas_woocommerce_product_data);
			$mwb_pas_woocommerce_product_data = array_slice($mwb_pas_woocommerce_product_data,(($current_page-1)*$per_page),$per_page);
			$this->items = $mwb_pas_woocommerce_product_data;
			$this->set_pagination_args(
                      ['total_items' => $total_items, //Calculate the total number of items
                   'per_page' => $per_page //Determine how many items to show on a page
                   ]);

		}
	}

	public function mwb_pas_for_woo_product()
	{
		$mwb_pas_woocommerce_product = array();
		$args = array(
				'post_type'      => 'product',
				'posts_per_page' => -1,
				);
			$mwb_pas_wooproduct_loop = new WP_Query( $args );
			if( $mwb_pas_wooproduct_loop->have_posts() ):
				while ( $mwb_pas_wooproduct_loop->have_posts() ) : $mwb_pas_wooproduct_loop->the_post();
		// global $product;
			$mwb_pas_product_id = $mwb_pas_wooproduct_loop->post->ID;
			$mwb_pas_product_title = $mwb_pas_wooproduct_loop->post->post_title;
			$mwb_pas_product_types = wp_get_object_terms( $mwb_pas_product_id, 'product_type' );

			if(isset($mwb_pas_product_types[0]))
			{
				$mwb_pas_product_type = $mwb_pas_product_types[0]->slug;
				if($mwb_pas_product_type != 'wgm_gift_card')
				{
					$mwb_pas_woocommerce_product[] = get_post($mwb_pas_product_id);
				}
			}
			endwhile;
			endif;
			return $mwb_pas_woocommerce_product;

	}


	public function get_hidden_columns()
	{
        // Setup Hidden columns and return them
		return array();
	}

	/** 
	* Columns to make sortable. 
	* * @return array 
	*/
	public function get_sortable_columns()
	{
		$sortable_columns = array(
			'name' => array('name',true)
			);
		return $sortable_columns;
	}

	/** 
	* Render the bulk edit checkbox 
	* * @param array $item 
	* * @return string 
	*/
	function column_cb($item)
	{
		if(isset($item) && !empty($item))
		{
			return sprintf('<input type="checkbox" name="mwb_woocommerce_product_share[]" value="%s" />', $item->ID);
		}
		
	}

	/**
	 * This function is for showing values for custom post coloumn name for class.
	 * @name column_name()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	function column_name($items)
	{
		
		$product = wc_get_product($items);
		if(isset($product) && !empty($product))
		{
			$link = get_edit_post_link( $items );
			$title =  $product->get_data()['name'];
			echo '<strong><a class="row-title" href="'.$link.'">' . $title.'</a>';
		}
	}

	/**
	 * This function is for showing values for custom post coloumn facebook for class.
	 * @name column_mwb_fb_share()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	function column_mwb_fb_share($items)
	{
		if(isset($items) && !empty($items))
		{

			$fb_shared =  get_post_meta( $items->ID, 'mwb_pas_fb_postid', true ) ;
			$fb_pageshared = get_post_meta($items->ID, 'mwb_pas_fbpage_postid', true);
			if($fb_shared != ""  || $fb_pageshared){
				echo "<img width = 30px src=".plugins_url()."/post-auto-share/assets/images/share_check.png>";
			}else{
				echo "<img width = 30px src=".plugins_url()."/post-auto-share/assets/images/share_cross.png>";
			}
		}
	}

	/**
	 * This function is for showing values for custom post coloumn twitter for class.
	 * @name column_mwb_tweet()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	function column_mwb_tweet($items)
	{

		if(isset($items) && !empty($items))
		{
			$tweet =  get_post_meta( $items->ID, 'mwb_pas_tweet_postid', true ) ;
			if($tweet != ""){
				echo "<img width = 30px src=".plugins_url()."/post-auto-share/assets/images/share_check.png>";
			}else{
				echo "<img width = 30px src=".plugins_url()."/post-auto-share/assets/images/share_cross.png>";
			}
		}
	}

	/**
	 * This function is for showing values for custom post coloumn linkedin for class.
	 * @name column_mwb_link()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	function column_mwb_link($items)
	{
		if(isset($items) && !empty($items))
		{
			$link =  get_post_meta( $items->ID, 'mwb_pas_linkedpost_id', true ) ;
			if($link != ""){
				echo "<img width = 30px src=".plugins_url()."/post-auto-share/assets/images/share_check.png>";
			}else{
				echo "<img width = 30px src=".plugins_url()."/post-auto-share/assets/images/share_cross.png>";
			}
		}
	}

	/**
	 * This function is for showing values for custom post coloumn pinterest for class.
	 * @name column_mwb_pint()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	function column_mwb_pint($items)
	{
		if(isset($items) && !empty($items))
		{
			$pint =  get_post_meta( $items->ID, 'mwb_pas_pint_id', true ) ;
			if($pint != ""){
				echo "<img width = 30px src=".plugins_url()."/post-auto-share/assets/images/share_check.png>";
			}else{
				echo "<img width = 30px src=".plugins_url()."/post-auto-share/assets/images/share_cross.png>";
			}
		}
	}

	/**
	 * This function is for showing values for custom post coloumn tumblr for class.
	 * @name column_mwb_tumblr()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	function column_mwb_tumblr($items)
	{
		if(isset($items) && !empty($items))
		{
			$tumblr =  get_post_meta( $items->ID, 'mwb_pas_tumblr', true ) ;					
			if($tumblr != ""){
				echo "<img width = 30px src=".plugins_url()."/post-auto-share/assets/images/share_check.png>";
			}else{
				echo "<img width = 30px src=".plugins_url()."/post-auto-share/assets/images/share_cross.png>";
			}
		}	
	}
	
	/**
	 * Returns an associative array containing the bulk action
	 *
	 * @return array
	 */
	public function get_bulk_actions() {
		
		$res=get_option( "mwb_pas_gen_settings");
		
		if(empty($res['mwb_fb']) && empty($res['mwb_tweet']) && empty($res['mwb_pint']) && empty($res['mwb_LinkedIn']) && empty($res['mwb_tumblr']) )
		{
			// $actions ='';
			return array();
		}
		else
		{
			if(!empty($res['mwb_fb'])){
				$actions[ 'mwb_fb_share' ] = __( 'Share to Facebook', 'post-auto-share' );
			}
			if(!empty($res['mwb_tweet'])){
				$actions[ 'mwb_tweet' ] = __( 'Share to Twitter', 'post-auto-share' );
			}
			if(!empty($res['mwb_pint'])){
				$actions[ 'mwb_pas_pinterest_share' ] = __( 'Share to Pinterest', 'post-auto-share' );
			}
			if(!empty($res['mwb_LinkedIn'])){
				$actions[ 'mwb_pas_linkedin_share' ] = __( 'Share to Linkedin', 'post-auto-share' );
			}
			if(!empty($res['mwb_tumblr'])){
				$actions[ 'mwb_pas_tumblr_share' ] = __( 'Share to Tumblr', 'post-auto-share' );
			}
		}

		return $actions;
	}

	/**
	 * This function is for reordering the coloumn.
	 * @name mwb_pas_usort_reorder()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	function mwb_pas_usort_reorder($columna,$cloumnb){
		
		$orderby = (!empty($_REQUEST['orderby'])) ? $_REQUEST['orderby'] : 'id'; 
		$order = (!empty($_REQUEST['order'])) ? $_REQUEST['order'] : 'dsc';
		$result = strcmp($cloumna[$orderby], $cloumnb[$orderby]);
		return ($order==='dsc') ? $result : -$result;
	}

	/**
	 * This function is for processing bulk action.
	 * @name process_bulk_action()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	public function process_bulk_action() 
	{
		$wp_list_table = _get_list_table( 'WP_Posts_List_Table' );
		$action = $wp_list_table->current_action();

		if( isset( $_POST['mwb_woocommerce_product_share'] ) ) {
			$post_ids = $_POST['mwb_woocommerce_product_share'];
			
		}

		switch( $action ) {
			case 'mwb_pas_linkedin_share':
			$shared = 0;
			$linkshare 	= new mwb_pas_link_share();
			if(isset($post_ids)){
				foreach( $post_ids as $post_id ) {
					$link = get_permalink( $post_id );

					if ( ! $linkshare->mwb_pas_share_on_linkedin( $link, $post_id ) ) 
					{

						if( get_option("mwb_linked_settings")['mwb_linkedin_apiid'] == "" ||  get_option("mwb_linked_settings")['mwb_linkedin_appsec'] == "" ) {
							$error = __( 'Error: Please check your Linkedin settings and authorize from Linkedin first.' );
							$this->mwb_pas_woocommerce_product_admin_notices($error);
						} else {
							$error = get_option( 'mwb_pas_link_error' );
							$this->mwb_pas_woocommerce_product_admin_notices($error);
						}
					}
					else
					{
						$this->mwb_pas_woocommerce_product_success_admin_notices('Linkedin');
					}
					$shared++;
					sleep(5);
				}
			}
			else
			{
				$this->mwb_pas_woocommerce_error_admin_notices();
			}
			break;

			case 'mwb_pas_pinterest_share':
			$shared = 0;
			$pinterest 	= new mwb_pas_share_pin();
			if(isset($post_ids)){
				foreach( $post_ids as $post_id ) {
					$link = get_permalink( $post_id );
					if ( ! $pinterest->mwb_pas_pinthis( $link, $post_id ) ) {
						if( get_option( 'mwb_sharepro_pin_appid' ) == "" ||  get_option( 'mwb_sharepro_pin_appsec' ) == "" ) {
							$error = __( 'Error: Please check your pinterest settings and authorize from pinterest first.' );
							$this->mwb_pas_woocommerce_product_admin_notices($error);
						} else {
							$error = get_option( 'mwb_pas_pint_error' );
				// wp_die( __( $error ) );
							$this->mwb_pas_woocommerce_product_admin_notices($error);
						}
					}
					else
					{
						$this->mwb_pas_woocommerce_product_success_admin_notices('Pinterest');
					}
					$shared++;
					sleep(5);
				}
			}
			else
			{
				$this->mwb_pas_woocommerce_error_admin_notices();
			}
			break;

			case 'mwb_fb_share':
	
			$shared = 0;
			$fb = new mwb_pas_fbshare();
			if(isset($post_ids)){

				foreach( $post_ids as $post_id ) {
					$link = get_permalink( $post_id);

					if ( !$fb->mwb_pas_shareonfb($link, $post_id ) ) {
						if( get_option( 'mwb_fb_sharepro_appid' ) == "" ||  get_option( 'mwb_fb_sharepro_appsec' ) == "" ) {
							$error = __('Error:Please check your facebook settings And Authorize from Facebook first.');
							$this->mwb_pas_woocommerce_product_admin_notices($error);
						} else {
							$error = get_option('mwb_pas_Fb_error');
				// wp_die( __($error) );
							$this->mwb_pas_woocommerce_product_admin_notices($error);
						}
					}
					else
					{
						$this->mwb_pas_woocommerce_product_success_admin_notices('facebook');
					}
					$shared++;
					sleep(5);
				}
			}
			else
			{
				$this->mwb_pas_woocommerce_error_admin_notices();
			}
			break;

			case "mwb_tweet" :

			$shared = 0;
			$tweet = new mwb_pas_share_tweet();
			if(isset($post_ids)){
				foreach( $post_ids as $post_id ) {
					$link = get_permalink( $post_id );
					if ( !$tweet->mwb_pas_tweet( $link, $post_id ) ) {

						if( get_option( 'mwb_pas_twitter_settings' )['mwb_twitter_app_id'] == "" ||  get_option('mwb_pas_twitter_settings')[ 'mwb_twitter_app_sec' ] == "" ) {
							$error =  __( 'Error: Please check your Twitter settings.' );
							$this->mwb_pas_woocommerce_product_admin_notices($error);
						} else {
							$error = get_option('mwb_pas_tweet_error');
				// wp_die( __( $error ) );
							$this->mwb_pas_woocommerce_product_admin_notices($error);
						}
					}
					else
					{
						$this->mwb_pas_woocommerce_product_success_admin_notices('twitter');
					}
					$shared++;
					sleep(5);
				}
			}
			else
			{
				$this->mwb_pas_woocommerce_error_admin_notices();
			}
			break;

			case 'mwb_pas_tumblr_share':
			$shared = 0;
			$tumblrShare = new mwb_pas_tumblr();
			if(isset($post_ids)){
				foreach( $post_ids as $post_id ) {
					$link = get_permalink( $post_id);
					if ( !$tumblrShare->mwb_pas_tumblrshare($link, $post_id ) ) {
						if( get_option('mwb_pas_tumblr_settings')['mwb_tumblr_app_id'] == "" ||  get_option('mwb_pas_tumblr_settings')['mwb_tumblr_app_sec'] == "" ) {
							$error =  __('Error:Please check your tumbler settings!');
							$this->mwb_pas_woocommerce_product_admin_notices($error);
						} else {
							$error = get_option('mwb_pas_tumblr_error');
				// wp_die( __($error) );
							$this->mwb_pas_woocommerce_product_admin_notices($error);
						}
					}
					else
					{
						$this->mwb_pas_woocommerce_product_success_admin_notices('tumblr');
					}
					$shared++;
					sleep(5);
				}
			}
			else
			{
				$this->mwb_pas_woocommerce_error_admin_notices();
			}
			break;

			default: 
			return;
		}
		// wp_redirect( $_SERVER['REQUEST_URI'] );

	}

	/**
	 * This function is for showing admin error notices
	 * @name mwb_pas_woocommerce_product_admin_notices()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	public function mwb_pas_woocommerce_product_admin_notices($error)
	{
		?>
		<div class="notice notice-error is-dismissible">
			<p><?php echo $error; ?></p>
		</div>
		<?php
	}

	/**
	 * This function is for showing admin error notices when no product selected
	 * @name mwb_pas_woocommerce_error_admin_notices()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	public function mwb_pas_woocommerce_error_admin_notices()
	{
		$error = __('Please Select Woocommerce Product First','post-auto-share');
		?>
		<div class="notice notice-error is-dismissible">
			<p><?php echo $error; ?></p>
		</div>
		<?php
		
	}

	/**
	 * This function is for showing admin success notices
	 * @name mwb_pas_woocommerce_product_success_admin_notices()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	public function mwb_pas_woocommerce_product_success_admin_notices($messages)
	{
		$msg = __('Woocommerce Product Share On ','post-auto-share');
		?>
		<div class="notice notice-success is-dismissible">
			<p><?php echo $msg.$messages; ?></p>
		</div>
		<?php
	}


}
