<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

require_once( 'share/class-mwb-pas-share-fb.php' );
require_once( 'share/class-mwb-pas-share-link.php' );
require_once( 'share/class-mwb-pas-share-pin.php' );
require_once( 'share/class-mwb-pas-share-tweet.php' );
require_once( 'share/class-mwb-pas-tumblr.php' );

global $current_user;
class mwb_pas_bulkshare {
	
	/**
	 * This function is construct function for class.
	 * @name __construct()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	function __construct(){
		add_filter( 'manage_edit-post_columns', array($this, MWB_PAS_PREFIX.'custom_post_column'),10);
		add_action( 'manage_posts_custom_column', array($this, MWB_PAS_PREFIX.'manage_custom_post_column'));
		add_action( 'admin_footer-edit.php',  array($this,'custom_bulk_admin_footer'));
		add_action( 'load-edit.php', array( $this, 'mwb_pas_custom_bulk_action' ) );
		add_action( 'admin_notices', array($this,MWB_PAS_PREFIX.'bulk_admin_notices'));
		add_filter( 'bulk_actions-edit-post', array( $this, 'pas_custom_bulk_actions' ) );

		add_filter( 'bulk_actions-edit-bank', 'mwb_pas_custom_bulk_actions' );

	}



	function pas_custom_bulk_actions( $actions ) {

		
		if ( isset( $_GET[ 'mwb_pas' ] ) and $_GET[ 'mwb_pas' ] == 'true' ) {

			unset( $actions[ 'edit' ] );
			unset($actions['trash']);
			$res=get_option( "mwb_pas_gen_settings");

			if(!empty($res['mwb_fb'])){
				$actions[ 'mwb_fb_share' ] = __( 'Share to Facebook', 'post-auto-share' );
			}
			if(!empty($res['mwb_tweet'])){
				$actions[ 'mwb_tweet' ] = __( 'Share to Twitter', 'post-auto-share' );
			}
			if(!empty($res['mwb_pint'])){
				$actions[ 'mwb_pas_pinterest_share' ] = __( 'Share to Pinterest', 'post-auto-share' );
			}
			if(!empty($res['mwb_LinkedIn'])){
				$actions[ 'mwb_pas_linkedin_share' ] = __( 'Share to Linkedin', 'post-auto-share' );
			}
			if(!empty($res['mwb_tumblr'])){
				$actions[ 'mwb_pas_tumblr_share' ] = __( 'Share to Tumblr', 'post-auto-share' );
			}
		}
		return $actions;
	}
	
	/**
	 * This function is construct custom post coloumn for class.
	 * @name mwb_pas_custom_post_column()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	function mwb_pas_custom_post_column( $columns ) {	
		if( isset( $_REQUEST['mwb_pas'] ) && $_REQUEST['mwb_pas'] == true ) {
			$new = array(
				'cb' 		=> "<input type='checkbox'>",	
				'name'		=> "Name<input type='hidden' name='mwb_pas' value='true'/>",	
				'mwb_fb_share'	=> "<img width = 40px src=".plugins_url()."/post-auto-share/assets/images/facebook.png>",
				'mwb_tweet'		=> "<img width = 40px src=".plugins_url()."/post-auto-share/assets/images/twitter.png>",
				'mwb_link'  	=>  "<img width = 40px src=".plugins_url()."/post-auto-share/assets/images/linkedin.png>",
				'mwb_pint'		=> "<img width = 40px src=".plugins_url()."/post-auto-share/assets/images/pint.png>",
				'mwb_tumblr'   	=> "<img width = 40px src=".plugins_url()."/post-auto-share/assets/images/tumblr.png>",
				);

			return apply_filters( 'mwb_pas_custom_post_column', $new );
		} else {
			return $columns;
		}
		
	}
	
	/**
	 * This function is construct custom post coloumn value for class.
	 * @name mwb_pas_manage_custom_post_column()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	function mwb_pas_manage_custom_post_column($column){
		global $post;
		
		if ( empty( $post ) || $post->ID != $post->ID )
			$the_post = get_post( $post );
		
		switch ($column) {
			case "name" :
			$link = get_edit_post_link( $post->ID );
			$title = get_the_title($post);
			echo '<strong><a class="row-title" href="'.$link.'">' . $title.'</a>';
			break;
			case "mwb_fb_share" :
			$fb_shared =  get_post_meta( $post->ID, 'mwb_pas_fb_postid', true ) ;
			$fb_pageshared = get_post_meta($post->ID, 'mwb_pas_fbpage_postid', true);
			if($fb_shared != ""  || $fb_pageshared){
				echo "<img width = 30px src=".plugins_url()."/post-auto-share/assets/images/share_check.png>";
			}else{
				echo "<img width = 30px src=".plugins_url()."/post-auto-share/assets/images/share_cross.png>";
			}
			break;
			case "mwb_tweet" :
			$tweet =  get_post_meta( $post->ID, 'mwb_pas_tweet_postid', true ) ;
			if($tweet != ""){
				echo "<img width = 30px src=".plugins_url()."/post-auto-share/assets/images/share_check.png>";
			}else{
				echo "<img width = 30px src=".plugins_url()."/post-auto-share/assets/images/share_cross.png>";
			}
			break;
			case "mwb_link" :
			$link =  get_post_meta( $post->ID, 'mwb_pas_linkedpost_id', true ) ;
			if($link != ""){
				echo "<img width = 30px src=".plugins_url()."/post-auto-share/assets/images/share_check.png>";
			}else{
				echo "<img width = 30px src=".plugins_url()."/post-auto-share/assets/images/share_cross.png>";
			}
			break;
			case "mwb_pint" :
			$pint =  get_post_meta( $post->ID, 'mwb_pas_pint_id', true ) ;
			if($pint != ""){
				echo "<img width = 30px src=".plugins_url()."/post-auto-share/assets/images/share_check.png>";
			}else{
				echo "<img width = 30px src=".plugins_url()."/post-auto-share/assets/images/share_cross.png>";
			}
			break;

			case "mwb_tumblr" :
			$tumblr =  get_post_meta( $post->ID, 'mwb_pas_tumblr', true ) ;					
			if($tumblr != ""){
				echo "<img width = 30px src=".plugins_url()."/post-auto-share/assets/images/share_check.png>";
			}else{
				echo "<img width = 30px src=".plugins_url()."/post-auto-share/assets/images/share_cross.png>";
			}
			break;
		}
		
	}

	/**
	 * This function is for creating custom share bulk action class.
	 * @name custom_bulk_admin_footer()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	function custom_bulk_admin_footer() {
		global $post_type;
		if(isset($_REQUEST['mwb_pas'])){
			if($post_type == 'post' && $_REQUEST['mwb_pas'] == true ) {
				wp_localize_script('task', 'post', array('post_type'=>'post'));
			}
		}
		
	}
	
	/**
	 * This function is for creating bulk action class.
	 * @name custom_bulk_admin_footer()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	
	function mwb_pas_custom_bulk_action(){	

		$wp_list_table = _get_list_table( 'WP_Posts_List_Table' );
		$action = $wp_list_table->current_action();


		if( isset( $_REQUEST['post'] ) ) {
			$post_ids = array_map( 'intval', $_REQUEST['post'] );
		}
		if( empty( $post_ids ) )
		{
			return;
		}

		switch( $action ) {
			case 'mwb_pas_linkedin_share':
			$shared = 0;
			$linkshare 	= new mwb_pas_link_share();
			foreach( $post_ids as $post_id ) {
				$link = get_permalink( $post_id );
				if ( ! $linkshare->mwb_pas_share_on_linkedin( $link, $post_id ) ) {
					if( get_option("mwb_linked_settings")['mwb_linkedin_apiid'] == "" ||  get_option("mwb_linked_settings")['mwb_linkedin_appsec'] == "" ) {
						$error = __( 'Error: Please check your Linkedin settings and authorize from Linkedin first.','post-auto-share');
						$error = str_replace ( ' ', '%20',$error);
					} else {
						$error = get_option( 'mwb_pas_link_error' );
						$error = str_replace ( ' ', '%20',$error);
					}
					$callback_url = add_query_arg(
						array(
							'post_type' => 'post',
							'mwb_pas' 	=> 'true',
							'share_on' => 'mwb_LinkedIn',
							'shared' 	=> $shared, 
							'mwb_pas_error' => $error, 
							'ids' 		=> join( ',', $post_ids ),
							'linkedin'	=> 'true'
							), 
						$callback_url 
						);
				}
				else
				{
					$callback_url = add_query_arg(
						array(
							'post_type' => 'post',
							'mwb_pas' 	=> 'true',
							'share_on' => 'mwb_LinkedIn',
							'shared' 	=> $shared, 
							'mwb_pas_error'	=> '', 
							'ids' 		=> join( ',', $post_ids ),
							'linkedin'	=> 'true'
							), 
						$callback_url 
						);
				}
				$shared++;
				sleep(5);
			}

			
			break;

			case 'mwb_pas_pinterest_share':
			$shared = 0;
			$pinterest 	= new mwb_pas_share_pin();
			foreach( $post_ids as $post_id ) {
				$link = get_permalink( $post_id );

				if ( ! $pinterest->mwb_pas_pinthis( $link, $post_id ) ) {
					if( get_option( 'mwb_sharepro_pin_appid' ) == "" ||  get_option( 'mwb_sharepro_pin_appsec' ) == "" ) {
						$error = __( 'Error: Please check your pinterest settings and authorize from pinterest first.','post-auto-share' );
						$error = str_replace ( ' ', '%20',$error);
						
					} else {
						$error = get_option( 'mwb_pas_pint_error' );
						$error = str_replace ( ' ', '%20',$error);
					}
					$callback_url = add_query_arg(
						array(
							'post_type' => 'post',
							'mwb_pas' 	=> 'true',
							'share_on' => 'mwb_pint',
							'shared' 	=> $shared, 
							'mwb_pas_error'		=> $error , 
							'ids' 		=> join( ',', $post_ids ),
							'pinterest'	=> 'true'
							), 
						$callback_url 
						);
				}
				else
				{
					$callback_url = add_query_arg(
						array(
							'post_type' => 'post',
							'mwb_pas' 	=> 'true',
							'share_on' => 'mwb_pint',
							'shared' 	=> $shared, 
							'mwb_pas_error'		=> '',  
							'ids' 		=> join( ',', $post_ids ),
							'pinterest'	=> 'true'
							), 
						$callback_url 
						);
				}
				$shared++;
				sleep(5);
			}

			break;

			case 'mwb_fb_share':
			$shared = 0;
			$fb = new mwb_pas_fbshare();

			foreach( $post_ids as $post_id ) {
				$link = get_permalink( $post_id);

				if ( !$fb->mwb_pas_shareonfb($link, $post_id ) ) {
					if( get_option( 'mwb_fb_sharepro_appid' ) == "" ||  get_option( 'mwb_fb_sharepro_appsec' ) == "" ) {
						$error = __('Error:Please check your facebook settings And Authorize from Facebook first.','post-auto-share');
						$error = str_replace ( ' ', '%20',$error);
					} else {
						$error = get_option('mwb_pas_Fb_error');
						$error = str_replace ( ' ', '%20',$error);
					}
					$callback_url = add_query_arg( 
						array(
							'post_type' => 'post',
							'share_on' => 'mwb_fb',
							'mwb_pas' => 'true',
							'shared' => $shared, 
							'mwb_pas_error'	=>$error, 
							'ids' => join(',', $post_ids)
							), 
						$callback_url 
						);
				}
				else
				{
					$callback_url = add_query_arg( 
						array(
							'post_type' => 'post',
							'share_on' => 'mwb_fb',
							'mwb_pas' => 'true',
							'shared' => $shared, 
							'mwb_pas_error'	=> '', 
							'ids' => join(',', $post_ids)
							), 
						$callback_url 
						);
				}
				$shared++;
				sleep(5);
			}
			break;

			case "mwb_tweet" :

			$shared = 0;
			$tweet = new mwb_pas_share_tweet();

			foreach( $post_ids as $post_id ) {
				$link = get_permalink( $post_id );
				if ( !$tweet->mwb_pas_tweet( $link, $post_id ) ) {
					if( get_option( 'mwb_pas_twitter_settings' )['mwb_twitter_app_id'] == "" ||  get_option('mwb_pas_twitter_settings')[ 'mwb_twitter_app_sec' ] == "" ) {
						$error = __( 'Error: Please check your Twitter settings.','post-auto-share' );
						$error = str_replace ( ' ', '%20',$error);
					} else {
						$error = get_option('mwb_pas_tweet_error');
						$error = str_replace ( ' ', '%20',$error);
					}
					$callback_url = add_query_arg( 
						array(
							'post_type' => 'post',
							'share_on' => 'mwb_tweet',
							'mwb_pas' 	=> 'true',
							'shared' 	=> $shared, 
							'mwb_pas_error'		=> $error,  
							'ids' 		=> join(',', $post_ids),
							'mwb_tweet'	=>'true'
							), 
						$callback_url 
						);
				}
				else
				{
					$callback_url = add_query_arg( 
						array(
							'post_type' => 'post',
							'share_on' => 'mwb_tweet',
							'mwb_pas' 	=> 'true',
							'shared' 	=> $shared, 
							 'mwb_pas_error'	=> '',
							'ids' 		=> join(',', $post_ids),
							'mwb_tweet'	=>'true'
							), 
						$callback_url 
						);
				}
				$shared++;
				sleep(5);
			}
			
			break;
				//Appending tumblr feature 

			case 'mwb_pas_tumblr_share':

			$shared = 0;
			$tumblrShare = new mwb_pas_tumblr();
			foreach( $post_ids as $post_id ){
				$link = get_permalink( $post_id);

				if ( !$tumblrShare->mwb_pas_tumblrshare($link, $post_id ) ) {

					if( get_option('mwb_pas_tumblr_settings')['mwb_tumblr_app_id'] == "" ||  get_option('mwb_pas_tumblr_settings')['mwb_tumblr_app_sec'] == "" ) {
						$error = __('Error:Please check your tumbler settings!','post-auto-share');
						$error = str_replace ( ' ', '%20',$error);
					} else {
						$error = get_option('mwb_pas_tumblr_error');
						$error = str_replace ( ' ', '%20',$error);
					}
					$callback_url = add_query_arg( 
						array(
							'post_type' => 'post',
							'share_on' => 'mwb_tumblr',
							'mwb_pas' => 'true',
							'shared' => $shared, 
							'mwb_pas_error'	=> $error
							// 'ids' => join(',', $post_ids)
							), 
						$callback_url 
						);
				}
				else
				{

					$callback_url = add_query_arg( 
						array(
							'post_type' => 'post',
							'share_on' => 'mwb_tumblr',
							'mwb_pas' => 'true',
							'shared' => $shared, 
							'mwb_pas_error'	=>'' ,
							// 'ids' => join(',', $post_ids)
							), 
						$callback_url 
						);
				}
				$shared++;
				sleep(5);
			}
			break;

			default: 
			return;
		}
		wp_redirect( $callback_url );
		exit();
	}

	/**
	 * This function is for creating custom share messages.
	 * @name custom_bulk_admin_footer()
	 * @author makewebbetter <webmaster@makewebbetter.com>
	 * @link http://makewebbetter.com/
	 */
	function mwb_pas_bulk_admin_notices() {

		global $post_type, $pagenow;
		if( isset($_REQUEST['mwb_pas_error']) && $_REQUEST['mwb_pas_error'] != '' && $pagenow == 'edit.php' && $post_type == 'post' && isset($_REQUEST['shared']) ) {
			
			$mwb_share_value = get_option( "mwb_pas_gen_settings", false);
			$message = __("Post is not Share on ","post-auto-share");
			$message.=$mwb_share_value[$_REQUEST['share_on']];
			$message.=__(' because of ','post-auto-share');
			?>
			<div data-dismiss="true" class="notice notice-error is-dismissible">
				<p><?php echo $message.$_REQUEST['mwb_pas_error']; ?></p>
			</div>
			<?php
		}
		elseif( isset($_REQUEST['mwb_pas_error']) && $_REQUEST['mwb_pas_error'] == '' && $pagenow == 'edit.php' && $post_type == 'post' && isset($_REQUEST['shared']) )
		{
			$mwb_share_value = get_option( "mwb_pas_gen_settings", false);
			$message = __("Post Share on ","post-auto-share");
			?>
			<div data-dismiss="true" class="notice notice-success is-dismissible">
				<p><?php echo $message.$mwb_share_value[$_REQUEST['share_on']]; ?></p>
			</div>
			<?php

		}		
	}

	public function mwb_pas_admin_post_notices()
	{
		$error = __('Please Select Post First','post-auto-share');
		?>
		<div class="notice notice-error is-dismissible">
			<p><?php echo $error; ?></p>
		</div>
		<?php
	}

	public function mwb_pas_admin_notices($error)
	{
		?>
		<div class="notice notice-error is-dismissible">
			<p><?php echo $error; ?></p>
		</div>
		<?php
	}

}