<?php
	$_wp_column_headers['toplevel_page_otw-pm'] = array(
	'title' => __( 'Title', 'otw-portfolio-manager' )
);
	
	$message = '';
	$massages = array();
	$messages[1] = __( 'Single Posts Template saved.', 'otw-portfolio-manager' );
	$messages[2] = __( 'Single Posts Template deleted.', 'otw-portfolio-manager' );
	$messages[5] = __( 'Single Posts Template copied.', 'otw-portfolio-manager' );
	
	if( isset( $_GET['message'] ) && isset( $messages[ $_GET['message'] ] ) ){
		$message .= $messages[ $_GET['message'] ];
	}
	
?>
<?php if ( $message ) : ?>
<div id="message" class="updated"><p><?php echo $message; ?></p></div>
<?php
 endif; ?>
<div class="wrap">
	<div id="icon-options-general" class="icon32"></div>
	<h2><?php _e('Single Posts Templates', 'otw-portfolio-manager'); ?>
		<a class="button add-new-h2" href="admin.php?page=otw-pm-custom-templates-add"><?php _e('Add New', 'otw-portfolio-manager') ?></a>
	</h2>
	<div class="updated"><p><?php _e( 'The plugin comes with ready to use templates for your single portfolio posts pages. In this section you can create custom once.', 'otw-portfolio-manager' );?></p></div>
	<?php if( is_array( $otw_custom_templates ) && count( $otw_custom_templates ) ){?>
		<table class="widefat fixed" cellspacing="0">
			<thead>
				<tr>
					<?php foreach( $_wp_column_headers['toplevel_page_otw-pm'] as $key => $name ){?>
						<th><?php echo $name?></th>
					<?php }?>
				</tr>
			</thead>
			<tfoot>
				<tr>
					<?php foreach( $_wp_column_headers['toplevel_page_otw-pm'] as $key => $name ){?>
						<th><?php echo $name?></th>
					<?php }?>
				</tr>
			</tfoot>
			<tbody>
				<?php foreach( $otw_custom_templates as $d_key => $d_item ){?>
					<tr>
						<?php foreach( $_wp_column_headers['toplevel_page_otw-pm'] as $column_name => $column_title ){
							
							$edit_link = admin_url( 'admin.php?page=otw-pm-custom-templates-edit&amp;custom_template='.$d_item['id'] );
							$delete_link = admin_url( 'admin.php?page=otw-pm-custom-templates-action&amp;custom_template='.$d_item['id'].'&amp;action=delete' );
							$copy_link = admin_url( 'admin.php?page=otw-pm-custom-templates-action&amp;custom_template='.$d_item['id'].'&amp;action=copy' );
							switch($column_name) {
								
								case 'title':
										echo '<td><strong><a href="'.$edit_link.'" title="'.esc_attr(sprintf(__('Edit &#8220;%s&#8221;', 'otw-portfolio-manager'), $d_item['title'])).'">';
										
										if( !isset( $d_item['title'] ) || !strlen( trim( $d_item['title'] ) ) ){
											_e( 'No title', 'otw-portfolio-manager' );
										}else{
											echo $d_item['title'];
										}
										echo '</a></strong><br />';
										echo '<div class="row-actions">';
											echo '<a href="'.$edit_link.'">' . __('Edit', 'otw-portfolio-manager') . '</a>';
											echo ' | <a href="'.$delete_link.'">' . __('Delete', 'otw-portfolio-manager'). '</a>';
											echo ' | <a href="'.$copy_link.'">' .__('Duplicate', 'otw-portfolio-manager'). '</a>';
											echo '</div>';
										echo '</td>';
									break;
							}?>
						<?php }?>
					</tr>
				<?php }?>
			</tbody>
		</table>
	<?php }else{?>
		<p><?php _e('No Single Posts Templates Available.', 'otw-portfolio-manager')?></p>
	<?php }?>
</div>