<?php
	$writableCssError = $this->check_writing( SKIN_PM_PATH );
	
	$selectOptionData = array(
		array( 'value' => 0, 'text'	=> '------' ),
		array( 'value' => '1-column', 'text' => __('Grid - Portfolio 1 Column', 'otw-portfolio-manager') ),
		array( 'value' => '2-column', 'text' => __('Grid - Portfolio 2 Columns', 'otw-portfolio-manager') ),
		array( 'value' => '3-column', 'text' => __('Grid - Portfolio 3 Columns', 'otw-portfolio-manager') ),
		array( 'value' => '4-column', 'text' => __('Grid - Portfolio 4 Columns', 'otw-portfolio-manager') ),
		array( 'value' => '1-column-lft-img', 'text' => __('Image Left - Portfolio 1 Column', 'otw-portfolio-manager') ),
		array( 'value' => '2-column-lft-img', 'text' => __('Image Left - Portfolio 2 Columns', 'otw-portfolio-manager') ),
		array( 'value' => '1-column-rght-img', 'text' => __('Image Right - Portfolio 1 Column', 'otw-portfolio-manager') ),
		array( 'value' => '2-column-rght-img', 'text' => __('Image Right - Portfolio 2 Columns', 'otw-portfolio-manager') ),
		array( 'value' => '2-column-news', 'text' => __('Newspaper - Portfolio 2 Columns', 'otw-portfolio-manager') ),
		array( 'value' => '3-column-news', 'text' => __('Newspaper - Portfolio 3 Columns', 'otw-portfolio-manager') ),
		array( 'value' => '4-column-news', 'text' => __('Newspaper - Portfolio 4 Columns', 'otw-portfolio-manager') ),
		array( 'value' => '1-3-mosaic', 'text' => __('Mosaic - 1/3', 'otw-portfolio-manager') ),
		array( 'value' => '1-4-mosaic', 'text' => __('Mosaic - 1/4', 'otw-portfolio-manager') ),
		array( 'value' => 'timeline', 'text' => __('Timeline', 'otw-portfolio-manager') ),
		array( 'value' => 'horizontal-layout', 'text' => __('Horizontal Layout', 'otw-portfolio-manager') ),
		array( 'value' => 'slider', 'text' => __('Slider', 'otw-portfolio-manager') ),
		array( 'value' => '3-column-carousel', 'text' => __('Carousel - 3 Columns', 'otw-portfolio-manager') ),
		array( 'value' => '4-column-carousel', 'text' => __('Carousel - 4 Columns', 'otw-portfolio-manager') ),
		array( 'value' => '5-column-carousel', 'text' => __('Carousel - 5 Columns', 'otw-portfolio-manager') ),
		array( 'value' => '2-column-carousel-wid', 'text' => __('Widget Carousel - 2 Columns', 'otw-portfolio-manager') ),
		array( 'value' => '3-column-carousel-wid', 'text' => __('Widget Carousel - 3 Columns', 'otw-portfolio-manager') ),
		array( 'value' => '4-column-carousel-wid', 'text' => __('Widget Carousel - 4 Columns', 'otw-portfolio-manager') ),
		array( 'value' => 'widget-lft', 'text' => __('Widget Style - Image Left', 'otw-portfolio-manager') ),
		array( 'value' => 'widget-right', 'text' => __('Widget Style - Image Right', 'otw-portfolio-manager') ),
		array( 'value' => 'widget-top', 'text' => __('Widget Style - Image Top', 'otw-portfolio-manager') )
	);

	$selectPaginationData = array(
		array( 'value' => '0', 'text' => __('None (default)', 'otw-portfolio-manager') ),
		array( 'value' => 'pagination', 'text' => __('Standard Pagination', 'otw-portfolio-manager') ),
		array( 'value' => 'load-more', 'text' => __('Load More Pagination', 'otw-portfolio-manager') ),
		array( 'value' => 'infinit-scroll', 'text' => __('Infinit Scroll', 'otw-portfolio-manager') ),
	);	

	$selectSocialData = array(
		array( 'value' => '0', 'text' => __('None (default)', 'otw-portfolio-manager') ),
		array( 'value' => 'share_icons', 'text' => __('Share Icons', 'otw-portfolio-manager') ),
		array( 'value' => 'share_btn_small', 'text' => __('Share Buttons Small', 'otw-portfolio-manager') ),
		array( 'value' => 'share_btn_large', 'text' => __('Share Buttons Large', 'otw-portfolio-manager') ),
		array( 'value' => 'like_buttons', 'text' => __('Like Buttons', 'otw-portfolio-manager') ),
		array( 'value' => 'custom_icons', 'text' => __('Custom Social Icons', 'otw-portfolio-manager') )
	);	

	$selectOrderData = array(
		array( 'value' => 'date_desc', 'text' => __('Latest Created (default)', 'otw-portfolio-manager') ),
		array( 'value' => 'date_asc', 'text' => __('Oldest Created', 'otw-portfolio-manager') ),
		array( 'value' => 'modified_desc', 'text' => __('Latest Modified', 'otw-portfolio-manager') ),
		array( 'value' => 'modified_asc', 'text' => __('Oldest Modified', 'otw-portfolio-manager') ),
		array( 'value' => 'title_asc', 'text' => __('Alphabetically: A-Z', 'otw-portfolio-manager') ),
		array( 'value' => 'title_desc', 'text' => __('Alphabetically: Z-A', 'otw-portfolio-manager') ),
		array( 'value' => 'rand_', 'text' => __('Random', 'otw-portfolio-manager') )
	);

	$selectHoverData = array(
		array( 'value' => 'hover-none', 'text' => __('None', 'otw-portfolio-manager') ),
		array( 'value' => 'otw_portfolio_manager-hover-effect-1', 'text' => __('Hover 1', 'otw-portfolio-manager') ),
		array( 'value' => 'otw_portfolio_manager-hover-effect-2', 'text' => __('Hover 2', 'otw-portfolio-manager') ),
		array( 'value' => 'otw_portfolio_manager-hover-effect-3', 'text' => __('Hover 3', 'otw-portfolio-manager') ),
		array( 'value' => 'otw_portfolio_manager-hover-effect-4', 'text' => __('Hover 4', 'otw-portfolio-manager') ),
		array( 'value' => 'otw_portfolio_manager-hover-effect-5', 'text' => __('Hover 5', 'otw-portfolio-manager') ),
		array( 'value' => 'otw_portfolio_manager-hover-effect-6', 'text' => __('Hover 6', 'otw-portfolio-manager') ),
		array( 'value' => 'otw_portfolio_manager-hover-effect-7', 'text' => __('Hover 7', 'otw-portfolio-manager') ),
		array( 'value' => 'otw_portfolio_manager-hover-effect-8', 'text' => __('Hover 8', 'otw-portfolio-manager') ),
		array( 'value' => 'otw_portfolio_manager-hover-effect-9', 'text' => __('Hover 9', 'otw-portfolio-manager') ),
		array( 'value' => 'otw_portfolio_manager-hover-effect-10', 'text' => __('Hover 10', 'otw-portfolio-manager') ),
		array( 'value' => 'otw_portfolio_manager-hover-effect-11', 'text' => __('Hover 11', 'otw-portfolio-manager') ),
		array( 'value' => 'otw_portfolio_manager-hover-effect-12', 'text' => __('Hover 12', 'otw-portfolio-manager') ),
		array( 'value' => 'otw_portfolio_manager-hover-effect-13', 'text' => __('Hover 13', 'otw-portfolio-manager') ),
		array( 'value' => 'otw_portfolio_manager-hover-effect-14', 'text' => __('Hover 14', 'otw-portfolio-manager') ),
		array( 'value' => 'otw_portfolio_manager-hover-effect-15', 'text' => __('Hover 15', 'otw-portfolio-manager') ),
		array( 'value' => 'otw_portfolio_manager-hover-effect-16', 'text' => __('Hover 16', 'otw-portfolio-manager') ),
		array( 'value' => 'otw_portfolio_manager-hover-effect-17', 'text' => __('Hover 17', 'otw-portfolio-manager') ),
		array( 'value' => 'otw_portfolio_manager-hover-effect-18', 'text' => __('Hover 18', 'otw-portfolio-manager') ),
		array( 'value' => 'otw_portfolio_manager-hover-effect-19', 'text' => __('Hover 19', 'otw-portfolio-manager') )
	);

	$selectIconData = array(
		array( 'value' => 0, 'text' => __('None (default)', 'otw-portfolio-manager') ),
		array( 'value' => 'icon-expand', 'text' => __('Icon Expand', 'otw-portfolio-manager') ),
		array( 'value' => 'icon-youtube-play', 'text' => __('Icon YouTube Play', 'otw-portfolio-manager') ),
		array( 'value' => 'icon-file', 'text' => __('Icon File', 'otw-portfolio-manager') ),
		array( 'value' => 'icon-book', 'text' => __('Icon Book', 'otw-portfolio-manager') ),
		array( 'value' => 'icon-check-sign', 'text' => __('Icon Check Sign', 'otw-portfolio-manager') ),
		array( 'value' => 'icon-comments', 'text' => __('Icon Comments', 'otw-portfolio-manager') ),
		array( 'value' => 'icon-ok-sign', 'text' => __('Icon OK Sign', 'otw-portfolio-manager') ),
		array( 'value' => 'icon-zoom-in', 'text' => __('Icon Zoom In', 'otw-portfolio-manager') ),
		array( 'value' => 'icon-thumbs-up-alt', 'text' => __('Icon Thumbs Up Alt', 'otw-portfolio-manager') ),
		array( 'value' => 'icon-plus-sign', 'text' => __('Icon Plus Sign', 'otw-portfolio-manager') ),
		array( 'value' => 'icon-cloud', 'text' => __('Icon Cloud', 'otw-portfolio-manager') ),
		array( 'value' => 'icon-chevron-sign-right', 'text' => __('Icon Chevron Sign Right', 'otw-portfolio-manager') ),
		array( 'value' => 'icon-hand-right', 'text' => __('Icon Hand Right', 'otw-portfolio-manager') ),
		array( 'value' => 'icon-fullscreen', 'text' => __('Icon Fullscreen', 'otw-portfolio-manager') ),
	);
	
	$selectLinkData = array(
		array( 'value' => 'single', 'text' => __('Single Post (default)', 'otw-portfolio-manager') ),
		array( 'value' => 'lightbox', 'text' => __('Lightbox', 'otw-portfolio-manager') ),
		array( 'value' => 'no-link', 'text' => __('No Link', 'otw-portfolio-manager') ),
	);

	$selectMetaData = array(
		array( 'value' => 'horizontal', 'text' => __('Horizontal (default)', 'otw-portfolio-manager') ),
		array( 'value' => 'vertical', 'text' => __('Vertical', 'otw-portfolio-manager') ),
	);

	$selectStripTags = array(
		array( 'value' => 'yes', 'text' => __('Yes (default)', 'otw-portfolio-manager') ),
		array( 'value' => 'no', 'text' => __('No', 'otw-portfolio-manager') ),
	);
	
	$selectStripShortcodes = array(
		array( 'value' => 'yes', 'text' => __('Yes (default)', 'otw-portfolio-manager') ),
		array( 'value' => 'no', 'text' => __('No', 'otw-portfolio-manager') ),
	);

	$selectSliderAlignmentData = array(
		array( 'value' => 'left', 'text' => __('Left (default)', 'otw-portfolio-manager') ),
		array( 'value' => 'center', 'text' => __('Center', 'otw-portfolio-manager') ),
		array( 'value' => 'right', 'text' => __('Right', 'otw-portfolio-manager') ),
	);

	$selectMosaicData = array(
		array( 'value' => 'full', 'text' => __('Full Content on Hover (default)', 'otw-portfolio-manager') ),
		array( 'value' => 'slide', 'text' => __('Slide Content on Hover', 'otw-portfolio-manager') ),
	);

	$selectFontSizeData = array(
		array( 'value' => '', 'text' => __('None (default)', 'otw-portfolio-manager') ),
		array( 'value' => '8', 'text' => '8px' ),
		array( 'value' => '10', 'text' => '10px' ),
		array( 'value' => '12', 'text' => '12px' ),
		array( 'value' => '14', 'text' => '14px' ),
		array( 'value' => '16', 'text' => '16px' ),
		array( 'value' => '18', 'text' => '18px' ),
		array( 'value' => '20', 'text' => '20px' ),
		array( 'value' => '22', 'text' => '22px' ),
		array( 'value' => '24', 'text' => '24px' ),
		array( 'value' => '26', 'text' => '26px' ),
		array( 'value' => '28', 'text' => '28px' ),
		array( 'value' => '30', 'text' => '30px' ),
		array( 'value' => '32', 'text' => '32px' ),
		array( 'value' => '34', 'text' => '34px' ),
		array( 'value' => '36', 'text' => '36px' ),
		array( 'value' => '38', 'text' => '38px' ),
		array( 'value' => '40', 'text' => '40px' ),
	);

	$selectFontStyleData = array(
		array( 'value' => '', 'text' => __('None (default)', 'otw-portfolio-manager') ),
		array( 'value' => 'regular', 'text' => __('Regular', 'otw-portfolio-manager') ),
		array( 'value' => 'bold', 'text' => __('Bold', 'otw-portfolio-manager') ),
		array( 'value' => 'italic', 'text' => __('Italic', 'otw-portfolio-manager') ),
		array( 'value' => 'bold_italic', 'text' => __('Bold and Italic', 'otw-portfolio-manager') ),
	);

	$selectViewTargetData = array(
		array( 'value' => '_self', 'text' => __('Same Window / Tab (default)', 'otw-portfolio-manager') ),
		array( 'value' => '_blank', 'text' => __('New Window / Tab', 'otw-portfolio-manager') ),
	);

	$selectCategoryTagRelation = array(
		array( 'value' => 'OR', 'text' => __('categories OR tags (default)', 'otw-portfolio-manager') ),
		array( 'value' => 'AND', 'text' => __('categories AND tags', 'otw-portfolio-manager') )
	);
	
	$thumb_format_options = array(
		'' => __('Keep original file format (default)', 'otw-portfolio-manager' ),
		'jpg' => 'jpg',
		'png' => 'png',
		'gif' => 'gif'
	);
	
	$selectBorderStyleData = array(
		array( 'value' => '', 'text' => __('None (default)', 'otw-portfolio-manager') ),
		array( 'value' => 'solid', 'text' => 'Solid' ),
		array( 'value' => 'dashed', 'text' => 'Dashed' ),
		array( 'value' => 'dotted', 'text' => 'Dotted' )
	);
	
	$selectBorderSizeData = array(
		array( 'value' => '', 'text' => __('None (default)', 'otw-portfolio-manager') ),
		array( 'value' => '1', 'text' => '1px' ),
		array( 'value' => '2', 'text' => '2px' ),
		array( 'value' => '3', 'text' => '3px' ),
		array( 'value' => '4', 'text' => '4px' )
	);
	
	
	$js_template_options = array();
	
	if( isset( $templateOptions ) && is_array( $templateOptions ) ){
		
		foreach( $templateOptions as $t_option ){
			$js_template_options[ $t_option['name'] ] = $t_option;
		}
	}
	
	$total_meta_elements = 5;
	
	$meta_elements = array();
	$meta_elements['category'] = __( 'category', 'otw-portfolio-manager' );
	$meta_elements['tags'] = __( 'tags', 'otw-portfolio-manager' );
	
	$otw_details = $this->get_details();
	
	foreach( $otw_details as $detail ){
		$meta_elements['otw_portfolio_detail_'.$detail['id'] ] = $detail['title'];
		$total_meta_elements++;
	}
	
	$meta_elements_height = ( ( $total_meta_elements + 2 ) * 20 );
?>
<div class="wrap">
	<div id="icon-edit" class="icon32"></div>
	<h2>
		<?php
			if( empty($this->errors) && !empty($content['list_name']) ) {
				echo __( 'Edit Portfolio List', 'otw-portfolio-manager' ); 	
			} else {
				echo __( 'Add New Portfolio List', 'otw-portfolio-manager' );
			}
		?>
		<a class="add-new-h2" href="admin.php?page=otw-pm"><?php _e('Back', 'otw-portfolio-manager');?></a>
	</h2>
	<?php
		if( $writableCssError ) {
			$message = __('The folder \''.SKIN_PM_PATH.'\' is not writable. Please make sure you add read/write permissions to this folder.', 'otw-portfolio-manager');
			 echo '<div class="error"><p>'.$message.'</p></div>';
		}
	?>
	<?php
	if( !empty( $_GET['success'] ) && $_GET['success'] == 'true' ) {
			$message = __('Item was saved.', 'otw-portfolio-manager');
			echo '<div class="updated"><p>'.$message.'</p></div>';
	}
	?>
	<form name="otw-pm-list" method="post" action="" class="validate">

		<input type="hidden" name="id" value="<?php echo $nextID;?>" />
		<input type="hidden" name="edit" value="<?php echo $edit;?>" />
		<input type="hidden" name="date_created" value="<?php echo $content['date_created'];?>" />
		<input type="hidden" name="user_id" value="<?php echo get_current_user_id();?>" />

		<?php
			if( !empty($this->errors) ){
				$errorMsg = __('Oops! Please check form for errors.', 'otw-portfolio-manager');
				echo '<div class="error"><p>'.$errorMsg.'</p></div>';
			}
		?>
		<script type="text/javascript">
		<?php
			
			echo 'var js_template_options='.json_encode( $js_template_options ).';'
		?>
		</script>
		<table class="form-table">
			<tbody>
				<tr valign="top">
					<th scope="row"><label for="list_name" class="required"><?php _e('Portfolio List Name', 'otw-portfolio-manager');?></label></th>
					<td>
						<input type="text" name="list_name" id="list_name" size="53" value="<?php echo $content['list_name'];?>" />
						<p class="description"><?php _e( 'Note: The List Name is going to be used ONLY for the admin as a reference.', 'otw-portfolio-manager');?></p>
						<div class="inline-error">
							<?php 
								( !empty($this->errors['list_name']) )? $errorMessage = $this->errors['list_name'] : $errorMessage = ''; 
								echo $errorMessage;
							?>
						</div>
					</td>
				</tr>				
				<tr valign="top">
					<th scope="row"><label for="template" class="required"><?php _e('Choose Template', 'otw-portfolio-manager');?></label></th>
					<td>
						<select id="template" name="template" class="js-template-style">
						<?php 
						foreach( $selectOptionData as $optionData ): 
							$selected = '';
							if( $optionData['value'] === $content['template'] ) {
								$selected = 'selected="selected"';
							}
							echo "<option value=\"".$optionData['value']."\" ".$selected.">".$optionData['text']."</option>";
							
						endforeach;
						?>
						</select>
						<div class="inline-error">
							<?php 
								( !empty($this->errors['template']) )? $errorMessage = $this->errors['template'] : $errorMessage = ''; 
								echo $errorMessage;
							?>
						</div>
					</td>
				</tr>
				<tr valign="top">
					<th scope="row">
						<label for="categories"><?php _e('Portfolio Categories:', 'otw-portfolio-manager');?></label>
					</th>
					<td>
						<?php 
								$categoriesCount 	= wp_count_terms( $this->portfolio_category, array( 'number' => '', 'hide_empty' => false  ) );
								$categoriesStatus = 'otw-admin-hidden';
								$categoriesAll 		= '';
								$categoriesInput 	= '';
								if( !empty($content['select_categories']) ) {
									
									$categoriesStatus = '';
									$categoriesAll = 'checked="checked"';
									$categoriesInput = 'disabled="disabled"';
								}
						?>
						<select name="categories[]" id="categories" class="js-categories" multiple="multiple" data-value="<?php echo $content['categories'];?>" <?php echo $categoriesInput ?>></select><br />
						<?php _e('- OR -', 'otw-portfolio-manager'); ?><br/>
						<input type="hidden" name="all_categories" class="js-categories-select" value="<?php echo $content['all_categories'];?>" />
						<input type="checkbox" name="select_categories" value="1" data-size="<?php echo $categoriesCount;?>" class="js-select-categories" id="select_all_categories" data-section="categories" <?php echo $categoriesAll;?> />
						<label for="select_all_categories">
							<?php _e('Select All', 'otw-portfolio-manager');?>
							<span class="js-categories-count <?php echo $categoriesStatus; ?>">
								(
								<span class="js-categories-counter"><?php echo $categoriesCount;?></span>
								<?php _e(' categories selected', 'otw-portfolio-manager');?>
								)
							</span>
						</label>
						<p class="description"><?php _e( 'Choose categories to include posts from those categories in your list or use the Select all checkbox to include posts from all categories.', 'otw-portfolio-manager');?></p>
					</td>
				</tr>
				<tr valign="top">
					<th scope="row">
						<label for="exclude_categories"><?php _e('Exclude Portfolio Categories:', 'otw-portfolio-manager');?></label>
					</th>
					<td>
						<?php 
								$exclude_categoriesAll 		= '';
								$exclude_categoriesInput 	= '';
						?>
						<select name="exclude_categories[]" id="exclude_categories" class="js-exclude_categories" multiple="multiple" data-value="<?php echo $content['exclude_categories'];?>" <?php echo $exclude_categoriesInput ?>></select><br />
						<p class="description"><?php _e( 'Choose categories to exclude posts from those categories in your list.', 'otw-portfolio-manager');?></p>
					</td>
				</tr>
				<tr valign="top">
					<th scope="row">
						<label for="tags"><?php _e('Portfolio Tags:', 'otw-portfolio-manager');?></label>
					</th>
					<td>
						<?php 
								$tagsCount 	= wp_count_terms( $this->portfolio_tag, array( 'number' => '', 'hide_empty' => false  ) );
								$tagsStatus = 'otw-admin-hidden';
								$tagsAll 		= '';
								$tagsInput 	= '';
								if( !empty($content['select_tags']) ) {
									$tagsStatus = '';
									$tagsAll = 'checked="checked"';
									$tagsInput = 'disabled="disabled"';
								}
						?>
						<select name="tags[]" id="tags" class="js-tags" multiple="multiple" data-value="<?php echo $content['tags'];?>" <?php echo $tagsInput;?>></select><br />
						<?php _e('- OR -', 'otw-portfolio-manager'); ?><br/><br/>
						<input type="hidden" name="all_tags" class="js-tags-select" value="<?php echo $content['all_tags'];?>" />
						<input type="checkbox" name="select_tags" value="1" data-size="<?php echo $tagsCount;?>" class="js-select-tags" id="select_all_tags" data-section="tags" <?php echo $tagsAll;?>/>
						<label for="select_all_tags">
							<?php _e('Select All', 'otw-portfolio-manager'); ?>
							<span class="js-tags-count <?php echo $tagsStatus;?>">
								(
								<span class="js-tags-counter"><?php echo $tagsCount;?></span>
								<?php _e(' tags selected', 'otw-portfolio-manager');?>
								)
							</span>
						</label>
						<p class="description"><?php _e( 'Choose tags to include posts from those tags in your list or use the Select all checkbox to include posts from all tags.', 'otw-portfolio-manager');?></p>
					</td>
				</tr>
				<tr valign="top">
					<th scope="row">
						<label for="exclude_tags"><?php _e('Exclude Portfolio Tags:', 'otw-portfolio-manager');?></label>
					</th>
					<td>
						<?php 
								$exclude_tagsAll 		= '';
								$exclude_tagsInput 	= '';
						?>
						<select name="exclude_tags[]" id="exclude_tags" class="js-exclude_tags" multiple="multiple" data-value="<?php echo $content['exclude_tags'];?>" <?php echo $exclude_tagsInput ?>></select><br />
						<p class="description"><?php _e( 'Choose tags to exclude posts from those tags in your list.', 'otw-portfolio-manager');?></p>
					</td>
				</tr>
				<tr valign="top">
					<th scope="row">
						<label for="authors"><?php _e('Post Author:', 'otw-portfolio-manager');?></label>
					</th>
					<td>
						<?php 
								$count_users = count_users();
								$usersCount = $count_users['total_users'];
								$usersStatus = 'otw-admin-hidden';
								$usersAll 		= '';
								$usersInput 	= '';
								if( !empty($content['select_users']) ) {
									$usersStatus = '';
									$usersAll = 'checked="checked"';
									$usersInput = 'disabled="disabled"';
								}
						?>
						<select name="users[]" id="users" class="js-users" multiple="multiple" data-value="<?php echo $content['users'];?>" <?php echo $usersInput ?>></select><br />
						<?php _e('- OR -', 'otw-portfolio-manager'); ?><br/><br/>
						<input type="hidden" name="all_users" class="js-users-select" value="<?php echo $content['all_users'];?>" />
						<input type="checkbox" name="select_users" value="1" data-size="<?php echo $usersCount; ?>" class="js-select-users" id="select_all_users" data-section="users" <?php echo $usersAll;?>/>
						<label for="select_all_users">
							<?php _e('Select All', 'otw-portfolio-manager'); ?>
							<span class="js-users-count <?php echo $usersStatus; ?>">
								(
								<span class="js-users-counter"><?php echo $usersCount; ?></span>
								<?php _e(' authors selected', 'otw-portfolio-manager');?>
								)
							</span>
						</label>
						<p class="description"><?php _e( 'Choose authors to include posts from those authors in your list or use the Select all checkbox to include posts from all authors.', 'otw-portfolio-manager');?></p>
					</td>
				</tr>
				<tr valign="top">
					<th scope="row">
						<label for="exclude_users"><?php _e('Exclude Portfolio Authors:', 'otw-portfolio-manager');?></label>
					</th>
					<td>
						<?php 
								$exclude_usersAll 		= '';
								$exclude_usersInput 	= '';
						?>
						<select name="exclude_users[]" id="exclude_users" class="js-exclude_users" multiple="multiple" data-value="<?php echo $content['exclude_users'];?>" <?php echo $exclude_usersInput ?>></select><br />
						<p class="description"><?php _e( 'Choose authors to exclude posts from those authors in your list.', 'otw-portfolio-manager');?></p>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<div class="inline-error">
							<?php 
								( !empty($this->errors['content']) )? $errorMessage = $this->errors['content'] : $errorMessage = ''; 
								echo $errorMessage;
							?>
						</div>
					</td>
				</tr>

			</tbody>
		</table>

		<div class="accordion-container">
			<ul class="outer-border">
				
				<!-- List Elements and Order -->
				<li class="control-section accordion-section  add-page top">
					<h3 class="accordion-section-title hndl" tabindex="0" title="<?php _e('List Elements and Order', 'otw-portfolio-manager');?>"><?php _e('List Elements and Order', 'otw-portfolio-manager');?></h3>
					<div class="accordion-section-content" style="display: none;">
						<div class="inside">
							<table class="form-table">
								<tbody>
									<tr>
										<th scope="row">
											<label for="meta_order"><?php _e('Portfolio List Items', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<div class="active_elements">
												<h3><?php _e('Active Elements', 'otw-portfolio-manager');?></h3>
												<input type="hidden" name="portfolio-items" class="js-portfolio-items" value="<?php echo $content['portfolio-items'];?>"/>
												<ul id="meta-active" class="b-pl-box js-pl-active">
												</ul>
											</div>
											<div class="inactive_elements">
												<h3><?php _e('Inactive Elements', 'otw-portfolio-manager');?></h3>
												<ul id="meta-inactive" class="b-pl-box js-pl-inactive">
													<li data-item="main" data-value="media" class="b-pl-items js-pl--item"><?php _e('Media', 'otw-portfolio-manager');?></li>
													<li data-item="main" data-value="title" class="b-pl-items js-pl--item"><?php _e('Title', 'otw-portfolio-manager');?></li>
													<li data-item="main" data-value="meta" class="b-pl-items js-pl--item"><?php _e('Portfolio Item Details', 'otw-portfolio-manager');?></li>
													<li data-item="main" data-value="description" class="b-pl-items js-pl--item"><?php _e('Description / Excerpt', 'otw-portfolio-manager');?></li>
													<li data-item="main" data-value="continue-reading" class="b-pl-items js-pl--item"><?php _e('View project', 'otw-portfolio-manager');?></li>
												</ul>
											</div>
											<p class="description">
												<?php _e('Drag & drop the items that you\'d like to show in the Active Elements area on the left. Arrange them however you want to see them in your list.', 'otw-portfolio-manager');?>
											</p>
											<p class="description">
												<?php _e('The setting will not affect the following templates: Slider, Carousel, Widget Style, Carousel Widget', 'otw-portfolio-manager'); ?>
											</p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="show-pagination"><?php _e('Show Pagination', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											
										<select id="show-pagination" name="show-pagination">
											<?php 
											foreach( $selectPaginationData as $optionData ): 
												$selected = '';
												if( $optionData['value'] === $content['show-pagination'] ) {
													$selected = 'selected="selected"';
												}
												echo "<option value=\"".$optionData['value']."\" ".$selected.">".$optionData['text']."</option>";
												
											endforeach;
											?>
											</select>
											<p class="description">
												<?php _e('Choose pagination type for your template.', 'otw-portfolio-manager'); ?><br/>
												<strong><?php _e('Note:', 'otw-portfolio-manager');?></strong><br/>
												<?php _e('Widget Style templates support only Load More Pagination.', 'otw-portfolio-manager'); ?><br/>
												<?php _e('Slider templates do not support pagination.', 'otw-portfolio-manager'); ?><br/>
												<?php _e('Timeline template will have the Infinite Scroll by default.', 'otw-portfolio-manager'); ?>
											</p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="show-post-icon"><?php _e('Show Post Type Icon', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php
												$yes = ''; $no = ''; 
												($content['show-post-icon'])? $yes = 'checked="checked"' : $no = 'checked="checked"'; 
											?>
											<input type="radio" name="show-post-icon" id="show-post-icon-no" value="0" <?php echo $no;?> /> 
											<label for="show-post-icon-no"><?php _e('No (default)', 'otw-portfolio-manager');?></label>

											<input type="radio" name="show-post-icon" id="show-post-icon-yes" value="1" <?php echo $yes;?>/> 
											<label for="show-post-icon-yes"><?php _e('Yes', 'otw-portfolio-manager');?></label>
											<p class="description"><?php _e('Enable the post type icon over the media. This is the icon that shows what is the type of the post.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="show-delimiter"><?php _e('Show Delimiter', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php
												$yes = ''; $no = ''; 
												($content['show-delimiter'])? $yes = 'checked="checked"' : $no = 'checked="checked"'; 
											?>
											<input type="radio" name="show-delimiter" id="show-delimiter-no" value="0" <?php echo $no;?> /> 
											<label for="show-delimiter-no"><?php _e('No (default)', 'otw-portfolio-manager');?></label>

											<input type="radio" name="show-delimiter" id="show-delimiter-yes" value="1" <?php echo $yes;?> /> 
											<label for="show-delimiter-yes"><?php _e('Yes', 'otw-portfolio-manager');?></label>
											<p class="description"><?php _e('Enable 1px line after post.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="show-border"><?php _e('Show Border', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php
												$yes = ''; $no = ''; 
												($content['show-border'])? $yes = 'checked="checked"' : $no = 'checked="checked"'; 
											?>
											<input type="radio" name="show-border" id="show-border-no" value="0" <?php echo $no;?> /> 
											<label for="show-border-no"><?php _e('No (default)', 'otw-portfolio-manager');?></label>

											<input type="radio" name="show-border" id="show-border-yes" value="1" <?php echo $yes;?> /> 
											<label for="show-border-yes"><?php _e('Yes', 'otw-portfolio-manager');?></label>
											<p class="description"><?php _e("A border (1px) is going to be applied to all of your posts within the list", 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="show-background"><?php _e('Show Background', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php
												$yes = ''; $no = ''; 
												($content['show-background'])? $yes = 'checked="checked"' : $no = 'checked="checked"'; 
											?>
											<input type="radio" name="show-background" id="show-background-no" value="0" <?php echo $no;?> /> 
											<label for="show-background-no"><?php _e('No (default)', 'otw-portfolio-manager');?></label>

											<input type="radio" name="show-background" id="show-background-yes" value="1" <?php echo $yes;?>/> 
											<label for="show-background-yes"><?php _e('Yes', 'otw-portfolio-manager');?></label>
											<p class="description"><?php _e("A background is going to be present on all of the posts within the list", 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="show-social-icons"><?php _e('Show Social Icons', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php
												$yes = ''; $no = ''; 
												($content['show-social-icons'])? $yes = 'checked="checked"' : $no = 'checked="checked"'; 
											?>
											<select id="show-social-icons" name="show-social-icons">
											<?php 
											foreach( $selectSocialData as $optionData ): 
												$selected = '';
												if( $optionData['value'] === $content['show-social-icons'] ) {
													$selected = 'selected="selected"';
												}
												echo "<option value=\"".$optionData['value']."\" ".$selected.">".$optionData['text']."</option>";
												
											endforeach;
											?>
											</select>
											<p class="description">
												<?php 
												_e("Social Icons will make your posts easy to share in social networks. Note that to use 
													\"Share buttons small\" and \"Share buttons large\" you need to have CURL installed on your server.
													", 'otw-portfolio-manager');
												?>
											</p>
										</td>
									</tr>

									<tr id="otw-show-social-icons-type">
										<th scope="row">
											<label for="show-social-icons-type"><?php _e('Select Social Icons', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<input type="checkbox" id="show-social-icons-type" name="show-social-icons-facebook" value="1" <?php echo ( $content['show-social-icons-facebook'] )?' checked="checked"':''?> /><label for="show-social-icons-type"><?php _e('Facebook', 'otw-portfolio-manager');?></label>
											<input type="checkbox" id="show-social-icons-twitter" name="show-social-icons-twitter" value="1" <?php echo ( $content['show-social-icons-twitter'] )?' checked="checked"':''?>/><label for="show-social-icons-twitter"><?php _e('Twitter', 'otw-portfolio-manager');?></label>
											<input type="checkbox" id="show-social-icons-googleplus" name="show-social-icons-googleplus" value="1" <?php echo ( $content['show-social-icons-googleplus'] )?' checked="checked"':''?>/><label for="show-social-icons-googleplus"><?php _e('Google+', 'otw-portfolio-manager');?></label>
											<input type="checkbox" id="show-social-icons-linkedin" name="show-social-icons-linkedin" value="1" <?php echo ( $content['show-social-icons-linkedin'] )?' checked="checked"':''?>/><label for="show-social-icons-linkedin"><?php _e('LinkedIn', 'otw-portfolio-manager');?></label>
											<input type="checkbox" id="show-social-icons-pinterest" name="show-social-icons-pinterest" value="1" <?php echo ( $content['show-social-icons-pinterest'] )?' checked="checked"':''?>/><label for="show-social-icons-pinterest"><?php _e('Pinterest', 'otw-portfolio-manager');?></label>
											<p class="description"><?php _e( 'Select the social icons that will be displayed.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr id="otw-show-social-icons-custom">
										<th scope="row">
											<label for="show-social-icons-custom"><?php _e('Custom Social Icons', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<textarea id="show-social-icons-custom" name="show-social-icons-custom" rows="6" cols="80"><?php echo ( $content['show-social-icons-custom'] )?></textarea>
											<p class="description"><?php _e( 'Insert your Custom Social Icons. HTML and Shortcodes are allowed.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
								</tbody>
							</table>
						</div><!-- .inside -->
					</div><!-- .accordion-section-content -->

				</li><!-- .accordion-section -->
				<!-- END List Elements and Order -->

				<!-- Post Order and Limits -->
				<li class="control-section accordion-section add-page top">
					<h3 class="accordion-section-title hndl" tabindex="1" title="<?php _e('Posts Order and Limits', 'otw-portfolio-manager');?>"><?php _e('Posts Order and Limits', 'otw-portfolio-manager');?></h3>
					<div class="accordion-section-content" style="display: none;">
						<div class="inside">
							<table class="form-table">
								<tbody>
									<tr valign="top">
										<th scope="row">
											<label for="posts_limit"><?php _e('Number of Posts in the List:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<input type="text" name="posts_limit" id="posts_limit" value="<?php echo $content['posts_limit'];?>" />
											<p class="description"><?php _e('Please leave empty for all posts.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="posts_limit_skip"><?php _e('Number of Posts to Skip:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<input type="text" name="posts_limit_skip" id="posts_limit_skip" value="<?php echo $content['posts_limit_skip'];?>" />
											<p class="description"><?php _e('By default this field is empty which means no posts will be skipped.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="posts_limit_page"><?php _e('Number of Posts per Page:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<input type="text" name="posts_limit_page" id="posts_limit_page" value="<?php echo $content['posts_limit_page'];?>" />
											<p class="description"><?php _e('Show pagination should be ebabled in the section above in order for this option to work.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="posts_order"><?php _e('Order of Posts:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<select name="posts_order" id="posts_order">
											<?php 
											foreach( $selectOrderData as $optionData ): 
												$selected = '';
												if( $optionData['value'] === $content['posts_order'] ) {
													$selected = 'selected="selected"';
												}
												echo "<option value=\"".$optionData['value']."\" ".$selected.">".$optionData['text']."</option>";
												
											endforeach;
											?>
											</select>
											<p class="description"><?php _e('Choose the order of the posts in the list. Timeline Template will ignore this selection and use Latest Created. Note that when Random is selected and pagination is enabled there might be posts displayed on more than one of the pagination pages.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
								</tbody>
							</table>
						</div>
					</div><!-- .accordion-section-content -->

				</li><!-- .accordion-section -->
				<!-- END Post Order and Limits -->

				<!-- Settings -->
				<li class="control-section accordion-section add-page top">
					<h3 class="accordion-section-title hndl" tabindex="2" title="<?php _e('Settings', 'otw-portfolio-manager');?>"><?php _e('Settings', 'otw-portfolio-manager');?></h3>
					<div class="accordion-section-content" style="display: none;">
						<div class="inside">
							<table class="form-table">
								<tbody>
									<tr valign="top">
										<th scope="row">
											<label for="portfolio_list_title"><?php _e('Portfolio List Title:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<input type="text" name="portfolio_list_title" id="portfolio_list_title" value="<?php echo $content['portfolio_list_title'];?>" size="53" />
											<p class="description"><?php _e('This is the title on top of your list. If empty no title will be displayed.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="view_all_page"><?php _e('View All Link:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<select name="view_all_page" id="view_all_page" class="js-pages" data-value="<?php echo $content['view_all_page'];?>" data-allow-clear="true"></select>
											<br/><?php _e('- OR -', 'otw-portfolio-manager'); ?><br/>
											<input type="text" name="view_all_page_link" value="<?php echo $content['view_all_page_link'];?>" size="53" placeholder="http://www.google.com"/>
											<p class="description"><?php _e('Choose the page you want "view all" to link to. Or enter an URL.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="view_all_page_text"><?php _e('View All Link Text:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<input type="text" name="view_all_page_text" id="view_all_page_text" value="<?php echo $content['view_all_page_text'];?>" size="53"/>
											<p class="description"><?php _e('Enter View all link text. By default the text is “View all”.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="view_all_target"><?php _e('View All Link Target:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<select name="view_all_target">
											<?php 
											foreach( $selectViewTargetData as $optionData ): 
												$selected = '';
												if( $optionData['value'] === $content['view_all_target'] ) {
													$selected = 'selected="selected"';
												}
												echo "<option value=\"".$optionData['value']."\" ".$selected.">".$optionData['text']."</option>";
												
											endforeach;
											?>
											</select>		
											<p class="description"><?php _e('Select if you would like to open the link in a new window / tab or the same window / tab.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="excerpt_length"><?php _e('Excerpt Length:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<input type="text" name="excerpt_length" id="excerpt_length" value="<?php echo $content['excerpt_length'];?>" size="53"/>
											<p class="description"><?php _e('Excerpt is pulled from excerpt field for each post. If excerpt fields is empty excerpt is pulled from the text area (the post editor). If Excerpt length is empty or 0 this means pull the entire text.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="strip_tags"><?php _e('Strip HTML Tags:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<select name="strip_tags" id="strip_tags">
											<?php 
											foreach( $selectStripTags as $optionData ): 
												$selected = '';
												if( $optionData['value'] === $content['strip_tags'] ) {
													$selected = 'selected="selected"';
												}
												echo "<option value=\"".$optionData['value']."\" ".$selected.">".$optionData['text']."</option>";
												
											endforeach;
											?>
											</select>
											<p class="description"><?php _e('Strip HTML tags from the excerpt in your portfolio lists.', 'otw-portfolio-manager');?>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="strip_shortcodes"><?php _e('Strip Shortcodes:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<select name="strip_shortcodes" id="strip_shortcodes">
											<?php 
											foreach( $selectStripShortcodes as $optionData ): 
												$selected = '';
												if( $optionData['value'] === $content['strip_shortcodes'] ) {
													$selected = 'selected="selected"';
												}
												echo "<option value=\"".$optionData['value']."\" ".$selected.">".$optionData['text']."</option>";
												
											endforeach;
											?>
											</select>
											<p class="description"><?php _e('Strip Shortcodes from the excerpt in your portfolio lists.', 'otw-portfolio-manager');?>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="continue_reading"><?php _e('View project Text:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<input type="text" name="continue_reading" id="continue_reading" value="<?php echo $content['continue_reading'];?>" size="53" />
											<p class="description"><?php _e('Enter the text for your view project link under each post. If left empty ‘View project’ is displayed.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="image_link"><?php _e('Click on Image Links to?', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<select name="image_link" id="image_link">
											<?php 
											foreach( $selectLinkData as $optionData ): 
												$selected = '';
												if( $optionData['value'] === $content['image_link'] ) {
													$selected = 'selected="selected"';
												}
												echo "<option value=\"".$optionData['value']."\" ".$selected.">".$optionData['text']."</option>";
												
											endforeach;
											?>
											</select>									
											<p class="description"><?php _e('Choose where a click on the image links to. This option does not work when some hovers are enabled since they have their specific settings.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="title_link"><?php _e('Click on Title Links to?', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<select name="title_link" id="title_link">
											<?php 
											foreach( $selectLinkData as $optionData ): 
												$selected = '';
												if( $optionData['value'] === $content['title_link'] ) {
													$selected = 'selected="selected"';
												}
												echo "<option value=\"".$optionData['value']."\" ".$selected.">".$optionData['text']."</option>";
												
											endforeach;
											?>
											</select>									
											<p class="description"><?php _e('Choose where a click on the title links to. This option does not work when some hovers are enabled since they have their specific settings.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="image_hover"><?php _e('Hover Effect', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<select name="image_hover" id="image_hover">
											<?php 
											foreach( $selectHoverData as $optionData ): 
												$selected = '';
												if( $optionData['value'] === $content['image_hover'] ) {
													$selected = 'selected="selected"';
												}
												echo "<option value=\"".$optionData['value']."\" ".$selected.">".$optionData['text']."</option>";
												
											endforeach;
											?>
											</select>									
											<p class="description"><?php _e('Choose the hover for the images in the posts list.', 'otw-portfolio-manager');?></p>
											<p class="description">
												<?php _e('The setting will not affect the following templates since they have their own specific hovers: Slider, Carousel.', 'otw-portfolio-manager'); ?> 
											</p>
											<p class="description">
												<?php _e('Widget Templates support only Full and None hover options.', 'otw-portfolio-manager'); ?> 
											</p>
										</td>
									</tr>
									<tr>
										<th scope="row">
											<label for="meta_order"><?php _e('Portfolio Item Details Order', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<div class="active_elements">
												<h3><?php _e('Active Elements', 'otw-portfolio-manager');?></h3>
												<input type="hidden" name="meta-items" class="js-meta-items" value="<?php echo $content['meta-items'];?>"/>
												<ul class="b-meta-box js-meta-active" style="height: <?php echo $meta_elements_height?>px;">
												</ul>
											</div>
											<div class="inactive_elements">
												<h3><?php _e('Inactive Elements', 'otw-portfolio-manager');?></h3>
												<ul class="b-meta-box js-meta-inactive" style="height: <?php echo $meta_elements_height?>px;">
													<?php foreach( $meta_elements as $meta_element_key => $meta_element_name ){?>
														<li data-item="meta" data-value="<?php echo $meta_element_key?>" class="b-meta-items js-meta--item"><?php echo $meta_element_name?></li>
													<?php }?>
												</ul>
											</div>
											<p class="description"><?php _e('Drag & drop the items that you\'d like to show in the Active Elements area on the left. Arrange them however you want to see them in your list.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>

									<tr valign="top">
										<th scope="row">
											<label for="meta_type_align"><?php _e('Portfolio Item Details Type:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<select name="meta_type_align" id="meta_type_align">
											<?php 
											foreach( $selectMetaData as $optionData ): 
												$selected = '';
												if( $optionData['value'] === $content['meta_type_align'] ) {
													$selected = 'selected="selected"';
												}
												echo "<option value=\"".$optionData['value']."\" ".$selected.">".$optionData['text']."</option>";
												
											endforeach;
											?>
											</select>
											<p class="description"><?php _e('Choose between horizontal and vertical Portfolio Item Details Type.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="meta_icons"><?php _e('Portfolio Item Details Icons:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php
												$yes = ''; $no = ''; 
												($content['meta_icons'])? $yes = 'checked="checked"' : $no = 'checked="checked"'; 
											?>
											<input type="radio" name="meta_icons" id="meta_icons-no" value="0" <?php echo $no;?>/> 
											<label for="meta_icons-no"><?php _e('No (default)', 'otw-portfolio-manager');?></label>

											<input type="radio" name="meta_icons" id="meta_icons-yes" value="1" <?php echo $yes;?>/> 
											<label for="meta_icons-yes"><?php _e('Yes', 'otw-portfolio-manager');?></label>
											<p class="description"><?php _e('Choose yes if you want to have icons instead of labels in your Portfolio Item Details.', 'otw-portfolio-manager');?>
										</td>
									</tr>

								</tbody>
							</table>
						</div> <!-- .inside -->
					</div><!-- .accordion-section-content -->

				</li><!-- .accordion-section -->
				<!-- END Settings -->


				<!-- Media Tab -->
				<li class="control-section accordion-section add-page top">
					<h3 class="accordion-section-title hndl" tabindex="4" title="<?php _e('Media', 'otw-portfolio-manager');?>"><?php _e('Media', 'otw-portfolio-manager');?></h3>
					<div class="accordion-section-content" style="display: none;">
						<div class="inside">
							<table class="form-table">
								<tbody>
									<tr valign="top">
										<th scope="row">
											<label for="thumb_width"><?php _e('Thumbnail Width', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php ( !isset($content['thumb_width']) )? $thumbWidth = '' : $thumbWidth = $content['thumb_width']; ?>
											<input type="text" name="thumb_width" id="thumb_width" size="3" value="<?php echo $thumbWidth;?>" />
											<p class="description"><?php _e('The width for your thumbnails in px. If left empty the default value will be used. Default value for the selected template is: ', 'otw-portfolio-manager');?><span class="default_thumb_width"></span><?php _e('<br>Horizontal template image widths are set in the Horizontal Layout Settings tab bellow.<br >Use -1 if you want to disable cropping and use the original image upload.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="thumb_height"><?php _e('Thumbnail Height', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php ( !isset($content['thumb_height']) )? $thumbHeight = '' : $thumbHeight = $content['thumb_height']; ?>
											<input type="text" name="thumb_height" id="thumb_height" size="3" value="<?php echo $thumbHeight;?>" />
											<p class="description"><?php _e('The height for your thumbnails in px. If left empty the default value will be used. Default value for the selected template is: ', 'otw-portfolio-manager');?><span class="default_thumb_height"></span><?php _e('<br>Horizontal template images height is set here.<br />Use -1 if you want to disable cropping and use the original image upload.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="thumb_format"><?php _e('Thumbnail Format', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php ( !isset($content['thumb_format']) )? $thumbFormat = '' : $thumbFormat = $content['thumb_format']; ?>
											<select id="thumb_format" name="thumb_format">
											<?php foreach( $thumb_format_options as $key => $name ){?>
												<?php
													$selected = '';
													if( $thumbFormat == $key ){
														$selected = ' selected="selected"';
													}
												?>
												<option value="<?php echo $key?>"<?php echo $selected?>><?php echo $name?></option>
											<?php }?>
											</select>
											<p class="description"><?php _e('The format for your thumbnails.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="thumb_crop"><?php _e('Thumnail Crop', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php ( !isset($content['thumb_crop']) )? $thumbCrop = '' : $thumbCrop = $content['thumb_crop']; ?>
											<select name="thumb_crop" id="thumb_crop">
												<option value="center_center" <?php echo ( $thumbCrop == 'center_center' )?'selected="selected"':'';?> ><?php _e( 'Crop center-center (default)', 'otw-portfolio-manager');?></option>
												<option value="center_left" <?php echo ( $thumbCrop == 'center_left' )?'selected="selected"':'';?> ><?php _e( 'Crop center-left', 'otw-portfolio-manager');?></option>
												<option value="center_right" <?php echo ( $thumbCrop == 'center_right' )?'selected="selected"':'';?> ><?php _e( 'Crop center-right', 'otw-portfolio-manager');?></option>
												<option value="top_center" <?php echo ( $thumbCrop == 'top_center' )?'selected="selected"':'';?> ><?php _e( 'Crop top-center', 'otw-portfolio-manager');?></option>
												<option value="top_left" <?php echo ( $thumbCrop == 'top_left' )?'selected="selected"':'';?> ><?php _e( 'Crop top-left', 'otw-portfolio-manager');?></option>
												<option value="top_right" <?php echo ( $thumbCrop == 'top_right' )?'selected="selected"':'';?> ><?php _e( 'Crop top-right', 'otw-portfolio-manager');?></option>
												<option value="bottom_center" <?php echo ( $thumbCrop == 'bottom_center' )?'selected="selected"':'';?> ><?php _e( 'Crop bottom-center', 'otw-portfolio-manager');?></option>
												<option value="bottom_left" <?php echo ( $thumbCrop == 'bottom_left' )?'selected="selected"':'';?> ><?php _e( 'Crop bottom-left', 'otw-portfolio-manager');?></option>
												<option value="botom_right" <?php echo ( $thumbCrop == 'bottom_right' )?'selected="selected"':'';?> ><?php _e( 'Crop bottom-right', 'otw-portfolio-manager');?></option>
												<option value="no" <?php echo ( $thumbCrop == 'no' )?'selected="selected"':'';?> ><?php _e( 'No cropping, resize only', 'otw-portfolio-manager');?></option>
											</select>
											<p class="description"><?php _e('Crop or just resize the thumbnail.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="white_spaces"><?php _e('Small Images', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php ( empty($content['white_spaces']) )? $whiteSpaces = 'yes' : $whiteSpaces = $content['white_spaces']; ?>
											<select name="white_spaces" id="white_spaces">
												<option value="yes" <?php echo ( $whiteSpaces != 'no' )?'selected="selected"':'';?> ><?php _e( 'Add background (default)', 'otw-portfolio-manager');?></option>
												<option value="no" <?php echo ( $whiteSpaces == 'no' )?'selected="selected"':'';?> ><?php _e( 'Don\'t add background', 'otw-portfolio-manager');?></option>
											</select>
											<p class="description"><?php _e('This option will affect only images which original size is smaller than the desired size.<br />\'Add background\' will add background to complete the image size to the desired image size. \'Don\'t add background\' will not add background and it will leave the images as they originally are.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr valign="top" id="white_spaces_color_container">
										<th scope="row">
											<label for="white_spaces_color"><?php _e('Image Background Color:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php
												if( empty( $content['white_spaces_color'] ) ){
													$content['white_spaces_color'] = '#FFFFFF';
												}
											?>
											<div class="otw-pm-color-picker">
												<div class="js-color-picker-icon js-color-picker">
													<div class="js-color-container" style="background-color: <?php echo $content['white_spaces_color'];?>;"></div>
												</div>
												<input type="text" name="white_spaces_color" class="js-color-picker-value" value="<?php echo $content['white_spaces_color'];?>"/>
											</div>
											<!-- END Excpert Font Color -->
											<p class="description"><?php _e('The extra background color to complete the image to the desired size.', 'otw-portfolio-manager'); ?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="thumb_alt_attr"><?php _e('Add alt tag', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php ( empty($content['thumb_alt_attr']) )? $thumb_alt_attr = 'no' : $thumb_alt_attr = $content['thumb_alt_attr']; ?>
											<select name="thumb_alt_attr" id="thumb_alt_attr">
												<option value="no" <?php echo ( $thumb_alt_attr == 'no' )?'selected="selected"':'';?> ><?php _e( 'No (default)', 'otw-portfolio-manager');?></option>
												<option value="media_settings" <?php echo ( $thumb_alt_attr == 'media_settings' )?'selected="selected"':'';?> ><?php _e( 'Use what is set in the Media Library', 'otw-portfolio-manager');?></option>
											</select>
											<p class="description"><?php _e('The alt tag helps position your images in search engines.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="thumb_title_attr"><?php _e('Add title tag', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php ( empty($content['thumb_title_attr']) )? $thumb_title_attr = 'no' : $thumb_title_attr = $content['thumb_title_attr']; ?>
											<select name="thumb_title_attr" id="thumb_title_attr">
												<option value="no" <?php echo ( $thumb_title_attr == 'no' )?'selected="selected"':'';?> ><?php _e( 'No (default)', 'otw-portfolio-manager');?></option>
												<option value="media_settings" <?php echo ( $thumb_title_attr == 'media_settings' )?'selected="selected"':'';?> ><?php _e( 'Use what is set in the Media Library', 'otw-portfolio-manager');?></option>
											</select>
											<p class="description"><?php _e('The title tag helps position your images in search engines and is displayed on hover of the image.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="lightbox_thumb_width"><?php _e('Lightbox Thumbnail Width', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php ( !isset($content['lightbox_thumb_width']) )? $lightboxThumbWidth = '' : $lightboxThumbWidth = $content['lightbox_thumb_width']; ?>
											<input type="text" name="lightbox_thumb_width" id="lightbox_thumb_width" size="3" value="<?php echo $lightboxThumbWidth;?>" />
											<p class="description"><?php _e('The width for your lightbox thumbnails in px. If left empty the default value will be used. Default value: 1024px', 'otw-portfolio-manager');?><span class="default_lightbox_thumb_width"></span><?php _e( '<br />Use -1 if you want to disable cropping and use the original image upload.', 'otw-portfolio-manager' )?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="lightbox_thumb_height"><?php _e('Lightbox Thumbnail Height', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php ( !isset($content['lightbox_thumb_height']) )? $lightboxThumbHeight = '' : $lightboxThumbHeight = $content['lightbox_thumb_height']; ?>
											<input type="text" name="lightbox_thumb_height" id="lightbox_thumb_height" size="3" value="<?php echo $lightboxThumbHeight;?>" />
											<p class="description"><?php _e('The height for your lightbox thumbnails in px. If left empty the default value will be used. Default value: 640px', 'otw-portfolio-manager');?><span class="default_lightbox_thumb_height"></span><?php _e( '<br />Use -1 if you want to disable cropping and use the original image upload.', 'otw-portfolio-manager' )?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="lightbox_thumb_format"><?php _e('Lightbox Thumbnail Format', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php ( !isset($content['lightbox_thumb_format']) )? $lightboxThumbFormat = '' : $lightboxThumbFormat = $content['lightbox_thumb_format']; ?>
											<select id="lightbox_thumb_format" name="lightbox_thumb_format">
											<?php foreach( $thumb_format_options as $key => $name ){?>
												<?php
													$selected = '';
													if( $lightboxThumbFormat == $key ){
														$selected = ' selected="selected"';
													}
												?>
												<option value="<?php echo $key?>"<?php echo $selected?>><?php echo $name?></option>
											<?php }?>
											</select>
											<p class="description"><?php _e('The format for your lightbox thumbnails.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
								</tbody>
							</table>
						</div>
					</div>
				</li><!-- .accordion-section -->
				<!-- Style Tab -->
				
				<li class="control-section accordion-section add-page top">
					<h3 class="accordion-section-title hndl" tabindex="5" title="<?php _e('Styles', 'otw-portfolio-manager');?>"><?php _e('Styles', 'otw-portfolio-manager');?></h3>
					<div class="accordion-section-content" style="display: none;">
						<div class="inside">
							<table class="form-table">
								<tbody>
									<tr valign="top">
										<th scope="row">
											<label for="title-font-size"><?php _e('Title Style:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<!-- Title Font Size -->
											<select name="title-font-size" id="title-font-size">
											<?php 
											foreach( $selectFontSizeData as $optionData ): 
												$selected = '';
												if( $optionData['value'] === $content['title-font-size'] ) {
													$selected = 'selected="selected"';
												}
												echo "<option value=\"".$optionData['value']."\" ".$selected.">".$optionData['text']."</option>";
												
											endforeach;
											?>
											</select>
											<!-- END Title Font Size -->

											<!-- Title Font Style -->
											<select name="title-font-style" id="title-font-style">
											<?php 
											foreach( $selectFontStyleData as $optionData ): 
												$selected = '';
												if( $optionData['value'] === $content['title-font-style'] ) {
													$selected = 'selected="selected"';
												}
												echo "<option value=\"".$optionData['value']."\" ".$selected.">".$optionData['text']."</option>";
												
											endforeach;
											?>
											</select>
											<!-- END Title Font Style -->

											<!-- Title Font Family -->
											<select name="title_font"  class="js-fonts" data-placeholder="<?php _e( 'Font Family', 'otw-portfolio-manager' )?>" data-value="<?php echo ( !empty( $content['title_font'] ) )? $content['title_font']:'';?>" data-allow-clear="true"></select>
											<!-- END Title Font Family -->

											<!-- Title Font Color -->
											<div class="otw-pm-color-picker">
												<div class="js-color-picker-icon js-color-picker">
													<div class="js-color-container" style="background-color: <?php echo $content['title-color'];?>;"></div>
												</div>
												<input type="text" name="title-color" class="js-color-picker-value" value="<?php echo $content['title-color'];?>"/>
											</div>
											<!-- END Title Font Color -->
											<p class="description"><?php _e('Adjust the style of the Title of each post in your list', 'otw-portfolio-manager'); ?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="meta-font-size"><?php _e('Portfolio Item Details Style:', 'otw-portfolio-manager');?></label>
										</th>
										<td>

											<!-- Meta Items Font Size -->
											<select name="meta-font-size" id="meta-font-size">
											<?php 
											foreach( $selectFontSizeData as $optionData ): 
												$selected = '';
												if( $optionData['value'] === $content['meta-font-size'] ) {
													$selected = 'selected="selected"';
												}
												echo "<option value=\"".$optionData['value']."\" ".$selected.">".$optionData['text']."</option>";
												
											endforeach;
											?>
											</select>
											<!-- END Meta Items Font Size -->

											<!-- Meta Font Style -->
											<select name="meta-font-style" id="meta-font-style">
											<?php 
											foreach( $selectFontStyleData as $optionData ): 
												$selected = '';
												if( $optionData['value'] === $content['meta-font-style'] ) {
													$selected = 'selected="selected"';
												}
												echo "<option value=\"".$optionData['value']."\" ".$selected.">".$optionData['text']."</option>";
												
											endforeach;
											?>
											</select>
											<!-- END Meta Font Style -->

											<!-- Title Font Family -->
											<select name="meta_font"  class="js-fonts" data-placeholder="<?php _e( 'Font Family', 'otw-portfolio-manager' )?>" data-value="<?php echo ( !empty( $content['meta_font'] ) )? $content['meta_font']:'';?>" data-allow-clear="true"></select>
											<!-- END Meta Font Family -->

											<!-- Meta Font Color -->
											<div class="otw-pm-color-picker">
												<div class="js-color-picker-icon js-color-picker">
													<div class="js-color-container" style="background-color: <?php echo $content['meta-color'];?>;"></div>
												</div>
												<input type="text" name="meta-color" class="js-color-picker-value" value="<?php echo $content['meta-color'];?>"/>
											</div>
											<!-- END Meta Font Color -->

											<p class="description"><?php _e('Adjust the style of the Portfolio Item Details.', 'otw-portfolio-manager'); ?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="excpert-font-size"><?php _e('Excpert Style:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<!-- Excpert Font Size -->
											<select name="excpert-font-size" id="meta-font-size">
											<?php 
											foreach( $selectFontSizeData as $optionData ): 
												$selected = '';
												if( $optionData['value'] === $content['excpert-font-size'] ) {
													$selected = 'selected="selected"';
												}
												echo "<option value=\"".$optionData['value']."\" ".$selected.">".$optionData['text']."</option>";
												
											endforeach;
											?>
											</select>
											<!-- END Excpert Font Size -->

											<!-- Excpert Font Style -->
											<select name="excpert-font-style" id="excpert-font-style">
											<?php 
											foreach( $selectFontStyleData as $optionData ): 
												$selected = '';
												if( $optionData['value'] === $content['excpert-font-style'] ) {
													$selected = 'selected="selected"';
												}
												echo "<option value=\"".$optionData['value']."\" ".$selected.">".$optionData['text']."</option>";
												
											endforeach;
											?>
											</select>
											<!-- END Excpert Font Style -->

											<!-- Excpert Font Family -->
											<select name="excpert_font"  class="js-fonts" data-placeholder="<?php _e( 'Font Family', 'otw-portfolio-manager' )?>" data-value="<?php echo ( !empty( $content['excpert_font'] ) )? $content['excpert_font']:'';?>" data-allow-clear="true"></select>
											<!-- END Excpert Font Family -->

											<!-- Excpert Font Color -->
											<div class="otw-pm-color-picker">
												<div class="js-color-picker-icon js-color-picker">
													<div class="js-color-container" style="background-color: <?php echo $content['excpert-color'];?>;"></div>
												</div>
												<input type="text" name="excpert-color" class="js-color-picker-value" value="<?php echo $content['excpert-color'];?>"/>
											</div>
											<!-- END Excpert Font Color -->
											<p class="description"><?php _e('Adjust the style of the Excpert of each post in your list', 'otw-portfolio-manager'); ?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="read-more-font-size"><?php _e('View project Style:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<!-- Excpert Font Size -->
											<select name="read-more-font-size" id="meta-font-size">
											<?php 
											foreach( $selectFontSizeData as $optionData ): 
												$selected = '';
												if( $optionData['value'] === $content['read-more-font-size'] ) {
													$selected = 'selected="selected"';
												}
												echo "<option value=\"".$optionData['value']."\" ".$selected.">".$optionData['text']."</option>";
												
											endforeach;
											?>
											</select>
											<!-- END Excpert Font Size -->

											<!-- Excpert Font Style -->
											<select name="read-more-font-style" id="read-more-font-style">
											<?php 
											foreach( $selectFontStyleData as $optionData ): 
												$selected = '';
												if( $optionData['value'] === $content['read-more-font-style'] ) {
													$selected = 'selected="selected"';
												}
												echo "<option value=\"".$optionData['value']."\" ".$selected.">".$optionData['text']."</option>";
												
											endforeach;
											?>
											</select>
											<!-- END Excpert Font Style -->

											<!-- Excpert Font Family -->
											<select name="read-more_font"  class="js-fonts" data-placeholder="<?php _e( 'Font Family', 'otw-portfolio-manager' )?>" data-value="<?php echo ( !empty( $content['read-more_font'] ) )? $content['read-more_font']:'';?>" data-allow-clear="true"></select>
											<!-- END Excpert Font Family -->

											<!-- Excpert Font Color -->
											<div class="otw-pm-color-picker">
												<div class="js-color-picker-icon js-color-picker">
													<div class="js-color-container" style="background-color: <?php echo $content['read-more-color'];?>;"></div>
												</div>
												<input type="text" name="read-more-color" class="js-color-picker-value" value="<?php echo $content['read-more-color'];?>"/>
											</div>
											<!-- END Excpert Font Color -->
											<p class="description"><?php _e('Adjust the style of the View project of each post in your list', 'otw-portfolio-manager'); ?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="border-style"><?php _e('Border Style:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<!--  Font Size -->
											<select name="border-style" id="border-style">
											<?php 
											foreach( $selectBorderStyleData as $optionData ): 
												$selected = '';
												if( $optionData['value'] === $content['border-style'] ) {
													$selected = 'selected="selected"';
												}
												echo "<option value=\"".$optionData['value']."\" ".$selected.">".$optionData['text']."</option>";
												
											endforeach;
											?>
											</select>
											<select name="border-size" id="border-size">
											<?php 
											foreach( $selectBorderSizeData as $optionData ): 
												$selected = '';
												if( $optionData['value'] === $content['border-size'] ) {
													$selected = 'selected="selected"';
												}
												echo "<option value=\"".$optionData['value']."\" ".$selected.">".$optionData['text']."</option>";
												
											endforeach;
											?>
											</select>
											<div class="otw-pm-color-picker">
												<div class="js-color-picker-icon js-color-picker">
													<div class="js-color-container" style="background-color: <?php echo $content['border-color'];?>;"></div>
												</div>
												<input type="text" name="border-color" class="js-color-picker-value" value="<?php echo $content['border-color'];?>"/>
											</div>
											<p class="description"><?php _e('Adjust the style of the Border from the Lists elements and order tab.', 'otw-portfolio-manager'); ?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="background-color"><?php _e('Background Color:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<div class="otw-pm-color-picker">
												<div class="js-color-picker-icon js-color-picker">
													<div class="js-color-container" style="background-color: <?php echo $content['background-color'];?>;"></div>
												</div>
												<input type="text" name="background-color" class="js-color-picker-value" value="<?php echo $content['background-color'];?>"/>
											</div>
											<p class="description"><?php _e('Adjust the style of the Background from the Lists elements and order tab.', 'otw-portfolio-manager'); ?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="background-color-opacity"><?php _e('Background Opacity:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<input type="text" name="background-color-opacity" id="background-color-opacity" size="4" value="<?php echo $content['background-color-opacity'];?>" />
											<p class="description"><?php _e('The opacity of the background. Could be between 0 and 1. For example 0.61. Leave empty for not opacity', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="hover-color"><?php _e('Hover Color:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<div class="otw-pm-color-picker">
												<div class="js-color-picker-icon js-color-picker">
													<div class="js-color-container" style="background-color: <?php echo $content['hover-color'];?>;"></div>
												</div>
												<input type="text" name="hover-color" class="js-color-picker-value" value="<?php echo $content['hover-color'];?>"/>
											</div>
											<p class="description"><?php _e('Adjust the color of the hover.', 'otw-portfolio-manager'); ?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="custom_css"><?php _e('Custom CSS:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<textarea name="custom_css" cols="70" rows="10"><?php echo str_replace('\\', '', $content['custom_css']);?></textarea>
										</td>
									</tr>
								</tbody>
							</table>
						</div> <!-- .inside -->
					</div><!-- .accordion-section-content -->

				</li><!-- .accordion-section -->
				<!-- Style Tab -->

				<!-- Query Selection Tab -->
				<li class="control-section accordion-section add-page top">
					<h3 class="accordion-section-title hndl" tabindex="6" title="<?php _e('Post Selection Method - Advanced Users', 'otw-portfolio-manager');?>">
						<?php _e('Post Selection Method - Advanced Users', 'otw-portfolio-manager');?>
					</h3>
					<div class="accordion-section-content" style="display: none;">
						<div class="inside">

							<table class="form-table">
								<tbody>
									<tr valign="top">
										<th scope="row">
											<label for="portfolio_list_title">
												<?php _e('Between Categories and Tags result-sets Selection Method:', 'otw-portfolio-manager');?>
											</label>
										</th>
										<td>
											<!-- Category / Tag relation -->
											<select name="cat-tag-relation" id="cat-tag-relation">
											<?php 
											foreach( $selectCategoryTagRelation as $optionData ): 
												$selected = '';
												if( $optionData['value'] === $content['cat-tag-relation'] ) {
													$selected = 'selected="selected"';
												}
												echo "<option value=\"".$optionData['value']."\" ".$selected.">".$optionData['text']."</option>";
												
											endforeach;
											?>
											</select>
											<!-- END Category / Tag relation -->
											<p class="description">
												<?php _e('categories OR tags means: WHERE post_id IN categories-result-set OR post_id IN tags-result-set. In other words your list will include all posts that are in categories-result-set or tags-result-set.', 'otw-portfolio-manager'); ?>
											</p>
											<p class="description">
												<?php _e('categories AND tags means: WHERE post_id IN categories-result-set AND post_id IN tags-result-set. In other words your list will include all posts that are in both result-sets categories-result-set and tags-result-set in the same time (If a post is only in categories-result-set, it will not be included in the list).', 'otw-portfolio-manager'); ?>
											</p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="author-relation">
												<?php _e('Before Authors result-set Selection Method:', 'otw-portfolio-manager');?>
											</label>
										</th>
										<td>
											<select name="author-relation" id="author-relation">
												<option value="or" <?php echo ( isset( $content['author-relation'] ) && ( $content['author-relation'] === 'or' ) )?'selected="selected"':''?>><?php _e( 'OR authors', 'otw-portfolio-manager' )?></option>
												<option value="and" <?php echo ( !isset( $content['author-relation'] ) || ( $content['author-relation'] !== 'or' ) )?'selected="selected"':''?>><?php _e( 'AND authors(default)', 'otw-portfolio-manager' )?></option>
											</select>
											<p class="description">
												<?php _e( 'AND authors means: WHERE post_id IN categories-and-tags-result-set AND post_id IN authors -result-set. In other words your list will include all posts that are in both result-sets categories-and-tags-result-set and authors-result-set in the same time (If a post is only in categories-and-tags-result-set, it will not be included in the list).', 'otw-portfolio-manager'); ?>
											</p>
											<p class="description">
												<?php _e('OR authors means: WHERE post_id IN categories-and-tags-result-set OR post_id IN authors-result-set. In other words your list will include all posts that are in result-sets categories-and-tags-result-set or authors-result-set.', 'otw-portfolio-manager'); ?>
											</p>
										</td>
									</tr>
								</tbody>
							</table>

						</div>
					</div>
				</li>
				<!-- End Query Selection Tab -->

				<!-- Mosaic Settings Tab -->
				<?php
				$mosaicSettings = 'otw-admin-hidden';
				if( !empty($content['template']) && ( $content['template'] == '1-3-mosaic' || $content['template'] == '1-4-mosaic') ) {
					$mosaicSettings = '';
				}
				?>
				<li class="control-section accordion-section add-page top js-mosaic-settings <?php echo $mosaicSettings;?>">
					<h3 class="accordion-section-title hndl" tabindex="5" title="<?php _e('Mosaic Settings', 'otw-portfolio-manager');?>"><?php _e('Mosaic Settings', 'otw-portfolio-manager');?></h3>
					<div class="accordion-section-content" style="display: none;">
						<div class="inside">
							<table class="form-table">
								<tbody>
									<tr valign="top">
										<th scope="row">
											<label for="portfolio_list_title"><?php _e('Space Tiles:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php
												$yes = ''; $no = ''; 
												($content['space-tiles'])? $yes = 'checked="checked"' : $no = 'checked="checked"'; 
											?>
											<input type="radio" name="space-tiles" id="space-tiles-no" value="0" <?php echo $no;?> /> 
											<label for="space-tiles-no"><?php _e('No', 'otw-portfolio-manager');?></label>

											<input type="radio" name="space-tiles" id="space-tiles-yes" value="1" <?php echo $yes;?> /> 
											<label for="space-tiles-yes"><?php _e('Yes (default)', 'otw-portfolio-manager');?></label>

											<p class="description"><?php _e('Add Space between the Mosaic Tiles. Disabling space tiles works best when you display only images and have the background, border, delimiter set to no.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="show-mosaic-cat-filter-yes"><?php _e('Show Category Filter:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php
												$yes = ''; $no = ''; 
												($content['show-mosaic-cat-filter'])? $yes = 'checked="checked"' : $no = 'checked="checked"'; 
											?>
											<input type="radio" name="show-mosaic-cat-filter" id="show-mosaic-cat-filter-no" value="0" <?php echo $no;?> /> 
											<label for="show-mosaic-cat-filter-no"><?php _e('No', 'otw-portfolio-manager');?></label>

											<input type="radio" name="show-mosaic-cat-filter" id="show-mosaic-cat-filter-yes" value="1" <?php echo $yes;?> /> 
											<label for="show-mosaic-cat-filter-yes"><?php _e('Yes (default)', 'otw-portfolio-manager');?></label>

											<p class="description"><?php _e('Enable the Category filter on top of your list.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>

									<tr valign="top">
										<th scope="row">
											<label for="show-mosaic-sort-filter-yes"><?php _e('Show Sort Filter:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php
												$yes = ''; $no = ''; 
												($content['show-mosaic-sort-filter'])? $yes = 'checked="checked"' : $no = 'checked="checked"'; 
											?>
											<input type="radio" name="show-mosaic-sort-filter" id="show-mosaic-sort-filter-no" value="0" <?php echo $no;?> /> 
											<label for="show-mosaic-sort-filter-no"><?php _e('No', 'otw-portfolio-manager');?></label>

											<input type="radio" name="show-mosaic-sort-filter" id="show-mosaic-sort-filter-yes" value="1" <?php echo $yes;?> /> 
											<label for="show-mosaic-sort-filter-yes"><?php _e('Yes (default)', 'otw-portfolio-manager');?></label>

											<p class="description"><?php _e('Enable the Sort filter on top of your list.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>

								</tbody>
							</table>
						</div> <!-- .inside -->
					</div><!-- .accordion-section-content -->

				</li><!-- .accordion-section -->
				<!-- Mosaic Settings Tab -->

				<!-- Horizontal Tab -->
				<?php
				$horizontalSettings = 'otw-admin-hidden';
				if( !empty($content['template']) && ( $content['template'] == 'horizontal-layout' ) ) {
					$horizontalSettings = '';
				}
				?>
				<li class="control-section accordion-section add-page top js-horizontal-settings <?php echo $horizontalSettings;?>">
					<h3 class="accordion-section-title hndl" tabindex="5" title="<?php _e('Horizontal Layout Settings', 'otw-portfolio-manager');?>">
						<?php _e('Horizontal Layout Settings', 'otw-portfolio-manager');?>
					</h3>
					<div class="accordion-section-content" style="display: none;">
						<div class="inside">
							<table class="form-table">
								<tbody>
									<tr valign="top">
										<th scope="row">
											<label for="horizontal-space-tiles-no"><?php _e('Space Tiles:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php
												$yes = ''; $no = ''; 
												($content['horizontal-space-tiles'])? $yes = 'checked="checked"' : $no = 'checked="checked"'; 
											?>
											<input type="radio" name="horizontal-space-tiles" id="horizontal-space-tiles-no" value="0" <?php echo $no;?> /> 
											<label for="horizontal-space-tiles-no"><?php _e('No', 'otw-portfolio-manager');?></label>

											<input type="radio" name="horizontal-space-tiles" id="horizontal-space-tiles-yes" value="1" <?php echo $yes;?> /> 
											<label for="horizontal-space-tiles-yes"><?php _e('Yes (default)', 'otw-portfolio-manager');?></label>

											<p class="description"><?php _e('Add Space between the Tiles. Disabling space tiles works best when you display only images and have the background, border, delimiter set to no.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr>
										<th scope="row">
											    <label for="horizontal-cell-width-1"><?php _e('Thumbnails widths:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php $cell_count = 10; ?>
											<ul class="otw_thumb_width"> 
											<?php for( $cC = 0; $cC < $cell_count; $cC++ ){ ?>
												<li>
													<label for="horizontal-cell-width-<?php echo $cC?>"><?php _e('Thumb '.( $cC + 1).' width', 'otw-portfolio-manager');?></label>
													<input id="horizontal-cell-width-<?php echo $cC?>" name="horizontal-cell-width-<?php echo $cC?>" type="text" class="otw_cell_size_input" value="<?php echo ( isset( $content['horizontal-cell-width-'.$cC] )?$content['horizontal-cell-width-'.$cC]:'' )?>" maxlength="4" />
												</li>
											<?php }?>
											</ul>
											<p class="description"><?php _e('Set the widths for your thumbs. The first thumb gets Thumb 1 width, the second gets Thumb 2 width, etc. Note that the script might not use the exact same widths you set here since it will try to position the images so they take the full width of the container they are placed in. <br>The thumbnails height is set in the Media tab -> Thumbnail Height.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
								</tbody>
							</table>
						</div> <!-- .inside -->
					</div><!-- .accordion-section-content -->

				</li><!-- .accordion-section -->
				<!-- Horizontal Slider Tab -->
				<!-- Grid Tab -->
				<?php
				$gridSettings = 'otw-admin-hidden';
				if( !empty($content['template']) && in_array( $content['template'], array( '2-column', '3-column', '4-column' ) ) ) {
					$gridSettings = '';
				}
				?>
				<li class="control-section accordion-section add-page top js-grid-settings <?php echo $gridSettings;?>">
					<h3 class="accordion-section-title hndl" tabindex="5" title="<?php _e('Grid Portfolio Templates Settings', 'otw-portfolio-manager');?>">
						<?php _e('Grid Portfolio Templates Settings', 'otw-portfolio-manager');?>
					</h3>
					<div class="accordion-section-content" style="display: none;">
						<div class="inside">
							<table class="form-table">
								<tbody>
									<tr valign="top">
										<th scope="row">
											<label for="grid-space-tiles-no"><?php _e('Space Tiles:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php
												$yes = ''; $no = ''; 
												($content['grid-space-tiles'])? $yes = 'checked="checked"' : $no = 'checked="checked"'; 
											?>
											<input type="radio" name="grid-space-tiles" id="grid-space-tiles-no" value="0" <?php echo $no;?> /> 
											<label for="grid-space-tiles-no"><?php _e('No', 'otw-portfolio-manager');?></label>

											<input type="radio" name="grid-space-tiles" id="grid-space-tiles-yes" value="1" <?php echo $yes;?> /> 
											<label for="grid-space-tiles-yes"><?php _e('Yes (default)', 'otw-portfolio-manager');?></label>

											<p class="description"><?php _e('Add Space between the Tiles. Disabling space tiles works best when you display only images and have the background, border, delimiter set to no.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
								</tbody>
							</table>
						</div> <!-- .inside -->
					</div><!-- .accordion-section-content -->

				</li><!-- .accordion-section -->
				<!--  Grid Portfolio Templates Settings Tab -->

				<!-- Slider Settings Tab -->
				<?php
				$sliderSettings = 'otw-admin-hidden';
	      $sliderArray = array(
	        'slider', '3-column-carousel', '4-column-carousel', '5-column-carousel',
	        '2-column-carousel-wid', '3-column-carousel-wid', '4-column-carousel-wid'
	      );
				if( !empty($content['template']) && in_array( $content['template'], $sliderArray ) ) {
					$sliderSettings = '';
				}
				?>
				<li class="control-section accordion-section  add-page top js-slider-settings <?php echo $sliderSettings; ?>">
					<h3 class="accordion-section-title hndl" tabindex="5" title="<?php _e('Slider and Carousel Settings', 'otw-portfolio-manager');?>">
						<?php _e('Slider and Carousel Settings', 'otw-portfolio-manager');?>
					</h3>
					<div class="accordion-section-content" style="display: none;">
						<div class="inside">
							<table class="form-table">
								<tbody>
									<tr valign="top">
										<th scope="row">
											<label for="slider_title"><?php _e('Enable Title and Excerpt:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php
												$yes = ''; $no = ''; 
												($content['show-slider-title'])? $yes = 'checked="checked"' : $no = 'checked="checked"'; 
											?>
											<input type="radio" name="show-slider-title" id="show-slider-title-no" value="0" <?php echo $no;?> /> 
											<label for="show-slider-title-no"><?php _e('No', 'otw-portfolio-manager');?></label>

											<input type="radio" name="show-slider-title" id="show-slider-title-yes" value="1" <?php echo $yes;?> /> 
											<label for="show-slider-title-yes"><?php _e('Yes (default)', 'otw-portfolio-manager');?></label>

											<p class="description"><?php _e('Displays the post title and excerpt as caption for the slider. Displays only the post title for Carousel Templates. This will not affect the Widget Carousel Templates.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>

									<tr valign="top">
										<th scope="row">
											<label for="slider_title_bg"><?php _e('Enable Title and Excerpt Background:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php
												$yes = ''; $no = ''; 
												($content['slider_title_bg'])? $yes = 'checked="checked"' : $no = 'checked="checked"'; 
											?>
											<input type="radio" name="slider_title_bg" id="slider_title_bg-no" value="0" <?php echo $no;?> /> 
											<label for="slider_title_bg-no"><?php _e('No', 'otw-portfolio-manager');?></label>

											<input type="radio" name="slider_title_bg" id="slider_title_bg-yes" value="1" <?php echo $yes;?> /> 
											<label for="slider_title_bg-yes"><?php _e('Yes (default)', 'otw-portfolio-manager');?></label>
											<p class="description"><?php _e('Enables a background for the title and excerpt. This will not affect the Widget Carousel Templates.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>

									<tr valign="top">
										<th scope="row">
											<label for="carousel-auto-scroll"><?php _e('Enable Auto Scroll:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php
												$yes = ''; $no = ''; 
												($content['slider-auto-scroll'])? $yes = 'checked="checked"' : $no = 'checked="checked"'; 
											?>
											<input type="radio" name="slider-auto-scroll" id="slider-auto-scroll-no" value="0" <?php echo $no;?> /> 
											<label for="slider-auto-scroll-no"><?php _e('No', 'otw-portfolio-manager');?></label>

											<input type="radio" name="slider-auto-scroll" id="slider-auto-scroll-yes" value="1" <?php echo $yes;?> /> 
											<label for="slider-auto-scroll-yes"><?php _e('Yes (default)', 'otw-portfolio-manager');?></label>

											<p class="description"><?php _e('Enables auto scroll.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>

									<tr valign="top">
										<th scope="row">
											<label for="slider_nav"><?php _e('Show Navigation:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php
												$yes = ''; $no = ''; 
												($content['slider_nav'])? $yes = 'checked="checked"' : $no = 'checked="checked"'; 
											?>
											<input type="radio" name="slider_nav" id="slider_nav-no" value="0" <?php echo $no;?> /> 
											<label for="slider_nav-no"><?php _e('No', 'otw-portfolio-manager');?></label>

											<input type="radio" name="slider_nav" id="slider_nav-yes" value="1" <?php echo $yes;?> /> 
											<label for="slider_nav-yes"><?php _e('Yes (default)', 'otw-portfolio-manager');?></label>

											<p class="description"><?php _e('Display arrows and bullet navigation for the slider and carousels. Note that when "Title and Excerpt" is enabled only the arrows navigation will be displayed.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>

									<tr valign="top">
										<th scope="row">
											<label for="slider_border"><?php _e('Show Border:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php
												$yes = ''; $no = ''; 
												($content['slider_border'])? $yes = 'checked="checked"' : $no = 'checked="checked"'; 
											?>
											<input type="radio" name="slider_border" id="slider_border-no" value="0" <?php echo $no;?> /> 
											<label for="slider_border-no"><?php _e('No (default)', 'otw-portfolio-manager');?></label>

											<input type="radio" name="slider_border" id="slider_border-yes" value="1" <?php echo $yes;?> /> 
											<label for="slider_border-yes"><?php _e('Yes', 'otw-portfolio-manager');?></label>

											<p class="description"><?php _e('This will add 1px border to the slider and carousels container. This will not affect the Widget Carousel Templates.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>

									<tr valign="top">
										<th scope="row">
											<label for="slider_title_alignment"><?php _e('Title and Excerpt Alignment:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<select id="slider_title_alignment" name="slider_title_alignment">
											<?php 
											foreach( $selectSliderAlignmentData as $optionData ): 
												$selected = '';
												if( $optionData['value'] === $content['slider_title_alignment'] ) {
													$selected = 'selected="selected"';
												}
												echo "<option value=\"".$optionData['value']."\" ".$selected.">".$optionData['text']."</option>";
												
											endforeach;
											?>
											</select>

											<p class="description"><?php _e('Choose the alignment for the title and excerpt. This will not affect the Widget Carousel Templates.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
								</tbody>
							</table>
						</div> <!-- .inside -->
					</div><!-- .accordion-section-content -->

				</li><!-- .accordion-section -->
				<!-- Slider Settings Tab -->

				<!-- News Settings Tab -->
				<?php
				$newsSettings = 'otw-admin-hidden';
				if( !empty($content['template']) && strpos($content['template'], 'news') ) {
					$newsSettings = '';
				}
				?>
				<li class="control-section accordion-section  add-page top js-news-settings <?php echo $newsSettings; ?>">
					<h3 class="accordion-section-title hndl" tabindex="5" title="<?php _e('Newspaper Settings', 'otw-portfolio-manager');?>"><?php _e('Newspaper Settings', 'otw-portfolio-manager');?></h3>
					<div class="accordion-section-content" style="display: none;">
						<div class="inside">
							<table class="form-table">
								<tbody>
									<tr valign="top">
										<th scope="row">
											<label for="newspaper-space-tiles-no"><?php _e('Space Tiles:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php
												$yes = ''; $no = ''; 
												($content['newspaper-space-tiles'])? $yes = 'checked="checked"' : $no = 'checked="checked"'; 
											?>
											<input type="radio" name="newspaper-space-tiles" id="newspaper-space-tiles-no" value="0" <?php echo $no;?> /> 
											<label for="newspaper-space-tiles-no"><?php _e('No', 'otw-portfolio-manager');?></label>

											<input type="radio" name="newspaper-space-tiles" id="newspaper-space-tiles-yes" value="1" <?php echo $yes;?> /> 
											<label for="newspaper-space-tiles-yes"><?php _e('Yes (default)', 'otw-portfolio-manager');?></label>

											<p class="description"><?php _e('Add Space between the Tiles. Disabling space tiles works best when you display only images and have the background, border, delimiter set to no.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
									<tr valign="top">
										<th scope="row">
											<label for="slider_title"><?php _e('Show Category Filter:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php
												$yes = ''; $no = ''; 
												($content['show-news-cat-filter'])? $yes = 'checked="checked"' : $no = 'checked="checked"'; 
											?>
											<input type="radio" name="show-news-cat-filter" id="show-news-cat-filter-no" value="0" <?php echo $no;?> /> 
											<label for="show-news-cat-filter-no"><?php _e('No', 'otw-portfolio-manager');?></label>

											<input type="radio" name="show-news-cat-filter" id="show-news-cat-filter-yes" value="1" <?php echo $yes;?> /> 
											<label for="show-news-cat-filter-yes"><?php _e('Yes (default)', 'otw-portfolio-manager');?></label>

											<p class="description"><?php _e('Enable the Category filter on top of your list.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>

									<tr valign="top">
										<th scope="row">
											<label for="slider_title"><?php _e('Show Sort Filter:', 'otw-portfolio-manager');?></label>
										</th>
										<td>
											<?php
												$yes = ''; $no = ''; 
												($content['show-news-sort-filter'])? $yes = 'checked="checked"' : $no = 'checked="checked"'; 
											?>
											<input type="radio" name="show-news-sort-filter" id="show-news-sort-filter-no" value="0" <?php echo $no;?> /> 
											<label for="show-news-sort-filter-no"><?php _e('No', 'otw-portfolio-manager');?></label>

											<input type="radio" name="show-news-sort-filter" id="show-news-sort-filter-yes" value="1" <?php echo $yes;?> /> 
											<label for="show-news-sort-filter-yes"><?php _e('Yes (default)', 'otw-portfolio-manager');?></label>

											<p class="description"><?php _e('Enable the Category filter on top of your list.', 'otw-portfolio-manager');?></p>
										</td>
									</tr>
								</tbody>
							</table>
						</div> <!-- .inside -->
					</div><!-- .accordion-section-content -->

				</li><!-- .accordion-section -->
				<!-- END News Settings Tab -->

			</ul><!-- .outer-border -->
			
		</div>

		<p class="submit">
			<input type="submit" value="<?php _e( 'Save', 'otw-portfolio-manager') ?>" name="submit-otw-pm" class="button button-primary button-hero"/>
		</p>

	</form>

<div class="live_preview js-preview"></div>