<?php
class OTW_Portfolio_Template_Shortcode_Portfolio_Item_Tabs extends OTW_Portfolio_Template_Shortcodes{
	
	public function __construct(){
		
		$this->has_options = false;
		
		$this->has_custom_options = false;
		
		$this->has_preview = false;
		
		parent::__construct();
		
		$this->shortcode_name = 'otw_shortcode_portfolio_item_tabs';
	}
	
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array();
	}
	/**
	 * Shortcode icon_link admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$this->apply_settings();
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		return $html;
	}
	
	/** build icon link shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_portfolio_item_tabs]';
		}
		
		return $code;
	}
	
	/**
	 * Process shortcode icon link
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '';
		
		$portfolio_item_id = $this->format_attribute( '', 'portfolio_item_id', $attributes, false, '' );
		
		if( is_admin() ){
			$html = '<img src="'.$this->component_url.'images/sidebars-icon-placeholder.png'.'" alt=""/>';
		}else{
			$html = '';
			
			if( $portfolio_item_id ){
			
				global $otw_porfolio_items_data;
				
				if( is_array( $otw_porfolio_items_data ) && isset( $otw_porfolio_items_data[ $portfolio_item_id ] ) && isset( $otw_porfolio_items_data[ $portfolio_item_id ]['data'] ) ){
					$html .= '<h3 class="otw_portfolio_manager-mb25">';
						if( !empty( $otw_porfolio_items_data[ $portfolio_item_id ]['data']['otw_pm_plugin_options']['otw_pm_moreinfo_title_text'] ) ){
							$html .= $otw_porfolio_items_data[ $portfolio_item_id ]['data']['otw_pm_plugin_options']['otw_pm_moreinfo_title_text'];
						}else{
							$html .= $this->get_label( 'More Project Info' );
						}
					$html .= '</h3>';
					$html .= '<div class="otw_portfolio_manager-tabs">';
						if( isset( $otw_porfolio_items_data[ $portfolio_item_id ]['data']['tabs'] ) && is_array( $otw_porfolio_items_data[ $portfolio_item_id ]['data']['tabs'] ) && count( $otw_porfolio_items_data[ $portfolio_item_id ]['data']['tabs'] ) ){
							$html .= '<ul>';
							foreach( $otw_porfolio_items_data[ $portfolio_item_id ]['data']['tabs'] as $tab_key => $tab_data ){
								$html .= '<li><a href="#tabs-'.$tab_key.'">'.$tab_data['title'].'</a></li>';
							}
							$html .= '</ul>';
							foreach( $otw_porfolio_items_data[ $portfolio_item_id ]['data']['tabs'] as $tab_key => $tab_data ){
								$html .= '<div id="tabs-'.$tab_key.'">';
								$html .= '<p>'.nl2br( do_shortcode( $tab_data['content'] ) ).'</p>';
								$html .= '</div>';
							}
						}
					$html .= '</div>';
				}
			}
		}
		
		return $this->format_shortcode_output( $html );
	}
	
	/**
	 * Return shortcode attributes
	 */
	public function get_shortcode_attributes( $attributes ){
		
		$shortcode_attributes = array();
		
		if( isset( $attributes['item_type'] ) ){
		
			if( isset( $this->settings['item_type_options'][ $attributes['item_type'] ] ) ){
				$shortcode_attributes['iname'] = $this->settings['item_type_options'][ $attributes['item_type'] ];
			}else{
				$shortcode_attributes['iname'] = ucfirst( $attributes['item_type'] );
			}
		}
		
		return $shortcode_attributes;
	}
}
?>