<?php
/**
 * Plugin Name:       Pofily - WooCommerce Product Filters Premium
 * Plugin URI:        https://villatheme.com/extensions/pofily-woocommerce-product-filters/
 * Description:       Pofily - WooCommerce Product Filter is an expert at filtering products. With just a few clicks of the filter, customers can quickly link to desired products.
 * Version:           1.2.7
 * Author:            VillaTheme
 * Author URI:        https://villatheme.com/
 * Text Domain:       pofily-woocommerce-product-filters
 * Domain Path:       /languages
 * Copyright 2021-2025 VillaTheme.com. All rights reserved.
 * Tested up to: 6.8
 * Elementor tested up to: 3.7.3
 * WC tested up to: 10.1.0
 * WC requires at least: 7.0.0
 * Requires PHP: 7.0
 * Requires Plugins: woocommerce
 */


if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * Currently plugin version.
 */
define( 'VIWCPF_VERSION', '1.2.7' );
define( 'VIWCPF_DIR_PATH', plugin_dir_path( __FILE__ ) );
define( 'VIWCPF_DIR_URL', plugin_dir_url( __FILE__ ) );
define( 'VIWCPF_ADMIN_IMG_URL', VIWCPF_DIR_URL . 'admin/images/' );
define( 'VIWCPF_CSS', VIWCPF_DIR_URL . 'assets/css/' );
define( 'VIWCPF_BASE_NAME', plugin_basename( __FILE__ ) );
define( 'VIWCPF_DIR_INCLUDES', VIWCPF_DIR_PATH . "includes" . DIRECTORY_SEPARATOR );
add_action( 'plugins_loaded', function () {
	require_once VIWCPF_DIR_PATH . 'includes/support.php';

	$environment = new VillaTheme_Require_Environment( [
			'plugin_name'     => 'Pofily - WooCommerce Product Filters Premium',
            'php_version'     => '7.0',
            'wp_version'      => '5.0',
            'require_plugins' => [
                [
                    'slug' => 'woocommerce',
                    'name' => 'WooCommerce',
					'defined_version' => 'WC_VERSION',
                    'version' => '7.0',
                ],
            ]
		]
	);
	if ( $environment->has_error() ) {
		return;
	}
	include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

	require_once VIWCPF_DIR_PATH . 'includes/update.php';
	require_once VIWCPF_DIR_PATH . 'includes/check_update.php';
	if ( is_file( VIWCPF_DIR_INCLUDES . '3rd/elementor/elementor.php' ) ) {
		require_once VIWCPF_DIR_INCLUDES . '3rd/elementor/elementor.php';
	}

	/*RUN POFILY*/
	viwcpf_run_woocommerce_product_filters();

	/*Add default data*/
	if ( ! get_option( 'viwcpf_setting_params' ) ) {
		$default_option = new VIWCPF_Woocommerce_Product_Filters_Data();
		$args_option = $default_option->get_default();
		add_option( 'viwcpf_setting_params', $args_option );

	}

	load_plugin_textdomain(
		'pofily-woocommerce-product-filters',
		false,
		dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
	);

	$get_viwcpf_params = new VIWCPF_Woocommerce_Product_Filters_Data();
	$key               = $get_viwcpf_params->get_params( 'key' );

	if ( class_exists( 'VillaTheme_Plugin_Check_Update' ) ) {
		new VillaTheme_Plugin_Check_Update (
			VIWCPF_VERSION,                    // current version
			'https://villatheme.com/wp-json/downloads/v3',  // update path
			'pofily-woocommerce-product-filters/pofily-woocommerce-product-filters.php',                  // plugin file slug
			'pofily-woocommerce-product-filters', '102284', $key
		);
		$setting_url = admin_url( 'admin.php?page=viwcpf-woocommerce-product-filters-settings' );
		new VillaTheme_Plugin_Updater( 'pofily-woocommerce-product-filters/pofily-woocommerce-product-filters.php', 'pofily-woocommerce-product-filters', $setting_url );
	}

	if ( class_exists( 'VillaTheme_Support_Pro' ) ) {
		new VillaTheme_Support_Pro(
			array(
				'support'   => 'pofily-woocommerce-product-filters',
				'docs'      => 'https://docs.villatheme.com/?item=pofily',
				'review'    => 'pofily-woocommerce-product-filters',
				'css'       => VIWCPF_CSS,
				'image'     => '',
				'slug'      => 'pofily-woocommerce-product-filters',
				'menu_slug' => 'viwcpf-woocommerce-product-filters',
				'version'   => VIWCPF_VERSION
			)
		);
	}

} );






/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */


require VIWCPF_DIR_PATH . 'includes/class-woocommerce-product-filters.php';
if ( is_file( VIWCPF_DIR_INCLUDES . '3rd/multi-currency.php' ) ) {
	require_once VIWCPF_DIR_INCLUDES . '3rd/multi-currency.php';
}

//compatible with 'High-Performance order storage (COT)
add_action( 'before_woocommerce_init', function () {
	if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'cart_checkout_blocks', __FILE__, true );
	}
} );
/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function viwcpf_run_woocommerce_product_filters() {

	$plugin = new VIWCPF_Woocommerce_Product_Filters();
	$plugin->run();


}


