<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class VIWCPF_Elementor_Reviews_Widget extends Elementor\Widget_Base {

	public static $slug = 'viwcpf-elementor-reviews-widget';

	public function get_name() {
		return 'pofily-woocommerce-product-filters';
	}

	public function get_title() {
		return esc_html__( 'VIWCPF Filter Menu (Villatheme)', 'pofily-woocommerce-product-filters' );
	}

	public function get_icon() {
		return 'eicon-filter';
	}

	public function get_categories() {
		return [ 'woocommerce-elements' ];
	}


	protected function render() {
		$settings  = $this->get_settings_for_display();
		$shortcode = $this->viwcpf_get_shortcode( $settings );
		$shortcode = do_shortcode( shortcode_unautop( $shortcode ) );
		echo $shortcode;// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}

	public function render_plain_content() {
		$settings  = $this->get_settings_for_display();
		$shortcode = $this->viwcpf_get_shortcode( $settings );
		echo $shortcode;// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}

	private function viwcpf_get_shortcode( $settings ) {

		$menu_display   = $settings['menu_display'] ?? '0';
		$column_display = $settings['column_display'] ?? '1';

		$shortcode = "[VIWCPF_SHORTCODE id_menu='{$menu_display}' column='{$column_display}']";

		return $shortcode;
	}
}


class VIWCPF_Compa_New_Elementer extends VIWCPF_Elementor_Reviews_Widget {
	protected function register_controls() {
		$option_menu_filter    = [];
		$option_menu_filter[0] = esc_html__( 'Choose menu filters', 'pofily-woocommerce-product-filters' );
		$args_menu             = array(
			'post_type'      => 'viwcpf_filter_menu',
			'post_status'    => 'publish',
			'posts_per_page' => - 1,
		);
		$filters_menu_query    = new WP_Query( $args_menu );

		if ( $filters_menu_query->have_posts() ):
			// The Loop
			while ( $filters_menu_query->have_posts() ) : $filters_menu_query->the_post();
				$option_menu_filter[ get_the_ID() ] = esc_html( get_the_title() );
			endwhile;
		endif;
		// Reset Post Data
		wp_reset_postdata();
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'pofily-woocommerce-product-filters' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'menu_display',
			[
				'label'       => esc_html__( 'Select menu', 'pofily-woocommerce-product-filters' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'default'     => '0',
				'options'     => $option_menu_filter,
				'label_block' => true
			]
		);
		$this->add_control(
			'column_display',
			[
				'label'       => esc_html__( 'Select column', 'pofily-woocommerce-product-filters' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'default'     => '0',
				'options'     => [ '--None--', 1, 2, 3, 4, 5 ],
				'label_block' => true
			]
		);


		$this->end_controls_section();

	}

}

class VIWCPF_Compa_Old_Elementer extends VIWCPF_Elementor_Reviews_Widget {
	protected function _register_controls() {
		$option_menu_filter    = [];
		$option_menu_filter[0] = esc_html__( 'Choose menu filters', 'pofily-woocommerce-product-filters' );
		$args_menu             = array(
			'post_type'      => 'viwcpf_filter_menu',
			'post_status'    => 'publish',
			'posts_per_page' => - 1,
		);
		$filters_menu_query    = new WP_Query( $args_menu );

		if ( $filters_menu_query->have_posts() ):
			// The Loop
			while ( $filters_menu_query->have_posts() ) : $filters_menu_query->the_post();
				$option_menu_filter[ get_the_ID() ] = esc_html( get_the_title() );
			endwhile;
		endif;
		// Reset Post Data
		wp_reset_postdata();
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'pofily-woocommerce-product-filters' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'menu_display',
			[
				'label'       => esc_html__( 'Select menu', 'pofily-woocommerce-product-filters' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'default'     => '0',
				'options'     => $option_menu_filter,
				'label_block' => true
			]
		);

		$this->add_control(
			'column_display',
			[
				'label'       => esc_html__( 'Select column', 'pofily-woocommerce-product-filters' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'default'     => '0',
				'options'     => [ '--None--', 1, 2, 3, 4, 5 ],
				'label_block' => true
			]
		);
		$this->end_controls_section();

	}

}