<?php
/* The file has a Filter Menu Detail page template
 *
 * @package    VIWCPF_Woocommerce_Product_Filters
 * @subpackage VIWCPF_Woocommerce_Product_Filters/admin/partials
 * */

wp_nonce_field( 'viwcpf_save_filter_menu', '_viwcpf_filter_menu_nonce' );
$viwcpf_filter_menu = get_post_meta( $post->ID, 'viwcpf_filter_menu', true );


if (
	$post->post_status != 'auto-draft'
) {
	$viwcpf_blocks_selected    = $viwcpf_filter_menu['viwcpf_blocks_selected'];
	$viwcpf_using_ajax         = $viwcpf_filter_menu['viwcpf_using_ajax'];
	$viwcpf_show_button_submit = $viwcpf_filter_menu['viwcpf_show_button_submit'];
	$viwcpf_block_relation     = $viwcpf_filter_menu['viwcpf_block_relation'];
	$viwcpf_show_in_modal      = $viwcpf_filter_menu['viwcpf_show_in_modal'];
	$viwcpf_display_conditions = $viwcpf_filter_menu['viwcpf_display_conditions'];

	if ( $viwcpf_blocks_selected != '' ) {
		$arr_blocks_selected = explode( ",", $viwcpf_blocks_selected );
	} else {
		$arr_blocks_selected = array( '' );
	}
} else {
	$arr_blocks_selected       = array( '' );
	$viwcpf_blocks_selected    = '';
	$viwcpf_using_ajax         = true;
	$viwcpf_block_relation     = 'AND';
	$viwcpf_show_button_submit = false;
	$viwcpf_show_in_modal      = true;
	$viwcpf_display_conditions = array();

}
?>
<div class="vi-ui grid segment detail_wrap_setting">
    <!--Filter Name-->
    <div class="vi-ui row two no-wrap">
        <div class="column three wide column_label">
            <label class="label-setting"><?php esc_html_e( 'Choose Filter Block:', 'pofily-woocommerce-product-filters' ) ?></label>
        </div>
        <div class="column twelve wide">
            <div id="wrap_choose_block_menu" class="wrap_choose_block_menu">
                <div class="wrap_choose_block_menu_column">
                    <div id="dragable_block_select" class="vi-ui ">
						<?php
						$args_block1           = array(
							'post_type'      => 'viwcpf_filter_block',
							'post_status'    => 'publish',
							'post__not_in'   => $arr_blocks_selected,//phpcs:ignore WordPressVIPMinimum.Performance.WPQueryParams.PostNotIn_post__not_in
							'posts_per_page' => - 1,
						);
						$filters_blocks_query1 = new WP_Query( $args_block1 );

						if ( $filters_blocks_query1->have_posts() ):
							// The Loop
							while ( $filters_blocks_query1->have_posts() ) : $filters_blocks_query1->the_post();
								?>
                                <div class="vi-ui segment item_block add_block"
                                     data-block_id="<?php echo esc_attr( get_the_ID() ); ?>"
                                     data-block_name="<?php echo esc_attr( get_the_title() ); ?>"
                                     data-block_url="<?php echo esc_url_raw( get_edit_post_link() ); ?>">
                                    <h4><?php echo esc_html( get_the_title() ); ?></h4>
                                    <div class="wrapp_btn">
                                        <a href="<?php echo esc_url_raw( get_edit_post_link() ); ?>"
                                           class="vi-ui edit_block icon blue button mini compact"> <i
                                                    class="edit icon"></i></a>
                                    </div>
                                </div>
							<?php
							endwhile;
						endif;
						// Reset Post Data
						wp_reset_postdata();
						?>
                    </div>
                </div>
                <i class="vi-ui icon big angle double right viwcpf_arrow_detail_menu"></i>
                <div class="wrap_choose_block_menu_column">
                    <div id="sortable_block_selected" class="vi-ui">
						<?php
						$args_block           = array(
							'post_type'      => 'viwcpf_filter_block',
							'post_status'    => 'publish',
							'post__in'       => $arr_blocks_selected,
							'orderby'        => 'post__in',
							'posts_per_page' => - 1,
						);
						$filters_blocks_query = new WP_Query( $args_block );

						if ( $filters_blocks_query->have_posts() ):
							// The Loop
							while ( $filters_blocks_query->have_posts() ) : $filters_blocks_query->the_post();
								?>
                                <div class="vi-ui segment item_block block_selected"
                                     data-block_id="<?php echo esc_attr( get_the_ID() ); ?>"
                                     data-block_name="<?php echo esc_attr( get_the_title() ); ?>"
                                     data-block_url="<?php echo esc_url_raw( get_edit_post_link() ); ?>">
                                    <h4><?php echo esc_html( get_the_title() ); ?></h4>
                                    <div class="wrapp_btn">
                                        <a href="<?php echo esc_url_raw( get_edit_post_link() ); ?>"
                                           class="vi-ui edit_block icon blue button mini compact"> <i
                                                    class="edit icon"></i></a>
                                        <a href="#" class="vi-ui del_block icon red button mini compact"> <i
                                                    class="minus icon"></i></a>
                                    </div>
                                </div>
							<?php
							endwhile;
						endif;
						// Reset Post Data
						wp_reset_postdata();
						?>
                    </div>
                    <input type="hidden" name="viwcpf_blocks_selected" id="viwcpf_blocks_selected"
                           value="<?php echo esc_html( $viwcpf_blocks_selected ); ?>">
                </div>
            </div>
            <span class="explanatory-text"><?php esc_html_e( 'Choose block filter you want display', 'pofily-woocommerce-product-filters' ) ?></span>
            <a href="#" class="vi-ui refresh_blocks_filter icon green button mini compact">
                <i class="redo icon"></i>
				<?php esc_html_e( 'Refresh', 'pofily-woocommerce-product-filters' ) ?>
            </a>
            <a href="<?php echo esc_url( admin_url( 'post-new.php?post_type=viwcpf_filter_block' ) ); ?>"
               target="_blank" class="vi-ui create_blocks_filter icon green button mini compact">
                <i class="plus icon"></i><?php esc_html_e( 'Create block filter', 'pofily-woocommerce-product-filters' ) ?>
            </a>

        </div>

    </div>

    <!--General Setting-->

    <!--Filter by submit button-->
    <div class="vi-ui row two no-wrap item_row">
        <div class="column eight wide">
            <div class="vi-ui two column grid no-wrap">
                <div class="column seven wide column_label">
                    <label class="label-setting"
                           for="viwcpf-show_button_submit"><?php esc_html_e( 'Using button to filter:', 'pofily-woocommerce-product-filters' ) ?></label>
                </div>
                <div class="column nine wide column_field">
                    <div class="vi-ui toggle checkbox">
                        <input type="checkbox" name="viwcpf-show_button_submit"
                               id="viwcpf-show_button_submit" <?php if ( $viwcpf_show_button_submit ) {
							echo esc_attr( 'checked' );
						} ?>>
                        <label></label>
                    </div>
                    <span class="explanatory-text"><?php esc_html_e( 'Choose show a button "Apply Filter" to apply all filters', 'pofily-woocommerce-product-filters' ); ?></span>
                </div>
            </div>
        </div>
        <div class="column eight wide">
            <div class="vi-ui two column grid no-wrap">
				<?php
				$modal_enabled = isset( get_option( 'viwcpf_setting_params' )['modal']['enabled'] ) ? true : false;
				if ( $modal_enabled ):
					?>

                    <div class="column seven wide column_label">
                        <label class="label-setting"><?php esc_html_e( 'Show menu in modal:', 'pofily-woocommerce-product-filters' ) ?></label>
                    </div>
                    <div class="column nine wide column_field">
                        <div class="vi-ui toggle checkbox ">
                            <input type="checkbox" name="viwcpf-show_in_modal"
                                   id="viwcpf-show_in_modal" <?php if ( $viwcpf_show_in_modal ) {
								echo esc_attr( 'checked' );
							} ?> >
                            <label></label>
                        </div>
                        <span class="explanatory-text"><?php esc_html_e( 'Enable to show the menu filter in content modal', 'pofily-woocommerce-product-filters' ) ?></span>
                    </div>

				<?php
				endif;
				?>
            </div>
        </div>

    </div>

    <div class="vi-ui row two no-wrap item_row">
        <div class="column three wide column_label">
            <label class="label-setting"
                   for=""><?php esc_html_e( 'Display Conditions:', 'pofily-woocommerce-product-filters' ) ?></label>
        </div>
        <div class="column twelve wide column_field">
            <div class="conditions_wrap" id="conditions_list">
				<?php
				if ( sizeof( $viwcpf_display_conditions ) > 0 ) {
					$count_condition = 0;
					foreach ( $viwcpf_display_conditions as $condition_item ) {

						?>
                        <div class="vi-ui field condition_item">
                            <div class="item_column type">
                                <select class="vi-ui dropdown fluid viwcpf_filter_block_select viwcpf-display_conditions_type"
                                        name="viwcpf-display_conditions[<?php echo esc_attr( $count_condition ); ?>][type]">
                                    <option value="<?php echo esc_attr( 'include' ) ?>"
										<?php
										if ( $condition_item['type'] == 'include' ) {
											echo esc_attr( 'selected' );
										}
										?>
                                    >
										<?php esc_html_e( 'INCLUDE', 'pofily-woocommerce-product-filters' ) ?>
                                    </option>
                                    <option value="<?php echo esc_attr( 'exclude' ) ?>"
										<?php
										if ( $condition_item['type'] == 'exclude' ) {
											echo esc_attr( 'selected' );
										}
										?>
                                    >
										<?php esc_html_e( 'EXCLUDE', 'pofily-woocommerce-product-filters' ) ?>
                                    </option>
                                </select>
                            </div>
                            <div class="item_column archive">
                                <select class="vi-ui dropdown fluid viwcpf_filter_block_select viwcpf-display_conditions_archive"
                                        name="viwcpf-display_conditions[<?php echo esc_attr( $count_condition ); ?>][archive]">
                                    <option value="<?php echo esc_attr( 'all' ) ?>"
										<?php
										if ( $condition_item['archive'] == 'all' ) {
											echo esc_attr( 'selected' );
										}
										?>
                                    >
										<?php esc_html_e( 'All Product Archives', 'pofily-woocommerce-product-filters' ) ?>
                                    </option>
                                    <option value="<?php echo esc_attr( 'product_search' ) ?>"
										<?php
										if ( $condition_item['archive'] == 'product_search' ) {
											echo esc_attr( 'selected' );
										}
										?>
                                    >
										<?php esc_html_e( 'Search results', 'pofily-woocommerce-product-filters' ) ?>
                                    </option>
                                    <option value="<?php echo esc_attr( 'shop_page' ) ?>"
										<?php
										if ( $condition_item['archive'] == 'shop_page' ) {
											echo esc_attr( 'selected' );
										}
										?>
                                    >
										<?php esc_html_e( 'Shop Page', 'pofily-woocommerce-product-filters' ) ?>
                                    </option>
                                    <option value="<?php echo esc_attr( 'product_cat' ) ?>"
										<?php
										if ( $condition_item['archive'] == 'product_cat' ) {
											echo esc_attr( 'selected' );
										}
										?>
                                    >
										<?php esc_html_e( 'Product Categories', 'pofily-woocommerce-product-filters' ) ?>
                                    </option>
                                    <option value="<?php echo esc_attr( 'product_tag' ) ?>"
										<?php
										if ( $condition_item['archive'] == 'product_tag' ) {
											echo esc_attr( 'selected' );
										}
										?>
                                    >
										<?php esc_html_e( 'Product Tags', 'pofily-woocommerce-product-filters' ); ?>
                                    </option>
                                </select>
                            </div>
                            <div class="item_column option_archive_id hidden" data-type_show="product_cat,product_tag">

                                <select class="viwcpf-display_conditions_archive_id"
                                        name="viwcpf-display_conditions[<?php echo esc_attr( $count_condition ); ?>][archive_id][]"
                                        multiple="multiple">
									<?php
									if (
										isset( $condition_item['archive_id'] ) &&
										is_array( $condition_item['archive_id'] ) &&
										! empty( $condition_item['archive_id'] )
									) {
										foreach ( $condition_item['archive_id'] as $archive_id ) {
											$condition_term = get_term_by( 'id', $archive_id, $condition_item['archive'], OBJECT );
											if ( is_object( $condition_term ) && ! empty( $condition_term ) ) {
												?>
                                                <option value="<?php echo esc_attr( $condition_term->term_id ); ?>"
                                                        selected>
													<?php echo esc_html( $condition_term->name ); ?>
                                                </option>
												<?php
											}

										}
									}
									?>

                                </select>
                            </div>
                            <div class="item_column action_btn">
                                <div class="wrap_add_del_btn">
                                    <a href="#" class="vi-ui add_row_condition icon green button mini compact"> <i
                                                class="plus icon"></i></a>
                                    <a href="#" class="vi-ui del_row_condition icon red button mini compact"> <i
                                                class="minus icon"></i></a>
                                </div>
                            </div>
                        </div>
						<?php
						$count_condition ++;
					}
				} else {
					?>
                    <div class="vi-ui field condition_item">
                        <div class="item_column type">
                            <select class="vi-ui dropdown fluid viwcpf_filter_block_select viwcpf-display_conditions_type"
                                    name="viwcpf-display_conditions[0][type]">
                                <option value="<?php echo esc_attr( 'include' ) ?>">
									<?php esc_html_e( 'INCLUDE', 'pofily-woocommerce-product-filters' ); ?>
                                </option>
                                <option value="<?php echo esc_attr( 'exclude' ) ?>">
									<?php esc_html_e( 'EXCLUDE', 'pofily-woocommerce-product-filters' ); ?>
                                </option>
                            </select>
                        </div>
                        <div class="item_column archive">
                            <select class="vi-ui dropdown fluid viwcpf_filter_block_select viwcpf-display_conditions_archive"
                                    name="viwcpf-display_conditions[0][archive]">
                                <option value="<?php echo esc_attr( 'all' ); ?>">
									<?php echo esc_html_e( 'All Product Archives', 'pofily-woocommerce-product-filters' ); ?>
                                </option>
                                <option value="<?php echo esc_attr( 'product_search' ) ?>">
									<?php esc_html_e( 'Search results', 'pofily-woocommerce-product-filters' ); ?>
                                </option>
                                <option value="<?php echo esc_attr( 'shop_page' ) ?>">
									<?php esc_html_e( 'Shop Page', 'pofily-woocommerce-product-filters' ); ?>
                                </option>
                                <option value="<?php echo esc_attr( 'product_cat' ) ?>">
									<?php esc_html_e( 'Product Categories', 'pofily-woocommerce-product-filters' ) ?>
                                </option>
                                <option value="<?php echo esc_attr( 'product_tag' ) ?>">
									<?php esc_html_e( 'Product Tags', 'pofily-woocommerce-product-filters' ) ?>
                                </option>
                            </select>
                        </div>
                        <div class="item_column option_archive_id hidden" data-type_show="product_cat,product_tag">
                            <select class="viwcpf-display_conditions_archive_id"
                                    name="viwcpf-display_conditions[0][archive_id][]" multiple="multiple"></select>
                        </div>
                        <div class="item_column action_btn">
                            <div class="wrap_add_del_btn">
                                <a href="#" class="vi-ui add_row_condition icon green button mini compact"> <i
                                            class="plus icon"></i></a>
                                <a href="#" class="vi-ui del_row_condition icon red button mini compact"> <i
                                            class="minus icon"></i></a>
                            </div>
                        </div>
                    </div>
					<?php

				}
				?>

            </div>
            <span class="explanatory-text"><?php esc_html_e( 'Add rule display conditions you want', 'pofily-woocommerce-product-filters' ) ?></span>
        </div>
    </div>
</div>
