<?php
/* The file has a Filter Block Detail page template
 *
 * @package    VIWCPF_Woocommerce_Product_Filters
 * @subpackage VIWCPF_Woocommerce_Product_Filters/admin/partials
 * */

wp_nonce_field('viwcpf_save_filter_block', '_viwcpf_filter_block_nonce');
$viwcpf_filter_block   = get_post_meta($post->ID, 'viwcpf_filter_block', true);
$viwcpf_setting_params = get_option('viwcpf_setting_params');


?>
<div class="vi-ui grid segment detail_wrap_setting">
    <div class="vi-ui row two no-wrap">
        <!--Filter Name-->
        <div class="column eight wide">
            <div class="vi-ui field">
                <div class="vi-ui labeled input fluid">
                    <div class="vi-ui label label-setting"><?php esc_html_e('Filter Name*:', 'pofily-woocommerce-product-filters') ?></div>
                    <input type="text" name="filter_block_name" id="filter_block_name"
                           placeholder="<?php esc_attr_e('Name of filter', 'pofily-woocommerce-product-filters') ?>"
                           value="<?php echo esc_html(isset($viwcpf_filter_block['name']) ? $viwcpf_filter_block['name'] : '') ?>"
                           required>
                </div>
            </div>
            <span class="explanatory-text"><?php esc_html_e('Name of filter', 'pofily-woocommerce-product-filters'); ?></span>
        </div>
        <!--Filter For-->
        <div class="column eight wide">
            <div class="vi-ui left labeled dropdown button fluid">
                <div class="vi-ui label label-setting"><?php esc_html_e('Filter For:', 'pofily-woocommerce-product-filters') ?></div>

                <select name="viwcpf_filter_for" id="viwcpf_filter_for" class="fluid viwcpf_filter_block_select viwcpf_filter_for">
                    <option value="filter_by_taxonomy" <?php if (!empty($viwcpf_filter_block['filter_for']) && $viwcpf_filter_block['filter_for'] == 'filter_by_taxonomy') {
						echo esc_attr('selected');
					} ?>>
						<?php esc_html_e('Filter By Taxonomy', 'pofily-woocommerce-product-filters') ?>
                    </option>
                    <option value="filter_by_price" <?php if (!empty($viwcpf_filter_block['filter_for']) && $viwcpf_filter_block['filter_for'] == 'filter_by_price') {
						echo esc_attr('selected');
					} ?>>
						<?php esc_html_e('Filter By Price', 'pofily-woocommerce-product-filters') ?>
                    </option>
                    <option value="filter_by_review" <?php if (!empty($viwcpf_filter_block['filter_for']) && $viwcpf_filter_block['filter_for'] == 'filter_by_review') {
						echo esc_attr('selected');
					} ?>>
						<?php esc_html_e('Filter By Review', 'pofily-woocommerce-product-filters') ?>
                    </option>
                    <option value="filter_by_sale_or_stock" <?php if (!empty($viwcpf_filter_block['filter_for']) && $viwcpf_filter_block['filter_for'] == 'filter_by_sale_or_stock') {
						echo esc_attr('selected');
					} ?>>
						<?php esc_html_e('Filter By OnSale/InStock', 'pofily-woocommerce-product-filters') ?>
                    </option>
                    <option value="filter_by_name_product" <?php if (!empty($viwcpf_filter_block['filter_for']) && $viwcpf_filter_block['filter_for'] == 'filter_by_name_product') {
						echo esc_attr('selected');
					} ?>>
						<?php esc_html_e('Filter By Name', 'pofily-woocommerce-product-filters') ?>
                    </option>
                    <option value="filter_by_metabox" <?php if (!empty($viwcpf_filter_block['filter_for']) && $viwcpf_filter_block['filter_for'] == 'filter_by_metabox') {
						echo esc_attr('selected');
					} ?>>
						<?php esc_html_e('Filter By Metabox', 'pofily-woocommerce-product-filters') ?>
                    </option>
                </select>
            </div>
            <span class="explanatory-text"><?php esc_html_e('Choose filter for', 'pofily-woocommerce-product-filters'); ?></span>

        </div>

    </div>
    <!--Filter By Item - Filter by Taxonomy-->
    <div class="vi-ui grid filter_by_item active" data-type="filter_by_taxonomy">
		<?php
		if (!empty($viwcpf_filter_block['filter_for']) && $viwcpf_filter_block['filter_for'] == 'filter_by_taxonomy') {
			$filter_data          = $viwcpf_filter_block['filter_data'];
			$tax_name             = $filter_data['tax_name'];
			$arr_term_id          = isset($filter_data['list_terms']) ? $filter_data['list_terms'] : array();
			$customize_terms_data = isset($filter_data['customize_value']) ? $filter_data['customize_value'] : array();
			$tax_type_show        = $filter_data['type_show'];
			if (!empty($arr_term_id)) {
				$arr_term_data = get_terms(
					array(
						'taxonomy' => $tax_name,
						'orderby'  => 'menu_order',
						'order'    => 'ASC',
						'include'  => $arr_term_id
					)
				);
			} else {
				$arr_term_data = array();
			}

			$tax_multiselect       = $filter_data['multiselect'];
			$tax_multi_relation    = $filter_data['multi_relation'];
			$tax_show_count_item   = $filter_data['show_count_item'];
			$tax_show_search_field = $filter_data['show_search_field'];
			$tax_btn_style         = $filter_data['btn_style'];
			$tax_order_by          = $filter_data['order_by'];
			$tax_order_type        = $filter_data['order_type'];
		} else {
			$tax_name              = '';
			$arr_term_data         = array();
			$arr_term_id           = array();
			$customize_terms_data  = array();
			$tax_type_show         = '';
			$tax_multiselect       = false;
			$tax_multi_relation    = 'AND';
			$tax_show_count_item   = false;
			$tax_show_search_field = false;
			$tax_btn_style         = array();
			$tax_order_by          = 'menu_order';
			$tax_order_type        = 'asc';
		}
		if (get_option('viwcpf_setting_params')) {
			$default_data_color_swatches  = get_option('viwcpf_setting_params')['color_swatches'];
			$default_btn_style            = $default_data_color_swatches['btn_style'];
			$default_btn_color_default    = $default_data_color_swatches['color_default'];
			$default_btn_style_width      = $default_btn_style['btn_width'];
			$default_btn_style_height     = $default_btn_style['btn_height'];
			$default_btn_border_radius    = $default_btn_style['btn_border_radius'];
			$default_btn_color_separator  = $default_btn_style['btn_color_separator'];
			$default_btn_image_show_title = isset($default_btn_style['btn_image_show_title']) ? $default_btn_style['btn_image_show_title'] : 0;
		} else {
			$default_btn_style_width      = '';
			$default_btn_style_height     = '';
			$default_btn_border_radius    = '';
			$default_btn_color_separator  = '';
			$default_btn_color_default    = '';
			$default_btn_image_show_title = 0;
		}
		?>
        <div class="vi-ui row two no-wrap item_row">
            <div class="column three wide column_label">
                <label class="label-setting"
                       for="viwcpf_filter_tax"><?php esc_html_e('Choose taxonomy:', 'pofily-woocommerce-product-filters') ?></label>
            </div>
            <div class="column fourteen wide column_field">
				<?php
				//get all taxonomies of post type product
				$product_taxonomies = get_object_taxonomies(array('post_type' => 'product'), 'objects');
				//exclude special some taxonomy
				$exclude           = array('product_type', 'product_visibility', 'product_shipping_class');
				$array_product_tax = array();

				$VIWCPF_Woocommerce_Product_Filters_Data = new VIWCPF_Woocommerce_Product_Filters_Data();

				foreach ($product_taxonomies as $key => $value):
					if (in_array($key, $exclude)) {
						continue;
					}
					$tax_label = $value->labels->name;
					/*Check if woo default brand is enable*/
					if ($VIWCPF_Woocommerce_Product_Filters_Data->viwcpf_check_woo_brand_is_enabled($key)) {
						$tax_label .= ' (default by WooCommerce)';
					}
					$array_product_tax[$key] = array(
						'label' => $tax_label,
						'total' => wp_count_terms(
							array(
								'taxonomy'   => $key,
								'hide_empty' => true,
							)
						),
					);

				endforeach;
				?>
                <select name="viwcpf_filter_tax" id="viwcpf_filter_tax"
                        class="vi-ui dropdown fluid viwcpf_filter_block_select"
                        data-counts='<?php echo wp_kses_post(htmlspecialchars(wp_json_encode($array_product_tax), ENT_QUOTES, 'UTF-8')); ?>'>
					<?php
					foreach ($array_product_tax as $key => $value):
						if ($tax_name == $key) {
							$selected = 'selected';
						} else {
							$selected = '';
						}
						echo '<option value="' . esc_attr($key) . '" ' . esc_attr($selected) . '>' . esc_html($value['label']) . '</option>';
					endforeach;
					?>
                </select>
				<?php
				if (is_a($arr_term_data, 'WP_Error')) {
					?>
                    <div class="vi-ui message large warning"><?php echo wp_kses_post("You have unregistered Taxonomy (\"{$tax_name}\") saved on this page, please select another Taxonomy to start over or keep this page until you reactivate taxonomy registration to avoid losing your settings data.") ?></div>
					<?php
				}
                /*Note for Brand default by WooCommerce*/
                if ($tax_name =='product_brand') {
					?>
                    <div class="vi-ui message large warning"><?php echo wp_kses_post("Using this filter, when you apply a brand filter on the Brand page, you will be redirected to the corresponding brand page. <br><strong>For example:</strong> if you are on `yourdomain/brand/brand-a/` and you select Brand B or Brand C, you will be redirected to `yourdomain/brand/brand-b/` or `yourdomain/brand/brand-c/`, respectively..") ?></div>
					<?php
				}
				?>
            </div>
        </div>
        <div class="vi-ui row two no-wrap item_row">
            <div class="column three wide column_label">
                <label class="label-setting"
                       for="viwcpf_input_search_term"><?php esc_html_e('Choose term:', 'pofily-woocommerce-product-filters') ?></label>
            </div>
            <div class="column fourteen wide column_field">
                <select class="viwcpf_input_search_term" id="viwcpf_input_search_term"
                        name="viwcpf_input_search_term[]"
                        multiple="multiple">
					<?php
					if (!is_a($arr_term_data, 'WP_Error')) {
						foreach ($arr_term_data as $term_item) {
							echo '<option value="' . esc_html($term_item->term_id) . '"  selected>' . esc_html($term_item->name) . '</option>';
						}
					}
					?>
                </select>
                <button class="vi-ui green button mini"
                        id="tax-select_all"><?php esc_html_e('Add all', 'pofily-woocommerce-product-filters') ?></button>
                <button class="vi-ui red button mini"
                        id="tax-remove_all"><?php esc_html_e('Remove all', 'pofily-woocommerce-product-filters') ?></button>
            </div>
        </div>
        <div class="vi-ui row two no-wrap item_row">
            <div class="column three wide column_label">
                <label class="label-setting"
                       for="tax-type_show"><?php esc_html_e('Show type:', 'pofily-woocommerce-product-filters') ?></label>
            </div>
            <div class="column fourteen wide column_field">
                <select name="viwcpf_tax-type_show" id="tax-type_show"
                        class="vi-ui dropdown fluid viwcpf_filter_block_select">
                    <option value="none" <?php selected($tax_type_show, 'none'); ?> >
						<?php esc_html_e('None', 'woo-product-filters') ?>
                    </option>
                    <option value="button" <?php selected($tax_type_show, 'button'); ?> >
						<?php esc_html_e('Button', 'pofily-woocommerce-product-filters') ?>
                    </option>
                    <option value="checkbox" <?php selected($tax_type_show, 'checkbox'); ?> >
						<?php esc_html_e('Checkbox', 'pofily-woocommerce-product-filters') ?>
                    </option>
                    <option value="select" <?php selected($tax_type_show, 'select'); ?> >
						<?php esc_html_e('Select', 'pofily-woocommerce-product-filters') ?>
                    </option>
                    <option value="color_swatches" <?php selected($tax_type_show, 'color_swatches'); ?> >
						<?php esc_html_e('Color Swatches', 'pofily-woocommerce-product-filters') ?>
                    </option>
                    <option value="images" <?php selected($tax_type_show, 'images'); ?> >
						<?php esc_html_e('Images', 'pofily-woocommerce-product-filters') ?>
                    </option>
                </select>
            </div>
        </div>
        <div class="vi-ui row two no-wrap item_row option_select hidden " data-select="viwcpf_tax-type_show"
             data-type_show="color_swatches,images">
            <div class="column three wide column_label">
                <label class="label-setting"
                       for="tax-filter_type"><?php esc_html_e('Button template:', 'pofily-woocommerce-product-filters') ?></label>
            </div>
            <div class="column fourteen wide column_field">
                <div class="tax-wrap_button_template">
                    <div class="item_style">
                        <label class="label-setting"
                               for="tax-btn_width"><?php esc_html_e('Width:', 'pofily-woocommerce-product-filters') ?></label>
                        <div class="vi-ui right labeled input">
                            <input type="number"
                                   name="tax-btn_width"
                                   id="tax-btn_width"
                                   placeholder="<?php esc_attr_e('Enter width', 'pofily-woocommerce-product-filters') ?>"
                                   value="<?php echo esc_attr(isset($tax_btn_style['btn_width']) ? $tax_btn_style['btn_width'] : $default_btn_style_width); ?>"
                                   min="0"
                            >
                            <div class="vi-ui basic label"><?php esc_html_e('px', 'pofily-woocommerce-product-filters') ?></div>
                        </div>
                    </div>
                    <div class="item_style">
                        <label class="label-setting"
                               for="tax-btn_height"
                        >
							<?php esc_html_e('Height:', 'pofily-woocommerce-product-filters') ?>
                        </label>
                        <div class="vi-ui right labeled input">
                            <input type="number"
                                   name="tax-btn_height"
                                   id="tax-btn_height"
                                   placeholder="<?php esc_attr_e('Enter height', 'pofily-woocommerce-product-filters') ?>"
                                   min="0"
                                   value="<?php echo esc_attr(isset($tax_btn_style['btn_height']) ? $tax_btn_style['btn_height'] : $default_btn_style_height); ?>"
                            >
                            <div class="vi-ui basic label"><?php esc_html_e('px', 'pofily-woocommerce-product-filters') ?></div>
                        </div>
                    </div>
                    <div class="item_style">
                        <label class="label-setting"
                               for="tax-btn_border_radius"
                        >
							<?php esc_html_e('Border radius:', 'pofily-woocommerce-product-filters') ?>
                        </label>
                        <div class="vi-ui right input">
                            <input type="text"
                                   name="tax-btn_border_radius"
                                   id="tax-btn_border_radius"
                                   placeholder="<?php esc_attr_e('Example: 10px or 10%', 'pofily-woocommerce-product-filters') ?>"
                                   min="0"
                                   value="<?php echo esc_attr(isset($tax_btn_style['btn_border_radius']) ? $tax_btn_style['btn_border_radius'] : $default_btn_border_radius); ?>"
                            >
                        </div>
                    </div>
                    <div class="item_style option_select " data-select="viwcpf_tax-type_show"
                         data-type_show="images">
                        <label class="label-setting"
                               for="tax-btn_image_show_title"
                        >
							<?php esc_html_e('Show/Hide title:', 'pofily-woocommerce-product-filters') ?>
                        </label>
                        <div class="vi-ui right fluid input">

                            <div class="vi-ui toggle checkbox">
                                <input type="checkbox" name="tax-btn_image_show_title"
                                       id="tax-btn_image_show_title" <?php checked(isset($tax_btn_style['btn_image_show_title']) ? $tax_btn_style['btn_image_show_title'] : $default_btn_image_show_title, 1); ?> >
                                <label></label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="vi-ui row two no-wrap item_row option_select hidden " data-select="viwcpf_tax-type_show"
             data-type_show="color_swatches">
            <div class="column three wide column_label">
                <label class="label-setting"
                       for="tax-color_separator"><?php esc_html_e('Color separator:', 'pofily-woocommerce-product-filters') ?></label>
            </div>
            <div class="column fourteen wide column_field">
				<?php
				if (isset($tax_btn_style['btn_color_separator'])) {
					$btn_color_separator = $tax_btn_style['btn_color_separator'];
				} else {
					$btn_color_separator = $default_btn_color_separator;
				}
				?>
                <select class="vi-ui dropdown fluid viwcpf_filter_block_select" name="tax-color_separator"
                        id="tax-color_separator">
                    <option value="1" <?php selected($btn_color_separator, '1'); ?> >
						<?php esc_html_e('Basic horizontal', 'pofily-woocommerce-product-filters') ?>
                    </option>
                    <option value="2" <?php selected($btn_color_separator, '2'); ?> >
						<?php esc_html_e('Basic vertical', 'pofily-woocommerce-product-filters') ?>
                    </option>
                    <option value="3" <?php selected($btn_color_separator, '3'); ?> >
						<?php esc_html_e('Basic diagonal left', 'pofily-woocommerce-product-filters') ?>
                    </option>
                    <option value="4" <?php selected($btn_color_separator, '4'); ?> >
						<?php esc_html_e('Basic diagonal right', 'pofily-woocommerce-product-filters') ?>
                    </option>
                    <option value="5" <?php selected($btn_color_separator, '5'); ?> >
						<?php esc_html_e('Hard lines horizontal', 'pofily-woocommerce-product-filters') ?>
                    </option>
                    <option value="6" <?php selected($btn_color_separator, '6'); ?> >
						<?php esc_html_e('Hard lines vertical', 'pofily-woocommerce-product-filters') ?>
                    </option>
                    <option value="7" <?php selected($btn_color_separator, '7'); ?> >
						<?php esc_html_e('Hard lines diagonal left', 'pofily-woocommerce-product-filters') ?>
                    </option>
                    <option value="8" <?php selected($btn_color_separator, '8'); ?> >
						<?php esc_html_e('Hard lines diagonal right', 'pofily-woocommerce-product-filters') ?>
                    </option>
                </select>
            </div>
        </div>
        <div class="vi-ui row two no-wrap item_row">
            <div class="column three wide column_label">
                <label class="label-setting"
                       for=""><?php esc_html_e('Customize term:', 'pofily-woocommerce-product-filters') ?></label>
            </div>
            <div class="column fourteen wide column_field">
                <div class="terms_wrap">
                    <div id="loading_table_term" class="vi-ui inverted dimmer">
                        <div class="vi-ui text loader"><?php esc_html_e('Loading', 'pofily-woocommerce-product-filters') ?></div>
                    </div>
                    <table id="terms_list" class="vi-ui celled table" style="width:100%">
                        <thead>
                        <tr>
                            <th><?php esc_html_e('Name', 'pofily-woocommerce-product-filters') ?></th>
                            <th><?php esc_html_e('New Label', 'pofily-woocommerce-product-filters') ?></th>
                            <th>
								<?php esc_html_e('Tooltip', 'pofily-woocommerce-product-filters') ?>
                                <a href="#" class="vi-ui red icon button mini labeled remove_all_tooltip">
                                    <i class="trash icon"></i><?php esc_html_e('Remove all tooltip', 'pofily-woocommerce-product-filters'); ?>
                                </a></th>
                            <th class="terms_item_option title_choose_color option_select hidden"
                                data-select="viwcpf_tax-type_show"
                                data-type_show="color_swatches"><?php esc_html_e('Choose Color', 'pofily-woocommerce-product-filters') ?> </th>
                            <th class="terms_item_option title_choose_image option_select hidden"
                                data-select="viwcpf_tax-type_show"
                                data-type_show="images"><?php esc_html_e('Choose image', 'pofily-woocommerce-product-filters') ?> </th>
                        </tr>
                        </thead>
                        <tbody>
						<?php

						if (
							($arr_term_id != '') &&
							(sizeof($arr_term_id) > 0) &&
							($customize_terms_data != '') &&
							(sizeof($customize_terms_data) > 0)
						) {
							foreach ($arr_term_id as $term_item_id) {
								$item_term_label = $customize_terms_data[$term_item_id]['old_label'] ?? '';
								if (empty($item_term_label)) {
									continue;
								}
								$item_term_new_label    = $customize_terms_data[$term_item_id]['new_label'] ?? '';
								$item_term_tooltip      = $customize_terms_data[$term_item_id]['tooltip'] ?? '';
								$item_term_color        = '';
								$item_term_image        = '';
								$item_term_color_output = '
                                        <div class="field">
                                            <div class="vi-ui input">
                                                <span class="color-picker"></span>
                                                <input type="text" 
                                                        class="color-text" 
                                                        name="viwcpf_term_color[' . esc_attr($term_item_id) . '][]" 
                                                        id="viwcpf_term' . esc_attr($term_item_id) . 'color1" 
                                                        placeholder="' . esc_attr__('Choose color', 'pofily-woocommerce-product-filters') . '" 
                                                        value="' . esc_attr($default_btn_color_default) . '" 
                                                        data-color_default="' . esc_attr($default_btn_color_default) . '" 
                                                >
                                            </div>
                                            <div class="viwcpf_add_input">
                                                <a href="#" class="vi-ui addinputs icon green button mini compact"> <i class="plus icon"></i></a>
                                                <a href="#" class="vi-ui delinputs icon red button disabled mini compact"> <i class="minus icon"></i></a>
                                            </div>
                                        </div>';
								$item_term_image_output = '
                                        <div class="field choose_image_btn">
                                            <div class="viwcpf-upload_image">
                                                <i class="file image icon"></i>
                                                <span class="choose_image_text">' . esc_html('Add/Upload Image') . '</span>
                                            </div>
                                        </div>
                                        <div class="field choose_image_review hidden">
                                            <a href="#" class="viwcpf-remove_image" title="Remove"><i class="delete icon"></i></a>
                                        </div>
                                        <input type="hidden" class="viwcpf_term_image" name="viwcpf_term_image[' . esc_attr($term_item_id) . ']" id="viwcpf_term' . esc_attr($term_item_id) . '_image_id" >';
								if (
									($tax_type_show == 'color_swatches') ||
									($tax_type_show == 'images')
								) {
									if ($tax_type_show == 'color_swatches') {
										$item_term_color = isset($customize_terms_data[$term_item_id]['color']) ? $customize_terms_data[$term_item_id]['color'] : array();
										if (
											(!empty($item_term_color)) &&
											(sizeof($item_term_color) > 0)
										) {
											/*Reset value $item_term_color_output*/
											$item_term_color_output = '';
											/*Check count color and update class for button add and del color*/
											if (sizeof($item_term_color) == 1) {
												$add_disable = '';
												$del_disable = 'disabled';
											} else if (sizeof($item_term_color) == 3) {
												$add_disable = 'disabled';
												$del_disable = '';
											} else {
												$add_disable = '';
												$del_disable = '';
											}
											$color_count = 1;
											foreach ($item_term_color as $color_value) {
												if ($color_value == '') {
													$color_value = $default_btn_color_default;
												}
												$item_term_color_output .= '
                                                        <div class="field">
                                                            <div class="vi-ui input">
                                                                <span class="color-picker"></span>
                                                                <input type="text" 
                                                                       class="color-text" 
                                                                       name="viwcpf_term_color[' . esc_attr($term_item_id) . '][]" 
                                                                       id="viwcpf_term' . esc_attr($term_item_id) . 'color' . esc_attr($color_count) . '" 
                                                                       placeholder="' . esc_attr__('Choose color', 'pofily-woocommerce-product-filters') . '" 
                                                                       value="' . esc_attr($color_value) . '" 
                                                                       data-color_default="' . esc_attr($default_btn_color_default) . '"
                                                                    >
                                                            </div>
                                                            <div class="viwcpf_add_input">
                                                                <a href="#" class="vi-ui addinputs icon green button mini compact ' . esc_attr($add_disable) . '"> <i class="plus icon"></i></a>
                                                                <a href="#" class="vi-ui delinputs icon red button mini compact ' . esc_attr($del_disable) . '"> <i class="minus icon"></i></a>
                                                            </div>
                                                        </div>
                                                    ';
												$color_count++;
											}
										}
									}
									if ($tax_type_show == 'images') {
										$item_term_image = $customize_terms_data[$term_item_id]['images'];
										if ((!empty($item_term_image))) {
											$item_term_image_output = '
                                                    <div class="field choose_image_btn hidden">
                                                        <div class="viwcpf-upload_image">
                                                            <i class="file image icon"></i>
                                                            <span class="choose_image_text">' . esc_html__('Add/Upload Image', 'pofily-woocommerce-product-filters') . '</span>
                                                        </div>
                                                    </div>
                                                    <div class="field choose_image_review ">
                                                        <a href="#" class="viwcpf-remove_image" title="Remove"><i class="delete icon"></i></a>
                                                        ' . wp_get_attachment_image(esc_attr($item_term_image), 'thumbnail', "", array(
													"width"  => "60",
													"height" => "60"
												)) . '
                                                    </div>
                                                    <input type="hidden" 
                                                           class="viwcpf_term_image" 
                                                           name="viwcpf_term_image[' . esc_attr($term_item_id) . ']" 
                                                           id="viwcpf_term' . esc_attr($term_item_id) . '_image_id" 
                                                           value="' . esc_attr($item_term_image) . '"
                                                    >
                                                ';
										}
									}
								}
								?>
                                <tr data-term_id="<?php echo esc_attr($term_item_id); ?>"
                                    data-term_name="<?php echo esc_attr($item_term_label); ?>">
                                    <td class="reorder sorting_1">
                                        <div class="wrap_td">
                                            <label class="label-setting"><?php echo esc_html($item_term_label); ?></label>
                                            <input type="hidden"
                                                   name="viwcpf_term<?php echo esc_attr($term_item_id); ?>_old_label"
                                                   id="viwcpf_term<?php echo esc_attr($term_item_id); ?>_old_label"
                                                   value="<?php echo esc_attr($item_term_label); ?>">
                                        </div>
                                    </td>
                                    <td>
                                        <div class="wrap_td">
                                            <div class="vi-ui input">
                                                <input type="text"
                                                       name="viwcpf_term<?php echo esc_attr($term_item_id); ?>_new_label"
                                                       id="viwcpf_term<?php echo esc_attr($term_item_id); ?>_new_label"
                                                       value="<?php echo esc_attr($item_term_new_label); ?>"
                                                       placeholder="<?php esc_attr_e('New Label', 'pofily-woocommerce-product-filters') ?>"
                                                >
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="vi-ui input ">
                                            <input type="text"
                                                   name="viwcpf_term<?php echo esc_attr($term_item_id); ?>_tooltip"
                                                   class="viwcpf_term_tooltip"
                                                   id="viwcpf_term<?php echo esc_attr($term_item_id); ?>_tooltip"
                                                   value="<?php echo esc_attr($item_term_tooltip); ?>"
                                                   placeholder="<?php esc_attr_e('Enter Tooltip', 'pofily-woocommerce-product-filters') ?>"
                                            >
                                        </div>
                                    </td>
                                    <td class="choose_color option_select hidden" data-select="viwcpf_tax-type_show"
                                        data-type_show="color_swatches">
										<?php echo wp_kses($item_term_color_output, $this->expanded_alowed_tags()); ?>
                                    </td>
                                    <td class="choose_image option_select hidden" data-select="viwcpf_tax-type_show"
                                        data-type_show="images">
										<?php echo wp_kses($item_term_image_output, $this->expanded_alowed_tags()); ?>
                                    </td>
                                </tr>
								<?php
							}
						}
						?>
                        </tbody>
                        <tfoot>
                        <tr>
                            <th><?php esc_html_e('Name', 'pofily-woocommerce-product-filters') ?></th>
                            <th><?php esc_html_e('New Label', 'pofily-woocommerce-product-filters') ?></th>
                            <th><?php esc_html_e('Tooltip', 'pofily-woocommerce-product-filters') ?> </th>
                            <th class="terms_item_option title_choose_color option_select hidden"
                                data-select="viwcpf_tax-type_show"
                                data-type_show="color_swatches"><?php esc_html_e('Choose Color', 'pofily-woocommerce-product-filters') ?> </th>
                            <th class="terms_item_option title_choose_image option_select hidden"
                                data-select="viwcpf_tax-type_show"
                                data-type_show="images"><?php esc_html_e('Choose image', 'pofily-woocommerce-product-filters') ?> </th>
                        </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
        <div class="vi-ui row two no-wrap item_row option_select hidden" data-select="viwcpf_tax-type_show"
             data-type_show="select">
            <div class="column three wide column_label">
                <label class="label-setting"
                       for="tax-show_search_field"><?php esc_html_e('Show Search Field:', 'pofily-woocommerce-product-filters') ?></label>
            </div>
            <div class="column fourteen wide column_field">
                <div class="vi-ui toggle checkbox">
                    <input type="checkbox" name="tax-show_search_field"
                           id="tax-show_search_field" <?php if ($tax_show_search_field) {
						echo esc_attr('checked');
					} ?>>
                    <label></label>
                </div>
            </div>
        </div>
        <div class="vi-ui row two no-wrap item_row">
            <div class="column eight wide">
                <div class="vi-ui two column grid no-wrap">
                    <div class="column four wide column_label column_label_child">
                        <label class="label-setting"
                               for="tax-order_by"><?php esc_html_e('Order by:', 'pofily-woocommerce-product-filters') ?></label>
                    </div>
                    <div class="column twelve wide column_field column_field_child">
                        <select name="viwcpf_tax-order_by" id="tax-order_by"
                                class="vi-ui dropdown fluid viwcpf_filter_block_select">
                            <option value="menu_order"
								<?php
								if ($tax_order_by == 'menu_order') {
									echo esc_attr('selected');
								}
								?>
                            >
								<?php esc_html_e('Default', 'pofily-woocommerce-product-filters') ?>
                            </option>
                            <option value="name"
								<?php
								if ($tax_order_by == 'name') {
									echo esc_attr('selected');
								}
								?>
                            >
								<?php esc_html_e('Name', 'pofily-woocommerce-product-filters') ?>
                            </option>
                            <option value="slug"
								<?php
								if ($tax_order_by == 'slug') {
									echo esc_attr('selected');
								}
								?>
                            >
								<?php esc_html_e('Slug', 'pofily-woocommerce-product-filters') ?>
                            </option>
                            <option value="id"
								<?php
								if ($tax_order_by == 'id') {
									echo esc_attr('selected');
								}
								?>
                            >
								<?php esc_html_e('Id', 'pofily-woocommerce-product-filters') ?>
                            </option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="column eight wide">
                <div class="vi-ui two column grid no-wrap">
                    <div class="column four wide column_label column_label_child">
                        <label class="label-setting"
                               for="tax-order_type"><?php esc_html_e('Order type:', 'pofily-woocommerce-product-filters') ?></label>
                    </div>
                    <div class="column twelve wide column_field column_field_child">
                        <select name="viwcpf_tax-order_type" id="tax-order_type"
                                class="vi-ui dropdown fluid viwcpf_filter_block_select">
                            <option value="asc"
								<?php
								if ($tax_order_type == 'asc') {
									echo esc_attr('selected');
								}
								?>
                            >
								<?php esc_html_e('ASC', 'pofily-woocommerce-product-filters') ?>
                            </option>
                            <option value="desc"
								<?php
								if ($tax_order_type == 'desc') {
									echo esc_attr('selected');
								}
								?>
                            >
								<?php esc_html_e('DESC', 'pofily-woocommerce-product-filters') ?>
                            </option>
                        </select>
                    </div>
                </div>
            </div>

        </div>
        <div class="vi-ui row two no-wrap item_row option_select" data-select="viwcpf_tax-type_show"
             data-type_show="button,checkbox,color_swatches">
            <div class="column three wide column_label">
                <label class="label-setting"
                       for="tax-show_count_items"><?php esc_html_e('Show count of items:', 'pofily-woocommerce-product-filters') ?></label>
            </div>
            <div class="column fourteen wide column_field">
                <div class="vi-ui toggle checkbox">
                    <input type="checkbox" name="tax-show_count_items"
                           id="tax-show_count_items" <?php if ($tax_show_count_item) {
						echo esc_attr('checked');
					} ?>>
                    <label></label>
                </div>
            </div>
        </div>
        <!--div class="vi-ui row two no-wrap item_row option_select hidden" data-select="viwcpf_tax-type_show" data-type_show="checkbox">
            <div class="column three wide column_label">
                <label class="label-setting"><?php esc_html_e('Show hierarchy:', 'pofily-woocommerce-product-filters') ?></label>
            </div>
            <div class="column twelve wide column_field">
                <div class="field">
                    <div class="vi-ui radio checkbox">
                        <input type="radio" name="tax-hierarchy" id="tax-hierarchy-no_show_all" value="tax-hierarchy-no_show_all">
                        <label for="tax-hierarchy-no_show_all">No, show all terms in same level</label>
                    </div>
                </div>
                <div class="field">
                    <div class="vi-ui radio checkbox">
                        <input type="radio" name="tax-hierarchy" id="tax-hierarchy-no_show_parent" value="tax-hierarchy-no_show_parent">
                        <label for="tax-hierarchy-no_show_parent">No, show only parent terms</label>
                    </div>
                </div>
                <div class="field">
                    <div class="vi-ui radio checkbox">
                        <input type="radio" name="tax-hierarchy" id="tax-hierarchy-yes_show_collapsed" value="tax-hierarchy-yes_show_collapsed">
                        <label for="tax-hierarchy-yes_show_collapsed">Yes, with terms collapsed</label>
                    </div>
                </div>
                <div class="field">
                    <div class="vi-ui radio checkbox">
                        <input type="radio" name="tax-hierarchy" id="tax-hierarchy-yes_show_expanded" value="tax-hierarchy-yes_show_expanded">
                        <label for="tax-hierarchy-yes_show_expanded">Yes, with terms expanded</label>
                    </div>
                </div>
            </div>
        </div-->
        <div class="vi-ui row two no-wrap item_row">
            <div class="column three wide column_label">
                <label class="label-setting"
                       for="tax-multi_select"><?php esc_html_e('Allow multiple selection:', 'pofily-woocommerce-product-filters') ?></label>
            </div>
            <div class="column fourteen wide column_field">
                <div class="vi-ui toggle checkbox">
                    <input type="checkbox" name="tax-multi_select" id="tax-multi_select" <?php if ($tax_multiselect) {
						echo esc_attr('checked');
					} ?> >
                    <label></label>
                </div>
            </div>
        </div>
        <div class="vi-ui row two no-wrap item_row option_select" data-select="tax-multi_select" data-type_show="true">
            <div class="column three wide column_label">
                <label class="label-setting"><?php esc_html_e('Multiselect relation:', 'pofily-woocommerce-product-filters') ?></label>
            </div>
            <div class="column fourteen wide column_field vi-ui form">
                <div class="grouped fields">
                    <div class="field">
                        <div class="vi-ui toggle checkbox">
                            <input type="radio" name="tax-multi_relation" id="tax-multi_relation-and"
                                   value="AND" <?php if ($tax_multi_relation == "AND") {
								echo esc_attr('checked');
							} ?> >
                            <label for="tax-multi_relation-and"><?php esc_html_e('And', 'pofily-woocommerce-product-filters') ?></label>
                        </div>
                    </div>
                    <div class="field">
                        <div class="vi-ui toggle checkbox">
                            <input type="radio" name="tax-multi_relation" id="tax-multi_relation-or"
                                   value="OR" <?php if ($tax_multi_relation == "OR") {
								echo esc_attr('checked');
							} ?>>
                            <label for="tax-multi_relation-or"><?php esc_html_e('Or', 'pofily-woocommerce-product-filters') ?></label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--Filter By Item - Filter by Price-->
    <div class="vi-ui grid filter_by_item " data-type="filter_by_price">
		<?php
		if (!empty($viwcpf_filter_block['filter_for']) && $viwcpf_filter_block['filter_for'] == 'filter_by_price') {
			$filter_data           = $viwcpf_filter_block['filter_data'];
			$price_type_filter     = $filter_data['type_filter'];
			$price_type_show       = $filter_data['type_show'];
			$price_show_count_item = $filter_data['show_count_item'];
			if ($price_type_filter == 'price_range') {
				$price_customize = $filter_data['customize_value'];
			} else {
				$price_customize = $filter_data['customize_value'];
			}
		} else {
			$price_type_filter     = '';
			$price_type_show       = '';
			$price_customize       = array();
			$price_show_count_item = false;
		}
		?>
        <div class="vi-ui row two no-wrap item_row">
            <div class="column three wide column_label">
                <label class="label-setting"
                       for="price-type_filter"><?php esc_html_e('Type Filter:', 'pofily-woocommerce-product-filters') ?></label>
            </div>
            <div class="column fourteen wide column_field">
                <select name="viwcpf_price-type_filter" id="price-type_filter"
                        class="vi-ui dropdown fluid viwcpf_filter_block_select">
                    <option value="range_slide"
						<?php
						if ($price_type_filter == 'range_slide') {
							echo esc_attr('selected');
						}
						?>
                    >
						<?php esc_html_e('Price Range Slider', 'pofily-woocommerce-product-filters') ?>
                    </option>
                    <option value="range"
						<?php
						if ($price_type_filter == 'range') {
							echo esc_attr('selected');
						}
						?>
                    >
						<?php esc_html_e('Price Range', 'pofily-woocommerce-product-filters') ?>
                    </option>
                </select>
            </div>
        </div>
        <div class="vi-ui row two no-wrap item_row option_select" data-select="viwcpf_price-type_filter"
             data-type_show="range">
            <div class="column three wide column_label">
                <label class="label-setting"
                       for="price-type_show"><?php esc_html_e('Type show:', 'pofily-woocommerce-product-filters') ?></label>
            </div>
            <div class="column fourteen wide column_field">
                <select name="viwcpf_price-type_show" id="price-type_show"
                        class="vi-ui dropdown fluid viwcpf_filter_block_select">
                    <option value="none" <?php selected($price_type_show, 'none'); ?> >
						<?php esc_html_e('None', 'pofily-woocommerce-product-filters') ?>
                    </option>
                    <option value="button" <?php selected($price_type_show, 'button'); ?> >
						<?php esc_html_e('Button', 'pofily-woocommerce-product-filters') ?>
                    </option>
                    <option value="select" <?php selected($price_type_show, 'select'); ?> >
						<?php esc_html_e('Select', 'pofily-woocommerce-product-filters') ?>
                    </option>
                </select>
            </div>
        </div>
        <div class="vi-ui row two no-wrap item_row option_select" data-select="viwcpf_price-type_filter"
             data-type_show="range">
            <div class="column three wide column_label">
                <label class="label-setting"><?php esc_html_e('Customize price ranges:', 'pofily-woocommerce-product-filters') ?></label>
            </div>
            <div class="column fourteen wide column_field">
                <div class="wrap_price_ranges">
                    <table id="range_price_list" class="vi-ui celled table" style="width:100%">
                        <thead>
                        <tr>
                            <th>
                                <span><?php esc_html_e('List range price', 'pofily-woocommerce-product-filters') ?></span>
                                <a href="#" class="vi-ui green icon button mini"
                                   id="price-add_range"><i
                                            class="plus icon"></i> <?php esc_html_e('Add range', 'pofily-woocommerce-product-filters') ?>
                                </a>
                            </th>
                        </tr>

                        </thead>
                        <tbody>
						<?php
						$limitless_checked = '';
						if (
							($price_type_filter == 'range') &&
							(!empty($price_customize)) &&
							(sizeof($price_customize) > 0)
						) {
							$count_range_price = 0;
							$len_range_price   = count($price_customize);
							foreach ($price_customize as $price_range_item) {
								$min_price       = isset($price_range_item['min']) ? $price_range_item['min'] : '';
								$max_price       = isset($price_range_item['max']) ? $price_range_item['max'] : '';
								$limitless_price = isset($price_range_item['limitless']) ? true : false;

								if ($limitless_price) {
									$limitless_checked = 'checked';
								}

								?>
                                <tr>
                                    <td>
                                        <div class="field range_price_item">
                                            <div class="column_item">
                                                <div class="vi-ui right labeled input min_input">
                                                    <label class="vi-ui label label-setting"><?php echo esc_html('Min (' . get_woocommerce_currency_symbol() . ')') ?></label>
                                                    <input type="number"
                                                           name="viwcpf_price_range[<?php echo esc_attr($count_range_price); ?>][min]"
                                                           id="viwcpf_price_range_<?php echo esc_attr($count_range_price); ?>_min"
                                                           min="0" step="0.01"
                                                           value="<?php echo esc_attr($min_price); ?>">
                                                    <div class="vi-ui label border_radius_zero"> -</div>
                                                </div>
                                                <div class="vi-ui left labeled input max_input ">
                                                    <label class="vi-ui label border_radius_zero label-setting"><?php echo esc_html('Max (' . get_woocommerce_currency_symbol() . ')') ?></label>
                                                    <input type="number"
                                                           name="viwcpf_price_range[<?php echo esc_attr($count_range_price); ?>][max]"
                                                           id="viwcpf_price_range_<?php echo esc_attr($count_range_price); ?>_max"
                                                           min="0" step="0.01"
                                                           value="<?php echo esc_attr($max_price); ?>">

                                                </div>
                                            </div>
                                            <a href="#" class="vi-ui icon red button price-range-remove mini compact">
                                                <i class="minus icon"></i></a>
                                        </div>
                                    </td>
                                </tr>
								<?php
								if (isset($price_range_item['limitless'])) {
									break;
								}
								$count_range_price++;
							}
						}
						?>
                        </tbody>
                        <tfoot>
                        <tr>
                            <th>
                                <div class="vi-ui toggle range_limitless checkbox ">
                                    <label class="label-setting" for="viwcpf_price_last_range_limitless">
										<?php esc_html_e('Show "&amp; Above" in last range', 'pofily-woocommerce-product-filters') ?>
                                    </label>
                                    <input type="checkbox"
                                           name="viwcpf_price_last_range_limitless"
                                           id="viwcpf_price_last_range_limitless"
                                           class="limitless_input"
										<?php echo esc_attr($limitless_checked); ?>>
                                </div>
                            </th>
                        </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
        <div class="vi-ui row two no-wrap item_row option_select hidden" data-select="viwcpf_price-type_filter"
             data-type_show="range_slide">
			<?php
			if ($price_type_filter == 'range_slide') {
				$min_price  = isset($price_customize['min_price']) ? $price_customize['min_price'] : '';
				$max_price  = isset($price_customize['max_price']) ? $price_customize['max_price'] : '';
				$step_price = isset($price_customize['step_price']) ? $price_customize['step_price'] : '';
			} else {
				$min_price  = '';
				$max_price  = '';
				$step_price = '';
			}
			?>
            <div class="column three wide column_label">
                <label class="label-setting"
                       for=""><?php esc_html_e('Price range slider value:', 'pofily-woocommerce-product-filters') ?></label>
            </div>
            <div class="column fourteen wide column_field">
                <div class="price-wrap_slider_value">
                    <div class="item_style">
                        <div class="vi-ui left labeled fluid input">
                            <label class="vi-ui label label-setting"
                                   for="price-slide_min"><?php echo esc_html('Min (' . get_woocommerce_currency_symbol() . '):') ?></label>
							<?php ?>
                            <input type="number" name="price-slide_min" id="price-slide_min"
                                   placeholder="<?php esc_attr_e('Amount', 'pofily-woocommerce-product-filters') ?>"
                                   min="0" step="0.1"
                                   value="<?php echo esc_attr($min_price); ?>">
                        </div>
                    </div>
                    <div class="item_style">
                        <div class="vi-ui left labeled fluid input">
                            <label class="vi-ui label label-setting"
                                   for="price-slide_max"><?php echo esc_html('Max (' . get_woocommerce_currency_symbol() . '):') ?></label>
                            <input type="number" name="price-slide_max" id="price-slide_max"
                                   placeholder="<?php esc_attr_e('Amount', 'pofily-woocommerce-product-filters') ?>"
                                   min="0" step="0.1"
                                   value="<?php echo esc_attr($max_price); ?>">
                        </div>
                    </div>
                    <div class="item_style">
                        <div class="vi-ui left labeled fluid input">
                            <label class="vi-ui label label-setting"
                                   for="price-slide_step"><?php esc_html_e('Price Range Slider step:', 'pofily-woocommerce-product-filters') ?></label>
                            <input type="number" name="price-slide_step" id="price-slide_step"
                                   placeholder="<?php esc_attr_e('Amount', 'pofily-woocommerce-product-filters') ?>"
                                   min="0" step="0.1"
                                   value="<?php echo esc_attr($step_price); ?>">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="vi-ui row two no-wrap item_row option_select" data-select="viwcpf_price-type_filter"
             data-type_show="range">
            <div class="column three wide column_label">
                <label class="label-setting"
                       for="price-show_count_items"><?php esc_html_e('Show count of items:', 'pofily-woocommerce-product-filters') ?></label>
            </div>
            <div class="column fourteen wide column_field">
                <div class="vi-ui toggle checkbox">
                    <input type="checkbox" name="price-show_count_items"
                           id="price-show_count_items" <?php if ($price_show_count_item) {
						echo esc_attr('checked');
					} ?>>
                    <label></label>
                </div>
            </div>
        </div>
    </div>
    <!--Filter By Item - Filter by Review-->
    <div class="vi-ui grid filter_by_item " data-type="filter_by_review">
		<?php
		if (!empty($viwcpf_filter_block['filter_for']) && $viwcpf_filter_block['filter_for'] == 'filter_by_review') {
			$filter_data            = $viwcpf_filter_block['filter_data'];
			$review_type_show       = $filter_data['type_show'] ?? false;
			$review_show_count_item = $filter_data['show_count_item'] ?? false;
			$review_show_tooltip    = $filter_data['show_tooltip'] ?? false;
			if ($review_type_show == 'icon_star') {
				$review_show_icon_star = false;
			} else {
				$review_show_icon_star = $filter_data['show_count_item'];
			}
		} else {
			$review_type_show       = '';
			$review_show_count_item = false;
			$review_show_icon_star  = false;
			$review_show_tooltip    = false;
		}
		?>
        <div class="vi-ui row two no-wrap item_row">
            <div class="column three wide column_label">
                <label class="label-setting"
                       for="review-type_show"><?php esc_html_e('Show type:', 'pofily-woocommerce-product-filters') ?></label>
            </div>
            <div class="column fourteen wide column_field">
                <select name="viwcpf_review-type_show" id="review-type_show"
                        class="vi-ui dropdown fluid viwcpf_filter_block_select">
                    <option value="none" <?php selected($review_type_show, 'none'); ?> >
						<?php esc_html_e('None', 'woo-product-filters') ?>
                    </option>
                    <option value="button" <?php selected($review_type_show, 'button'); ?> >
						<?php esc_html_e('Button', 'pofily-woocommerce-product-filters') ?>
                    </option>
                    <option value="select" <?php selected($review_type_show, 'select'); ?> >
						<?php esc_html_e('Select', 'pofily-woocommerce-product-filters') ?>
                    </option>
                </select>
            </div>
        </div>
        <div class="vi-ui row two no-wrap item_row option_select" data-select="viwcpf_review-type_show"
             data-type_show="none,button"
        ">
        <div class="column eight wide">
            <div class="vi-ui two column grid no-wrap">
                <div class="column four wide column_label column_label_child">
                    <label class="label-setting"
                           for="review-show_icon_star"><?php esc_html_e('Show star icon:', 'pofily-woocommerce-product-filters') ?></label>
                </div>
                <div class="column twelve wide column_field column_field_child">
                    <div class="vi-ui toggle checkbox">
                        <input type="checkbox" name="review-show_icon_star"
                               id="review-show_icon_star" <?php if ($review_show_icon_star) {
							echo esc_attr('checked');
						} ?> >
                        <label></label>
                    </div>
                </div>
            </div>
        </div>
        <div class="column eight wide">
            <div class="vi-ui two column grid no-wrap">
                <div class="column four wide column_label column_label_child">
                    <label class="label-setting"
                           for="review-show_tooltip"><?php esc_html_e('Show Tooltip:', 'pofily-woocommerce-product-filters') ?></label>
                </div>
                <div class="column twelve wide column_field column_field_child">
                    <div class="vi-ui toggle checkbox">
                        <input type="checkbox" name="review-show_tooltip"
                               id="review-show_tooltip" <?php if ($review_show_tooltip) {
							echo esc_attr('checked');
						} ?> >
                        <label></label>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="vi-ui row two no-wrap item_row option_select" data-select="viwcpf_review-type_show"
         data-type_show="none,button,select">
        <div class="column three wide column_label">
            <label class="label-setting"
                   for="review-show_count_items"><?php esc_html_e('Show count of items:', 'pofily-woocommerce-product-filters') ?></label>
        </div>
        <div class="column fourteen wide column_field">
            <div class="vi-ui toggle checkbox">
                <input type="checkbox" name="review-show_count_items"
                       id="review-show_count_items" <?php if ($review_show_count_item) {
					echo esc_attr('checked');
				} ?> >
                <label></label>
            </div>
        </div>
    </div>
</div>
<!--Filter By Item - Filter by OnSale/InStock-->
<div class="vi-ui grid filter_by_item" data-type="filter_by_sale_or_stock">
	<?php
	if (!empty($viwcpf_filter_block['filter_for']) && $viwcpf_filter_block['filter_for'] == 'filter_by_sale_or_stock') {
		$filter_data         = $viwcpf_filter_block['filter_data'];
		$oai_type_show       = $filter_data['type_show'];
		$oai_show_count_item = $filter_data['show_count_item'];
		$show_onsale         = $filter_data['show_onsale'];
		$show_instock        = $filter_data['show_instock'];
	} else {
		$oai_type_show       = '';
		$show_onsale         = false;
		$show_instock        = false;
		$oai_show_count_item = false;
	}
	?>
    <div class="vi-ui row two no-wrap item_row">
        <div class="column eight wide">
            <div class="vi-ui two column grid no-wrap">
                <div class="column four wide column_label column_label_child">
                    <label class="label-setting"
                           for="show-onsale"><?php esc_html_e('Show OnSale Filter:', 'pofily-woocommerce-product-filters') ?></label>
                </div>
                <div class="column twelve wide column_field column_field_child">
                    <div class="vi-ui toggle checkbox">
                        <input type="checkbox" name="show-onsale" id="show-onsale" <?php if ($show_onsale) {
							echo esc_attr('checked');
						} ?> >
                        <label></label>
                    </div>
                    <span class="explanatory-text"><?php esc_html_e('Enable if you want to show "OnSale" filter', 'pofily-woocommerce-product-filters'); ?></span>
                </div>
            </div>
        </div>
        <div class="column eight wide">
            <div class="vi-ui two column grid no-wrap">
                <div class="column four wide column_label column_label_child">
                    <label class="label-setting"
                           for="show-instock"><?php esc_html_e('Show InStock Filter:', 'pofily-woocommerce-product-filters') ?></label>
                </div>
                <div class="column twelve wide column_field column_field_child">
                    <div class="vi-ui toggle checkbox">
                        <input type="checkbox" name="show-instock" id="show-instock" <?php if ($show_instock) {
							echo esc_attr('checked');
						} ?> >
                        <label></label>
                    </div>
                    <span class="explanatory-text"><?php esc_html_e('Enable if you want to show "In-Stock" filter', 'pofily-woocommerce-product-filters'); ?></span>
                </div>
            </div>
        </div>

    </div>

    <div class="vi-ui row two no-wrap">
        <div class="column three wide column_label">
            <label class="label-setting"
                   for="onsale-instock_type_show"><?php esc_html_e('Filter Type:', 'pofily-woocommerce-product-filters') ?></label>
        </div>
        <div class="column fourteen wide column_field">
            <select name="viwcpf_onsale-instock_type_show" id="onsale-instock_type_show"
                    class="vi-ui dropdown fluid viwcpf_filter_block_select">
                <option value="button"
					<?php
					if ($oai_type_show == 'button') {
						echo esc_attr('selected');
					}
					?>
                >
					<?php esc_html_e('Button', 'pofily-woocommerce-product-filters') ?>
                </option>
                <option value="checkbox"
					<?php
					if ($oai_type_show == 'checkbox') {
						echo esc_attr('selected');
					}
					?>
                >
					<?php esc_html_e('Checkbox', 'pofily-woocommerce-product-filters') ?>
                </option>

            </select>
        </div>
    </div>
    <div class="vi-ui row two no-wrap item_row">
        <div class="column three wide column_label">
            <label class="label-setting"
                   for="onsale-instock-show_count_items"><?php esc_html_e('Show count of items:', 'pofily-woocommerce-product-filters') ?></label>
        </div>
        <div class="column fourteen wide column_field">
            <div class="vi-ui toggle checkbox">
                <input type="checkbox" name="onsale-instock-show_count_items"
                       id="onsale-instock-show_count_items" <?php if ($oai_show_count_item) {
					echo esc_attr('checked');
				} ?>>
                <label></label>
            </div>
        </div>
    </div>
</div>
<!--Filter By Item - Filter by Name-->
<div class="vi-ui grid filter_by_item " data-type="filter_by_name_product">
	<?php
	if (!empty($viwcpf_filter_block['filter_for']) && $viwcpf_filter_block['filter_for'] == 'filter_by_name_product') {
		$filter_data        = $viwcpf_filter_block['filter_data'];
		$placeholder_search = $filter_data['placeholder_search'];
		$trending_search    = $filter_data['trending_search'] ?? '';
	} else {
		$placeholder_search = '';
		$trending_search    = '';
	}
	?>
    <div class="vi-ui row no-wrap">
        <div class="column wide">
            <div class="vi-ui labeled input fluid">
                <div class="vi-ui label label-setting"><?php esc_html_e('Placeholder text:', 'pofily-woocommerce-product-filters') ?></div>
                <input type="text" name="viwcpf-name-placeholder" id="viwcpf-name-placeholder"
                       placeholder="<?php esc_attr_e('Enter placeholder', 'pofily-woocommerce-product-filters') ?>"
                       value="<?php echo esc_attr($placeholder_search); ?>">
            </div>
            <span class="explanatory-text"><?php esc_html_e('Enter the placeholder for search field, it will be displayed on frontend', 'pofily-woocommerce-product-filters') ?></span>
        </div>
    </div>
    <div class="vi-ui row two no-wrap ">
        <div class="column three wide column_label">
            <label class="label-setting" for="viwcpf-show_clear"><?php esc_html_e('Trending search:', 'pofily-woocommerce-product-filters') ?></label>
        </div>
        <div class="column fourteen wide column_field">
            <div class="vi-ui form fluid">
                <textarea name="viwcpf-trending-search"
                          id="viwcpf-trending-search"
                          placeholder="<?php esc_attr_e('Trending search', 'pofily-woocommerce-product-filters') ?>"
                ><?php echo esc_attr($trending_search); ?></textarea>
                <label></label>
            </div>
            <span class="explanatory-text"><?php esc_html_e('Enter the trending key search. Each key on a line.', 'pofily-woocommerce-product-filters') ?></span>
        </div>
    </div>

</div>
<!--Filter By Item - Filter by Metabox-->
<div class="vi-ui grid filter_by_item " data-type="filter_by_metabox">
	<?php
	if (!empty($viwcpf_filter_block['filter_for']) && $viwcpf_filter_block['filter_for'] == 'filter_by_metabox') {
		$filter_data                = $viwcpf_filter_block['filter_data'];
		$meta_key_filter            = $filter_data['meta_key_filter'];
		$meta_type_filter           = $filter_data['meta_type_filter'];
		$meta_filter_number_display = $filter_data['meta_filter_number_display'];
		$meta_type_show             = $filter_data['type_show'];
		$list_metavalue             = $filter_data['list_metavalue'];
		$customize_meta_value       = $filter_data['customize_value'];
		$meta_multiselect           = $filter_data['multiselect'];
		$meta_multi_relation        = $filter_data['multi_relation'];
		$meta_order_by              = $filter_data['order_by'];
		$meta_order_type            = $filter_data['order_type'];
	} else {
		$meta_key_filter            = '';
		$meta_type_filter           = '';
		$meta_filter_number_display = '';
		$meta_type_show             = '';
		$list_metavalue             = array();
		$customize_meta_value       = array();
		$meta_show_count_item       = false;
		$meta_multiselect           = true;
		$meta_multi_relation        = 'AND';
		$meta_order_by              = 'name';
		$meta_order_type            = 'asc';
	}
	if (get_option('viwcpf_setting_params')) {
		$default_data_color_swatches  = get_option('viwcpf_setting_params')['color_swatches'];
		$default_btn_style            = $default_data_color_swatches['btn_style'];
		$default_btn_color_default    = $default_data_color_swatches['color_default'];
		$default_btn_style_width      = $default_btn_style['btn_width'];
		$default_btn_style_height     = $default_btn_style['btn_height'];
		$default_btn_border_radius    = $default_btn_style['btn_border_radius'];
		$default_btn_color_separator  = $default_btn_style['btn_color_separator'];
		$default_btn_image_show_title = isset($default_btn_style['btn_image_show_title']) ? $default_btn_style['btn_image_show_title'] : 0;
	} else {
		$default_btn_style_width      = '';
		$default_btn_style_height     = '';
		$default_btn_border_radius    = '';
		$default_btn_color_separator  = '';
		$default_btn_color_default    = '';
		$default_btn_image_show_title = 0;
	}
	?>
    <div class="vi-ui row two no-wrap">
        <div class="column eight wide">
			<?php
			$array_metakey = isset($viwcpf_setting_params['display_metakey']) ? $viwcpf_setting_params['display_metakey'] : array();

			if (!empty($array_metakey)):
				?>
                <div class="vi-ui left labeled dropdown button fluid">
                    <div class="vi-ui label label-setting"><?php esc_html_e('Choose meta key:', 'pofily-woocommerce-product-filters') ?></div>

                    <select name="viwcpf_meta_key" id="viwcpf_meta_key"
                            class="fluid viwcpf_filter_block_select viwcpf_meta_key">
						<?php
						foreach ($array_metakey as $value_item):
							if ($value_item == $meta_key_filter) {
								$selected = 'selected';
							} else {
								$selected = '';
							}
							echo '<option value="' . esc_attr($value_item) . '" ' . esc_attr($selected) . '>' . esc_html($value_item) . '</option>';
						endforeach;
						?>
                    </select>
                </div>
                <span class="explanatory-text"><?php esc_html_e('Choose your meta key', 'pofily-woocommerce-product-filters'); ?></span>
			<?php
			else:
				?>
                <span class="explanatory-text"><?php echo wp_kses_post('You have not selected which meta_key to display, go to <a href="' . admin_url('admin.php?page=viwcpf-woocommerce-product-filters-settings#/metadata') . '">Setting > Metadata</a> to add the meta_key you want to display.'); ?></span>
			<?php
			endif;
			?>
        </div>
        <div class="column eight wide">
            <div class="vi-ui left labeled dropdown button fluid">
                <div class="vi-ui label label-setting"><?php esc_html_e('Choose meta type:', 'pofily-woocommerce-product-filters'); ?></div>
                <select name="viwcpf_meta_type" id="viwcpf_meta_type" data-option="meta_type"
                        class="fluid viwcpf_filter_block_select viwcpf_meta_type">

                    <option value="string"
						<?php if ($meta_type_filter == 'string') {
							echo esc_attr('selected');
						} ?>
                    >
						<?php esc_html_e('String', 'pofily-woocommerce-product-filters'); ?>
                    </option>
                    <option value="numberic"
						<?php if ($meta_type_filter == 'numberic') {
							echo esc_attr('selected');
						} ?>
                    >
						<?php esc_html_e('Numberic', 'pofily-woocommerce-product-filters'); ?>
                    </option>

                </select>
            </div>
            <span class="explanatory-text"><?php esc_html_e('Choose your meta type', 'pofily-woocommerce-product-filters'); ?></span>
        </div>

    </div>
    <div class="vi-ui row two no-wrap option_select" data-select="viwcpf_meta_type" data-type_show="string">
        <div class="column three wide column_label ">
            <label class="label-setting"
                   for="viwcpf_meta_string-show_type"><?php esc_html_e('Show type:', 'pofily-woocommerce-product-filters'); ?></label>
        </div>
        <div class="column fourteen wide column_field">
            <select name="viwcpf_meta_string-show_type" id="viwcpf_meta_string-show_type"
                    class="vi-ui dropdown fluid viwcpf_filter_block_select ">
                <option value="none" <?php selected($meta_type_show, 'none'); ?> >
					<?php esc_html_e('None', 'woo-product-filters') ?>
                </option>
                <option value="button" <?php selected($meta_type_show, 'button'); ?> >
					<?php esc_html_e('Button', 'pofily-woocommerce-product-filters'); ?>
                </option>
                <option value="checkbox" <?php selected($meta_type_show, 'checkbox'); ?> >
					<?php esc_html_e('Checkbox', 'pofily-woocommerce-product-filters'); ?>
                </option>

                <option value="select" <?php selected($meta_type_show, 'select'); ?> >
					<?php esc_html_e('Select', 'pofily-woocommerce-product-filters'); ?>
                </option>
                <option value="color_swatches" <?php selected($meta_type_show, 'color_swatches'); ?> >
					<?php esc_html_e('Color Swatches', 'pofily-woocommerce-product-filters') ?>
                </option>
            </select>
        </div>
    </div>
    <div class="vi-ui row two no-wrap item_row option_select hidden " data-select="viwcpf_meta_string-show_type"
         data-type_show="color_swatches">
        <div class="column three wide column_label">
            <label class="label-setting"
                   for="tax-filter_type"><?php esc_html_e('Button template:', 'pofily-woocommerce-product-filters') ?></label>
        </div>
        <div class="column fourteen wide column_field">
            <div class="tax-wrap_button_template">
                <div class="item_style">
                    <label class="label-setting"
                           for="tax-btn_width"><?php esc_html_e('Width:', 'pofily-woocommerce-product-filters') ?></label>
                    <div class="vi-ui right labeled input">
                        <input type="number"
                               name="viwcpf_meta_string-btn_width"
                               id="viwcpf_meta_string-btn_width"
                               placeholder="<?php esc_attr_e('Enter width', 'pofily-woocommerce-product-filters') ?>"
                               value="<?php echo esc_attr(isset($tax_btn_style['btn_width']) ? $tax_btn_style['btn_width'] : $default_btn_style_width); ?>"
                               min="0"
                        >
                        <div class="vi-ui basic label"><?php esc_html_e('px', 'pofily-woocommerce-product-filters') ?></div>
                    </div>
                </div>
                <div class="item_style">
                    <label class="label-setting"
                           for="viwcpf_meta_string-btn_height"
                    >
						<?php esc_html_e('Height:', 'pofily-woocommerce-product-filters') ?>
                    </label>
                    <div class="vi-ui right labeled input">
                        <input type="number"
                               name="viwcpf_meta_string-btn_height"
                               id="viwcpf_meta_string-btn_height"
                               placeholder="<?php esc_attr_e('Enter height', 'pofily-woocommerce-product-filters') ?>"
                               min="0"
                               value="<?php echo esc_attr(isset($tax_btn_style['btn_height']) ? $tax_btn_style['btn_height'] : $default_btn_style_height); ?>"
                        >
                        <div class="vi-ui basic label"><?php esc_html_e('px', 'pofily-woocommerce-product-filters') ?></div>
                    </div>
                </div>
                <div class="item_style">
                    <label class="label-setting"
                           for="viwcpf_meta_string-btn_border_radius"
                    >
						<?php esc_html_e('Border radius:', 'pofily-woocommerce-product-filters') ?>
                    </label>
                    <div class="vi-ui right input">
                        <input type="text"
                               name="viwcpf_meta_string-btn_border_radius"
                               id="viwcpf_meta_string-btn_border_radius"
                               placeholder="<?php esc_attr_e('Example: 10px or 10%', 'pofily-woocommerce-product-filters') ?>"
                               min="0"
                               value="<?php echo esc_attr(isset($tax_btn_style['btn_border_radius']) ? $tax_btn_style['btn_border_radius'] : $default_btn_border_radius); ?>"
                        >
                    </div>
                </div>

            </div>
        </div>
    </div>
    <div class="vi-ui row two no-wrap item_row option_select hidden " data-select="viwcpf_meta_string-show_type"
         data-type_show="color_swatches">
        <div class="column three wide column_label">
            <label class="label-setting"
                   for="viwcpf_meta_string-color_separator"><?php esc_html_e('Color separator:', 'pofily-woocommerce-product-filters') ?></label>
        </div>
        <div class="column fourteen wide column_field">
			<?php
			if (isset($tax_btn_style['btn_color_separator'])) {
				$btn_color_separator = $tax_btn_style['btn_color_separator'];
			} else {
				$btn_color_separator = $default_btn_color_separator;
			}
			?>
            <select class="vi-ui dropdown fluid viwcpf_filter_block_select" name="viwcpf_meta_string-color_separator"
                    id="viwcpf_meta_string-color_separator">
                <option value="1" <?php selected($btn_color_separator, '1'); ?> >
					<?php esc_html_e('Basic horizontal', 'pofily-woocommerce-product-filters') ?>
                </option>
                <option value="2" <?php selected($btn_color_separator, '2'); ?> >
					<?php esc_html_e('Basic vertical', 'pofily-woocommerce-product-filters') ?>
                </option>
                <option value="3" <?php selected($btn_color_separator, '3'); ?> >
					<?php esc_html_e('Basic diagonal left', 'pofily-woocommerce-product-filters') ?>
                </option>
                <option value="4" <?php selected($btn_color_separator, '4'); ?> >
					<?php esc_html_e('Basic diagonal right', 'pofily-woocommerce-product-filters') ?>
                </option>
                <option value="5" <?php selected($btn_color_separator, '5'); ?> >
					<?php esc_html_e('Hard lines horizontal', 'pofily-woocommerce-product-filters') ?>
                </option>
                <option value="6" <?php selected($btn_color_separator, '6'); ?> >
					<?php esc_html_e('Hard lines vertical', 'pofily-woocommerce-product-filters') ?>
                </option>
                <option value="7" <?php selected($btn_color_separator, '7'); ?> >
					<?php esc_html_e('Hard lines diagonal left', 'pofily-woocommerce-product-filters') ?>
                </option>
                <option value="8" <?php selected($btn_color_separator, '8'); ?> >
					<?php esc_html_e('Hard lines diagonal right', 'pofily-woocommerce-product-filters') ?>
                </option>
            </select>
        </div>
    </div>
    <div class="vi-ui row two no-wrap item_row option_select" data-select="viwcpf_meta_type"
         data-type_show="string">
        <div class="column three wide column_label">
            <label class="label-setting"
                   for="viwcpf_input_search_meta_value"><?php esc_html_e('Search/Add Meta Value:', 'pofily-woocommerce-product-filters') ?></label>
        </div>
        <div class="column fourteen wide column_field">
            <select class="viwcpf_input_search_meta_value" id="viwcpf_input_search_meta_value"
                    name="viwcpf_input_search_meta_value[]"
                    multiple="multiple">
				<?php
				if (
					($list_metavalue != '') &&
					is_array($list_metavalue) &&
					count($list_metavalue) > 0
				) {
					foreach ($list_metavalue as $metavalue_item) {
						echo '<option value="' . esc_html($metavalue_item) . '"  selected>' . esc_html($metavalue_item) . '</option>';
					}
				}
				?>
            </select>
            <button class="vi-ui green button mini"
                    id="meta-select_all"><?php esc_html_e('Add all', 'pofily-woocommerce-product-filters') ?></button>
            <button class="vi-ui red button mini"
                    id="meta-remove_all"><?php esc_html_e('Remove all', 'pofily-woocommerce-product-filters') ?></button>
        </div>
    </div>
    <div class="vi-ui row two no-wrap item_row option_select" data-select="viwcpf_meta_type"
         data-type_show="string">
        <div class="column three wide column_label">
            <label class="label-setting"
                   for=""><?php esc_html_e('Customize meta value:', 'pofily-woocommerce-product-filters') ?></label>
        </div>
        <div class="column fourteen wide column_field">
            <div class="viwcpf_metavalue_wrap">
                <table id="viwcpf_metavalue_list" class="vi-ui celled table" style="width:100%">
                    <thead>
                    <tr>
                        <th><?php esc_html_e('Name', 'pofily-woocommerce-product-filters') ?></th>
                        <th><?php esc_html_e('New Label', 'pofily-woocommerce-product-filters') ?></th>
                        <th><?php esc_html_e('Tooltip', 'pofily-woocommerce-product-filters') ?>
                            <a href="#" class="vi-ui red icon button mini labeled remove_all_tooltip">
                                <i class="trash icon"></i><?php esc_html_e('Remove all tooltip', 'pofily-woocommerce-product-filters'); ?>
                            </a></th>
                        <th class="meta_item_option title_choose_color option_select hidden"
                            data-select="viwcpf_meta_string-show_type"
                            data-type_show="color_swatches"><?php esc_html_e('Choose Color', 'pofily-woocommerce-product-filters') ?> </th>
                    </tr>
                    </thead>
                    <tbody>
					<?php
					if (
						($list_metavalue != '') &&
						(sizeof($list_metavalue) > 0) &&
						($customize_meta_value != '') &&
						(sizeof($customize_meta_value) > 0)
					) {
						$count = 0;
						foreach ($list_metavalue as $metavalue_item) {
							$item_metavalue_label = $customize_meta_value[$metavalue_item]['old_label'] ?? '';
							if (empty($item_metavalue_label)) {
								continue;
							}
							$item_metavalue_new_label = $customize_meta_value[$metavalue_item]['new_label'] ?? '';
							$item_metavalue_tooltip   = $customize_meta_value[$metavalue_item]['tooltip'] ?? '';
							$id_prefix                = 'viwcpf_metavalue_' . $meta_key_filter . '_' . $count;
							?>
                            <tr data-meta_value-id="<?php echo esc_attr($meta_key_filter . '_' . $count); ?>"
                                data-meta_value-name="<?php echo esc_attr($item_metavalue_label); ?>">
                                <td>
                                    <div class="wrap_td">
                                        <label class="label-setting"><?php echo esc_html($item_metavalue_label); ?></label>
                                        <input type="hidden"
                                               name="viwcpf_metavalue_<?php echo esc_attr($meta_key_filter); ?>[<?php echo esc_attr($count); ?>][old_label]"
                                               id="<?php echo esc_attr($id_prefix); ?>_old_label"
                                               value="<?php echo esc_attr($item_metavalue_label); ?>">
                                    </div>
                                </td>
                                <td>
                                    <div class="wrap_td">
                                        <div class="vi-ui input">
                                            <input type="text"
                                                   name="viwcpf_metavalue_<?php echo esc_attr($meta_key_filter); ?>[<?php echo esc_attr($count); ?>][new_label]"
                                                   id="<?php echo esc_attr($id_prefix); ?>_new_label"
                                                   value="<?php echo esc_attr($item_metavalue_new_label); ?>"
                                                   placeholder="<?php esc_attr_e('New Label', 'pofily-woocommerce-product-filters'); ?>">
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="vi-ui input ">
                                        <input type="text"
                                               name="viwcpf_metavalue_<?php echo esc_attr($meta_key_filter); ?>[<?php echo esc_attr($count); ?>][tooltip]"
                                               class="tooltip viwcpf_meta_tooltip"
                                               id="<?php echo esc_attr($id_prefix); ?>_tooltip"
                                               value="<?php echo esc_attr($item_metavalue_tooltip); ?>"
                                               placeholder="<?php esc_attr_e('Enter Tooltip', 'pofily-woocommerce-product-filters'); ?>">
                                    </div>
                                </td>
                                <td class="choose_color option_select hidden" data-select="viwcpf_meta_string-show_type" data-type_show="color_swatches">

                                </td>

                            </tr>
							<?php
							$count++;
						}
					}
					?>
                    </tbody>
                    <tfoot>
                    <tr>
                        <th><?php esc_html_e('Name', 'pofily-woocommerce-product-filters') ?></th>
                        <th><?php esc_html_e('New Label', 'pofily-woocommerce-product-filters') ?></th>
                        <th><?php esc_html_e('Tooltip', 'pofily-woocommerce-product-filters') ?> </th>
                        <th class="meta_item_option title_choose_color option_select hidden"
                            data-select="viwcpf_meta_string-show_type"
                            data-type_show="color_swatches"><?php esc_html_e('Choose Color', 'pofily-woocommerce-product-filters') ?> </th>
                    </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

    <div class="vi-ui row two no-wrap item_row option_select" data-select="viwcpf_meta_type"
         data-type_show="string">
        <div class="column three wide column_label">
            <label class="label-setting"
                   for="viwcpf_meta-show_count_items"><?php esc_html_e('Show count of items:', 'pofily-woocommerce-product-filters') ?></label>
        </div>
        <div class="column fourteen wide column_field">
            <div class="vi-ui toggle checkbox">
                <input type="checkbox" name="viwcpf_meta-show_count_items"
                       id="viwcpf_meta-show_count_items" <?php if ($price_show_count_item) {
					echo esc_attr('checked');
				} ?>>
                <label></label>
            </div>
        </div>
    </div>
    <div class="vi-ui row two no-wrap item_row option_select hidden" data-select="viwcpf_meta_type"
         data-type_show="numberic">
        <div class="column three wide column_label">
            <label class="label-setting"
                   for="viwcpf_meta_numberic-show_type"><?php esc_html_e('Show type:', 'pofily-woocommerce-product-filters') ?></label>
        </div>
        <div class="column fourteen wide column_field">
            <select name="viwcpf_meta_numberic-show_type" id="viwcpf_meta_numberic-show_type"
                    class="vi-ui dropdown fluid viwcpf_filter_block_select ">
                <option value="range"
					<?php
					if ($meta_filter_number_display == 'range') {
						echo esc_attr('selected');
					}
					?>
                >
					<?php esc_html_e('Range', 'pofily-woocommerce-product-filters') ?>
                </option>
                <option value="range_slide"
					<?php
					if ($meta_filter_number_display == 'range_slide') {
						echo esc_attr('selected');
					}
					?>
                >
					<?php esc_html_e('Range Slider', 'pofily-woocommerce-product-filters') ?>
                </option>


            </select>
        </div>
    </div>
    <div class="vi-ui row two no-wrap item_row type_numberic option_select <?php if ($meta_filter_number_display != 'range') {
		echo esc_attr('hidden');
	} ?>" data-select="viwcpf_meta_numberic-show_type" data-type_show="range">
        <div class="column three wide column_label">
            <label class="label-setting"><?php esc_html_e('Customize ranges:', 'pofily-woocommerce-product-filters') ?></label>
        </div>
        <div class="column fourteen wide column_field">

            <div class="wrap_price_ranges">
                <table id="range_meta_list" class="vi-ui celled table" style="width:100%">
                    <thead>
                    <tr>
                        <th>
                            <span><?php esc_html_e('List range meta', 'pofily-woocommerce-product-filters') ?></span>
                            <a href="#" class="vi-ui green icon mini button"
                               id="meta-add_range"><i
                                        class="plus icon"></i> <?php esc_html_e('Add range', 'pofily-woocommerce-product-filters') ?>
                            </a>
                        </th>
                    </tr>
                    </thead>
                    <tbody>
					<?php
					$limitless_checked = '';
					if (
						($meta_filter_number_display == 'range') &&
						(!empty($customize_meta_value)) &&
						(sizeof($customize_meta_value) > 0)
					) {
						$count_range = 0;
						$len         = count($customize_meta_value);
						foreach ($customize_meta_value as $customize_meta_item) {
							$meta_range_min       = isset($customize_meta_item['min']) ? $customize_meta_item['min'] : '';
							$meta_range_max       = isset($customize_meta_item['max']) ? $customize_meta_item['max'] : '';
							$meta_range_limitless = isset($customize_meta_item['limitless']) ? true : false;


							if ($meta_range_limitless) {
								$limitless_checked = 'checked';
							}

							?>
                            <tr>
                                <td>
                                    <div class="field range_meta_item">
                                        <div class="column_item">
                                            <div class="vi-ui right labeled input min_input">
                                                <label class="vi-ui label label-setting"><?php esc_html_e('Min', 'pofily-woocommerce-product-filters') ?></label>
                                                <input type="number"
                                                       name="viwcpf_meta_range[<?php echo esc_attr($count_range); ?>][min]"
                                                       id="viwcpf_meta_range_<?php echo esc_attr($count_range); ?>_min"
                                                       min="0" step="0.01"
                                                       value="<?php echo esc_attr($meta_range_min); ?>">
                                                <div class="vi-ui label border_radius_zero"> -</div>
                                            </div>
                                            <div class="vi-ui left labeled input max_input">
                                                <label class="vi-ui label label-setting border_radius_zero"><?php esc_html_e('Max', 'pofily-woocommerce-product-filters') ?></label>
                                                <input type="number"
                                                       name="viwcpf_meta_range[<?php echo esc_attr($count_range); ?>][max]"
                                                       id="viwcpf_meta_range_<?php echo esc_attr($count_range); ?>_max"
                                                       min="0" step="0.01"
                                                       value="<?php echo esc_attr($meta_range_max); ?>">

                                            </div>
                                        </div>
                                        <a href="#" class="vi-ui icon red button range-remove mini compact"> <i
                                                    class="minus icon"></i></a>
                                    </div>
                                </td>
                            </tr>
							<?php
							if (isset($customize_meta_item['limitless'])) {
								break;
							}
							$count_range++;
						}
					}
					?>
                    </tbody>
                    <tfoot>
                    <tr>
                        <th>
                            <div class="vi-ui toggle range_limitless checkbox ">
                                <label class="label-setting"
                                       for="viwcpf_meta_last_range_limitless"><?php esc_html_e('Show "&amp; Above" in last range', 'pofily-woocommerce-product-filters') ?></label>
                                <input type="checkbox"
                                       name="viwcpf_meta_last_range_limitless"
                                       id="viwcpf_meta_last_range_limitless"
                                       class="limitless_input" <?php echo esc_attr($limitless_checked); ?>>
                            </div>
                        </th>
                    </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
    <div class="vi-ui row two no-wrap item_row type_numberic option_select <?php if ($meta_filter_number_display != 'range_slide') {
		echo esc_attr('hidden');
	} ?>" data-select="viwcpf_meta_numberic-show_type" data-type_show="range_slide">
		<?php
		if ($meta_filter_number_display == 'range_slide') {
			$meta_range_min  = isset($customize_meta_value['meta_range_min']) ? $customize_meta_value['meta_range_min'] : '';
			$meta_range_max  = isset($customize_meta_value['meta_range_max']) ? $customize_meta_value['meta_range_max'] : '';
			$meta_range_step = isset($customize_meta_value['meta_range_step']) ? $customize_meta_value['meta_range_step'] : '1';
		} else {
			$meta_range_min  = '';
			$meta_range_max  = '';
			$meta_range_step = '1';
		}
		?>
        <div class="column three wide column_label">
            <label class="label-setting"
                   for=""><?php esc_html_e('Ranger slider value:', 'pofily-woocommerce-product-filters') ?></label>
        </div>
        <div class="column fourteen wide column_field">
            <div class="price-wrap_slider_value">
                <div class="item_style">
                    <label class="label-setting"
                           for="viwcpf_meta-range_slide_min"><?php esc_html_e('Range Slider min value:', 'pofily-woocommerce-product-filters') ?></label>
                    <div class="vi-ui fluid input">
                        <input type="number" name="viwcpf_meta-range_slide_min" id="viwcpf_meta-range_slide_min"
                               placeholder="<?php esc_attr_e('Enter min value', 'pofily-woocommerce-product-filters'); ?>"
                               min="0" step="0.01"
                               value="<?php echo esc_attr($meta_range_min); ?>">
                    </div>
                </div>
                <div class="item_style">
                    <label class="label-setting"
                           for="viwcpf_meta-range_slide_max"><?php esc_html_e('Range Slider max value:', 'pofily-woocommerce-product-filters') ?></label>
                    <div class="vi-ui fluid input">
                        <input type="number" name="viwcpf_meta-range_slide_max" id="viwcpf_meta-range_slide_max"
                               placeholder="<?php esc_attr_e('Enter max value', 'pofily-woocommerce-product-filters'); ?>"
                               min="0" step="0.01"
                               value="<?php echo esc_attr($meta_range_max); ?>">
                    </div>
                </div>
                <div class="item_style">
                    <label class="label-setting"
                           for="viwcpf_meta-slide_step"><?php esc_html_e('Slider step:', 'pofily-woocommerce-product-filters') ?></label>
                    <div class="vi-ui fluid input">
                        <input type="number" name="viwcpf_meta-range_slide_step" id="viwcpf_meta-slide_step"
                               placeholder="<?php esc_attr_e('Enter step value', 'pofily-woocommerce-product-filters'); ?>"
                               min="0" step="0.01"
                               value="<?php echo esc_attr($meta_range_step); ?>">
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="vi-ui row no-wrap item_row option_select" data-select="viwcpf_meta_type" data-type_show="string">
        <div class="vi-ui column wide column_label grid">
            <div class="vi-ui row two no-wrap item_row">
                <div class="column three wide column_label">
                    <label class="label-setting"
                           for="viwcpf_meta-multi_select"><?php esc_html_e('Allow multiple selection:', 'pofily-woocommerce-product-filters') ?></label>
                </div>
                <div class="column fourteen wide column_field">
                    <div class="vi-ui toggle checkbox">
                        <input type="checkbox" name="viwcpf_meta-multi_select"
                               id="viwcpf_meta-multi_select" <?php if ($meta_multiselect) {
							echo esc_attr('checked');
						} ?>>
                        <label></label>
                    </div>
                </div>
            </div>
            <div class="vi-ui row two no-wrap item_row option_select" data-select="viwcpf_meta-multi_select"
                 data-type_show="true">
                <div class="column three wide column_label">
                    <label class="label-setting"><?php esc_html_e('Multiselect relation:', 'pofily-woocommerce-product-filters') ?></label>
                </div>
                <div class="column fourteen wide column_field vi-ui form">
                    <div class="grouped fields">
                        <div class="field">
                            <div class="vi-ui toggle checkbox">
                                <input type="radio" name="viwcpf_meta-multi_relation"
                                       id="viwcpf_meta-multi_relation-and"
                                       value="AND" <?php if ($meta_multi_relation == 'AND') {
									echo esc_attr('checked');
								} ?>>
                                <label for="viwcpf_meta-multi_relation-and"><?php esc_html_e('And', 'pofily-woocommerce-product-filters'); ?></label>
                            </div>
                        </div>
                        <div class="field">
                            <div class="vi-ui toggle checkbox">
                                <input type="radio" name="viwcpf_meta-multi_relation"
                                       id="viwcpf_meta-multi_relation-or"
                                       value="OR" <?php if ($meta_multi_relation == 'OR') {
									echo esc_attr('checked');
								} ?>>
                                <label for="viwcpf_meta-multi_relation-or"><?php esc_html_e('Or', 'pofily-woocommerce-product-filters'); ?></label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

<!--General Setting-->
<!--Display type-->
<?php
$viwcpf_filter_block_setting = isset($viwcpf_filter_block['settings']) ? $viwcpf_filter_block['settings'] : '';
if ($viwcpf_filter_block_setting != '') {
	$display_type    = $viwcpf_filter_block_setting['display_type'];
	$show_clear      = $viwcpf_filter_block_setting['show_clear'];
	$show_view_more  = $viwcpf_filter_block_setting['show_view_more'];
	$view_more_limit = $viwcpf_filter_block_setting['view_more_limit'];
	$show_as_toggle  = $viwcpf_filter_block_setting['show_as_toggle'];
	$toggle_style    = $viwcpf_filter_block_setting['toggle_style'];
} else {
	$display_type    = '';
	$show_clear      = false;
	$show_view_more  = false;
	$view_more_limit = 10;
	$show_as_toggle  = false;
	$toggle_style    = 'toggle_style-opened';
}
?>
<div class="vi-ui row two no-wrap global_setting_conditional">
    <div class="column three wide column_label">
        <label class="label-setting"
               for="viwcpf_display-type"><?php esc_html_e('Display type:', 'pofily-woocommerce-product-filters') ?></label>
    </div>
    <div class="column fourteen wide column_field">
        <select name="viwcpf_display-type" id="viwcpf_display-type"
                class="vi-ui dropdown fluid viwcpf_filter_block_select">
            <option value="vertical" <?php selected($display_type, 'vertical'); ?> >
				<?php esc_html_e('Vertical', 'pofily-woocommerce-product-filters') ?>
            </option>
            <option value="horizontal" <?php selected($display_type, 'horizontal'); ?> >
				<?php esc_html_e('Horizontal', 'pofily-woocommerce-product-filters') ?>
            </option>
        </select>
        <span class="explanatory-text"><?php esc_html_e('Choose the display type for your filter block', 'pofily-woocommerce-product-filters') ?></span>
    </div>
</div>
<!--Show clear-->
<div class="vi-ui row two no-wrap ">
    <div class="column three wide column_label">
        <label class="label-setting"
               for="viwcpf-show_clear"><?php esc_html_e('Show "clear" button:', 'pofily-woocommerce-product-filters') ?></label>
    </div>
    <div class="column fourteen wide column_field">
        <div class="vi-ui toggle checkbox">
            <input type="checkbox" name="viwcpf-show_clear" id="viwcpf-show_clear" <?php if ($show_clear) {
				echo esc_attr('checked');
			} ?>>
            <label></label>
        </div>
        <span class="explanatory-text"><?php esc_html_e('Enable to show the "Clear" link above the filter block', 'pofily-woocommerce-product-filters') ?></span>
    </div>
</div>
<!--Show as toggle-->
<div class="vi-ui row two no-wrap">
    <div class="column eight wide">
        <div class="vi-ui two column grid no-wrap">
            <div class="column four wide column_label column_label_child">
                <label class="label-setting"
                       for="viwcpf-show_clear"><?php esc_html_e('Show as toggle:', 'pofily-woocommerce-product-filters') ?></label>
            </div>
            <div class="column twelve wide column_field column_field_child">
                <div class="vi-ui toggle checkbox">
                    <input type="checkbox" name="viwcpf-show_as_toggle"
                           id="viwcpf-show_as_toggle" <?php if ($show_as_toggle) {
						echo esc_attr('checked');
					} ?>>
                    <label></label>
                </div>
                <span class="explanatory-text"><?php esc_html_e('Enable if you want to show this filter as a toggle', 'pofily-woocommerce-product-filters'); ?></span>
            </div>
        </div>
    </div>
    <!--Toggle style-->
    <div class="column eight wide option_select hidden" data-select="viwcpf-show_as_toggle" data-type_show="true">
        <div class="vi-ui left labeled dropdown button fluid">
            <div class="vi-ui label label-setting"><?php esc_html_e('Toggle style:', 'pofily-woocommerce-product-filters') ?></div>
            <select name="viwcpf_toggle_style"
                    id="viwcpf_toggle_style"
                    class=" fluid viwcpf_filter_block_select viwcpf_toggle_style">
                <option value="toggle_style-opened"
					<?php
					if ($toggle_style == 'toggle_style-opened') {
						echo esc_attr('selected');
					}
					?>
                >
					<?php esc_html_e('Opened by default', 'pofily-woocommerce-product-filters') ?>
                </option>
                <option value="toggle_style-closed"
					<?php
					if ($toggle_style == 'toggle_style-closed') {
						echo esc_attr('selected');
					}
					?>
                >
					<?php esc_html_e('Closed by default', 'pofily-woocommerce-product-filters') ?>
                </option>
            </select>
        </div>
        <span class="explanatory-text"><?php esc_html_e('Choose if toggle has to closed or opened by default', 'pofily-woocommerce-product-filters'); ?></span>
    </div>
</div>
<!--Show view more-->
<div class="vi-ui row two no-wrap global_setting_conditional">
    <div class="column eight wide">
        <div class="vi-ui two column grid no-wrap">
            <div class="column four wide column_label column_label_child">
                <label class="label-setting"
                       for="viwcpf-show_view_more"><?php esc_html_e('Show "view more" button:', 'pofily-woocommerce-product-filters') ?></label>
            </div>
            <div class="column twelve wide column_field column_field_child">
                <div class="vi-ui toggle checkbox">
                    <input type="checkbox" name="viwcpf-show_view_more"
                           id="viwcpf-show_view_more" <?php if ($show_view_more) {
						echo esc_attr('checked');
					} ?>>
                    <label></label>
                </div>
                <span class="explanatory-text"><?php esc_html_e('Show view more item (Only works if show type is button or checkbox)', 'pofily-woocommerce-product-filters') ?></span>
            </div>
        </div>
    </div>
    <!--Label display limit-->
    <div class="column eight wide option_select hidden" data-select="viwcpf-show_view_more" data-type_show="true">
        <div class="vi-ui left labeled input fluid">
            <label class="vi-ui label label-setting"
                   for="viwcpf-label_limit"><?php esc_html_e('Label display limit:', 'pofily-woocommerce-product-filters') ?></label>
            <input type="number" name="viwcpf-label_limit" id="viwcpf-label_limit"
                   placeholder="<?php esc_attr_e('Default value is 10', 'pofily-woocommerce-product-filters'); ?>"
                   min="1"
                   value="<?php echo esc_attr($view_more_limit); ?>">
        </div>
        <span class="explanatory-text"><?php esc_html_e('Enter items number limit you want to display', 'pofily-woocommerce-product-filters') ?></span>
    </div>
</div>
</div>
<!--<div class="vi-ui grid segment detail_wrap_preview">-->
<!---->
<!--</div>-->

