<?php

if ( PWB_PRO_PLUGIN_IS_WC ) {
	add_action(
		'woocommerce_init',
		function () {
			add_filter(
				'pwb_admin_settings_tabs',
				function( $tabs ) {

					$tabs = array_filter(
						$tabs,
						function( $tab ) {

							if ( isset( $tab['title'] ) && in_array( $tab['title'], array( 'Premium', 'Suggestions', 'Documentation' ) ) ) {
								return false;
							}

						return true;
						}
					);

					return $tabs;
				}
			);
		},
		100
	);
	add_filter(
		'plugin_row_meta',
		function ( $plugin_meta, $plugin_file, $plugin_data, $status ) {
			if ( plugin_basename( PWB_PRO_PLUGIN_FILE ) === $plugin_file ) {

				// Replace Author URI
				if ( ! empty( $plugin_data['AuthorURI'] ) ) {
					$plugin_meta[1] = esc_html__( 'By' ) . ' <a target="_blank" href="' . esc_url( 'https://woocommerce.com/vendor/quadlayers/' ) . '">QuadLayers</a>';
				}
				// Replace Plugin URI
				if ( ! empty( $plugin_data['PluginURI'] ) ) {
					$plugin_meta[2] = '<a target="_blank" href="' . esc_url( 'https://woocommerce.com/products/perfect-brands-for-woocommerce/' ) . '">' . esc_html__( 'Visit plugin site', 'perfect-woocommerce-brands-pro' ) . '</a>';
				}
			}
			return $plugin_meta;
		},
		100,
		4
	);
}
