<?php

namespace QuadLayers\PWB_PRO\Backend\Controller\Settings;

class License {

	protected static $instance;

	public function __construct() {
		add_filter(
			'pwb_admin_settings_tabs',
			function ( $tabs ) {

				global $pwb_license_client;

				if ( ! isset( $pwb_license_client->plugin ) ) {
					return $tabs;
				}

				$license_menu_url = $pwb_license_client->plugin->get_menu_license_url();

				$tabs[] = array(
					'title' => esc_html__( 'License', 'perfect-woocommerce-brands-pro' ),
					'href'  => $license_menu_url,
				);

				return $tabs;
			}
		);
	}

	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
}
