<?php

namespace QuadLayers\PWB_PRO\Backend\Controller;

class Load {

	protected static $instance;

	public function __construct() {

		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ), 10 );

		Settings\License::instance();
	}

	public function enqueue_scripts() {

		$screen = get_current_screen();

		if ( ! isset( $screen->id ) || ! in_array( $screen->id, array( 'shop_subscription' ) ) ) {
			return;
		}

		wp_enqueue_script( 'pwb-admin' );
		wp_enqueue_style( 'pwb-admin' );
	}

	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
}
