<?php
/**
 * Outputs the Attributes metabox when adding/editing a Content Groups
 *
 * @package Page_Generator_Pro
 * @author WP Zinc
 */

?>
<!-- Group Parent -->
<div class="wpzinc-option">
	<div class="full">
		<label for="parent"><?php esc_html_e( 'Group Parent', 'page-generator-pro' ); ?></label>
	</div>
	<div class="full">
		<?php
		echo $parent_groups_dropdown; // phpcs:ignore WordPress.Security.EscapeOutput

		if ( $parent_group_id ) {
			?>
			<a href="post.php?post=<?php echo esc_attr( $parent_group_id ); ?>&action=edit" target="_blank"><?php esc_html_e( 'Edit Parent Group', 'page-generator-pro' ); ?></a>
			<?php
		}
		?>
	</div>

	<p class="description">
		<?php esc_html_e( 'To make generated Page(s) / Post(s) from this Group be children of existing Page / Posts generated by another Group, select the Parent Group here.', 'page-generator-pro' ); ?>
	</p>
</div>

<!-- Parent -->
<div class="wpzinc-option sidebar">
	<div class="full">
		<label for="parent"><?php esc_html_e( 'Parent', 'page-generator-pro' ); ?></label>
	</div>
	<div class="full">
		<?php
		// For each hierarchical post type, output a Post ID field.
		if ( is_array( $hierarchical_post_types ) && count( $hierarchical_post_types ) > 0 ) {
			foreach ( $hierarchical_post_types as $key => $hierarchical_post_type ) {
				?>
				<input type="text" id="parent" name="<?php echo esc_attr( $this->base->plugin->name ) . '[pageParent][' . esc_attr( $key ) . ']'; ?>" class="post-type-conditional <?php echo esc_attr( $key ); ?> widefat" value="<?php echo esc_attr( isset( $this->settings['pageParent'][ $key ] ) ? $this->settings['pageParent'][ $key ] : '' ); ?>" />
				<?php
			}
		}
		?>
	</div>

	<p class="description">
		<?php esc_html_e( 'To make generated Page(s) / Post(s) the child of an existing Page / Post, enter the parent Page / Post ID or Name (Slug) here.', 'page-generator-pro' ); ?><br />
		<a href="<?php echo esc_attr( $this->base->plugin->documentation_url ); ?>/generate-content/#fields--attributes" rel="noopener" target="_blank">
			<?php esc_html_e( 'How to find the Parent Page ID', 'page-generator-pro' ); ?>
		</a>
	</p>
</div>
