(function ($) {
  'use strict';

  window.initate_out_of_the_box_media = function (listtoken) {

    var self = $('.media[data-token="' + listtoken + '"]');

    if (self.hasClass('audio')) {
      load_audio_player(listtoken);
    }

    if (self.hasClass('video')) {
      load_video_player(listtoken);
    }
  }

  function load_audio_player(listtoken) {
    var self = $('.media.audio[data-token="' + listtoken + '"]');

    var extensions = self.attr('data-extensions');
    var autoplay = self.attr('data-autoplay');
    var $jPlayer = self.find('.jp-jplayer');
    var jPlayerSelector = '#' + self.find('.jp-jplayer').attr('id');
    var cssSelector = '#' + self.find('.jp-video').attr('id');

    oftb_playlists[listtoken] = new jPlayerPlaylist({
      jPlayer: jPlayerSelector,
      cssSelectorAncestor: cssSelector
    }, [], {
      playlistOptions: {
        autoPlay: (autoplay === '1' ? true : false)
      },
      swfPath: OutoftheBox_vars.js_url,
      supplied: extensions,
      solution: "html,flash",
      wmode: "window",
      size: {
        width: "100%",
        height: "0px"
      },
      volume: 1,
      ready: function () {
        var data = {
          action: 'outofthebox-get-playlist',
          lastFolder: self.attr('data-id'),
          sort: self.attr('data-sort'),
          listtoken: listtoken,
          _ajax_nonce: OutoftheBox_vars.getplaylist_nonce
        };
        $.ajaxQueue({
          type: "POST",
          url: OutoftheBox_vars.ajax_url,
          data: data,
          success: function (result) {
            if (result instanceof Array) {
              oftb_playlists[listtoken].setPlaylist(result);

              $jPlayer.css('opacity', '100');

              if (!self.find(".jp-playlist").hasClass('hideonstart')) {
                self.find(".jp-playlist").slideDown("slow");
              }

              self.find(".jp-playlist-item-dl").unbind('click');
              self.find(".jp-playlist-item-dl").click(function (e) {
                e.stopPropagation();
                var href = $(this).attr('href') + '&dl=1',
                        dataname = self.find(".jp-playlist-item.jp-playlist-current  .jp-playlist-item-song-title").html() +
                        " - " + self.find(".jp-playlist-item.jp-playlist-current  .jp-playlist-item-song-artist").html();

                sendGooglePageView('Download', dataname);

                // Delay a few milliseconds for Tracking event
                setTimeout(function () {
                  window.location = href;
                }, 300);

                return false;

              });

              switchSong(listtoken);
            } else {

              self.find(".jp-playlist-item-song-title").html(OutoftheBox_vars.str_error);
              self.find(".jp-playlist-item-song-artist").html(OutoftheBox_vars.str_xhrError_title);
              $jPlayer.fadeOut();
            }
          },
          error: function () {
            self.find(".jp-playlist-item-song-title").html(OutoftheBox_vars.str_error);
            self.find(".jp-playlist-item-song-artist").html(OutoftheBox_vars.str_xhrError_title);
            $jPlayer.fadeOut();
          },
          dataType: 'json'
        });

        $jPlayer.find("img").imagesLoaded(function () {
          $jPlayer.stop().delay(1500).animate({height: "200px"});
        });
      },
      play: function (e) {
        var dataname = self.find(".jp-playlist-item.jp-playlist-current  .jp-playlist-item-song-title").html() +
                " - " + self.find(".jp-playlist-item.jp-playlist-current  .jp-playlist-item-song-artist").html();
        switchSong(listtoken);
        sendGooglePageView('Play Music', dataname);
      },
      loadstart: function (e) {
        var $song_title = self.find('.jp-playlist ul li.jp-playlist-current .jp-playlist-current .jp-playlist-item-song-title').html();
        self.find('.jp-song-title .jp-playlist-item-song-title').html($song_title);
        self.find('.jp-song-title .jp-playlist-item-song-artist').html('<i class="fas fa-circle-notch fa-spin fa-fw"></i>');

      },
      loadedmetadata: function (e) {
        var $song_title = self.find('.jp-playlist ul li.jp-playlist-current .jp-playlist-item-song-title').html();
        var $song_artist = self.find('.jp-playlist ul li.jp-playlist-current .jp-playlist-item-song-artist').html();
        self.find('.jp-song-title .jp-playlist-item-song-title').html($song_title);
        self.find('.jp-song-title .jp-playlist-item-song-artist').html('').html($song_artist);
      }
    });
  }

  function load_video_player(listtoken) {

    var self = $('.media.video[data-token="' + listtoken + '"]');

    var extensions = self.attr('data-extensions');
    var autoplay = self.attr('data-autoplay');
    var $jPlayer = self.find('.jp-jplayer');
    var jPlayerSelector = '#' + self.find('.jp-jplayer').attr('id');
    var cssSelector = '#' + self.find('.jp-video').attr('id');


    oftb_playlists[listtoken] = new jPlayerPlaylist({
      jPlayer: jPlayerSelector,
      cssSelectorAncestor: cssSelector
    }, [], {
      playlistOptions: {
        autoPlay: (autoplay === '1' ? true : false)
      },
      swfPath: OutoftheBox_vars.js_url,
      supplied: extensions,
      solution: "html,flash",
      volume: 1,
      audioFullScreen: true,
      errorAlerts: false,
      warningAlerts: false,
      size: {
        width: "100%",
        height: "100%"
      },
      ready: function (e) {
        var data = {
          action: 'outofthebox-get-playlist',
          lastFolder: self.attr('data-id'),
          sort: self.attr('data-sort'),
          listtoken: listtoken,
          _ajax_nonce: OutoftheBox_vars.getplaylist_nonce
        };
        $.ajaxQueue({
          type: "POST",
          url: OutoftheBox_vars.ajax_url,
          data: data,
          success: function (result) {
            if (result instanceof Array) {
              oftb_playlists[listtoken].setPlaylist(result);

              $jPlayer.css('opacity', '100');

              if (!self.find(".jp-playlist").hasClass('hideonstart')) {
                self.find(".jp-playlist").slideDown("slow");
              }
              self.find(".jp-playlist-item-dl").unbind('click');
              self.find(".jp-playlist-item-dl").click(function (e) {
                e.stopPropagation();
                var href = $(this).attr('href') + '&dl=1',
                        dataname = self.find(".jp-playlist-item.jp-playlist-current  .jp-playlist-item-song-title").html() +
                        " - " + self.find(".jp-playlist-item.jp-playlist-current  .jp-playlist-item-song-artist").html();

                sendGooglePageView('Download', dataname);

                // Delay a few milliseconds for Tracking event
                setTimeout(function () {
                  window.location = href;
                }, 300);

                return false;

              });
            } else {
              self.find(".jp-playlist-item-song-title").html(OutoftheBox_vars.str_error);
              self.find(".jp-playlist-item-song-artist").html(OutoftheBox_vars.str_xhrError_title);
              $jPlayer.fadeOut();
            }
            switchSong(listtoken);
          },
          error: function () {
            self.find(".jp-playlist-item-song-title").html(OutoftheBox_vars.str_error);
            self.find(".jp-playlist-item-song-artist").html(OutoftheBox_vars.str_xhrError_title);
            $jPlayer.fadeOut();
          },
          dataType: 'json'
        });
        $jPlayer.height($jPlayer.width() / 1.6);
        self.find("object").width('100%').height($jPlayer.height());
        self.find(".jp-video-play").height($jPlayer.height());

      },
      ended: function (e) {

      },
      pause: function (e) {
        self.find(".jp-video-play").height($jPlayer.height());
      },
      loadstart: function (e) {

        var $song_title = self.find('.jp-playlist ul li.jp-playlist-current .jp-playlist-current .jp-playlist-item-song-title').html();
        self.find('.jp-song-title .jp-playlist-item-song-title').html($song_title);
        self.find('.jp-song-title .jp-playlist-item-song-artist').html('<i class="fas fa-circle-notch fa-spin fa-fw"></i>');

      },
      loadedmetadata: function (e) {

        if (e.jPlayer.status.videoHeight !== 0 && e.jPlayer.status.videoWidth !== 0) {
          var ratio = e.jPlayer.status.videoWidth / e.jPlayer.status.videoHeight;
          var videoselector = self.find("object");
          if (e.jPlayer.html.active === true) {
            videoselector = self.find("video");
            videoselector.bind('contextmenu', function () {
              return false;
            });
          }
          if (videoselector.height() === 0 || videoselector.height() !== videoselector.parent().width() / ratio) {
            videoselector.width(videoselector.parent().width());
            videoselector.height(videoselector.width() / ratio);
            $jPlayer.animate({height: (videoselector.width() / ratio)});
          }
          $jPlayer.find("img").hide();
        }

        var $song_title = self.find('.jp-playlist ul li.jp-playlist-current .jp-playlist-current .jp-playlist-item-song-title').html();
        self.find('.jp-song-title .jp-playlist-item-song-title').html($song_title);
        self.find('.jp-song-title .jp-playlist-item-song-artist').fadeOut();
      },
      waiting: function (e) {
        var videoselector = $jPlayer.find("object");
        if (e.jPlayer.html.active === true) {
          videoselector = $jPlayer.find(" video");
          videoselector.bind('contextmenu', function () {
            return false;
          });
        }
        $jPlayer.find(".jp-video-play").height($jPlayer.height());
      },
      resize: function (e) {

      },
      play: function (e) {

        var dataname = $jPlayer.find(".jp-playlist-item.jp-playlist-current  .jp-playlist-item-song-title").html() +
                " - " + $jPlayer.find(".jp-playlist-item.jp-playlist-current  .jp-playlist-item-song-artist").html();
        sendGooglePageView('Play Video', dataname);
        switchSong(listtoken);
      }
    });

  }

  function switchSong(listtoken) {
    var self = $('.media.video[data-token="' + listtoken + '"]');

    self.find(".jp-previous").removeClass('disabled');
    self.find(".jp-next").removeClass('disabled');

    if ((self.find('.jp-playlist ul li:last-child')).hasClass('jp-playlist-current')) {
      self.find(".jp-next").addClass('disabled');
    }

    if ((self.find('.jp-playlist ul li:first-child')).hasClass('jp-playlist-current')) {
      self.find(".jp-previous").addClass('disabled');
    }

    var $song_title = self.find('.jp-playlist ul li.jp-playlist-current .jp-playlist-current .jp-playlist-item-song-title').html();
    var $song_artist = self.find('.jp-playlist ul li.jp-playlist-current .jp-playlist-current .jp-playlist-item-song-artist').html();
    self.find('.jp-song-title .jp-playlist-item-song-title').html($song_title);
    self.find('.jp-song-title .jp-playlist-item-song-artist').html('').html($song_artist);

  }

  $(".media .jp-playlist-toggle").unbind('click').click(function () {
    var $this = $(this).closest('.media');
    $this.find(".jp-playlist").slideToggle("slow");
  });

  var ajaxQueue = $({});

  $.ajaxQueue = function (ajaxOpts) {

    var oldComplete = ajaxOpts.complete;

    ajaxQueue.queue(function (next) {

      ajaxOpts.complete = function () {
        if (oldComplete)
          oldComplete.apply(this, arguments);

        next();
      };

      $.ajax(ajaxOpts);
    });
  };
})(jQuery);