<?php

namespace TheLion\OutoftheBox;

use \Kunnu\Dropbox\Dropbox;
use \Kunnu\Dropbox\DropboxApp;

class App {

    /**
     * 
     * @var string 
     */
    private $_access_token = null;

    /**
     *
     * @var string 
     */
    private $_root_namespace_id = '';

    /**
     * 
     * @var string 
     */
    private $_account_type = '';

    /**
     *
     * @var bool 
     */
    private $_own_app = false;

    /**
     *
     * @var string 
     */
    private $_app_key = 'm3n3zyvyr59cdjb';

    /**
     *
     * @var string 
     */
    private $_app_secret = 'eu73x5upk7ehes4';

    /**
     *
     * @var string 
     */
    private $_identifier;

    /**
     * 
     * @var \Kunnu\Dropbox\Dropbox
     */
    private $_client = null;

    /**
     * 
     * @var \Kunnu\Dropbox\DropboxApp
     */
    private $_client_app = null;

    /**

     * We don't save your data or share it. 
     * This script just simply creates a redirect with your id and secret to Dropbox and returns the created token.
     * It is exactly the same script as the _authorizeApp.php file in the includes folder of the plugin, 
     * and is used for an easy and one-click authorization process that will always work!
     * 
     * @var string 
     */
    private $_redirect_uri = 'https://www.wpcloudplugins.com:443/out-of-the-box/_AuthorizeApp.php';

    /**
     *
     * @var \TheLion\OutoftheBox\Processor 
     */
    private $_processor;

    public function __construct(Processor $processor) {
        $this->_processor = $processor;
        require_once OUTOFTHEBOX_ROOTDIR . '/includes/dropbox-sdk/vendor/autoload.php';

        $own_key = $this->get_processor()->get_setting('dropbox_app_key');
        $own_secret = $this->get_processor()->get_setting('dropbox_app_secret');

        if (
                (!empty($own_key)) &&
                (!empty($own_secret))
        ) {
            $this->_app_key = $this->get_processor()->get_setting('dropbox_app_key');
            $this->_app_secret = $this->get_processor()->get_setting('dropbox_app_secret');
            $this->_own_app = true;
        }

        /* Set right redirect URL */
        $this->set_redirect_uri();

        /* Process codes/tokens if needed */
        $this->process_authorization();

        $this->_access_token = $this->get_processor()->get_setting('dropbox_app_token');

        $this->_root_namespace_id = $this->get_processor()->get_setting('dropbox_root_namespace_id');
        $this->_account_type = $this->get_processor()->get_setting('dropbox_account_type');

        if ($this->get_processor()->is_network_authorized()) {
            $settings = get_site_option('outofthebox_network_settings', array());
            $this->_root_namespace_id = $settings['dropbox_root_namespace_id'];
            $this->_account_type = $settings['dropbox_account_type'];
        }
    }

    public function process_authorization() {

        if (isset($_REQUEST['action']) && $_REQUEST['action'] !== 'outofthebox_authorization') {
            return false;
        } elseif (!empty($_REQUEST['state'])) {
            $state = (strtr($_REQUEST['state'], '-_~', '+/='));

            $csrfToken = $state;
            $urlState = null;

            $splitPos = strpos($state, "|");

            if ($splitPos !== false) {
                $csrfToken = substr($state, 0, $splitPos);
                $urlState = substr($state, $splitPos + 1);
            }
            $redirectto = base64_decode($urlState);

            if (strpos($redirectto, 'outofthebox_authorization') === false) {
                return false;
            }
        } else {
            return false;
        }

        $this->get_processor()->reset_complete_cache();

        $redirect = admin_url('admin.php?page=OutoftheBox_settings');
        if (isset($_GET['network'])) {
            $redirect = network_admin_url('admin.php?page=OutoftheBox_network_settings');
        }

        if (isset($_GET['code'])) {
            $access_token = $this->create_access_token();
            /** Echo To Popup */
            echo '<script type="text/javascript">window.opener.parent.location.href = "' . $redirect . '"; window.close();</script>';
            die();
        } elseif (isset($_GET['_token'])) {
            $new_access_token = $_GET['_token'];
            $access_token = $this->set_access_token($new_access_token);

            /** Echo To Popup */
            echo '<script type="text/javascript">window.opener.parent.location.href = "' . $redirect . '"; window.close();</script>';
            die();
        }



        return false;
    }

    public function can_do_own_auth() {
        $blog_url = parse_url(admin_url());
        return ($blog_url['scheme'] === 'https' || $blog_url['host'] === 'localhost');
    }

    public function has_plugin_own_app() {
        return $this->_own_app;
    }

    public function get_auth_url() {
        $auth_helper = $this->get_client()->getAuthHelper();

        if ($this->get_processor()->is_network_authorized()) {
            $redirect = network_admin_url('admin.php?page=OutoftheBox_network_settings&action=outofthebox_authorization&network=1');
        } else {
            $redirect = admin_url('admin.php?page=OutoftheBox_settings&action=outofthebox_authorization');
        }

        $encodedredirect = strtr(base64_encode($redirect), '+/=', '-_~');

        return $auth_helper->getAuthUrl($this->get_redirect_uri(), array(), $encodedredirect);
    }

    public function start_client() {
        
    }

    public function create_access_token() {
        try {
            $code = $_REQUEST['code'];
            $state = $_REQUEST['state'];

            //Fetch the AccessToken
            $accessToken = $this->get_client()->getAuthHelper()->getAccessToken($code, $state, $this->get_redirect_uri());
            $this->set_access_token($accessToken->getToken());
        } catch (\Exception $ex) {
            return new \WP_Error('broke', __("error communicating with Dropbox API: ", 'outofthebox') . $ex->getMessage());
        }

        return true;
    }

    public function revoke_token() {
        try {
            $this->get_client()->getAuthHelper()->revokeAccessToken();
        } catch (\Exception $ex) {
            
        }

        $this->get_processor()->set_setting('userfolder_backend_auto_root', null);
        $this->set_root_namespace_id('');
        $this->set_access_token(null);
        $this->set_account_type('');

        if (($timestamp = wp_next_scheduled('outofthebox_lost_authorisation_notification')) !== false) {
            wp_unschedule_event($timestamp, 'outofthebox_lost_authorisation_notification');
        }

        $this->get_processor()->get_main()->send_lost_authorisation_notification();
    }

    public function get_app_key() {
        return $this->_app_key;
    }

    public function get_app_secret() {
        return $this->_app_secret;
    }

    public function set_app_key($_app_key) {
        $this->_app_key = $_app_key;
    }

    public function set_app_secret($_app_secret) {
        $this->_app_secret = $_app_secret;
    }

    public function get_access_token() {
        return $this->_access_token;
    }

    public function set_access_token($_access_token) {

        /* Remove Lost Authorisation message */
        if (($timestamp = wp_next_scheduled('outofthebox_lost_authorisation_notification')) !== false) {
            wp_unschedule_event($timestamp, 'outofthebox_lost_authorisation_notification');
        }

        $this->_access_token = $_access_token;
        $this->get_processor()->get_cache()->reset_cache();

        if ($this->get_processor()->is_network_authorized()) {
            $settings = get_site_option('outofthebox_network_settings', array());
            $settings['dropbox_app_token'] = $_access_token;
            return update_site_option('outofthebox_network_settings', $settings);
        } else {
            return $this->get_processor()->set_setting('dropbox_app_token', $_access_token);
        }
    }

    public function has_access_token() {
        return (!empty($this->_access_token));
    }

    public function get_root_namespace_id() {

        if (empty($this->_root_namespace_id)) {
            try {
                $account = $this->_client->getCurrentAccount();
            } catch (\Exception $ex) {
                error_log('[Out-of-the-Box message]: ' . sprintf('API Error on line %s: %s', __LINE__, $ex->getMessage()));
                return '';
            }

            $root_info = $account->getRootInfo();
            $root_namespace_id = $root_info['root_namespace_id'];
            $this->set_root_namespace_id($root_namespace_id);
        }

        return $this->_root_namespace_id;
    }

    public function set_root_namespace_id($_root_namespace_id) {
        $this->_root_namespace_id = $_root_namespace_id;

        if ($this->get_processor()->is_network_authorized()) {
            $settings = get_site_option('outofthebox_network_settings', array());
            $settings['dropbox_root_namespace_id'] = $_root_namespace_id;
            update_site_option('outofthebox_network_settings', $settings);
        }

        return $this->get_processor()->set_setting('dropbox_root_namespace_id', $_root_namespace_id);
    }

    public function get_account_type() {

        if (empty($this->_account_type) && !empty($this->_access_token)) {
            try {
                $account = $this->get_client()->getCurrentAccount();
            } catch (\Exception $ex) {
                error_log('[Out-of-the-Box message]: ' . sprintf('API Error on line %s: %s', __LINE__, $ex->getMessage()));
                return '';
            }

            $account_type = $account->getAccountType();
            $this->set_account_type($account_type);
        }

        return $this->_account_type;
    }

    public function set_account_type($_account_type) {
        $this->_account_type = $_account_type;

        if ($this->get_processor()->is_network_authorized()) {
            $settings = get_site_option('outofthebox_network_settings', array());
            $settings['dropbox_account_type'] = $_account_type;
            update_site_option('outofthebox_network_settings', $settings);
        }

        return $this->get_processor()->set_setting('dropbox_account_type', $_account_type);
    }

    /**
     * 
     * @return \TheLion\OutoftheBox\Processor
     */
    public function get_processor() {
        return $this->_processor;
    }

    /**
     * 
     * @return \Kunnu\Dropbox\Dropbox
     */
    public function get_client() {
        if (empty($this->_client)) {
            $this->_client = new Dropbox($this->get_client_app(), array('persistent_data_store' => new \Kunnu\Dropbox\Store\DatabasePersistentDataStore()));
        }

        /* Set the right Root Folder for the Dropbox */
        if (!defined('OUTOFTHEBOX_ROOT_NAMESPACE_ID')) {

            $use_team_folders = $this->get_processor()->get_setting('use_team_folders') === 'Yes';
            if ($this->get_processor()->is_network_authorized()) {
                $settings = get_site_option('outofthebox_network_settings', array());
                $use_team_folders = $settings['use_team_folders'] === 'Yes';
            }

            if ($use_team_folders && !empty($this->_access_token) && $this->get_root_namespace_id() !== '') {
                define('OUTOFTHEBOX_ROOT_NAMESPACE_ID', $this->get_root_namespace_id());
            }
        }

        return $this->_client;
    }

    /**
     * 
     * @return \Kunnu\Dropbox\DropboxApp
     */
    public function get_client_app() {
        if (empty($this->_client_app)) {
            $this->_client_app = new DropboxApp($this->get_app_key(), $this->get_app_secret(), $this->get_access_token());
        }

        return $this->_client_app;
    }

    public function get_redirect_uri() {
        return $this->_redirect_uri;
    }

    public function set_redirect_uri() {
        if ($this->can_do_own_auth() && $this->has_plugin_own_app()) {

            $this->_redirect_uri = admin_url('admin.php?page=OutoftheBox_settings');
            if (isset($_GET['network'])) {
                $this->_redirect_uri = network_admin_url('admin.php?page=OutoftheBox_network_settings');
            }
        }
    }

}
