<?php

namespace TheLion\OutoftheBox;

class Filebrowser {

    /**
     *
     * @var \TheLion\OutoftheBox\Processor 
     */
    private $_processor;
    private $_search = false;
    private $_parentfolders = array();
    private $_layout;

    public function __construct(Processor $_processor) {
        $this->_processor = $_processor;
    }

    /**
     * 
     * @return \TheLion\OutoftheBox\Processor 
     */
    public function get_processor() {
        return $this->_processor;
    }

    public function get_files_list() {

        $this->_folder = $this->get_processor()->get_client()->get_folder();

        if (($this->_folder !== false)) {
            $this->setLayout();
            $this->renderFileList();
        }
    }

    public function search_files() {
        $this->_search = true;
        $input = mb_strtolower($_REQUEST['query'], 'UTF-8');
        $this->_folder = $this->get_processor()->get_client()->search($input);

        if (($this->_folder !== false)) {
            $this->setLayout();
            $this->renderFileList();
        }
    }

    public function setLayout() {

        /* Set layout */
        $this->_layout = $this->get_processor()->get_shortcode_option('filelayout');
        if (isset($_REQUEST['filelayout'])) {
            switch ($_REQUEST['filelayout']) {
                case 'grid':
                    $this->_layout = 'grid';
                    break;
                case 'list':
                    $this->_layout = 'list';
                    break;
            }
        }
    }

    public function renderFileList() {

        /* Create HTML Filelist */
        $filelist_html = "";

        $filelist_html = "<div class='files layout-" . $this->_layout . "'>";

        // Add 'back to Previous folder' if needed
        if (
                ($this->_search === false) &&
                ($this->_folder->get_path() !== '') &&
                (strtolower($this->_folder->get_path()) !== strtolower($this->get_processor()->get_root_folder()))
        ) {


            $foldername = basename($this->_folder->get_path());
            $location = str_replace('\\', '/', (dirname($this->get_processor()->get_requested_path())));

            $parent_folder_entry = new Entry();
            $parent_folder_entry->set_id('Previous Folder');
            $parent_folder_entry->set_name(__('Previous folder', 'outofthebox'));
            $parent_folder_entry->set_path($location);
            $parent_folder_entry->set_path_display($location);
            $parent_folder_entry->set_is_dir(true);
            $parent_folder_entry->set_parent_folder(true);
            $parent_folder_entry->set_icon(OUTOFTHEBOX_ROOTPATH . '/css/icons/32x32/folder-grey.png');

            if ($this->_layout === 'list') {
                $filelist_html .= $this->renderDirForList($parent_folder_entry);
            } elseif ($this->_layout === 'grid') {
                $filelist_html .= $this->renderDirForGrid($parent_folder_entry);
            }
        }


        /* Limit the number of files if needed */
        if ($this->get_processor()->get_shortcode_option('max_files') !== '-1' && $this->_folder->has_children()) {
            $children = $this->_folder->get_children();
            $children_sliced = array_slice($children, 0, (int) $this->get_processor()->get_shortcode_option('max_files'));
            $this->_folder->set_children($children_sliced);
        }

        if ($this->_folder->has_children()) {

            $hasfilesorfolders = false;

            foreach ($this->_folder->get_children() as $item) {
                /* Render folder div */
                if ($item->is_dir()) {
                    if ($this->_layout === 'list') {
                        $filelist_html .= $this->renderDirForList($item);
                    } elseif ($this->_layout === 'grid') {
                        $filelist_html .= $this->renderDirForGrid($item);
                    }


                    if (!$item->is_parent_folder()) {
                        $hasfilesorfolders = true;
                    }
                }
            }
        }

        if ($this->_search === false) {
            if ($this->_layout === 'list') {
                $filelist_html .= $this->renderNewFolderForList();
            } elseif ($this->_layout === 'grid') {
                $filelist_html .= $this->renderNewFolderForGrid();
            }
        }

        if ($this->_folder->has_children()) {
            foreach ($this->_folder->get_children() as $item) {
                /* Render files div */
                if ($item->is_file()) {
                    if ($this->_layout === 'list') {
                        $filelist_html .= $this->renderFileForList($item);
                    } elseif ($this->_layout === 'grid') {
                        $filelist_html .= $this->renderFileForGrid($item);
                    }
                    $hasfilesorfolders = true;
                }
            }

            if ($hasfilesorfolders === false) {
                if ($this->get_processor()->get_shortcode_option('show_files') === '1') {
                    $filelist_html .= $this->renderNoResults();
                }
            }
        } else {
            if ($this->get_processor()->get_shortcode_option('show_files') === '1' || $this->_search === true) {
                $filelist_html .= $this->renderNoResults();
            }
        }

        $filelist_html .= "</div>";

        /* Create HTML Filelist title */
        $spacer = ' &raquo; ';

        $breadcrumbelements = array_filter(explode('/', $this->get_processor()->get_requested_path()));

        $location = '';
        foreach ($breadcrumbelements as &$element) {
            $location .= '/' . $element;
            $class = 'folder';
            if (basename($this->get_processor()->get_requested_path()) == $element) {
                $class .= ' current_folder';
            }
            $element = "<a href='javascript:void(0)' class='" . $class . "' data-url='" . rawurlencode($location) . "'>" . $element . "</a>";
        }

        if (($this->get_processor()->get_shortcode_option('show_root') === '1') && ($this->get_processor()->get_root_folder() != '/')) {
            $startelement = "<a href='javascript:void(0)' class='folder' data-url='" . rawurlencode('/') . "'>" . ltrim($this->get_processor()->get_root_folder(), '/') . "</a>";
            array_unshift($breadcrumbelements, $startelement);
        } else {
            $userfolder_name = $this->get_processor()->get_user_folders()->get_auto_linked_folder_name_for_user();
            $startelement = "<a href='javascript:void(0)' class='folder' data-url='" . rawurlencode('/') . "'>" . $this->get_processor()->get_shortcode_option('root_text') . "</a>";

            array_unshift($breadcrumbelements, $startelement);
        }

        $filepath = implode($spacer, $breadcrumbelements);

        $raw_path = '';
        if (
                (\TheLion\OutoftheBox\Helpers::check_user_role($this->get_processor()->get_setting('permissions_add_shortcodes'))) ||
                (\TheLion\OutoftheBox\Helpers::check_user_role($this->get_processor()->get_setting('permissions_add_links'))) ||
                (\TheLion\OutoftheBox\Helpers::check_user_role($this->get_processor()->get_setting('permissions_add_embedded')))
        ) {
            $raw_path = ($this->_folder->get_path() !== null) ? $this->_folder->get_path() : '';
        }


        if ($this->_search === true) {
            $expires = 0;
        } else {
            $expires = time() + 60 * 5;
        }

        $response = json_encode(array(
            'lastpath' => rawurlencode($this->get_processor()->get_last_path()),
            'rawpath' => $raw_path,
            'breadcrumb' => $filepath,
            'html' => $filelist_html,
            'expires' => $expires));


        $cached_request = new CacheRequest($this->get_processor());
        $cached_request->add_cached_response($response);

        echo $response;
        die();
    }

    public function renderNoResults() {

        $html = '';

        if ($this->_layout === 'list') {
            $html .= '
  <div class="entry folder no-entries">
<div class="entry_icon">
<img src="' . OUTOFTHEBOX_ROOTPATH . '/css/images/loader_no_results.png" ></div>
<div class="entry_name"><a class="entry_link">' . __('No files or folders found', 'outofthebox') . '</a></div></div>
';
        } else {
            $html .= '<div class="entry file no-entries">
<div class="entry_block">
<div class="entry_thumbnail"><div class="entry_thumbnail-view-bottom"><div class="entry_thumbnail-view-center">
<a class="entry_link"><img class="preloading" src="' . OUTOFTHEBOX_ROOTPATH . '/css/images/transparant.png" data-src="' . OUTOFTHEBOX_ROOTPATH . '/css/images/loader_no_results.png" data-src-retina="' . OUTOFTHEBOX_ROOTPATH . '/css/images/loader_no_results.png"></a></div></div></div>
<div class="entry_name"><a class="entry_link"><div class="entry-name-view"><span><strong>' . __('No files or folders found', 'outofthebox') . '</strong></span></div></a></div>
</div>
</div>';
        }

        return $html;
    }

    public function renderDirForList(Entry $item) {
        $return = '';

        $classmoveable = ($this->get_processor()->get_user()->can_move()) ? 'moveable' : '';
        $style = ($item->is_parent_folder()) ? ' previous ' : '';

        $return .= "<div class='entry folder $classmoveable $style' data-url='" . rawurlencode($item->get_path_display()) . "' data-name=\"" . htmlentities($item->get_basename(), ENT_QUOTES | ENT_HTML401) . "\">\n";
        $return .= "<div class='entry_icon' data-url='" . rawurlencode($item->get_path_display()) . "'><img src='" . $item->get_icon() . "'/></div>\n";

        if ($item->is_parent_folder() === false) {

            if ($this->get_processor()->get_shortcode_option('mcepopup') === 'linkto' || $this->get_processor()->get_shortcode_option('mcepopup') === 'linktobackendglobal') {
                $return .= "<div class='entry_linkto'>\n";
                $return .= "<span>" . "<input class='button-secondary' type='submit' title='" . __('Select folder', 'outofthebox') . "' value='" . __('Select folder', 'outofthebox') . "'>" . '</span>';
                $return .= "</div>";
            }

            if ($this->get_processor()->get_user()->can_download_zip() || $this->get_processor()->get_user()->can_delete_folders()) {
                $return .= "<div class='entry_checkbox'><input type='checkbox' name='selected-files[]' class='selected-files' value='" . rawurlencode($item->get_name()) . "'/></div>";
            }

            if ($this->get_processor()->get_shortcode_option('mcepopup') === 'links') {
                $return .= "<div class='entry_checkbox'><input type='checkbox' name='selected-files[]' class='selected-files' value='" . rawurlencode($item->get_name()) . "'/></div>";
            }

            $return .= "<div class='entry_edit'>";
            $return .= $this->renderEditItem($item);
            $return .= "</div>";

            $return .= "<div class='entry_name'><a class='entry_link' title='{$item->get_basename()}'><span>" . $item->get_basename() . "</span></a></div>";
        } else {
            $return .= "<div class='entry_name'><a class='entry_link' title='{$item->get_basename()}'><span>" . $item->get_name() . "</span></a></div>";
        }

        $return .= "</div>\n";
        return $return;
    }

    public function renderDirForGrid(Entry $item) {
        $return = '';

        $classmoveable = ($this->get_processor()->get_user()->can_move()) ? 'moveable' : '';
        $style = ($item->is_parent_folder()) ? ' previous ' : '';

        $return .= "<div class='entry folder $classmoveable  $style' data-url='" . rawurlencode($item->get_path_display()) . "' data-name='" . htmlentities($item->get_basename(), ENT_QUOTES | ENT_HTML401) . "'>\n";
        if ($item->is_parent_folder() === false) {

            if ($this->get_processor()->get_shortcode_option('mcepopup') === 'linkto' || $this->get_processor()->get_shortcode_option('mcepopup') === 'linktobackendglobal') {
                $return .= "<div class='entry_linkto'>\n";
                $return .= "<span>" . "<input class='button-secondary' type='submit' title='" . __('Select folder', 'outofthebox') . "' value='" . __('Select folder', 'outofthebox') . "'>" . '</span>';
                $return .= "</div>";
            }
        }

        $return .= "<div class='entry_block'>\n";

        if ($item->is_parent_folder() === false) {
            $return .= "<div class='entry_edit'>";

            if ($this->get_processor()->get_user()->can_download_zip() || $this->get_processor()->get_user()->can_delete_folders()) {
                $return .= "<div class='entry_checkbox'><input type='checkbox' name='selected-files[]' class='selected-files' value='" . rawurlencode($item->get_name()) . "'/></div>";
            }

            if (($this->get_processor()->get_shortcode_option('mcepopup') === 'links')) {
                $return .= "<div class='entry_checkbox'><input type='checkbox' name='selected-files[]' class='selected-files' value='" . rawurlencode($item->get_name()) . "'/></div>";
            }

            $return .= $this->renderEditItem($item);
            $return .= "</div>";
        }

        $return .= "<div class='entry_thumbnail'><div class='entry_thumbnail-view-bottom'><div class='entry_thumbnail-view-center'>\n";
        $return .= "<a class='entry_link' title='{$item->get_basename()}'><div class='preloading'></div><img class='preloading' src='" . OUTOFTHEBOX_ROOTPATH . "/css/images/transparant.png' data-src='" . $item->get_icon_large() . "' data-src-retina='" . $item->get_icon_large() . "'/></a>";
        $return .= "</div></div></div>\n";
        $return .= "<div class='entry_name'><a class='entry_link' title='{$item->get_basename()}'><div class='entry-name-view'><span>";

        $return .= (($item->is_parent_folder()) ? '<strong>' . $item->get_name() . '</strong>' : $item->get_name()) . " </span></div></a>";
        $return .= "</div>\n";
        $return .= "</div>\n";
        $return .= "</div>\n";

        return $return;
    }

    public function renderFileForList(Entry $item) {
        $return = '';
        $classmoveable = ($this->get_processor()->get_user()->can_move()) ? 'moveable' : '';

        $thumbnail_url = ($item->has_own_thumbnail() ? $this->get_processor()->get_client()->get_thumbnail($item, true, 160, 160, false, 95) : false);

        $return .= "<div class='entry file $classmoveable' data-url='" . rawurlencode($item->get_path_display()) . "' data-name=\"" . $item->get_name() . "\" " . ((!empty($thumbnail_url)) ? "data-tooltip=''" : '') . ">\n";
        $return .= "<div class='entry_icon'><img src='" . $item->get_icon() . "'/></div>";

        $link = $this->renderFileNameLink($item);
        $title = $link['filename'] . ((($this->get_processor()->get_shortcode_option('show_filesize') === '1') && ($item->get_size() > 0)) ? ' (' . \TheLion\OutoftheBox\Helpers::bytes_to_size_1024($item->get_size()) . ')' : '&nbsp;');

        if ($this->get_processor()->get_user()->can_download_zip() || $this->get_processor()->get_user()->can_delete_files()) {
            $return .= "<div class='entry_checkbox'><input type='checkbox' name='selected-files[]' class='selected-files' value='" . rawurlencode($item->get_name()) . "'/></div>";
        }

        if (in_array($this->get_processor()->get_shortcode_option('mcepopup'), array('links', 'embedded'))) {
            $return .= "<div class='entry_checkbox'><input type='checkbox' name='selected-files[]' class='selected-files' value='" . rawurlencode($item->get_name()) . "'/></div>";
        }

        $return .= "<div class='entry_edit_placheholder'><div class='entry_edit'>";
        $return .= $this->renderEditItem($item);
        $return .= "</div></div>";


        $download_url = admin_url('admin-ajax.php') . "?action=outofthebox-download&OutoftheBoxpath=" . rawurlencode($item->get_path()) . "&lastpath=" . rawurlencode($this->get_processor()->get_last_path()) . "&listtoken=" . $this->get_processor()->get_listtoken() . "&dl=1";
        $caption = ($this->get_processor()->get_user()->can_download()) ? '<a href="' . $download_url . '" title="' . __('Download', 'outofthebox') . '"><i class="fas fa-arrow-circle-down" aria-hidden="true"></i></a>&nbsp' : '';
        $caption .= $link['filename'];

        $add_caption = true;
        if (in_array($item->get_extension(), array('mp4', 'm4v', 'ogg', 'ogv', 'webmv', 'mp3', 'm4a', 'ogg', 'oga', 'wav'))) {
            /* Don't overlap the player controls with the caption */
            $add_caption = false;
        }

        $return .= "<a {$link['url']} {$link['target']} class='{$link['class']}' title='$title' {$link['lightbox']} {$link['onclick']} data-filename='{$link['filename']}' " . (($add_caption) ? "data-caption='$caption'" : '') . ">";

        if ($this->get_processor()->get_shortcode_option('show_filesize') === '1') {
            $return .= "<div class='entry_size'>" . \TheLion\OutoftheBox\Helpers::bytes_to_size_1024($item->get_size()) . "</div>";
        }

        if ($this->get_processor()->get_shortcode_option('show_filedate') === '1') {
            $return .= "<div class='entry_lastedit'>" . $item->get_last_edited_str() . "</div>";
        }

        if (!empty($thumbnail_url)) {
            $return .= "<div class='description_textbox'>";
            $return .= "<div class='preloading'></div>";
            $return .= "<img class='preloading hidden' src='" . OUTOFTHEBOX_ROOTPATH . "/css/images/transparant.png' data-src='" . $thumbnail_url . "' data-src-retina='" . $thumbnail_url . "' data-src-backup='" . $item->get_icon_large() . "'/>";
            $return .= "</div>";
        }

        $return .= "<div class='entry_name'><span>" . $link['filename'];

        $return .= "</span></div>";

        if ($this->_search === true) {
            $return .= "<div class='entry_foundpath'>" . $item->get_path() . "</div>";
        }

        $return .= "</a>";

        $return .= $link['lightbox_inline'];
        $return .= "</div>\n";


        return $return;
    }

    public function renderFileForGrid(Entry $item) {
        $link = $this->renderFileNameLink($item);
        $title = $link['filename'] . ((($this->get_processor()->get_shortcode_option('show_filesize') === '1') && ($item->get_size() > 0)) ? ' (' . Helpers::bytes_to_size_1024($item->get_size()) . ')' : '&nbsp;');

        $classmoveable = ($this->get_processor()->get_user()->can_move()) ? 'moveable' : '';

        $return = '';
        $return .= "<div class='entry file $classmoveable' data-url='" . rawurlencode($item->get_path_display()) . "' data-name='" . htmlentities($item->get_name(), ENT_QUOTES | ENT_HTML401) . "'>\n";
        $return .= "<div class='entry_block'>\n";

        $return .= "<div class='entry_edit'>";

        if ($this->get_processor()->get_user()->can_download_zip() || $this->get_processor()->get_user()->can_delete_files()) {
            $return .= "<div class='entry_checkbox'><input type='checkbox' name='selected-files[]' class='selected-files' value='" . rawurlencode($item->get_name()) . "'/></div>";
        }

        if ((in_array($this->get_processor()->get_shortcode_option('mcepopup'), array('links', 'embedded')))) {
            $return .= "<div class='entry_checkbox'><input type='checkbox' name='selected-files[]' class='selected-files' value='" . rawurlencode($item->get_name()) . "'/></div>";
        }

        $return .= $this->renderEditItem($item);
        $return .= "</div>";

        $download_url = admin_url('admin-ajax.php') . "?action=outofthebox-download&OutoftheBoxpath=" . rawurlencode($item->get_path()) . "&lastpath=" . rawurlencode($this->get_processor()->get_last_path()) . "&listtoken=" . $this->get_processor()->get_listtoken() . "&dl=1";
        $caption = ($this->get_processor()->get_user()->can_download()) ? '<a href="' . $download_url . '" title="' . __('Download', 'outofthebox') . '"><i class="fas fa-arrow-circle-down" aria-hidden="true"></i></a>&nbsp' : '';
        $caption .= $link['filename'];

        $add_caption = true;
        if (in_array($item->get_extension(), array('mp4', 'm4v', 'ogg', 'ogv', 'webmv', 'mp3', 'm4a', 'ogg', 'oga', 'wav'))) {
            /* Don't overlap the player controls with the caption */
            $add_caption = false;
        }

        $return .= "<a " . $link['url'] . " " . $link['target'] . " class='entry_link " . $link['class'] . "' " . $link['onclick'] . " title='" . $title . "' " . $link['lightbox'] . " data-filename='" . $link['filename'] . "' " . (($add_caption) ? "data-caption='$caption'" : '') . ">";

        $return .= "<div class='entry_thumbnail'><div class='entry_thumbnail-view-bottom'><div class='entry_thumbnail-view-center'>\n";

        $thumbnail_url = ($item->has_own_thumbnail() ? $this->get_processor()->get_client()->get_thumbnail($item, true, 0, 300, false, 95) : $item->get_icon_large());

        $return .= "<div class='preloading'></div>";
        $return .= "<img class='preloading' src='" . OUTOFTHEBOX_ROOTPATH . "/css/images/transparant.png' data-src='" . $thumbnail_url . "' data-src-retina='" . $thumbnail_url . "' data-src-backup='" . $item->get_icon_large() . "'/>";
        $return .= "</div></div></div>\n";

        $return .= "<div class='entry_name'>";

        $return .= "<div class='entry-name-view'><span>" . $link['filename'] . "</span></div>";
        $return .= "</div>\n";
        $return .= "</a>\n";

        $return .= $link['lightbox_inline'];

        $return .= "</div>\n";
        $return .= "</div>\n";

        return $return;
    }

    public function renderFileNameLink(Entry $item) {
        $class = '';
        $url = '';
        $target = '';
        $onclick = '';
        $lightbox = '';
        $lightbox_inline = '';
        $datatype = 'iframe';
        $filename = ($this->get_processor()->get_shortcode_option('show_ext') === '1') ? $item->get_name() : $item->get_basename();

        /* Check if user is allowed to preview the file */
        $usercanpreview = $this->get_processor()->get_user()->can_preview() && $this->get_processor()->get_shortcode_option('forcedownload') !== '1';

        if (
                $item->is_dir() ||
                $item->get_can_preview_by_cloud() === false ||
                $this->get_processor()->get_user()->can_view() === false
        ) {
            $usercanpreview = false;
        }

        /* Check if user is allowed to preview the file */
        if ($usercanpreview) {


            $url = admin_url('admin-ajax.php') . "?action=outofthebox-preview&OutoftheBoxpath=" . rawurlencode($item->get_path()) . "&lastpath=" . rawurlencode($this->get_processor()->get_last_path()) . "&listtoken=" . $this->get_processor()->get_listtoken();

            /* Display direct links for image and media files */
            if (in_array($item->get_extension(), array('jpg', 'jpeg', 'gif', 'png'))) {
                $datatype = 'image';
                if ($this->get_processor()->get_client()->has_temporarily_link($item)) {
                    $url = $this->get_processor()->get_client()->get_temporarily_link($item);
                } elseif ($this->get_processor()->get_client()->has_shared_link($item)) {
                    $url = $this->get_processor()->get_client()->get_shared_link($item) . '?raw=1';
                }
            } else if (in_array($item->get_extension(), array('mp4', 'm4v', 'ogg', 'ogv', 'webmv', 'mp3', 'm4a', 'ogg', 'oga', 'wav'))) {
                $datatype = 'inline';
                if ($this->get_processor()->get_client()->has_temporarily_link($item)) {
                    $url = $this->get_processor()->get_client()->get_temporarily_link($item);
                }
            }

            /* Check if we need to preview inline */
            if ($this->get_processor()->get_shortcode_option('previewinline') === '1') {
                $class = 'entry_link ilightbox-group';
                $onclick = "sendGooglePageView('Preview', '{$item->get_name()}');";

                /* Lightbox Settings */
                $lightbox = "rel='ilightbox[" . $this->get_processor()->get_listtoken() . "]' ";
                $lightbox .= 'data-type="' . $datatype . '"';

                switch ($datatype) {
                    case 'image':
                        $lightbox .= ' data-options="thumbnail: \'' . $this->get_processor()->get_client()->get_thumbnail($item, true, 128, 128, false) . '\'"';
                        break;
                    case 'inline':
                        $id = 'ilightbox_' . $this->get_processor()->get_listtoken() . '_' . md5($item->get_id());
                        $html5_element = (strpos($item->get_mimetype(), 'video') === false) ? 'audio' : 'video';
                        $icon = str_replace('32x32', '128x128', $item->get_icon());
                        $icon_256 = str_replace('32x32', '256x256', $item->get_icon());
                        $lightbox_size = (strpos($item->get_mimetype(), 'audio') !== false) ? '' : 'width: \'85%\', height: \'85%\',';
                        $lightbox .= ' data-options="mousewheel: false, ' . $lightbox_size . ' thumbnail: \'' . $icon . '\'"';
                        $thumbnail = ($html5_element === 'audio') ? '<div class="html5_player_thumbnail"><img src="' . $icon_256 . '"/><h3>' . $item->get_basename() . '</h3></div>' : '';
                        $download = ($this->get_processor()->get_user()->can_download()) ? '' : 'controlsList="nodownload"';
                        $lightbox_inline = '<div id="' . $id . '" class="html5_player" style="display:none;"><div class="html5_player_container"><div style="width:100%"><' . $html5_element . ' controls ' . $download . ' preload="metadata"  poster="' . $icon_256 . '"> <source data-src="' . $url . '" type="' . $item->get_mimetype() . '">' . __('Your browser does not support HTML5. You can only download this file', 'outofthebox') . '</' . $html5_element . '></div>' . $thumbnail . '</div></div>';
                        $url = '#' . $id;
                        break;
                    case 'iframe':
                        $lightbox .= ' data-options="mousewheel: false, width: \'85%\', height: \'80%\', thumbnail: \'' . str_replace('32x32', '128x128', $item->get_icon()) . '\'"';
                    default:
                        break;
                }
            } else {
                $class = 'entry_action_external_view';
                $target = '_blank';
                $onclick = "sendGooglePageView('Preview  (new window)', '{$item->get_name()}');";
            }
        } else if (($this->get_processor()->get_shortcode_option('mcepopup') === '0') && $this->get_processor()->get_user()->can_download()) {
            /* Check if user is allowed to download file */

            $url = admin_url('admin-ajax.php') . "?action=outofthebox-download&OutoftheBoxpath=" . rawurlencode($item->get_path()) . "&lastpath=" . rawurlencode($this->get_processor()->get_last_path()) . "&listtoken=" . $this->get_processor()->get_listtoken();
            $class = 'entry_action_download';

            $target = ($item->get_extension() === 'url') ? '"_blank"' : $target;
        }

        if ($this->get_processor()->get_shortcode_option('mcepopup') === 'woocommerce') {
            $class = 'entry_woocommerce_link';
        }


        if ($this->get_processor()->is_mobile() && $datatype === 'iframe') {
            $lightbox = '';
            $class = 'entry_action_external_view';
            $target = '_blank';
            $onclick = "sendGooglePageView('Preview  (new window)', '{$item->get_name()}');";
        }

        if (!empty($url)) {
            $url = "href='" . $url . "'";
        };
        if (!empty($target)) {
            $target = "target='" . $target . "'";
        };
        if (!empty($onclick)) {
            $onclick = 'onclick="' . $onclick . '"';
        };

        return array('filename' => htmlspecialchars($filename, ENT_COMPAT | ENT_HTML401 | ENT_QUOTES), 'class' => $class, 'url' => $url, 'lightbox' => $lightbox, 'lightbox_inline' => $lightbox_inline, 'target' => $target, 'onclick' => $onclick);
    }

    public function renderEditItem(Entry $item) {
        $html = '';

        $usercanpreview = $this->get_processor()->get_user()->can_preview();

        if (
                $item->is_dir() ||
                $item->get_can_preview_by_cloud() === false ||
                $item->get_extension() === 'zip' ||
                $this->get_processor()->get_user()->can_view() === false
        ) {
            $usercanpreview = false;
        }

        $usercanshare = $this->get_processor()->get_user()->can_share();

        $usercanrename = ($item->is_dir()) ? $this->get_processor()->get_user()->can_rename_folders() : $this->get_processor()->get_user()->can_rename_files();
        $usercandelete = ($item->is_dir()) ? $this->get_processor()->get_user()->can_delete_folders() : $this->get_processor()->get_user()->can_delete_files();

        $filename = $item->get_name();
        $filename .= (($this->get_processor()->get_shortcode_option('show_ext') === '1' && !empty($item->extension)) ? '.' . $item->get_extension() : '');

        /* View */
        $previewurl = admin_url('admin-ajax.php') . "?action=outofthebox-preview&OutoftheBoxpath=" . rawurlencode($item->get_path()) . "&lastpath=" . rawurlencode($this->get_processor()->get_last_path()) . "&listtoken=" . $this->get_processor()->get_listtoken();
        $onclick = "sendGooglePageView('Preview', '" . $item->get_name() . "');";

        if ($usercanpreview && $this->get_processor()->get_shortcode_option('forcedownload') !== '1') {

            if ($item->get_can_preview_by_cloud() && $this->get_processor()->get_shortcode_option('previewinline') === '1') {
                $html .= "<li><a class='entry_action_view' title='" . __('Preview', 'outofthebox') . "'><i class='fas fa-eye fa-lg'></i>&nbsp;" . __('Preview', 'outofthebox') . "</a></li>";
                $html .= "<li><a href='$previewurl' target='_blank' class='entry_action_external_view' onclick=\"$onclick\" title='" . __('Preview (new window)', 'outofthebox') . "'><i class='fas fa-desktop fa-lg'></i>&nbsp;" . __('Preview (new window)', 'outofthebox') . "</a></li>";
            } else if ($item->get_can_preview_by_cloud()) {

                if ($this->get_processor()->get_shortcode_option('previewinline') === '1') {
                    $html .= "<li><a class='entry_action_view' title='" . __('Preview', 'outofthebox') . "'><i class='fas fa-eye fa-lg'></i>&nbsp;" . __('Preview', 'outofthebox') . "</a></li>";
                }
                $html .= "<li><a href='$previewurl' target='_blank' class='entry_action_external_view' onclick=\"$onclick\" title='" . __('Preview (new window)', 'outofthebox') . "'><i class='fas fa-desktop fa-lg'></i>&nbsp;" . __('Preview (new window)', 'outofthebox') . "</a></li>";
            }
        }

        /* Download */
        if (($item->is_file()) && ($this->get_processor()->get_user()->can_download())) {
            $target = ($item->get_extension() === 'url') ? 'target="_blank"' : '';
            $html .= "<li><a href='" . admin_url('admin-ajax.php') . "?action=outofthebox-download&OutoftheBoxpath=" . rawurlencode($item->get_path()) . "&lastpath=" . rawurlencode($this->get_processor()->get_last_path()) . "&listtoken=" . $this->get_processor()->get_listtoken() . "&dl=1' $target data-filename='" . $filename . "' class='entry_action_download' title='" . __('Download', 'outofthebox') . "'><i class='fas fa-download fa-lg'></i>&nbsp;" . __('Download', 'outofthebox') . "</a></li>";
        }

        /* Shortlink */
        if ($usercanshare) {
            $html .= "<li><a class='entry_action_shortlink' title='" . __('Share', 'outofthebox') . "'><i class='fas fa-share-alt fa-lg'></i>&nbsp;" . __('Share', 'outofthebox') . "</a></li>";
        }

        /* Rename */
        if ($usercanrename) {
            $html .= "<li><a class='entry_action_rename' title='" . __('Rename', 'outofthebox') . "'><i class='fas fa-tag fa-lg'></i>&nbsp;" . __('Rename', 'outofthebox') . "</a></li>";
        }

        /* Delete */
        if ($usercandelete) {
            $html .= "<li><a class='entry_action_delete' title='" . __('Delete', 'outofthebox') . "'><i class='fas fa-trash fa-lg'></i>&nbsp;" . __('Delete', 'outofthebox') . "</a></li>";
        }

        if ($html !== '') {
            return "<a class='entry_edit_menu'><i class='fas fa-chevron-circle-down fa-lg'></i></a><div id='menu-" . $item->get_id() . "' class='oftb-dropdown-menu'><ul data-path='" . rawurlencode($item->get_path_display()) . "' data-name=\"" . $item->get_basename() . "\">" . $html . "</ul></div>\n";
        }

        return $html;
    }

    public function renderNewFolderForList() {
        $html = '';
        if ($this->_search === false) {

            if ($this->get_processor()->get_user()->can_add_folders()) {
                $html .= "<div class='entry folder newfolder'>";
                $html .= "<div class='entry_icon'><img src='" . OUTOFTHEBOX_ROOTPATH . "/css/icons/32x32/folder-new.png'/></div>";
                $html .= "<div class='entry_name'>" . __('Add folder', 'outofthebox') . "</div>";
                $html .= "<div class='entry_description'>" . __('Add a new folder in this directory', 'outofthebox') . "</div>";
                $html .= "</div>";
            }
        }
        return $html;
    }

    public function renderNewFolderForGrid() {
        $return = '';
        if ($this->_search === false) {

            if ($this->get_processor()->get_user()->can_add_folders()) {

                $return .= "<div class='entry folder newfolder'>\n";
                $return .= "<div class='entry_block'>\n";
                $return .= "<div class='entry_thumbnail'><div class='entry_thumbnail-view-bottom'><div class='entry_thumbnail-view-center'>\n";
                $return .= "<a class='entry_link'><img class='preloading' src='" . OUTOFTHEBOX_ROOTPATH . "/css/images/transparant.png' data-src='" . plugins_url('css/icons/128x128/folder-new.png', dirname(__FILE__)) . "' /></a>";
                $return .= "</div></div></div>\n";
                $return .= "<div class='entry_name'><a class='entry_link'><div class='entry-name-view'><span>" . __('Add folder', 'outofthebox') . "</span></div></a>";
                $return .= "</div>\n";
                $return .= "</div>\n";
                $return .= "</div>\n";
            }
        }
        return $return;
    }

}
