<?php
/**
 * Shortcode
 *
 * @package otfd
 * @subpackage _controllers
 * @since One Time File Download
 */

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

require_once OTFD_PLUGIN_PATH . '_controllers/class-main.php';
use Otfd\Controllers\Main as MainController;

require_once OTFD_PLUGIN_PATH . '_controllers/class-link.php';
use Otfd\Controllers\Link as LinkController;

require_once OTFD_PLUGIN_PATH . '_controllers/class-db.php';
use Otfd\Controllers\Db as DbController;

/**
 *
 * Custom shortcode function.
 */
function wp_otfd_shortcode_display( $attributes, $content = null ) {
	$attr = shortcode_atts( array(
		'type'  => 'link',
		'title' => false,
		'class' => '',
		'id'    => '0',
	), $attributes );

	if ( isset( $attr['id'] ) ) :
		// init db
		$db = new DbController();
		// get file row
		$file_entry = $db->get_file_entry( $attr['id'] );
		if ( isset( $attr['class'] ) ) {
			$css_class = $attr['class'];
		} else {
			$css_class = '';
		}

		// if file entry exists
		if ( isset( $file_entry ) ) {
			$link_controller = new LinkController();
			// valability?
			if ( 0 == $file_entry['valid_after_link_is_created'] ) {
				$valid_after_link_is_created = 0;
			} else {
				$valid_after_link_is_created = time() + $file_entry['valid_after_link_is_created'] * 60;
			}
			// data to store
			$link_data = array(
				'otfd_id'    => (int) $attr['id'],
				'created_at' => time(),
				'expire_at'  => $valid_after_link_is_created,
				'is_valid'   => 1,
			);
			if ( 1 == $file_entry['send_link_via_email'] ) {
				$form_data = json_decode( $file_entry['form_data'], true );
				if ( isset( $file_entry['form_data_custom_fields'] ) ) {
					$form_data_custom_fields = json_decode( $file_entry['form_data_custom_fields'], true );
				}
				ob_start();
				include OTFD_PLUGIN_PATH . '_views/fe-form.php';
				return ob_get_clean();
			} else {
				$via_js = $link_controller->should_generate_link_via_php( (int) $attr['id'] );
				if ( $via_js ) {
					$wp_otfd_id = (int) $attr['id'];
					if ( isset( $content ) && ! empty( $content ) ) {
						return '<a href="#" rel="nofollow" class="wp-otfd-unique-link ' . esc_attr( $css_class ) . '" data-key="' . $wp_otfd_id . '" data-nonce="">' . $content . '</a>';
					} elseif ( isset( $attr['title'] ) && ! empty( $attr['title'] ) ) {
						return '<a href="#" rel="nofollow" class="wp-otfd-unique-link ' . esc_attr( $css_class ) . '" data-key="' . $wp_otfd_id . '" data-nonce="">' . $attr['title'] . '</a>';
					}
					return '<a href="#" rel="nofollow" class="wp-otfd-unique-link ' . esc_attr( $css_class ) . '" data-key="' . $wp_otfd_id . '" data-nonce="">' . $file_entry['title'] . '</a>';
				} else {
					$url_key              = $link_controller->generate_link_key( (int) $attr['id'] );
					$link_data['url_key'] = $url_key;
					$link_id              = $link_controller->create_link( $link_data );
					$download_url         = $link_controller->generate_full_download_url( $url_key );

					do_action( 'wp_otfd_shortcode_displayed', array( 'shortcode_attributes' => $attributes, 'link_id' => $link_id, 'post_data' => isset( $_POST ) ? $_POST : '' ) );

					if ( isset( $content ) && ! empty( $content ) ) {
						return '<a href="' . $download_url . '" rel="nofollow" class="' . esc_attr( $css_class ) . '" target="_blank">' . $content . '</a>';
					} elseif ( isset( $attr['title'] ) && ! empty( $attr['title'] ) ) {
						return '<a href="' . $download_url . '" rel="nofollow" class="' . esc_attr( $css_class ) . '" target="_blank">' . $attr['title'] . '</a>';
					}
					return '<a href="' . $download_url . '" rel="nofollow" class="' . esc_attr( $css_class ) . '" target="_blank">' . $download_url . '</a>';
				}
			}
		}
	endif;

	return false;
}
add_action( 'init', function () {
	add_shortcode( 'wp_otfd', 'wp_otfd_shortcode_display' );
});
