<?php
/**
 * Settings
 *
 * @package otfd
 * @subpackage _controllers
 * @since One Time File Download
 */

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

require_once OTFD_PLUGIN_PATH . '_controllers/class-main.php';
use Otfd\Controllers\Main as MainController;

add_action( 'admin_enqueue_scripts', 'otfd_admin_enqueue_scripts_and_styles' );
/**
 *
 * Add styles and js scripts
 */
function otfd_admin_enqueue_scripts_and_styles( $hook ) {
	if ( in_array( $hook, array( 'toplevel_page_otfd', 'wp-otfd_page_otfd-edit', 'wp-otfd_page_otfd-entries' ) ) ) {
		wp_enqueue_style( 'otfd-wpadmin-style', OTFD_PLUGIN_URL . 'assets/css/otfd-backend.css', array(), '1.0.0' );

		wp_enqueue_media();
		wp_enqueue_script( 'otfd-wpadmin-scripts', OTFD_PLUGIN_URL . 'assets/js/otfd-admin.js', array( 'jquery', 'media-upload' ), '1.0', true );

		wp_enqueue_script( 'sweetalert2', OTFD_PLUGIN_URL . 'assets/js/sweetalert2.all.js', array( 'jquery' ), '1.0', true );
	}
}

add_action( 'wp_enqueue_scripts', 'otfd_enqueue_scripts_and_styles' );
/**
 *
 * Add styles and js scripts
 */
function otfd_enqueue_scripts_and_styles() {
	wp_enqueue_style( 'otfd-wp-style', OTFD_PLUGIN_URL . 'assets/css/otfd-frontend.css', array(), '1.0.0' );
	wp_enqueue_script( 'otfd-wp-scripts', OTFD_PLUGIN_URL . 'assets/js/otfd-frontend.js', array( 'jquery' ), '1.0', true );
	wp_localize_script( 'otfd-wp-scripts', 'otfd_ajax_vars', array( 'ajax_url' => admin_url( '/admin-ajax.php' ) ) );
}

add_action( 'admin_menu', 'add_otfd_plugin_page' );
/**
 * Init plugin admin page
 *
 * @var function
 */
function add_otfd_plugin_page() {

	$otfd_icon_url = OTFD_PLUGIN_URL . 'assets/images/icons/otfd-icon-16x16.png';

	add_menu_page( 'One Time File Download', 'WP OTFD', 'manage_options', 'otfd', array( new MainController(), 'init_backend' ), $otfd_icon_url );
	add_submenu_page( 'otfd', 'Create New', 'Create New', 'manage_options', 'otfd-edit', array( new MainController(), 'create_new' ) );
	add_submenu_page( 'otfd', 'Form Entries', 'Form Entries', 'manage_options', 'otfd-entries', array( new MainController(), 'form_entries' ) );
}

function otfd_output_buffer() {
	if ( strpos( $_SERVER['REQUEST_URI'], OTFD_EDIT_PAGE ) !== false ) {
		ob_start();
	}
}
add_action( 'init', 'otfd_output_buffer' );



// mailster integration.
// TODO: add an option in dashboard to activate/deactivate shortcodes in mailster
if ( function_exists( 'mailster' ) ) {
	add_filter( 'mailster_strip_shortcodes', '__return_false' );
}
