<?php
/**
 * Shortcode
 *
 * @package otfd
 * @subpackage _controllers
 * @since One Time File Download
 */

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

require_once OTFD_PLUGIN_PATH . '_controllers/class-main.php';
use Otfd\Controllers\Main as MainController;

require_once OTFD_PLUGIN_PATH . '_controllers/class-link.php';
use Otfd\Controllers\Link as LinkController;

require_once OTFD_PLUGIN_PATH . '_controllers/class-db.php';
use Otfd\Controllers\Db as DbController;


function wp_otfd_generate_download_link() {
	if ( isset( $_POST['id'] ) && !isset( $_POST['otfd_nonce'] ) || isset( $_POST['id'] ) && !wp_verify_nonce( $_POST['otfd_nonce'], 'otfd_nonce' ) ) {
		echo json_encode(
			array(
				'success' => false,
				'message' => esc_html__( 'Invalid nonce', 'wp-one-time-file-download' ),
			)
		);
		exit;
	} else {
		// init db
		$db = new DbController();
		// get file row
		$file_entry = $db->get_file_entry( (int) sanitize_text_field( wp_unslash( $_POST['id'] ) ) );
		// if file entry exists
		if ( isset( $file_entry ) ) {
			$link_controller = new LinkController();
			// valability?
			if ( 0 == $file_entry['valid_after_link_is_created'] ) {
				$valid_after_link_is_created = 0;
			} else {
				$valid_after_link_is_created = time() + $file_entry['valid_after_link_is_created'] * 60;
			}

			// data to store
			$link_data = array(
				'otfd_id'    => (int) sanitize_text_field( wp_unslash( $_POST['id'] ) ),
				'created_at' => time(),
				'expire_at'  => $valid_after_link_is_created,
				'is_valid'   => 1,
			);

			$url_key              = $link_controller->generate_link_key( $link_data['otfd_id'] );
			$link_data['url_key'] = $url_key;
			$link_id              = $link_controller->create_link( $link_data );

			echo json_encode(
				array(
					'success' => true,
					'link'    => get_site_url() . '/index.php/?wp_otfd_file=' . $url_key
				)
			);
		} else {
			echo json_encode(
				array(
					'success' => false,
					'message' => esc_html__( 'Invalid file entry', 'wp-one-time-file-download' ),
				)
			);
		}
	}

	wp_die(); // this is required to terminate immediately and return a proper response
}
add_action( 'wp_ajax_wp_otfd_generate_download_link', 'wp_otfd_generate_download_link' );

function wp_otfd_generate_frontend_download_link() {
	if ( isset( $_POST['data']['id'] ) && !isset( $_POST['data']['wp_otfd_nonce'] ) || isset( $_POST['data']['id'] ) && !wp_verify_nonce( $_POST['data']['wp_otfd_nonce'], 'wp_otfd_nonce' ) ) {
		echo json_encode(
			array(
				'success' => false,
				'message' => esc_html__( 'Invalid nonce', 'wp-one-time-file-download' ),
			)
		);
		exit;
	} else {
		// init db
		$db = new DbController();
		// get file row
		$file_entry = $db->get_file_entry( (int) sanitize_text_field( wp_unslash( $_POST['data']['id'] ) ) );
		// if file entry exists
		if ( isset( $file_entry ) ) {
			$link_controller = new LinkController();
			// valability?
			if ( 0 == $file_entry['valid_after_link_is_created'] ) {
				$valid_after_link_is_created = 0;
			} else {
				$valid_after_link_is_created = time() + $file_entry['valid_after_link_is_created'] * 60;
			}

			// data to store
			$link_data = array(
				'otfd_id'    => (int) sanitize_text_field( wp_unslash( $_POST['data']['id'] ) ),
				'created_at' => time(),
				'expire_at'  => $valid_after_link_is_created,
				'is_valid'   => 1,
			);

			$url_key              = $link_controller->generate_link_key( $link_data['otfd_id'] );
			$link_data['url_key'] = $url_key;
			$link_id              = $link_controller->create_link( $link_data );

			echo json_encode(
				array(
					'success' => true,
					'link'    => get_site_url() . '/index.php/wp-one-time-file-download/?wp_otfd_file=' . $url_key,
					'expire'  => $file_entry['valid_after_download'] * 60
				)
			);
		} else {
			echo json_encode(
				array(
					'success' => false,
					'message' => esc_html__( 'Invalid file entry', 'wp-one-time-file-download' ),
				)
			);
		}
	}

	wp_die(); // this is required to terminate immediately and return a proper response
}
add_action( 'wp_ajax_wp_otfd_generate_frontend_download_link', 'wp_otfd_generate_frontend_download_link' );
add_action( 'wp_ajax_nopriv_wp_otfd_generate_frontend_download_link', 'wp_otfd_generate_frontend_download_link' );

function wp_otfd_generate_download_link_then_email_it() {
	if ( isset( $_POST['data'] ) && !isset( $_POST['data']['nonce'] ) || isset( $_POST['data'] ) && !wp_verify_nonce( $_POST['data']['nonce'], 'otfd_fe_nonce_' . $_POST['data']['id'] ) ) {
		echo json_encode(
			array(
				'success' => false,
				'message' => esc_html__( 'Invalid nonce', 'wp-one-time-file-download' ),
			)
		);
		exit;
	} elseif ( isset( $_POST['data'] ) && !wp_verify_nonce( $_POST['nonce'], 'otfd_fe_nonce_' . $_POST['data']['id'] ) ) {
		$link_controller = new LinkController();
		$post_data = $_POST['data'];
		unset( $post_data['id'] );
		unset( $post_data['nonce'] );

		$link_url = $link_controller->generate_unique_download_link_by_otfd_id( (int) sanitize_text_field( wp_unslash( $_POST['data']['id'] ) ), $post_data );

		$db = new DbController();
		$file_entry = $db->get_file_entry( (int) sanitize_text_field( wp_unslash( $_POST['data']['id'] ) ) );

		$edata = json_decode( $file_entry['email_data'], true );
		if ( isset( $edata['email_content'] ) && !empty( $edata['email_content'] ) ) {
			$message = wp_unslash( $edata['email_content'] );
			$message = str_replace( '{{LINK}}', $link_url, $message );
		} else {
			$message = 'Hello. Here is the link to download the file: ' . $link_url;
		}

		if ( isset( $edata['email_subject'] ) && !empty( $edata['email_subject'] ) ) {
			$subject = $edata['email_subject'];
		} else {
			$subject = 'Your download link';
		}

		if ( isset( $edata['email_from'] ) && !empty( $edata['email_from'] ) && isset( $edata['email_from_name'] ) && !empty( $edata['email_from_name'] ) ) {
			$headers[] = 'From: '. $edata['email_from_name'] . " <" . $edata['email_from'] . "> \r\n";
		} elseif ( isset( $edata['email_from'] ) && !empty( $edata['email_from'] ) ) {
			$headers[] = 'From: ' . $edata['email_from'] . " \r\n";
		}
		$headers[] = 'Content-Type: text/html; charset=UTF-8';

		wp_mail( $_POST['data']['email'], $subject, $message, $headers );

		echo json_encode(
			array(
				'success' => true,
				'message' => esc_html__( 'Email with download link is on the way. Please check your inbox.', 'wp-one-time-file-download' ),
			)
		);
		exit;
	}
}
add_action( 'wp_ajax_wp_otfd_generate_download_link_then_email_it', 'wp_otfd_generate_download_link_then_email_it' );
add_action( 'wp_ajax_nopriv_wp_otfd_generate_download_link_then_email_it', 'wp_otfd_generate_download_link_then_email_it' );


function wp_otfd_generate_nonce() {
	$nonce = wp_create_nonce( 'wp_otfd_nonce' );
	if ( $nonce ) {
		echo json_encode(
			array(
				'success' => true,
				'nonce' => $nonce,
			)
		);
	} else {
		echo json_encode(
			array(
				'success' => false,
				'nonce' => false,
			)
		);
	}
	wp_die(); // this is required to terminate immediately and return a proper response
}
add_action( 'wp_ajax_wp_otfd_generate_nonce', 'wp_otfd_generate_nonce' );
add_action( 'wp_ajax_nopriv_wp_otfd_generate_nonce', 'wp_otfd_generate_nonce' );
