<?php
/**
 * Shortcode
 *
 * @package otfd
 * @subpackage _controllers
 * @since One Time File Download
 */

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

require_once OTFD_PLUGIN_PATH . '_controllers/class-main.php';
use Otfd\Controllers\Main as MainController;

require_once OTFD_PLUGIN_PATH . '_controllers/class-link.php';
use Otfd\Controllers\Link as LinkController;

require_once OTFD_PLUGIN_PATH . '_controllers/class-db.php';
use Otfd\Controllers\Db as DbController;

function check_if_wp_otfd_page() {
	if ( strpos( $_SERVER['REQUEST_URI'], OTFD_DOWNLOAD_PAGE ) !== false || isset( $_GET['wp_otfd_file'] ) ) {
		// is our page.
		if ( isset( $_GET['wp_otfd_file'] ) ) {
			$url_key = sanitize_text_field( wp_unslash( $_GET['wp_otfd_file'] ) );
		} else {
			$url_key = sanitize_text_field( wp_unslash( $_GET['file'] ) );
		}
		$link_controller = new LinkController();
		$download_data   = $link_controller->get_file_url_if_link_valid( $url_key );
		if ( isset( $download_data['link'] ) ) {
			if ( isset( $download_data['display_download_page'] ) && 1 == $download_data['display_download_page'] && ! isset( $_GET['fd'] ) ) {
				include OTFD_PLUGIN_PATH . '_views/fe-download.php';
				die;
			} else {
				$link_controller->mark_file_url_as_downloaded( $url_key );
				$file_url  = $download_data['link'];
				$file_name = $download_data['filename'];
				$file_name = str_replace( ' ', '%20', $file_name );

				$url_parts = pathinfo( $file_url );
				if ( ! isset( $file_name ) || empty( $file_name ) ) {
					$file_name = $url_parts['basename'];
				}
				$file_ext      = $url_parts['extension'];
				$ctype_default = 'application/octet-stream';
				$content_types = array(
					'exe'  => 'application/octet-stream',
					'zip'  => 'application/zip',
					'mp3'  => 'audio/mpeg',
					'mpg'  => 'video/mpeg',
					'avi'  => 'video/x-msvideo',
					'csv'  => 'text/csv',
					'doc'  => 'application/msword',
					'docx' => 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
					'epub' => 'epub',
					'gif'  => 'image/gif',
					'htm'  => 'text/html',
					'html' => 'text/html',
					'ico'  => 'image/x-icon',
					'ics'  => 'text/calendar',
					'jpeg' => 'image/jpeg',
					'jpg'  => 'image/jpeg',
					'png'  => 'image/png',
					'pdf'  => 'application/pdf',
					'json' => 'application/json',
					'ppt'  => 'application/vnd.ms-powerpoint',
					'pptx' => 'application/vnd.openxmlformats-officedocument.presentationml.presentation',
					'svg'  => 'image/svg+xml',
					'xls'  => 'application/vnd.ms-excel',
					'xlsx' => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
					'xml'  => 'application/xml',
					'zip'  => 'application/zip',
				);
				if ( isset( $content_types[ $file_ext ] ) ) {
					$ctype = $content_types[ $file_ext ];
				} else {
					$ctype = $ctype_default;
				}

				header( 'Pragma: public' );
				header( 'Expires: -1' );
				header( 'Cache-Control: public, must-revalidate, post-check=0, pre-check=0' );
				header( 'Content-Type: ' . $ctype );
				header( 'Content-Disposition: attachment; filename="' . $file_name . '"' );

				read_file_chunked( $file_url );
				die;
			}
		} else {
			if ( isset( $download_data['display_download_page'] ) && 1 == $download_data['display_download_page'] ) {
				include OTFD_PLUGIN_PATH . '_views/fe-downloaded.php';
				die;
			}
		}
	}
}

function read_file_chunked( $filename, $retbytes = true ) {
	$chunksize = 1 * ( 1024 * 1024 );
	$buffer    = '';
	$cnt       = 0;
	$handle    = fopen( str_replace( ' ', '%20', $filename ), 'rb' );
	// check if the file is valid.
	if ( false === $handle ) {
		return false;
	}
	while ( ! feof( $handle ) ) {
		$buffer = fread( $handle, $chunksize );
		echo $buffer;
		ob_flush();
		flush();
		if ( $retbytes ) {
			$cnt += strlen( $buffer );
		}
	}

	$status = fclose( $handle );
	if ( $retbytes && $status ) {
		return $cnt;
	}
	return $status;
}

add_action( 'init', 'check_if_wp_otfd_page' );
