<?php
/**
 * Settings
 *
 * @package otfd
 * @subpackage _controllers
 * @since One Time File Download
 */

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

require_once OTFD_PLUGIN_PATH . '_controllers/class-main.php';
use Otfd\Controllers\Db as DbController;

register_activation_hook( __FILE__, 'set_cleanup_link_downloads' );
register_deactivation_hook( __FILE__, 'unset_cleanup_link_downloads' );
// schedule the cleanup functionality
function set_cleanup_link_downloads() {
	if ( ! wp_next_scheduled( 'cleanup_link_downloads_action' ) ) {
		wp_schedule_event( time(), 'daily', 'cleanup_link_downloads_action' );
	}
}
// remove scheduled cleanup functionality
function unset_cleanup_link_downloads() {
	wp_clear_scheduled_hook( 'cleanup_link_downloads_action' );
}

add_action( 'cleanup_link_downloads_action', 'cleanup_link_downloads' );
// function to delete form entries
function cleanup_link_downloads() {
	$db    = new DbController();
	$forms = $db->get_file_entries_for_cleanup();
	if ( isset( $forms ) && count( $forms ) ) {
		foreach ( $forms as $form ) {
			$limit_timestamp = time() - ( $form['days_to_keep_entries'] * 60 * 60 * 24 );
			$db->cleanup_link_entries_older_than( $form['id'], $limit_timestamp );
		}
	}
}
