<?php
/**
 * Plugin Name: WP One Time File Download
 * Plugin URI: http://wp.pixolette.com/wordpress-plugins/wp-one-time-file-download
 * Description: Create Unique One Time Download Links for your files.
 * Author: پرشین اسکریپت
 * Version: 2.2
 * Author URI: http://www.persianscript.ir
 */

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

define( 'OTFD_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'OTFD_PLUGIN_URL', plugins_url() . '/wp-one-time-file-download/' );

require_once OTFD_PLUGIN_PATH . '_controllers/class-db.php';
use Otfd\Controllers\Db as DbController;
use Otfd\Controllers\Link as LinkController;

define( 'OTFD_DOWNLOAD_PAGE', '/wp-one-time-file-download/' );
define( 'OTFD_EDIT_PAGE', 'page=otfd-edit' );

register_activation_hook( __FILE__, array( new DbController(), 'create_table_on_install' ) );

include OTFD_PLUGIN_PATH . 'settings/settings.php';
include OTFD_PLUGIN_PATH . 'settings/cleanup.php';
include OTFD_PLUGIN_PATH . 'settings/link.php';
include OTFD_PLUGIN_PATH . 'settings/shortcode.php';
include OTFD_PLUGIN_PATH . 'settings/download.php';

function wp_otfd_update_db_check() {
	$db = new DbController();
	if ( get_option( 'otfd_db_version' ) != $db->otfd_db_version ) {
		$db->create_table_on_install();
		// set the cleanup functionality
		add_action( 'init', 'set_cleanup_link_downloads' );
	}
}
add_action( 'plugins_loaded', 'wp_otfd_update_db_check' );
