jQuery(document).ready( function($) {
	$('.wp-otfd-unique-link').each(function(i,v) {
		var $link = $(this);
		var post_data = {
			'action': 'wp_otfd_generate_nonce',
		};
		jQuery.post(otfd_ajax_vars.ajax_url, post_data, function(res) {
			var response = JSON.parse(res);
			if (response.success) {
				$link.attr('data-nonce', response.nonce);
			} else {
				console.log('WP OTFD nonce error.');
			}
		})
	})

	$(document).on('click', '.wp-otfd-unique-link', function(e) {
		e.preventDefault();
		var $link = $(this);
		if (!$link.hasClass('working') && $link.attr('data-key')) {
			if ($link.attr('data-exp')) {
				var dtm = new Date();
				var curr_timestamp = dtm.getTime();
				if (curr_timestamp > parseInt($link.attr('data-exp'))) {
					$link.attr('data-key', '');
					alert('Expired link');
					return false;
				}
			}

			$link.addClass('working');
			var post_data = {
				'action': 'wp_otfd_generate_frontend_download_link',
				'data': {
					'wp_otfd_nonce': $link.attr('data-nonce'),
					'id': $link.attr('data-key'),
				}
			};

			jQuery.post(otfd_ajax_vars.ajax_url, post_data, function(res) {
				var response = JSON.parse(res);
				$link.removeClass('working');
				if (response.success) {
					if (response.expire > 0) {
						if (!$link.attr('data-exp')) {
							var dt = new Date();
							var timestamp = dt.getTime();
							var exp = timestamp + response.expire * 1000;
							$link.attr('data-exp', exp);

							setTimeout(function (){
								$link.attr('data-key', '');
							}, response.expire * 1000)
						}
					} else {
						$link.attr('data-key', '');
					}
					window.location = response.link;
				} else {
					alert('An error occured');
				}
			})
		} else if (!$link.attr('data-key')) {
			alert('Expired link')
		}
	})
	$('.otfd-fe-input').on('keydown', function(e) {
		if (e.which == 13) {
			e.preventDefault();
			var $wrapper = $(this).closest('.otfe-fe-form-wrapper');
			$wrapper.find('.otfd-fe-form-submit').trigger('click');
		}
	})
	$(document).on('click', '.otfd-fe-form-submit', function (e){
		e.preventDefault();
		var $button = $(this);
		if ( $button.hasClass('button-loading') ) {
			return;
		}
		var has_errors = false;
		var data = {};

		if ( !$(this).attr('data-otfdid') ) {
			return;
		} else {
			data.id = $(this).attr('data-otfdid');
		}

		var $wrapper = $(this).closest('.otfe-fe-form-wrapper');

		if ( 'email_link' == $('#otfd-fe-form-'+data.id+' .otfd_fe_action').val() ) {

			$button.addClass('button-loading');

			$wrapper.find('.otfd-fe-form-row').removeClass('has-error');
			if ( !$('#otfd_fe_nonce_'+data.id).length || '' == $('#otfd_fe_nonce_'+data.id).val().trim()) {
				$button.removeClass('button-loading');
				return;
			} else {
				data.nonce = $('#otfd_fe_nonce_'+data.id).val();
			}
			$wrapper.find('.otfd-fe-input').each(function(i, v){
				var input = $(this)[0];

				switch (input.type) {
					case 'text':
						if ('' == $(input).val().trim()) {
							has_errors = true;
							$(input).closest('.otfd-fe-form-row').addClass('has-error')
						} else {
							data[input.name] = $(input).val();
						}
						break;
					case 'email':
						if (!isEmail($(input).val())) {
							has_errors = true;
							$(input).closest('.otfd-fe-form-row').addClass('has-error')
						} else {
							data[input.name] = $(input).val();
						}
						break;
					case 'checkbox':
						if (!$(input).is(":checked")) {
							has_errors = true;
							$(input).closest('.otfd-fe-form-row').addClass('has-error')
						} else {
							data[input.name] = '1';
						}
						break;
				}
			})

			if (has_errors) {
				$wrapper.find('.otfd-fe-form-errors').removeClass('otfd-hidden');
				$button.removeClass('button-loading');
			} else {
				$wrapper.find('.otfd-fe-form-errors').addClass('otfd-hidden');
				var data = {
					'action': 'wp_otfd_generate_download_link_then_email_it',
					'data': data
				};

				jQuery.post(otfd_ajax_vars.ajax_url, data, function(res) {
					var response = JSON.parse(res);
					if (response.success) {
						$wrapper.find('.otfe-fe-message-wrapper').removeClass('otfd-error').html('<p>' + response.message + '</p>');
						$('#otfd-fe-form-' + data.data.id).hide();
						$button.removeClass('button-loading');
					} else {
						$wrapper.find('.otfe-fe-message-wrapper').addClass('otfd-error').html('<p>' + response.message + '</p>')
						$button.removeClass('button-loading');
					}
				})
			}

		}
	})
});

function isEmail(email) {
	var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
	return regex.test(email);
}
