jQuery(document).ready( function($) {
	$(document).on('click', '#otfd_media_button', function(e) {
		var button_id ='#'+$(this).attr('id');
		var button = $(this);
		wp.media.editor.send.attachment = function(props, attachment){
			$('#otfd-file').val(attachment.id).trigger('change');
			$('.otfd-image-wrapper').html('<a href="'+attachment.url+'" target="_blank">'+attachment.name+'</a>&nbsp; - &nbsp;<a href="#" class="otfd-file-remove">Remove</a>').css('display','block');
		}
		wp.media.editor.open(button);
		return false;
	});

	$(document).on('click', '.otfd-file-remove', function (e){
		e.preventDefault();
		$('.otfd-file').val('');
		$('.otfd-image-wrapper').html('');
	})

	$(document).on('click', '.add-form-field-row', function (e){
		e.preventDefault();
		var html = $('.otfd-form-row-clone-parent').html();
		$('.otfd-form-row-clonned').append(html);
	})

	$(document).on('click', '.otfd-clone-remove', function (e){
		e.preventDefault();
		$(this).closest('.otfd-form-row').remove();
	})

	$(document).on('click', '.form-delete-button', function (e){
		e.preventDefault();
		swal({
			title: 'Are you sure?',
			text: "You won't be able to revert this! If you'll delete this entry, all links will not be available anymore.",
			type: 'question',
			showCancelButton: true,
			cancelButtonColor: '#3085d6',
			confirmButtonColor: '#d33',
			confirmButtonText: 'Yes, delete it!'
		}).then((result) => {
			if (result.value) {
				$('.otfd-form-delete').submit();
			}
		})
	})

	$(document).on('click', '.link-generate', function (e){
		e.preventDefault();

		var data = {
			'action': 'wp_otfd_generate_download_link',
			'id': $(this).attr('data-id'),
			'otfd_nonce': $('#otfd_nonce').val()
		};

		jQuery.post(ajaxurl, data, function(res) {
			var response = JSON.parse(res);
			if (response.success) {
				// copyToClipboard(response.link);
				swal({
					title: '<strong class="otfd-modal-title">Unique Download Link<strong>',
					type: 'success',
					html:
					'<div class="otfd-copy-wrapper">' +
					'<p>New "1 Time File Download Link" was generated</p>' +
					'<input type="text" name="otfd-clipboard" id="otfd-clipboard" value="' + response.link + '" />' +
					'<a href="#" class="clipcopy">Copy to clipboard</a>' +
					'</div>',
					showCloseButton: true,
					showCancelButton: false,
					showConfirmButton: false,
					focusConfirm: false,
					position: 'bottom-end',
				})
			} else {
				alert(response.message);
			}
		});
	})

	$(document).on('click', '.clipcopy', function (e){
		e.preventDefault();
		copyToClipboard()
	})

	$(document).on('change', 'input[name="send_link_via_email"]', function (e){
		e.preventDefault();
		if ($(this).val() == 1) {
			$('#otfd-link-data').removeClass('form-visible');
			$('#otfd-form-data').addClass('form-visible');
		} else {
			$('#otfd-link-data').addClass('form-visible');
			$('#otfd-form-data').removeClass('form-visible');
		}
	})
	$(document).on('change', 'input[name="form_data_name"]', function (e){
		e.preventDefault();
		if ($(this).val() == 1) {
			$('#otfd-form-data-name').removeClass('hidden-group');
		} else {
			$('#otfd-form-data-name').addClass('hidden-group');
		}
	})
	$(document).on('change', 'input[name="form_data_terms"]', function (e){
		e.preventDefault();
		if ($(this).val() == 1) {
			$('#otfd-form-data-terms').removeClass('hidden-group');
		} else {
			$('#otfd-form-data-terms').addClass('hidden-group');
		}
	})
	$(document).on('change', 'input[name="display_download_page"]', function (e){
		e.preventDefault();
		if ($(this).val() == 1) {
			$('#otfd-download-page-data').addClass('form-visible');
		} else {
			$('#otfd-download-page-data').removeClass('form-visible');
		}
	})

	$(document).on('focus', '.shortcode-input', function (e){
		e.preventDefault();
		$(this).select();
	})

	$(document).on('click', '.shortcode-copy', function (e){
		e.preventDefault();
		$(this).prev('.shortcode-input').select();
		document.execCommand('copy');
		$(this).text('Copied');
		setTimeout(function (){
			$('.shortcode-copy').text('Copy shortcode');
			$('.shortcode-input').blur();
		}, 3000)
	})

});

function copyToClipboard(text) {
	var $ = jQuery;
	var aux = $('#otfd-clipboard');
	aux.select();
	document.execCommand('copy');
	$('.clipcopy').text('Copied')
}
