<?php
/**
 *
 * Frontend Form View
 *
 * @package wp-one-time-file-download
 * @subpackage _views
 * @package WP OTFD 1.0
 */

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

?>

<div class="otfe-fe-form-wrapper">

	<div class="otfe-fe-message-wrapper otfe-fe-message-wrapper-<?php echo esc_attr( $file_entry['id'] ); ?>"></div>

	<form method="post" action="" class="otfd-fe-form" id="otfd-fe-form-<?php echo esc_attr( $file_entry['id'] ); ?>">
		<?php if ( 1 == $form_data['form_data_name'] ) : ?>
			<div class="otfd-fe-form-row">
				<label><?php echo esc_html( isset( $form_data['form_data_name_label'] ) && ! empty( $form_data['form_data_name_label'] ) ? $form_data['form_data_name_label'] : esc_html__( 'Your name', 'wp-one-time-file-download' ) ); ?></label>
				<input type="text" name="name" class="otfd-fe-name otfd-fe-input" value="" placeholder="<?php echo esc_html( isset( $form_data['form_data_name_label'] ) && ! empty( $form_data['form_data_name_label'] ) ? $form_data['form_data_name_label'] : esc_html__( 'Your name', 'wp-one-time-file-download' ) ); ?>" />
			</div>
		<?php endif; ?>
		<div class="otfd-fe-form-row">
			<label><?php echo esc_html( isset( $form_data['form_data_email_label'] ) && ! empty( $form_data['form_data_email_label'] ) ? $form_data['form_data_email_label'] : esc_html__( 'Your email address', 'wp-one-time-file-download' ) ); ?></label>
			<input type="email" name="email" class="otfd-fe-email otfd-fe-input" value="" placeholder="<?php echo esc_html( isset( $form_data['form_data_email_label'] ) && ! empty( $form_data['form_data_email_label'] ) ? $form_data['form_data_email_label'] : esc_html__( 'Your email address', 'wp-one-time-file-download' ) ); ?>" />
		</div>
		<?php if ( 1 == $form_data['form_data_terms'] ) : ?>
			<div class="otfd-fe-form-row">
				<label>
					<input type="checkbox" name="Terms" class="otfd-fe-name otfd-fe-input" value="1"/>
					<?php if ( isset( $form_data['form_data_terms_label'] ) && ! empty( $form_data['form_data_terms_label'] ) ) : ?>
						<?php echo wp_kses( $form_data['form_data_terms_label'], array( 'a' => array( 'href' => array(), 'target' => array() ) ) ); ?>
					<?php else : ?>
						<?php esc_html_e( 'By submitting this form you agree to our terms and conditions.', 'wp-one-time-file-download' ); ?>
					<?php endif; ?>
				</label>
			</div>
		<?php endif; ?>

		<?php if ( isset( $form_data_custom_fields ) && is_array( $form_data_custom_fields ) ) : ?>
			<?php foreach ( $form_data_custom_fields as $key => $value ) : ?>
				<div class="otfd-fe-form-row">
					<label><?php echo esc_html( $value['name'] ); ?></label>
					<input type="text" name="<?php echo esc_attr( $value['name'] ); ?>" class="otfd-fe-input" value="" placeholder="<?php echo esc_attr( $value['name'] ); ?>" />
				</div>
			<?php endforeach; ?>
		<?php endif; ?>

		<div class="otfd-fe-form-row otfd-fe-form-errors otfd-hidden">
			<p>
				<?php esc_html_e( 'Please fix the errors above and try to submit again', 'wp-one-time-file-download' ); ?>
			</p>
		</div>
		<?php wp_nonce_field( 'otfd_fe_nonce_' . $file_entry['id'], 'otfd_fe_nonce_' . $file_entry['id'] ); ?>
		<input type="hidden" name="otfd_fe_action" class="otfd_fe_action" value="email_link" />
		<div class="otfd-fe-form-row">
			<a href="#" class="otfd-fe-form-submit" data-otfdid="<?php echo esc_attr( $file_entry['id'] ); ?>"><?php echo esc_html( isset( $form_data['form_data_submit_label'] ) && '' != $form_data['form_data_submit_label'] ? $form_data['form_data_submit_label'] : __( 'Download', 'wp-one-time-file-download' ) ); ?></a>
		</div>
	</form>

</div>
