<?php
/**
 *
 * Backend view
 *
 * @package wp-one-time-file-download
 * @subpackage _views
 * @package WP OTFD 1.0
 */

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

?>

<div class="otfd-backend-wrapper">

	<div class="otfd-main-container">
		<div class="otfd-header">
			<div class="otfd-intro">
				<h2><?php esc_html_e( 'One-Time File Download', 'wp-one-time-file-download' ); ?></h2>
				<p>
					<?php esc_html_e( "Create links that will allow your website's visitors to download files once. Set a link expiration time, max number of downloads, send download link via email etc.", 'wp-one-time-file-download' ); ?>
				</p>
			</div>
			<a href="<?php echo admin_url( 'admin.php?page=otfd-edit&otfd_id=new' ); ?>" class="otfd-button otfd-button-primary-filled"><?php esc_html_e( 'Create new shortcode', 'wp-one-time-file-download' ); ?></a>
		</div>

		<div class="otfd-body">
			<?php if ( count( $entries ) ) : ?>
				<table class="wp-list-table widefat fixed striped pages">
					<thead>
						<tr>
							<td id="cb" class="manage-column column-cb check-column num index-col">#</td>
							<th scope="col" id="title" class="manage-column column-primary"><?php esc_html_e( 'Title', 'wp-one-time-file-download' ); ?></th>
							<th scope="col" id="file" class="manage-column"><?php esc_html_e( 'File', 'wp-one-time-file-download' ); ?></th>
							<th scope="col" id="valid_after_link_is_created" class="manage-column num"><?php esc_html_e( 'Valid after link is created', 'wp-one-time-file-download' ); ?></th>
							<th scope="col" id="valid_after_file_is_downloaded" class="manage-column num"><?php esc_html_e( 'Valid after file is downloaded', 'wp-one-time-file-download' ); ?></th>
							<th scope="col" id="email" class="manage-column num"><?php esc_html_e( 'Via email?', 'wp-one-time-file-download' ); ?></th>
							<th scope="col" id="edit" class="manage-column num"><?php esc_html_e( 'Shortcode', 'wp-one-time-file-download' ); ?></th>
							<th scope="col" id="edit" class="manage-column num"><?php esc_html_e( 'Generate unique link', 'wp-one-time-file-download' ); ?></th>
							<th scope="col" id="edit" class="manage-column num"><?php esc_html_e( 'Edit', 'wp-one-time-file-download' ); ?></th>
						</tr>
					</thead>
					<tbody>
						<?php foreach ( $entries as $key => $entry ) : ?>
							<tr>
								<td class="column index-col">
									<strong><?php echo esc_html( ( $page_nr - 1 ) * $this->per_page + $key + 1 ); ?></strong>
								</td>
								<td class="column-primary" data-colname="Title">
									<a href="<?php echo admin_url( 'admin.php?page=otfd-edit&otfd_id=' . $entry['id'] ); ?>"><strong><?php echo esc_html( $entry['title'] ); ?></strong></a>
								</td>
								<td class="column">
									<?php if ( isset( $entry['external_file_link'] ) && ! empty( $entry['external_file_link'] ) ) : ?>
										<a href="<?php echo esc_url( $entry['external_file_link'] ); ?>" target="_blank" class="otfd-link-title"><?php esc_html_e( 'External file', 'wp-one-time-file-download' ); ?></a>
									<?php else : ?>
										<a href="<?php echo esc_url( wp_get_attachment_url( $entry['file_id'] ) ); ?>" target="_blank" class="otfd-link-title"><?php echo get_the_title( $entry['file_id'] ); ?></a>
									<?php endif; ?>
								</td>
								<td class="column num">
									<?php if ( 0 == $entry['valid_after_link_is_created'] ) : ?>
										<?php esc_html_e( 'Unlimited', 'wp-one-time-file-download' ); ?>
									<?php else : ?>
										<?php /* translators: %s: number of minutes */ ?>
										<?php printf( esc_html__( '%d minutes', 'wp-one-time-file-download' ), $entry['valid_after_link_is_created'] ); ?>
									<?php endif; ?>
									<?php if ( $entry['valid_after_link_is_created'] / 60 / 24 > 1 ) : ?>
										<br />
										<?php /* translators: %s: number of days */ ?>
										(<?php printf( esc_html__( '%d days', 'wp-one-time-file-download' ), $entry['valid_after_link_is_created'] / 60 / 24 ); ?>)
									<?php endif; ?>
								</td>
								<td class="column num">
									<?php if ( 1 == $entry['valid_after_download'] ) : ?>
										<?php /* translators: %s: number of minutes */ ?>
										<?php printf( esc_html__( '%d minute', 'wp-one-time-file-download' ), $entry['valid_after_download'] ); ?>
									<?php else : ?>
										<?php /* translators: %s: number of minutes */ ?>
										<?php printf( esc_html__( '%d minutes', 'wp-one-time-file-download' ), $entry['valid_after_download'] ); ?>
									<?php endif; ?>
									<?php if ( 0 == $entry['valid_after_download'] ) : ?>
										<br />
										<em><?php esc_html_e( 'Expire on download', 'wp-one-time-file-download' ); ?></em>
									<?php endif; ?>
								</td>
								<td class="column num">
									<?php $entry['send_link_via_email'] ? esc_html_e( 'Yes', 'wp-one-time-file-download' ) : esc_html_e( 'No', 'wp-one-time-file-download' ); ?>
								</td>
								<td class="column num generate-icon">
									<code>
										[wp_otfd id="<?php echo esc_attr( $entry['id'] ); ?>" title="<?php echo esc_attr( $entry['link_title'] ); ?>" class="<?php echo esc_attr( $entry['link_css_class'] ); ?>"]
									</code>
								</td>
								<td class="column num generate-icon">
									<a href="#" class="link-generate" data-id="<?php echo esc_attr( $entry['id'] ); ?>" title="<?php esc_html_e( 'Generate 1 unique link', 'wp-one-time-file-download' ); ?>"><img src="<?php echo esc_url( OTFD_PLUGIN_URL ); ?>/assets/images/icons/otfd-icon.svg" /></a>
								</td>
								<td class="column num edit-icon">
									<a href="<?php echo admin_url( 'admin.php?page=otfd-edit&otfd_id=' . $entry['id'] ); ?>" title="<?php esc_html_e( 'Edit', 'wp-one-time-file-download' ); ?>"><img src="<?php echo esc_url( OTFD_PLUGIN_URL ); ?>/assets/images/icons/edit-icon.svg" /></a>
								</td>
							</tr>
						<?php endforeach; ?>
					</tbody>
				</table>
				<?php wp_nonce_field( 'otfd_nonce', 'otfd_nonce' ); ?>
			<?php endif; ?>

			<?php if ( 1 < $total_pages ) : ?>
				<ul class="wpotfd-pagination">
					<?php for ( $i = 1; $i <= $total_pages; $i++ ) : ?>
						<li>
							<a href="<?php echo esc_url( add_query_arg( 'page_nr', $i ) ); ?>" class="<?php echo esc_attr( $i == $page_nr ? 'wpotfd-pagination-active' : '' ); ?>"><?php echo esc_html( $i ); ?></a>
						</li>
					<?php endfor; ?>
				</ul>
			<?php endif; ?>
		</div>
	</div>
</div>
