<?php
/**
 *
 * Backend view
 *
 * @package wp-one-time-file-download
 * @subpackage _views
 * @package WP OTFD 1.0
 */

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );
?>

<div class="otfd-backend-wrapper">

	<?php if ( isset( $_GET['otfd_created'] ) ) : ?>
		<div id="message" class="updated notice">
			<p><?php esc_html_e( 'Entry created successfully', 'wp-one-time-file-download' ); ?></p>
			<a href="<?php echo esc_url( remove_query_arg( 'otfd_created' ) ); ?>" class="notice-dismiss">
				<span class="screen-reader-text"><?php esc_html_e( 'Dismiss this notice.', 'wp-one-time-file-download' ); ?></span>
			</a>
		</div>
	<?php endif; ?>
	<?php if ( isset( $_GET['otfd_updated'] ) ) : ?>
		<div id="message" class="updated notice">
			<p><?php esc_html_e( 'Entry saved successfully', 'wp-one-time-file-download' ); ?></p>
			<a href="<?php echo esc_url( remove_query_arg( 'otfd_updated' ) ); ?>" class="notice-dismiss">
				<span class="screen-reader-text"><?php esc_html_e( 'Dismiss this notice.', 'wp-one-time-file-download' ); ?></span>
			</a>
		</div>
	<?php endif; ?>

	<div class="otfd-main-container">
		<div class="otfd-header">
			<div class="otfd-intro">
				<?php if ( isset( $otfd['id'] ) ) : ?>
					<h2><?php esc_html_e( "Edit 'One Time File Download' Entry", 'wp-one-time-file-download' ); ?></h2>
				<?php else : ?>
					<h2><?php esc_html_e( "Create 'One Time File Download' Entry", 'wp-one-time-file-download' ); ?></h2>
				<?php endif; ?>
				<p>
					<?php esc_html_e( "Create links that will allow your website's visitors to download files once. Set a link expiration time, max number of downloads, send download link via email etc.", 'wp-one-time-file-download' ); ?>
				</p>
			</div>
		</div>
		<div class="otfd-body">
			<?php if ( isset( $otfd['id'] ) && 'new' != $otfd['id'] && isset( $otfd['id'] ) ) : ?>
				<div class="otfd-shortcode-wrapper">
					<h3><?php esc_html_e( 'Shortcode', 'wp-one-time-file-download' ); ?></h3>
					<em><?php esc_html_e( 'Copy and paste the shortcode on the needed post/page to display the Download Link/Form', 'wp-one-time-file-download' ); ?></em>
					<div class="otfd-shortcode-row">
						<input type="text" value='[wp_otfd id="<?php echo esc_attr( $otfd['id'] ); ?>" title="<?php echo esc_attr( $otfd['link_title'] ); ?>" class="<?php echo esc_attr( $otfd['link_css_class'] ); ?>"]' class="shortcode-input" />
						<a href="#" class="shortcode-copy"><?php esc_html_e( 'Copy Shortcode', 'wp-one-time-file-download' ); ?></a>
					</div>
				</div>
			<?php endif; ?>
			<form method="post" action="" class="otfd-form">
				<div class="otfd-form-row <?php echo esc_attr( isset( $otfd_errors['title'] ) ? 'has-error' : '' ); ?>">
					<label class="otfd-main-label" for="otfd-title"><?php esc_html_e( 'Title', 'wp-one-time-file-download' ); ?></label>
					<input type="text" name="title" placeholder="<?php esc_html_e( 'Title', 'wp-one-time-file-download' ); ?>" value="<?php echo esc_attr( $otfd['title'] ); ?>" />
					<?php if ( isset( $otfd_errors['title'] ) ) : ?>
						<em class="otfd-help-text"><?php echo esc_html( $otfd_errors['title'] ); ?></em>
					<?php endif; ?>
				</div>
				<div class="otfd-form-row-group">
					<div class="otfd-form-row <?php echo esc_attr( isset( $otfd_errors['file_id'] ) ? 'has-error' : '' ); ?>">
						<label class="otfd-main-label" for="otfd-file"><?php esc_html_e( 'Choose a local file:', 'wp-one-time-file-download' ); ?></label>

						<input type="hidden" class="otfd-file" name="file_id" id="otfd-file" value="<?php echo isset( $otfd['file_id'] ) ? esc_attr( $otfd['file_id'] ) : ''; ?>" style="margin-top:5px;">

						<input type="button" class="otfd-button otfd-button-primary otfd_media_button" id="otfd_media_button" name="file" value="Choose File" />
						<div class="otfd-image-wrapper">
							<?php if ( isset( $otfd['file_id'] ) && ! empty( $otfd['file_id'] ) ) : ?>
								<a href="<?php echo esc_url( wp_get_attachment_url( $otfd['file_id'] ) ); ?>" target="_blank"><?php echo get_the_title( $otfd['file_id'] ); ?></a>&nbsp; - &nbsp;<a href="#" class="otfd-file-remove"><?php esc_html_e( 'Remove', 'wp-one-time-file-download' ); ?></a>
							<?php endif; ?>
						</div>
						<?php if ( isset( $otfd_errors['file_id'] ) ) : ?>
							<em class="otfd-help-text"><?php echo esc_html( $otfd_errors['file_id'] ); ?></em>
						<?php endif; ?>
					</div>
					<div class="otfd-form-row <?php echo esc_attr( isset( $otfd_errors['external_file_link'] ) ? 'has-error' : '' ); ?>">
						<label class="otfd-main-label" for="external_file_link"><?php esc_html_e( 'or add an external file link:', 'wp-one-time-file-download' ); ?></label>
						<input type="text" name="external_file_link" placeholder="<?php esc_html_e( 'External file link URL', 'wp-one-time-file-download' ); ?>" value="<?php echo isset( $otfd['external_file_link'] ) ? esc_attr( $otfd['external_file_link'] ) : ''; ?>" />
						<em><?php esc_html_e( 'Submit an external link if you want to generate unique download links for it', 'wp-one-time-file-download' ); ?></em>
						<?php if ( isset( $otfd_errors['external_file_link'] ) ) : ?>
							<em class="otfd-help-text"><?php echo esc_html( $otfd_errors['external_file_link'] ); ?></em>
						<?php endif; ?>
					</div>
					<hr class="otfd-hr" />
					<div class="otfd-form-row">
						<label for="filename"><?php esc_html_e( 'Filename and extension', 'wp-one-time-file-download' ); ?></label>
						<input type="text" name="filename" placeholder="<?php esc_html_e( 'download.zip', 'wp-one-time-file-download' ); ?>" value="<?php echo isset( $otfd['filename'] ) ? esc_attr( $otfd['filename'] ) : ''; ?>" />
						<em><?php esc_html_e( 'The downloaded file will have this filename and extension. IE: download.zip', 'wp-one-time-file-download' ); ?></em>
						<?php if ( isset( $otfd_errors['filename'] ) ) : ?>
							<em class="otfd-help-text"><?php echo esc_html( $otfd_errors['filename'] ); ?></em>
						<?php endif; ?>
					</div>
				</div>
				<div class="otfd-form-row <?php echo esc_attr( isset( $otfd_errors['valid_after_link_is_created'] ) ? 'has-error' : '' ); ?>">
					<label class="otfd-main-label" for="valid_after_link_is_created"><?php esc_html_e( 'How long should be link valid after it was generated? (minutes)', 'wp-one-time-file-download' ); ?></label>
					<input type="text" name="valid_after_link_is_created" placeholder="<?php esc_html_e( 'Time in minutes', 'wp-one-time-file-download' ); ?>" value="<?php echo isset( $otfd['valid_after_link_is_created'] ) ? esc_attr( $otfd['valid_after_link_is_created'] ) : ''; ?>" />
					<em><?php esc_html_e( 'If you don\'t want the link to have an expiration date after it was generated, set the value to 0', 'wp-one-time-file-download' ); ?></em>
					<em><?php esc_html_e( 'If you want the link to expire after 24 hours, set the value to 1440', 'wp-one-time-file-download' ); ?></em>
					<?php if ( isset( $otfd_errors['valid_after_link_is_created'] ) ) : ?>
						<em class="otfd-help-text"><?php echo esc_html( $otfd_errors['valid_after_link_is_created'] ); ?></em>
					<?php endif; ?>
				</div>
				<div class="otfd-form-row <?php echo esc_attr( isset( $otfd_errors['valid_after_download'] ) ? 'has-error' : '' ); ?>">
					<label class="otfd-main-label" for="valid_after_download"><?php esc_html_e( 'How long should be link valid after it was downloaded? (minutes)', 'wp-one-time-file-download' ); ?></label>
					<input type="text" name="valid_after_download" placeholder="<?php esc_html_e( 'Time in minutes', 'wp-one-time-file-download' ); ?>" value="<?php echo isset( $otfd['valid_after_download'] ) ? esc_attr( $otfd['valid_after_download'] ) : ''; ?>" />
					<?php if ( isset( $otfd_errors['valid_after_download'] ) ) : ?>
						<em class="otfd-help-text"><?php echo esc_html( $otfd_errors['valid_after_download'] ); ?></em>
					<?php endif; ?>
				</div>

				<div class="otfd-form-row <?php echo esc_attr( isset( $otfd_errors['send_link_via_email'] ) ? 'has-error' : '' ); ?>">
					<label class="otfd-main-label" for="send_link_via_email"><?php esc_html_e( 'How do you want to display the link?', 'wp-one-time-file-download' ); ?></label>
					<div class="otfd-radio-group">
						<label><input name="send_link_via_email" type="radio" value="1" <?php echo esc_attr( 1 == $otfd['send_link_via_email'] ? 'checked="checked"' : '' ); ?>><?php esc_html_e( 'As form and user will receive the link via email after form submission', 'wp-one-time-file-download' ); ?></label>
					</div>
					<div class="otfd-radio-group">
						<label><input name="send_link_via_email" type="radio" value="0" <?php echo esc_attr( 1 != $otfd['send_link_via_email'] ? 'checked="checked"' : '' ); ?>><?php esc_html_e( 'As regular link', 'wp-one-time-file-download' ); ?></label>
					</div>
					</select>
					<?php if ( isset( $otfd_errors['send_link_via_email'] ) ) : ?>
						<em class="otfd-help-text"><?php echo esc_html( $otfd_errors['send_link_via_email'] ); ?></em>
					<?php endif; ?>
				</div>

				<div class="otfd-form-data <?php echo esc_attr( 1 != $otfd['send_link_via_email'] ? 'form-visible' : '' ); ?>" id="otfd-link-data">
					<div class="otfd-form-row <?php echo esc_attr( isset( $otfd_errors['link_title'] ) ? 'has-error' : '' ); ?>">
						<label for="link_title"><?php esc_html_e( 'Link title', 'wp-one-time-file-download' ); ?></label>
						<input type="text" name="link_title" placeholder="<?php esc_html_e( 'Link title', 'wp-one-time-file-download' ); ?>" value="<?php echo isset( $otfd['link_title'] ) ? esc_attr( $otfd['link_title'] ) : ''; ?>" />
						<?php if ( isset( $otfd_errors['link_title'] ) ) : ?>
							<em class="otfd-help-text"><?php echo esc_html( $otfd_errors['link_title'] ); ?></em>
						<?php endif; ?>
					</div>
					<div class="otfd-form-row <?php echo esc_attr( isset( $otfd_errors['link_css_class'] ) ? 'has-error' : '' ); ?>">
						<label for="link_css_class"><?php esc_html_e( 'Link CSS class', 'wp-one-time-file-download' ); ?></label>
						<input type="text" name="link_css_class" placeholder="<?php esc_html_e( 'Link CSS class', 'wp-one-time-file-download' ); ?>" value="<?php echo isset( $otfd['link_css_class'] ) ? esc_attr( $otfd['link_css_class'] ) : ''; ?>" />
						<?php if ( isset( $otfd_errors['link_css_class'] ) ) : ?>
							<em class="otfd-help-text"><?php echo esc_html( $otfd_errors['link_css_class'] ); ?></em>
						<?php endif; ?>
					</div>

					<div class="otfd-form-row <?php echo esc_attr( isset( $otfd_errors['content_is_cached'] ) ? 'has-error' : '' ); ?>">
						<label for="content_is_cached"><?php esc_html_e( 'Will the shortcode be used on posts, pages or widgets?', 'wp-one-time-file-download' ); ?></label>
						<div class="otfd-radio-group">
							<label><input name="content_is_cached" type="radio" value="1" <?php echo esc_attr( 1 == $otfd['content_is_cached'] ? 'checked="checked"' : '' ); ?>><?php esc_html_e( 'Yes', 'wp-one-time-file-download' ); ?></label>
							<label><input name="content_is_cached" type="radio" value="0" <?php echo esc_attr( 1 != $otfd['content_is_cached'] ? 'checked="checked"' : '' ); ?>><?php esc_html_e( 'No', 'wp-one-time-file-download' ); ?></label>
						</div>
						<em><?php esc_html_e( 'If shorcode will be used with 3rd party plugins like "Mailster" and you need to generate links in email content, then you should select the "No" value.', 'wp-one-time-file-download' ); ?></em>
						<em><?php esc_html_e( 'If shorcode will be used on pages, posts and widgets, then you should select the "Yes" value.', 'wp-one-time-file-download' ); ?></em>
						</select>
						<?php if ( isset( $otfd_errors['content_is_cached'] ) ) : ?>
							<em class="otfd-help-text"><?php echo esc_html( $otfd_errors['content_is_cached'] ); ?></em>
						<?php endif; ?>
					</div>
				</div>

				<div class="otfd-form-data <?php echo esc_attr( 1 == $otfd['send_link_via_email'] ? 'form-visible' : '' ); ?>" id="otfd-form-data">
					<div class="otfd-form-row no-margin">
						<h3><?php esc_html_e( 'Customize the form:', 'wp-one-time-file-download' ); ?></h3>
					</div>
					<div class="otfd-form-row">
						<label><?php esc_html_e( 'Ask users to submit their name?', 'wp-one-time-file-download' ); ?></label>
						<div class="otfd-radio-group">
							<label><input name="form_data_name" type="radio" value="1" <?php echo esc_attr( 1 == $form_data_fields['form_data_name'] ? 'checked="checked"' : '' ); ?>><?php esc_html_e( 'Yes', 'wp-one-time-file-download' ); ?></label>
							<label><input name="form_data_name" type="radio" value="0" <?php echo esc_attr( 1 != $form_data_fields['form_data_name'] ? 'checked="checked"' : '' ); ?>><?php esc_html_e( 'No', 'wp-one-time-file-download' ); ?></label>
						</div>
						<div class="otfd-form-group <?php echo esc_attr( 1 != $form_data_fields['form_data_name'] ? 'hidden-group' : '' ); ?>" id="otfd-form-data-name">
							<label><?php esc_html_e( "Text label for 'Name' field", 'wp-one-time-file-download' ); ?></label>
							<input type="text" name="form_data_name_label" placeholder="<?php esc_html_e( 'Default: Your name', 'wp-one-time-file-download' ); ?>" value="<?php echo isset( $form_data_fields['form_data_name_label'] ) ? esc_attr( $form_data_fields['form_data_name_label'] ) : ''; ?>" />
						</div>
					</div>
					<div class="otfd-form-row">
						<label><?php esc_html_e( "Text label for 'Email' field", 'wp-one-time-file-download' ); ?></label>
						<input type="text" name="form_data_email_label" placeholder="<?php esc_html_e( 'Default: Email address', 'wp-one-time-file-download' ); ?>" value="<?php echo isset( $form_data_fields['form_data_email_label'] ) ? esc_attr( $form_data_fields['form_data_email_label'] ) : ''; ?>" />
					</div>
					<label><?php esc_html_e( 'Display terms and condition checkbox?', 'wp-one-time-file-download' ); ?></label>
					<div class="otfd-form-row">
						<div class="otfd-radio-group">
							<label><input name="form_data_terms" type="radio" value="1" <?php echo esc_attr( 1 == $form_data_fields['form_data_terms'] ? 'checked="checked"' : '' ); ?>><?php esc_html_e( 'Yes', 'wp-one-time-file-download' ); ?></label>
							<label><input name="form_data_terms" type="radio" value="0" <?php echo esc_attr( 1 != $form_data_fields['form_data_terms'] ? 'checked="checked"' : '' ); ?>><?php esc_html_e( 'No', 'wp-one-time-file-download' ); ?></label>
						</div>
						<div class="otfd-form-group <?php echo esc_attr( 1 != $form_data_fields['form_data_terms'] ? 'hidden-group' : '' ); ?>" id="otfd-form-data-terms">
							<label><?php esc_html_e( "Text label for 'Terms and Conditions' checkbox", 'wp-one-time-file-download' ); ?></label>
							<textarea name="form_data_terms_label" placeholder="<?php esc_html_e( 'Default: By submitting this form you agree to our terms and conditions.', 'wp-one-time-file-download' ); ?>"><?php echo isset( $form_data_fields['form_data_terms_label'] ) ? esc_attr( $form_data_fields['form_data_terms_label'] ) : ''; ?></textarea>
							<em><?php esc_html_e( 'You can add links in terms and conditions label. Example: <a href="https://yourwebsiteurl.com/tos" target="_blank">Link title goes here</a>', 'wp-one-time-file-download' ); ?></em>
						</div>
					</div>
					<div class="otfd-form-row">
						<label><?php esc_html_e( "Text label for 'Submit' button", 'wp-one-time-file-download' ); ?></label>
						<input type="text" name="form_data_submit_label" placeholder="<?php esc_html_e( 'Default: Download', 'wp-one-time-file-download' ); ?>" value="<?php echo isset( $form_data_fields['form_data_submit_label'] ) ? esc_attr( $form_data_fields['form_data_submit_label'] ) : ''; ?>" />
					</div>

					<label><?php esc_html_e( 'Need to display more text fields?', 'wp-one-time-file-download' ); ?></label>
					<br />
					<div class="otfd-form-row-clonned">
						<?php if ( isset( $form_data_custom_fields ) && is_array( $form_data_custom_fields ) ) : ?>
							<?php foreach ( $form_data_custom_fields as $key => $value ) : ?>
								<div class="otfd-form-row">
									<label><span><?php esc_html_e( 'Custom field name:', 'wp-one-time-file-download' ); ?></span><a href="#" class="otfd-clone-remove"><?php esc_html_e( 'Remove', 'wp-one-time-file-download' ); ?></a></label>
									<input type="text" name="form_data_custom_fields[]" placeholder="<?php esc_html_e( 'Field name', 'wp-one-time-file-download' ); ?>" value="<?php echo esc_attr( $value['name'] ); ?>" />
								</div>
							<?php endforeach; ?>
						<?php endif; ?>
					</div>
					<a href="#" class="add-form-field-row"><?php esc_html_e( 'Add text field', 'wp-one-time-file-download' ); ?></a>

					<div class="otfd-form-row-clone-parent">
						<div class="otfd-form-row">
							<label><span><?php esc_html_e( 'Custom field name:', 'wp-one-time-file-download' ); ?></span><a href="#" class="otfd-clone-remove"><?php esc_html_e( 'Remove', 'wp-one-time-file-download' ); ?></a></label>
							<input type="text" name="form_data_custom_fields[]" placeholder="<?php esc_html_e( 'Field name', 'wp-one-time-file-download' ); ?>" value="" />
						</div>
					</div>

					<hr />

					<br />
					<div class="otfd-form-row no-margin">
						<h3><?php esc_html_e( 'Email content:', 'wp-one-time-file-download' ); ?></h3>
					</div>
					<div class="otfd-form-row">
						<label><?php esc_html_e( 'Email: Subject line', 'wp-one-time-file-download' ); ?></label>
						<input type="text" name="email_subject" placeholder="<?php esc_html_e( 'Email subject', 'wp-one-time-file-download' ); ?>" value="<?php echo isset( $email_data_fields['email_subject'] ) ? esc_attr( $email_data_fields['email_subject'] ) : ''; ?>" />
					</div>
					<div class="otfd-form-row">
						<label><?php esc_html_e( 'Email: From line (email address)', 'wp-one-time-file-download' ); ?></label>
						<input type="email" name="email_from" placeholder="<?php esc_html_e( 'Email address to be displayed as sender', 'wp-one-time-file-download' ); ?>" value="<?php echo isset( $email_data_fields['email_from'] ) ? esc_attr( $email_data_fields['email_from'] ) : ''; ?>" />
					</div>
					<div class="otfd-form-row">
						<label><?php esc_html_e( 'Email: From line (name)', 'wp-one-time-file-download' ); ?></label>
						<input type="text" name="email_from_name" placeholder="<?php esc_html_e( 'Name to be displayed as sender', 'wp-one-time-file-download' ); ?>" value="<?php echo isset( $email_data_fields['email_from_name'] ) ? esc_attr( $email_data_fields['email_from_name'] ) : ''; ?>" />
					</div>
					<div class="otfd-form-row">
						<label><?php esc_html_e( 'Email: Content', 'wp-one-time-file-download' ); ?></label>
						<textarea name="email_content" rows="10" placeholder="<?php esc_html_e( 'Message content', 'wp-one-time-file-download' ); ?>"><?php echo isset( $email_data_fields['email_content'] ) ? wp_unslash( $email_data_fields['email_content'] ) : ''; ?></textarea>
						<em><?php esc_html_e( 'Use {{LINK}} to display the download link.', 'wp-one-time-file-download' ); ?></em>
						<em><?php esc_html_e( 'Example: <a href="{{LINK}}">Click here to download file</a>', 'wp-one-time-file-download' ); ?></em>
					</div>
					<hr />
					<br />
					<div class="otfd-form-row no-margin">
						<h3><?php esc_html_e( 'Auto cleanup form enties after period of time?', 'wp-one-time-file-download' ); ?></h3>
					</div>
					<div class="otfd-form-row">
						<label><?php esc_html_e( 'Set the number of days to keep form entries.', 'wp-one-time-file-download' ); ?></label>
						<input type="text" name="days_to_keep_entries" placeholder="<?php esc_html_e( 'Delete form entries after X days', 'wp-one-time-file-download' ); ?>" value="<?php echo isset( $otfd['days_to_keep_entries'] ) ? esc_attr( $otfd['days_to_keep_entries'] ) : ''; ?>" />
						<em><?php esc_html_e( 'If you don\'t want to delete form entries automatically, leave this field empty', 'wp-one-time-file-download' ); ?></em>
					</div>
				</div>

				<div class="otfd-form-row <?php echo esc_attr( isset( $otfd_errors['send_link_via_email'] ) ? 'has-error' : '' ); ?>">
					<label class="otfd-main-label" for="send_link_via_email"><?php esc_html_e( 'When accessing the download link, a user will:', 'wp-one-time-file-download' ); ?></label>
					<div class="otfd-radio-group">
						<label><input name="display_download_page" type="radio" value="0" <?php echo esc_attr( 1 != $otfd['display_download_page'] ? 'checked="checked"' : '' ); ?>><?php esc_html_e( 'download the file from a empty page/tab', 'wp-one-time-file-download' ); ?></label>
					</div>
					<div class="otfd-radio-group">
						<label><input name="display_download_page" type="radio" value="1" <?php echo esc_attr( 1 == $otfd['display_download_page'] ? 'checked="checked"' : '' ); ?>><?php esc_html_e( 'see a page with a button to download the file', 'wp-one-time-file-download' ); ?></label>
					</div>
					</select>
					<?php if ( isset( $otfd_errors['display_download_page'] ) ) : ?>
						<em class="otfd-help-text"><?php echo esc_html( $otfd_errors['display_download_page'] ); ?></em>
					<?php endif; ?>
				</div>

				<div class="<?php echo esc_attr( 1 == $otfd['display_download_page'] ? 'form-visible' : '' ); ?>" id="otfd-download-page-data">
					<div class="otfd-form-row <?php echo esc_attr( isset( $otfd_errors['download_page_content'] ) ? 'has-error' : '' ); ?>">
						<label for="download_page_content"><?php esc_html_e( 'Page content', 'wp-one-time-file-download' ); ?></label>
						<br />
						<?php wp_editor( $otfd['download_page_content'], 'download_page_content' ); ?>
						<?php if ( isset( $otfd_errors['download_page_content'] ) ) : ?>
							<em class="otfd-help-text"><?php echo esc_html( $otfd_errors['download_page_content'] ); ?></em>
						<?php endif; ?>
					</div>
				</div>

				<input type="hidden" name="otfd_action" value="new" />
				<?php wp_nonce_field( 'otfd_nonce', 'otfd_nonce' ); ?>

				<?php if ( isset( $otfd_errors['error_message'] ) ) : ?>
					<div class="otfd-form-row">
						<div class="otfd-error-message">
							<?php echo esc_html( $otfd_errors['error_message'] ); ?>
						</div>
					</div>
				<?php endif; ?>

				<?php if ( isset( $otfd['id'] ) && 'new' != $otfd['id'] && isset( $otfd['id'] ) ) : ?>
					<div class="otfd-shortcode-wrapper">
						<h3><?php esc_html_e( 'Shortcode', 'wp-one-time-file-download' ); ?></h3>
						<em><?php esc_html_e( 'Copy and paste the shortcode on the needed post/page to display the Download Link/Form', 'wp-one-time-file-download' ); ?></em>
						<div class="otfd-shortcode-row">
							<input type="text" value='[wp_otfd id="<?php echo esc_attr( $otfd['id'] ); ?>" title="<?php echo esc_attr( $otfd['link_title'] ); ?>" class="<?php echo esc_attr( $otfd['link_css_class'] ); ?>"]' class="shortcode-input" />
							<a href="#" class="shortcode-copy"><?php esc_html_e( 'Copy Shortcode', 'wp-one-time-file-download' ); ?></a>
						</div>
					</div>
				<?php endif; ?>

				<div class="otfd-form-row no-flex">
					<a href="<?php echo admin_url( 'admin.php?page=otfd' ); ?>" class="otfd-button button-left"><?php esc_html_e( 'Cancel', 'wp-one-time-file-download' ); ?></a>
					<input type="submit" class="otfd-button otfd-button-primary-filled form-submit-button button-right" value="Save" />
				</div>
			</form>

			<?php if ( isset( $otfd['id'] ) && 'new' != $otfd['id'] && isset( $otfd['id'] ) ) : ?>
				<hr class="form-divider" />
				<div class="otfd-delete-form">
					<form method="post" action="" class="otfd-form otfd-form-delete">
						<input type="hidden" name="otfd_action" value="delete" />
						<?php wp_nonce_field( 'otfd_nonce', 'otfd_nonce' ); ?>
						<h3><?php esc_html_e( "If you'll delete this entry, all links will not be available anymore.", 'wp-one-time-file-download' ); ?></h3>
						<div class="otfd-form-row">
							<a href="#" class="otfd-button otfd-button-danger-filled form-delete-button button-right"><?php echo esc_attr( 'Delete this shortcode', 'wp-one-time-file-download' ); ?></a>
						</div>
					</form>
				</div>
			<?php endif; ?>
		</div>
	</div>
</div>
