<?php
/**
 *
 * Backend view
 *
 * @package wp-one-time-file-download
 * @subpackage _views
 * @package WP OTFD 1.0
 */

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

?>

<div class="otfd-backend-wrapper">

	<div class="otfd-main-container">
		<div class="otfd-header">
			<div class="otfd-intro">
				<h2><?php esc_html_e( 'WP OTFD - User data', 'wp-one-time-file-download' ); ?></h2>
			</div>
		</div>

		<div class="otfd-body">
			<div class="otfd-shortcode-wrapper">
				<h3><?php esc_html_e( 'User data is related to the following form:', 'wp-one-time-file-download' ); ?></h3>
				<p><?php esc_html_e( 'Form title', 'wp-one-time-file-download' ); ?>: <strong><a href="<?php echo admin_url( 'admin.php?page=otfd-edit&otfd_id=' . $form_data['id'] ); ?>"><?php echo esc_html( $form_data['title'] ); ?></a></strong></p>
				<?php if ( isset( $form_data['file_id'] ) && ! empty( $form_data['file_id'] ) ) : ?>
					<p><?php esc_html_e( 'File:', 'wp-one-time-file-download' ); ?> <a href="<?php echo esc_url( wp_get_attachment_url( $form_data['file_id'] ) ); ?>" target="_blank"><?php echo get_the_title( $form_data['file_id'] ); ?></a></p>
				<?php endif; ?>
				<?php if ( isset( $form_data['external_file_link'] ) && ! empty( $form_data['external_file_link'] ) ) : ?>
					<p><?php esc_html_e( 'File:', 'wp-one-time-file-download' ); ?> <a href="<?php echo esc_url( $form_data['external_file_link'] ); ?>" target="_blank"><?php esc_html_e( 'Click here to open file in new tab', 'wp-one-time-file-download' ) ?></a></p>
				<?php endif; ?>
			</div>

			<?php if ( isset( $otfd_message ) && '' != $otfd_message ) : ?>
				<div class="otfd-shortcode-wrapper">
					<strong><span class="dashicons dashicons-warning"></span> <?php echo esc_html( $otfd_message ); ?></strong>
				</div>
			<?php endif; ?>

			<?php if ( count( $entries ) ) : ?>
				<table class="wp-list-table widefat fixed striped pages">
					<thead>
						<tr>
							<td id="cb" class="manage-column column-cb check-column num index-col">#</td>
							<th scope="col" id="th-email" class="manage-column"><?php esc_html_e( 'Email', 'wp-one-time-file-download' ); ?></th>
							<th scope="col" id="th-name" class="manage-column column-primary"><?php esc_html_e( 'Name', 'wp-one-time-file-download' ); ?></th>
							<th scope="col" id="th-custom-fields" class="manage-column column-primary"><?php esc_html_e( 'Custom fields', 'wp-one-time-file-download' ); ?></th>
							<th scope="col" id="th-name" class="manage-column column-primary"><?php esc_html_e( 'Submitted on', 'wp-one-time-file-download' ); ?></th>
							<th scope="col" id="th-is-downloaded" class="manage-column column-primary"><?php esc_html_e( 'Is downloaded', 'wp-one-time-file-download' ); ?></th>
							<th scope="col" id="th-is-downloaded" class="manage-column column-primary"><?php esc_html_e( 'Downloaded timestamp', 'wp-one-time-file-download' ); ?></th>
							<th scope="col" id="th-action" class="manage-column num"><?php esc_html_e( 'Actions', 'wp-one-time-file-download' ); ?></th>
						</tr>
					</thead>
					<tbody>
						<?php $key = 0; ?>
						<?php foreach ( $entries as $entry ) : ?>
							<?php $user_data = json_decode( $entry['user_data'] ); ?>
							<?php
							if ( ! isset( $user_data->email ) && ! isset( $user_data->name ) ) {
								// there is no username or email stored. This situation can occur when an shorcode was changed from email to simple link
								continue;
							}
							?>
							<tr>
								<td class="column index-col">
									<strong><?php echo esc_html( ( $page_nr - 1 ) * $this->per_page + $key + 1 ); ?></strong>
									<?php $key++; ?>
								</td>
								<td class="column">
									<strong><?php echo esc_html( isset( $user_data->email ) ? $user_data->email : '-' ); ?></strong>
								</td>
								<td class="column-primary" data-colname="name">
									<strong><?php echo esc_html( isset( $user_data->name ) ? $user_data->name : '-' ); ?></strong>
								</td>
								<td class="column-primary" data-colname="name">
									<?php foreach ( $user_data as $ud_key => $ud_value ) : ?>
										<?php if ( ! in_array( $ud_key, array( 'name', 'email' ) ) ) : ?>
											<?php echo esc_html( $ud_key ); ?>: <strong><?php echo esc_html( $ud_value ); ?></strong><br />
										<?php endif; ?>
									<?php endforeach; ?>
								</td>
								<td class="column-primary" data-colname="date">
									<?php echo esc_html( isset( $entry['created_at'] ) ? $this->gmt_to_local_timestamp( $entry['created_at'] ) : esc_html__( 'N/A', 'wp-one-time-file-download' ) ); ?>
								</td>
								<td class="column-primary" data-colname="date">
									<?php echo esc_html( isset( $entry['is_downloaded'] ) && 1 == $entry['is_downloaded'] ? esc_html__( 'Yes', 'wp-one-time-file-download' ) : __( 'No', 'wp-one-time-file-download' ) ); ?>
								</td>
								<td class="column-primary" data-colname="date">
									<?php echo esc_html( isset( $entry['downloaded_timestamp'] ) && 0 < $entry['downloaded_timestamp'] ? $this->gmt_to_local_timestamp( $entry['downloaded_timestamp'] ) : __( 'N/A', 'wp-one-time-file-download' ) ); ?>
								</td>
								<td class="column-secondary num" data-colname="actions">
									<form action="" method="post">
										<input type="hidden" name="otfd_action" value="delete_entry" />
										<input type="hidden" name="otfd_entry_id" value="<?php echo esc_attr( $entry['id'] ); ?>" />
										<?php wp_nonce_field( 'otfd_nonce', 'otfd_nonce' ); ?>
										<button type="submit" class="otfd-delete-entry-button"><span class="dashicons dashicons-trash"></span></button>
									</form>
								</td>
							</tr>
						<?php endforeach; ?>
					</tbody>
				</table>
				<?php wp_nonce_field( 'otfd_nonce', 'otfd_nonce' ); ?>
			<?php endif; ?>

			<?php if ( 1 < $total_pages ) : ?>
				<ul class="wpotfd-pagination">
					<?php for ( $i = 1; $i <= $total_pages; $i++ ) : ?>
						<li>
							<a href="<?php echo esc_url( add_query_arg( 'page_nr', $i ) ); ?>" class="<?php echo esc_attr( $i == $page_nr ? 'wpotfd-pagination-active' : '' ); ?>"><?php echo esc_html( $i ); ?></a>
						</li>
					<?php endfor; ?>
				</ul>
			<?php endif; ?>
		</div>
	</div>
</div>
