<?php
/**
 *
 * Backend view
 *
 * @package wp-one-time-file-download
 * @subpackage _views
 * @package WP OTFD 1.0
 */

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

?>

<div class="otfd-backend-wrapper">

	<div class="otfd-main-container">
		<div class="otfd-header">
			<div class="otfd-intro">
				<h2><?php esc_html_e( 'WP OTFD - Form Entries', 'wp-one-time-file-download' ); ?></h2>
				<p>
					<?php esc_html_e( "Below you'll find the data that was submitted in the front end in order to receive the download links via email", 'wp-one-time-file-download' ); ?>
				</p>
			</div>
		</div>

		<div class="otfd-body">
			<?php if ( count( $entries ) ) : ?>
				<table class="wp-list-table widefat fixed striped pages">
					<thead>
						<tr>
							<td id="cb" class="manage-column column-cb check-column num index-col">#</td>
							<th scope="col" id="title" class="manage-column column-primary"><?php esc_html_e( 'Title', 'wp-one-time-file-download' ); ?></th>
							<th scope="col" id="file" class="manage-column"><?php esc_html_e( 'File', 'wp-one-time-file-download' ); ?></th>
							<th scope="col" id="edit" class="manage-column num"><?php esc_html_e( 'Entries', 'wp-one-time-file-download' ); ?></th>
							<th scope="col" id="edit" class="manage-column num"><?php esc_html_e( 'Actions', 'wp-one-time-file-download' ); ?></th>
						</tr>
					</thead>
					<tbody>
						<?php foreach ( $entries as $key => $entry ) : ?>
							<tr>
								<td class="column index-col">
									<strong><?php echo esc_html( $key + 1 ); ?></strong>
								</td>
								<td class="column-primary" data-colname="Title">
									<a href="<?php echo admin_url( 'admin.php?page=otfd-entries&otfd_id=' . $entry['id'] ); ?>"><strong><?php echo esc_html( $entry['title'] ); ?></strong></a>
								</td>
								<td class="column">
									<?php if ( isset( $entry['external_file_link'] ) && !empty( $entry['external_file_link'] ) ) : ?>
										<a href="<?php echo esc_url( $entry['external_file_link'] ); ?>" target="_blank" class="otfd-link-title"><?php esc_html_e( 'External file', 'wp-one-time-file-download' ); ?></a>
									<?php else : ?>
										<a href="<?php echo esc_url( wp_get_attachment_url( $entry['file_id'] ) ); ?>" target="_blank" class="otfd-link-title"><?php echo get_the_title( $entry['file_id'] ); ?></a>
									<?php endif; ?>
								</td>
								<td class="column num">
									<?php echo esc_html( $entry['total'] ); ?>
								</td>
								<td class="column num edit-icon">
									<a href="<?php echo admin_url( 'admin.php?page=otfd-entries&otfd_id=' . $entry['id'] ); ?>" title="<?php esc_html_e( 'Edit', 'wp-one-time-file-download' ); ?>" class="dashicons dashicons-visibility" ></a>
								</td>
							</tr>
						<?php endforeach; ?>
					</tbody>
				</table>
				<?php wp_nonce_field( 'otfd_nonce', 'otfd_nonce' ); ?>
			<?php endif; ?>
		</div>
	</div>
</div>
