<?php
/**
 * Main controller
 *
 * @package otfd
 * @subpackage _controllers
 * @since One Time File Download
 */

namespace Otfd\Controllers;

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

require_once OTFD_PLUGIN_PATH . '_controllers/class-db.php';
use Otfd\Controllers\Db as DbController;

/**
 * Class One Time File Download Controller
 *
 * @category Controller
 * @package  otfd
 * @author  IV | PIXOLETTE
 * @license  http://wp.pixollete.com
 * @link     http://wp.pixollete.com
 */
class Main {

	private $per_page = 20;
	private $page_nr = 1;

	/**
	 *
	 * Init function.
	 */
	function init_backend() {
		if ( isset( $_GET['page_nr'] ) && $_GET['page_nr'] > 1 ) {
			$this->page_nr = sanitize_text_field( wp_unslash( $_GET['page_nr'] ) );
		}

		$db = new DbController();
		$entries = $db->get_file_entries( $this->page_nr, $this->per_page );
		$total_entries = $db->get_total_file_entries();
		$total_pages = 1;
		if ( $total_entries && isset( $total_entries['total_entries'] ) ) {
			$total_pages = ceil( $total_entries['total_entries'] / $this->per_page );
		}
		$page_nr = $this->page_nr;

		include OTFD_PLUGIN_PATH . '_views/be-main.php';
	}

	/**
	 *
	 * Init function.
	 */
	function create_new() {
		$db = new DbController();
		$is_new = true;
		$otfd = array(
			'title' => '',
			'file_id' => '',
			'external_file_link' => '',
			'filename' => '',
			'valid_after_link_is_created' => '0',
			'valid_after_download' => '0',
			'created_by' => get_current_user_id(),
			'timestamp' => time(),
			'site_id' => get_current_blog_id(),
			'send_link_via_email' => 1,
			'content_is_cached' => 1,
			'link_title' => '',
			'link_css_class' => '',
			'days_to_keep_entries' => '',
			'display_download_page' => '0',
			'download_page_content' => '',
		);

		$otfd_errors = array();
		$required = array(
			'title' => 'required',
			'file_id' => 'required_if',
			'valid_after_link_is_created' => 'int',
			'valid_after_download' => 'int',
			'send_link_via_email' => 'int',
			'content_is_cached' => 'int',
		);
		$required_if = array(
			'file_id' => 'external_file_link',
		);

		$form_data_fields = array(
			'form_data_name' => 0,
			'form_data_name_label' => '',
			'form_data_email_label' => '',
			'form_data_terms' => 0,
			'form_data_terms_label' => '',
			'form_data_submit_label' => '',
		);
		$email_data_fields = array(
			'email_subject' => '',
			'email_from' => '',
			'email_from_name' => '',
			'email_content' => '',
		);
		$form_data_custom_fields = array();

		if ( isset( $_GET['otfd_id'] ) && intval( $_GET['otfd_id'] ) && !isset( $_POST['otfd_action'] ) ) {
			$entry = $db->get_file_entry( sanitize_text_field( wp_unslash( $_GET['otfd_id'] ) ) );
			// $otfd = array_intersect_key( $entry, $otfd );
			$otfd = $entry;
			$form_data_fields = json_decode( $otfd['form_data'], true );
			$email_data_fields = json_decode( $otfd['email_data'], true );
			if ( isset( $otfd['form_data_custom_fields'] ) ) {
				$form_data_custom_fields = json_decode( $otfd['form_data_custom_fields'], true );
			}
		}

		if ( isset( $_POST['otfd_action'] ) && !isset( $_POST['otfd_nonce'] ) || isset( $_POST['otfd_action'] ) && !wp_verify_nonce( $_POST['otfd_nonce'], 'otfd_nonce' ) ) {
			echo 'Invalid nonce';
			exit;
		} elseif ( isset( $_POST['otfd_action'] ) && wp_verify_nonce( $_POST['otfd_nonce'], 'otfd_nonce' ) ) {
			if ( 'delete' == $_POST['otfd_action'] ) {
				$db->update_file_entry( array( 'status' => '0' ), array( 'id' => intval( sanitize_text_field( wp_unslash( $_GET['otfd_id'] ) ) ) ), array( '%d' ) );
				$url = add_query_arg(
					array(
						'page' => 'otfd',
					),
					get_admin_url( null, 'admin.php' )
				);
				wp_redirect( $url );
				exit;
			} else {
				foreach ( $otfd as $field => $value ) {
					if ( isset( $required[ $field ] ) ) {
						switch ( $required[ $field ] ) {
							case 'required':
								if ( sanitize_text_field( wp_unslash( $_POST[ $field ] ) ) ) {
									$otfd[ $field ] = sanitize_text_field( wp_unslash( $_POST[ $field ] ) );
								} else {
									$otfd[ $field ] = sanitize_text_field( wp_unslash( $_POST[ $field ] ) );
									$otfd_errors[ $field ] = esc_html__( 'This field is required.', 'wp-one-time-file-download' );
								}
								break;
							case 'required_if':
								if ( sanitize_text_field( wp_unslash( $_POST[ $field ] ) ) ) {
									$otfd[ $field ] = sanitize_text_field( wp_unslash( $_POST[ $field ] ) );
								} else {
									if ( sanitize_text_field( wp_unslash( $_POST[ $required_if[ $field ] ] ) ) ) {
										continue;
									} else {
										$otfd[ $field ] = sanitize_text_field( wp_unslash( $_POST[ $field ] ) );
										$otfd_errors[ $field ] = esc_html__( 'This field is required.', 'wp-one-time-file-download' );
									}
								}
								break;
							case 'int':
								if ( sanitize_text_field( wp_unslash( $_POST[ $field ] ) ) && intval( sanitize_text_field( wp_unslash( $_POST[ $field ] ) ) ) || 0 == sanitize_text_field( wp_unslash( $_POST[ $field ] ) ) ) {
									$otfd[ $field ] = (int) sanitize_text_field( wp_unslash( $_POST[ $field ] ) );
								} else {
									$otfd[ $field ] = sanitize_text_field( wp_unslash( $_POST[ $field ] ) );
									$otfd_errors[ $field ] = esc_html__( 'This one should be a number.', 'wp-one-time-file-download' );
								}
								break;
							default:
								if ( 'download_page_content' == $field ) {
									// $otfd[ $field ] = sanitize_text_field( wp_unslash( $_POST[ $field ] ) );
									$otfd[ $field ] = wp_kses_post( stripslashes( $_POST[ $field ] ) );
								} elseif ( sanitize_text_field( wp_unslash( $_POST[ $field ] ) ) ) {
									$otfd[ $field ] = sanitize_text_field( wp_unslash( $_POST[ $field ] ) );
								}
								break;
						}
					} else {
						if ( isset( $_POST[ $field ] ) && 'download_page_content' == $field ) {
							// $otfd[ $field ] = sanitize_text_field( wp_unslash( $_POST[ $field ] ) );
							$otfd[ $field ] = wp_kses_post( stripslashes( $_POST[ $field ] ) );
						} elseif ( isset( $_POST[ $field ] ) && sanitize_text_field( wp_unslash( $_POST[ $field ] ) ) ) {
							$field_val = sanitize_text_field( wp_unslash( $_POST[ $field ] ) );
							$otfd[ $field ] = $field_val;
						}
					}
				}
				foreach ( $form_data_fields as $field => $value ) {
					if ( 'form_data_terms_label' == $field ) {
						if ( isset( $_POST[ $field ] ) && sanitize_text_field( wp_unslash( $_POST[ $field ] ) ) ) {
							$form_data_fields[ $field ] = wp_kses( $_POST[ $field ], array( 'a' => array( 'href' => array(), 'target' => array( '_blank' ) ) ) );
						}
					} else {
						if ( isset( $_POST[ $field ] ) && sanitize_text_field( wp_unslash( $_POST[ $field ] ) ) ) {
							$field_val = sanitize_text_field( wp_unslash( $_POST[ $field ] ) );
							$form_data_fields[ $field ] = $field_val;
						}
					}
				}
				foreach ( $email_data_fields as $field => $value ) {
					if ( 'email_content' == $field ) {
						if ( isset( $_POST[ $field ] ) && sanitize_text_field( wp_unslash( $_POST[ $field ] ) ) ) {
							$email_data_fields[ $field ] = wp_kses_post( $_POST[ $field ] );
						}
					} else {
						if ( isset( $_POST[ $field ] ) && sanitize_text_field( wp_unslash( $_POST[ $field ] ) ) ) {
							$email_data_fields[ $field ] = sanitize_text_field( wp_unslash( $_POST[ $field ] ) );
						}
					}
				}
				// check for form custom fields
				$fd_custom_fields = array();
				if ( isset( $_POST['form_data_custom_fields'] ) && is_array( $_POST['form_data_custom_fields'] ) ) {
					foreach ( $_POST['form_data_custom_fields'] as $key => $value ) {
						$sanitized_value = sanitize_text_field( wp_unslash( $value ) );
						if ( !empty( $sanitized_value ) ) {
							$fd_custom_fields[] = array(
								'type' => 'text',
								'name' => $sanitized_value,
							);
						}
					}
				}
				if ( count( $otfd_errors ) ) {
					$otfd_errors['error_message'] = esc_html__( 'Please fix the errors above.', 'wp-one-time-file-download' );
				} else {
					$otfd['form_data'] = wp_json_encode( $form_data_fields );
					$otfd['form_data_custom_fields'] = wp_json_encode( $fd_custom_fields );
					$otfd['email_data'] = wp_json_encode( $email_data_fields );
					if ( !isset( $_GET['otfd_id'] ) || isset( $_GET['otfd_id'] ) && 'new' == $_GET['otfd_id'] ) {
						$id = $db->create_new_file_entry( $otfd );
						$url = add_query_arg(
							array(
								'page'         => 'otfd-edit',
								'otfd_created' => '1',
								'otfd_id'      => $id,
							),
							get_admin_url( null, 'admin.php' )
						);

						wp_redirect( $url );
						exit;
					} else {
						$curr_id = intval( sanitize_text_field( wp_unslash( $_GET['otfd_id'] ) ) );
						$db->update_file_entry( $otfd, array( 'id' => $curr_id ) );
						$url = add_query_arg(
							array(
								'otfd_updated' => '1',
								'page'         => 'otfd-edit',
								'otfd_id'      => $curr_id,
							),
							get_admin_url( null, 'admin.php' )
						);
						wp_redirect( $url );
						exit;
					}
				}
			}
		}

		include OTFD_PLUGIN_PATH . '_views/be-item.php';
	}


	/**
	 *
	 * Init function.
	 */
	function form_entries() {
		if ( isset( $_GET['page_nr'] ) && $_GET['page_nr'] > 1 ) {
			$page_nr = sanitize_text_field( wp_unslash( $_GET['page_nr'] ) );
		} else {
			$page_nr = 1;
		}

		$db = new DbController();
		$otfd_message = '';

		if ( isset( $_GET['otfd_id'] ) ) {
			$otfd_id = sanitize_text_field( wp_unslash( $_GET['otfd_id'] ) );
			$form_data = $db->get_file_entry( sanitize_text_field( wp_unslash( $_GET['otfd_id'] ) ) );

			if ( isset( $_POST['otfd_action'] ) && !isset( $_POST['otfd_nonce'] ) || isset( $_POST['otfd_action'] ) && !wp_verify_nonce( $_POST['otfd_nonce'], 'otfd_nonce' ) ) {
				echo 'Invalid nonce';
				exit;
			} elseif ( isset( $_POST['otfd_action'] ) && wp_verify_nonce( $_POST['otfd_nonce'], 'otfd_nonce' ) ) {
				switch ( sanitize_text_field( wp_unslash( $_POST['otfd_action'] ) ) ) {
					case 'delete_entry':
						$otfd_entry_id = (int) sanitize_text_field( wp_unslash( $_POST['otfd_entry_id'] ) );
						unset( $_POST['otfd_entry_id'] );
						$otfd_message = esc_html__( 'Form entry successfully deleted', 'wp-one-time-file-download' );
						$db->delete_link_entry( $otfd_entry_id );
						break;
				}
			}

			$entries = $db->get_form_entries_for_form( $otfd_id, $page_nr, $this->per_page );
			$entries_count = $db->get_count_form_entries_for_form( $otfd_id );
			$total_pages = 1;
			if ( $entries_count && isset( $entries_count['total_entries'] ) ) {
				$total_pages = ceil( $entries_count['total_entries'] / $this->per_page );
			}
			include OTFD_PLUGIN_PATH . '_views/be-entry.php';
		} else {
			$entries = $db->get_form_entries_count( $page_nr, $this->per_page );
			include OTFD_PLUGIN_PATH . '_views/be-entries.php';
		}
	}

	public static function gmt_to_local_timestamp( $gmt_timestamp ) {
		return get_date_from_gmt( date( 'Y-m-d H:i:s', $gmt_timestamp ), 'd M Y, H:i' );
	}

}
