<?php
/**
 * Main controller
 *
 * @package otfd
 * @subpackage _controllers
 * @since One Time File Download
 */

namespace Otfd\Controllers;

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

require_once OTFD_PLUGIN_PATH . '_controllers/class-db.php';
use Otfd\Controllers\Db as DbController;

/**
 * Class Link
 *
 * @category Controller
 * @package  otfd
 * @author  IV | PIXOLETTE
 * @license  http://wp.pixollete.com
 * @link     http://wp.pixollete.com
 */
class Link {

	private $valid_after_link_is_created = 1440; // number of minutes: 1440 = 24 hours
	private $valid_after_download        = 0; // link will be deactivated instantly after download.

	/**
	 *
	 * Generate unique key function.
	 */
	function generate_link_key( $file_id ) {
		$key = md5( microtime() . $file_id . rand() );

		return $key;
	}

	/**
	 *
	 * Generate full download url function.
	 */
	function generate_full_download_url( $url_key ) {
		$full_url = get_site_url() . '/index.php/wp-one-time-file-download/?wp_otfd_file=' . $url_key;

		return $full_url;
	}

	function create_link( $data ) {
		$db = new DbController();

		$link_data = array(
			'otfd_id'    => 0,
			'created_at' => time(),
			'expire_at'  => time(),
			'is_valid'   => 0,
			'url_key'   => '',
			'user_data'   => '',
		);

		$link_data_format = array(
			'%d',
			'%d',
			'%d',
			'%d',
			'%s',
			'%s',
		);

		$link_data = array_merge( $link_data, $data );

		$link_id = $db->create_new_link_entry( $link_data, $link_data_format );

		return $link_id;
	}

	function get_file_url_if_link_valid( $url_key ) {
		$db = new DbController();
		$link_entry = $db->get_link_entry_by_url_key( $url_key );

		if ( isset( $link_entry ) ) {
			if ( 0 == $link_entry['expire_at'] || time() < $link_entry['expire_at'] ) {
				// if ( 0 == $link_entry['expire_at'] ) {
				// 	$expire_time = time() + $link_entry['valid_after_download'] * 60;
				// 	$updated = $db->update_link_entry( array( 'expire_at' => $expire_time, 'is_downloaded' => 1, 'downloaded_timestamp' => time() ), array( 'id' => $link_entry['linkid'] ) );
				// } elseif ( 0 == $link_entry['is_downloaded'] ) {
				// 	$expire_time = time() + $link_entry['valid_after_download'] * 60;
				// 	$updated = $db->update_link_entry( array( 'expire_at' => $expire_time, 'is_downloaded' => 1, 'downloaded_timestamp' => time() ), array( 'id' => $link_entry['linkid'] ) );
				// }

				if ( isset( $link_entry['external_file_link'] ) && !empty( $link_entry['external_file_link'] ) ) {
					$download_link = $link_entry['external_file_link'];
				} else {
					$download_link = wp_get_attachment_url( $link_entry['file_id'] );
				}
				$download_data = wp_check_filetype( $download_link );
				return array(
					'link' => $download_link,
					'filename' => $link_entry['filename'],
					'id' => $link_entry['otfd_id'],
					'display_download_page' => $link_entry['display_download_page'],
					'download_page_content' => $link_entry['download_page_content'],
				);
			} else {
				return array(
					'id' => $link_entry['otfd_id'],
					'display_download_page' => $link_entry['display_download_page'],
					'download_page_content' => $link_entry['download_page_content'],
				);
			}
		}
	}

	function mark_file_url_as_downloaded( $url_key ) {
		$db = new DbController();
		$link_entry = $db->get_link_entry_by_url_key( $url_key );

		if ( isset( $link_entry ) ) {
			if ( 0 == $link_entry['expire_at'] || time() < $link_entry['expire_at'] ) {
				if ( 0 == $link_entry['expire_at'] ) {
					$expire_time = time() + $link_entry['valid_after_download'] * 60;
					$updated = $db->update_link_entry( array( 'expire_at' => $expire_time, 'is_downloaded' => 1, 'downloaded_timestamp' => time() ), array( 'id' => $link_entry['linkid'] ) );
				} elseif ( 0 == $link_entry['is_downloaded'] ) {
					$expire_time = time() + $link_entry['valid_after_download'] * 60;
					$updated = $db->update_link_entry( array( 'expire_at' => $expire_time, 'is_downloaded' => 1, 'downloaded_timestamp' => time() ), array( 'id' => $link_entry['linkid'] ) );
				}
			}
		}
	}

	function generate_unique_download_link_by_otfd_id( $otfd_id, $form_data = array() ) {
		// init db
		$db = new DbController();
		// get file row
		$file_entry = $db->get_file_entry( $otfd_id );
		// if file entry exists
		if ( isset( $file_entry ) ) {
			// valability?
			if ( 0 == $file_entry['valid_after_link_is_created'] ) {
				$valid_after_link_is_created = 0;
			} else {
				$valid_after_link_is_created = time() + $file_entry['valid_after_link_is_created'] * 60;
			}

			// data to store
			$link_data = array(
				'otfd_id'    => (int) sanitize_text_field( wp_unslash( $otfd_id ) ),
				'created_at' => time(),
				'expire_at'  => $valid_after_link_is_created,
				'is_valid'   => 1,
			);

			if ( !empty( $form_data ) ) {
				$link_data['user_data'] = wp_json_encode( $form_data );
			}

			$url_key              = $this->generate_link_key( $link_data['otfd_id'] );
			$link_data['url_key'] = $url_key;
			$link_id              = $this->create_link( $link_data );

			$link = $this->generate_full_download_url( $url_key );

			return $link;
		} else {
			return false;
		}
	}

	function should_generate_link_via_php( $otfd_id ) {
		// init db
		$db = new DbController();
		// get file row
		$file_entry = $db->get_file_entry( $otfd_id );
		// if file entry exists
		if ( isset( $file_entry ) ) {
			return $file_entry['content_is_cached'];
		}
	}

}
