<?php
/**
 * MailingListsApi
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Moosend API
 *
 * TODO: Add a description
 *
 * OpenAPI spec version: 1.0
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Api;

use \Swagger\Client\ApiClient;
use \Swagger\Client\ApiException;
use \Swagger\Client\Configuration;
use \Swagger\Client\ObjectSerializer;

/**
 * MailingListsApi Class Doc Comment
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class MailingListsApi
{
    /**
     * API Client
     *
     * @var \Swagger\Client\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \Swagger\Client\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\Swagger\Client\ApiClient $apiClient = null)
    {
        if ($apiClient === null) {
            $apiClient = new ApiClient();
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \Swagger\Client\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \Swagger\Client\ApiClient $apiClient set the API client
     *
     * @return MailingListsApi
     */
    public function setApiClient(\Swagger\Client\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation creatingACustomField
     *
     * Creating a custom field
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $mailing_list_id The ID of the mailing list where the custom field will belong. (required)
     * @param \Swagger\Client\Model\CreatingACustomFieldRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\CreatingACustomFieldResponse
     */
    public function creatingACustomField($format, $apikey, $mailing_list_id, $body)
    {
        list($response) = $this->creatingACustomFieldWithHttpInfo($format, $apikey, $mailing_list_id, $body);
        return $response;
    }

    /**
     * Operation creatingACustomFieldWithHttpInfo
     *
     * Creating a custom field
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $mailing_list_id The ID of the mailing list where the custom field will belong. (required)
     * @param \Swagger\Client\Model\CreatingACustomFieldRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\CreatingACustomFieldResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function creatingACustomFieldWithHttpInfo($format, $apikey, $mailing_list_id, $body)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling creatingACustomField');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling creatingACustomField');
        }
        // verify the required parameter 'mailing_list_id' is set
        if ($mailing_list_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $mailing_list_id when calling creatingACustomField');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling creatingACustomField');
        }
        // parse inputs
        $resourcePath = "/lists/{MailingListID}/customfields/create.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($mailing_list_id !== null) {
            $resourcePath = str_replace(
                "{" . "MailingListID" . "}",
                $this->apiClient->getSerializer()->toPathValue($mailing_list_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\CreatingACustomFieldResponse',
                '/lists/{MailingListID}/customfields/create.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\CreatingACustomFieldResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\CreatingACustomFieldResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation creatingAMailingList
     *
     * Creating a mailing list
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param \Swagger\Client\Model\CreatingAMailingListRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\CreatingAMailingListResponse
     */
    public function creatingAMailingList($format, $apikey, $body)
    {
        list($response) = $this->creatingAMailingListWithHttpInfo($format, $apikey, $body);
        return $response;
    }

    /**
     * Operation creatingAMailingListWithHttpInfo
     *
     * Creating a mailing list
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param \Swagger\Client\Model\CreatingAMailingListRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\CreatingAMailingListResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function creatingAMailingListWithHttpInfo($format, $apikey, $body)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling creatingAMailingList');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling creatingAMailingList');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling creatingAMailingList');
        }
        // parse inputs
        $resourcePath = "/lists/create.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\CreatingAMailingListResponse',
                '/lists/create.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\CreatingAMailingListResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\CreatingAMailingListResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deletingAMailingList
     *
     * Deleting a mailing list
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $mailing_list_id The ID of the mailing list to be deleted. (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\DeletingAMailingListResponse
     */
    public function deletingAMailingList($format, $apikey, $mailing_list_id)
    {
        list($response) = $this->deletingAMailingListWithHttpInfo($format, $apikey, $mailing_list_id);
        return $response;
    }

    /**
     * Operation deletingAMailingListWithHttpInfo
     *
     * Deleting a mailing list
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $mailing_list_id The ID of the mailing list to be deleted. (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\DeletingAMailingListResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function deletingAMailingListWithHttpInfo($format, $apikey, $mailing_list_id)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling deletingAMailingList');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling deletingAMailingList');
        }
        // verify the required parameter 'mailing_list_id' is set
        if ($mailing_list_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $mailing_list_id when calling deletingAMailingList');
        }
        // parse inputs
        $resourcePath = "/lists/{MailingListID}/delete.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($mailing_list_id !== null) {
            $resourcePath = str_replace(
                "{" . "MailingListID" . "}",
                $this->apiClient->getSerializer()->toPathValue($mailing_list_id),
                $resourcePath
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\DeletingAMailingListResponse',
                '/lists/{MailingListID}/delete.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\DeletingAMailingListResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\DeletingAMailingListResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation gettingAllActiveMailingLists
     *
     * Getting all active mailing lists
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $with_statistics Specifies whether to fetch statistics for the subscribers or not. If omitted, results will be returned with statistics by default. (optional)
     * @param string $short_by The name of the campaign property to sort results by. If not specified, results will be sorted by the CreatedOn property (optional)
     * @param string $sort_method The method to sort results: ASC for ascending, DESC for descending. If not specified, &#x60;ASC&#x60; will be assumed (optional)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\GettingAllActiveMailingListsResponse
     */
    public function gettingAllActiveMailingLists($format, $apikey, $with_statistics = null, $short_by = null, $sort_method = null)
    {
        list($response) = $this->gettingAllActiveMailingListsWithHttpInfo($format, $apikey, $with_statistics, $short_by, $sort_method);
        return $response;
    }

    /**
     * Operation gettingAllActiveMailingListsWithHttpInfo
     *
     * Getting all active mailing lists
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $with_statistics Specifies whether to fetch statistics for the subscribers or not. If omitted, results will be returned with statistics by default. (optional)
     * @param string $short_by The name of the campaign property to sort results by. If not specified, results will be sorted by the CreatedOn property (optional)
     * @param string $sort_method The method to sort results: ASC for ascending, DESC for descending. If not specified, &#x60;ASC&#x60; will be assumed (optional)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\GettingAllActiveMailingListsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function gettingAllActiveMailingListsWithHttpInfo($format, $apikey, $with_statistics = null, $short_by = null, $sort_method = null)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling gettingAllActiveMailingLists');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling gettingAllActiveMailingLists');
        }
        // parse inputs
        $resourcePath = "/lists.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // query params
        if ($with_statistics !== null) {
            $queryParams['WithStatistics'] = $this->apiClient->getSerializer()->toQueryValue($with_statistics);
        }
        // query params
        if ($short_by !== null) {
            $queryParams['ShortBy'] = $this->apiClient->getSerializer()->toQueryValue($short_by);
        }
        // query params
        if ($sort_method !== null) {
            $queryParams['SortMethod'] = $this->apiClient->getSerializer()->toQueryValue($sort_method);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\GettingAllActiveMailingListsResponse',
                '/lists.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\GettingAllActiveMailingListsResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\GettingAllActiveMailingListsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation gettingAllActiveMailingListsWithPaging
     *
     * Getting all active mailing lists with paging
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param double $page The page that you want to get. (required)
     * @param double $page_size Lists Per Page. (required)
     * @param string $short_by The name of the campaign property to sort results by. If not specified, results will be sorted by the CreatedOn property (optional)
     * @param string $sort_method The method to sort results: ASC for ascending, DESC for descending. If not specified, &#x60;ASC&#x60; will be assumed (optional)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\GettingAllActiveMailingListsWithPagingResponse
     */
    public function gettingAllActiveMailingListsWithPaging($format, $apikey, $page, $page_size, $short_by = null, $sort_method = null)
    {
        list($response) = $this->gettingAllActiveMailingListsWithPagingWithHttpInfo($format, $apikey, $page, $page_size, $short_by, $sort_method);
        return $response;
    }

    /**
     * Operation gettingAllActiveMailingListsWithPagingWithHttpInfo
     *
     * Getting all active mailing lists with paging
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param double $page The page that you want to get. (required)
     * @param double $page_size Lists Per Page. (required)
     * @param string $short_by The name of the campaign property to sort results by. If not specified, results will be sorted by the CreatedOn property (optional)
     * @param string $sort_method The method to sort results: ASC for ascending, DESC for descending. If not specified, &#x60;ASC&#x60; will be assumed (optional)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\GettingAllActiveMailingListsWithPagingResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function gettingAllActiveMailingListsWithPagingWithHttpInfo($format, $apikey, $page, $page_size, $short_by = null, $sort_method = null)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling gettingAllActiveMailingListsWithPaging');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling gettingAllActiveMailingListsWithPaging');
        }
        // verify the required parameter 'page' is set
        if ($page === null) {
            throw new \InvalidArgumentException('Missing the required parameter $page when calling gettingAllActiveMailingListsWithPaging');
        }
        // verify the required parameter 'page_size' is set
        if ($page_size === null) {
            throw new \InvalidArgumentException('Missing the required parameter $page_size when calling gettingAllActiveMailingListsWithPaging');
        }
        // parse inputs
        $resourcePath = "/lists/{Page}/{PageSize}.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // query params
        if ($short_by !== null) {
            $queryParams['ShortBy'] = $this->apiClient->getSerializer()->toQueryValue($short_by);
        }
        // query params
        if ($sort_method !== null) {
            $queryParams['SortMethod'] = $this->apiClient->getSerializer()->toQueryValue($sort_method);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($page !== null) {
            $resourcePath = str_replace(
                "{" . "Page" . "}",
                $this->apiClient->getSerializer()->toPathValue($page),
                $resourcePath
            );
        }
        // path params
        if ($page_size !== null) {
            $resourcePath = str_replace(
                "{" . "PageSize" . "}",
                $this->apiClient->getSerializer()->toPathValue($page_size),
                $resourcePath
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\GettingAllActiveMailingListsWithPagingResponse',
                '/lists/{Page}/{PageSize}.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\GettingAllActiveMailingListsWithPagingResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\GettingAllActiveMailingListsWithPagingResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation gettingMailingListDetails
     *
     * Getting mailing list details
     *
     * @param string $format  (required)
     * @param string $mailing_list_id The ID of the mailing list to be returned. (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $with_statistics Specifies whether to fetch statistics for the subscribers or not. If omitted, results will be returned with statistics by default. (optional)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\GettingMailingListDetailsResponse
     */
    public function gettingMailingListDetails($format, $mailing_list_id, $apikey, $with_statistics = null)
    {
        list($response) = $this->gettingMailingListDetailsWithHttpInfo($format, $mailing_list_id, $apikey, $with_statistics);
        return $response;
    }

    /**
     * Operation gettingMailingListDetailsWithHttpInfo
     *
     * Getting mailing list details
     *
     * @param string $format  (required)
     * @param string $mailing_list_id The ID of the mailing list to be returned. (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $with_statistics Specifies whether to fetch statistics for the subscribers or not. If omitted, results will be returned with statistics by default. (optional)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\GettingMailingListDetailsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function gettingMailingListDetailsWithHttpInfo($format, $mailing_list_id, $apikey, $with_statistics = null)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling gettingMailingListDetails');
        }
        // verify the required parameter 'mailing_list_id' is set
        if ($mailing_list_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $mailing_list_id when calling gettingMailingListDetails');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling gettingMailingListDetails');
        }
        // parse inputs
        $resourcePath = "/lists/{MailingListID}/details.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // query params
        if ($with_statistics !== null) {
            $queryParams['WithStatistics'] = $this->apiClient->getSerializer()->toQueryValue($with_statistics);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($mailing_list_id !== null) {
            $resourcePath = str_replace(
                "{" . "MailingListID" . "}",
                $this->apiClient->getSerializer()->toPathValue($mailing_list_id),
                $resourcePath
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\GettingMailingListDetailsResponse',
                '/lists/{MailingListID}/details.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\GettingMailingListDetailsResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\GettingMailingListDetailsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation removingACustomField
     *
     * Removing a custom field
     *
     * @param string $format  (required)
     * @param string $custom_field_id The ID of the custom field to be deleted. (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $mailing_list_id The ID of the mailing list where the custom field belongs. (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\RemovingACustomFieldResponse
     */
    public function removingACustomField($format, $custom_field_id, $apikey, $mailing_list_id)
    {
        list($response) = $this->removingACustomFieldWithHttpInfo($format, $custom_field_id, $apikey, $mailing_list_id);
        return $response;
    }

    /**
     * Operation removingACustomFieldWithHttpInfo
     *
     * Removing a custom field
     *
     * @param string $format  (required)
     * @param string $custom_field_id The ID of the custom field to be deleted. (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $mailing_list_id The ID of the mailing list where the custom field belongs. (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\RemovingACustomFieldResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function removingACustomFieldWithHttpInfo($format, $custom_field_id, $apikey, $mailing_list_id)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling removingACustomField');
        }
        // verify the required parameter 'custom_field_id' is set
        if ($custom_field_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $custom_field_id when calling removingACustomField');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling removingACustomField');
        }
        // verify the required parameter 'mailing_list_id' is set
        if ($mailing_list_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $mailing_list_id when calling removingACustomField');
        }
        // parse inputs
        $resourcePath = "/lists/{MailingListID}/customfields/{CustomFieldID}/delete.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($custom_field_id !== null) {
            $resourcePath = str_replace(
                "{" . "CustomFieldID" . "}",
                $this->apiClient->getSerializer()->toPathValue($custom_field_id),
                $resourcePath
            );
        }
        // path params
        if ($mailing_list_id !== null) {
            $resourcePath = str_replace(
                "{" . "MailingListID" . "}",
                $this->apiClient->getSerializer()->toPathValue($mailing_list_id),
                $resourcePath
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\RemovingACustomFieldResponse',
                '/lists/{MailingListID}/customfields/{CustomFieldID}/delete.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\RemovingACustomFieldResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\RemovingACustomFieldResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updatingACustomField
     *
     * Updating a custom field
     *
     * @param string $format  (required)
     * @param string $custom_field_id The ID of the custom field to be updated. (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $mailing_list_id The ID of the mailing list where the custom field belongs. (required)
     * @param \Swagger\Client\Model\UpdatingACustomFieldRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\UpdatingACustomFieldResponse
     */
    public function updatingACustomField($format, $custom_field_id, $apikey, $mailing_list_id, $body)
    {
        list($response) = $this->updatingACustomFieldWithHttpInfo($format, $custom_field_id, $apikey, $mailing_list_id, $body);
        return $response;
    }

    /**
     * Operation updatingACustomFieldWithHttpInfo
     *
     * Updating a custom field
     *
     * @param string $format  (required)
     * @param string $custom_field_id The ID of the custom field to be updated. (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $mailing_list_id The ID of the mailing list where the custom field belongs. (required)
     * @param \Swagger\Client\Model\UpdatingACustomFieldRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\UpdatingACustomFieldResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatingACustomFieldWithHttpInfo($format, $custom_field_id, $apikey, $mailing_list_id, $body)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling updatingACustomField');
        }
        // verify the required parameter 'custom_field_id' is set
        if ($custom_field_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $custom_field_id when calling updatingACustomField');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling updatingACustomField');
        }
        // verify the required parameter 'mailing_list_id' is set
        if ($mailing_list_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $mailing_list_id when calling updatingACustomField');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling updatingACustomField');
        }
        // parse inputs
        $resourcePath = "/lists/{MailingListID}/customfields/{CustomFieldID}/update.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($custom_field_id !== null) {
            $resourcePath = str_replace(
                "{" . "CustomFieldID" . "}",
                $this->apiClient->getSerializer()->toPathValue($custom_field_id),
                $resourcePath
            );
        }
        // path params
        if ($mailing_list_id !== null) {
            $resourcePath = str_replace(
                "{" . "MailingListID" . "}",
                $this->apiClient->getSerializer()->toPathValue($mailing_list_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\UpdatingACustomFieldResponse',
                '/lists/{MailingListID}/customfields/{CustomFieldID}/update.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\UpdatingACustomFieldResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\UpdatingACustomFieldResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updatingAMailingList
     *
     * Updating a mailing list
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $mailing_list_id The ID of the mailing list to be updated. (required)
     * @param \Swagger\Client\Model\UpdatingAMailingListRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\UpdatingAMailingListResponse
     */
    public function updatingAMailingList($format, $apikey, $mailing_list_id, $body)
    {
        list($response) = $this->updatingAMailingListWithHttpInfo($format, $apikey, $mailing_list_id, $body);
        return $response;
    }

    /**
     * Operation updatingAMailingListWithHttpInfo
     *
     * Updating a mailing list
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $mailing_list_id The ID of the mailing list to be updated. (required)
     * @param \Swagger\Client\Model\UpdatingAMailingListRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\UpdatingAMailingListResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatingAMailingListWithHttpInfo($format, $apikey, $mailing_list_id, $body)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling updatingAMailingList');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling updatingAMailingList');
        }
        // verify the required parameter 'mailing_list_id' is set
        if ($mailing_list_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $mailing_list_id when calling updatingAMailingList');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling updatingAMailingList');
        }
        // parse inputs
        $resourcePath = "/lists/{MailingListID}/update.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($mailing_list_id !== null) {
            $resourcePath = str_replace(
                "{" . "MailingListID" . "}",
                $this->apiClient->getSerializer()->toPathValue($mailing_list_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\UpdatingAMailingListResponse',
                '/lists/{MailingListID}/update.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\UpdatingAMailingListResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\UpdatingAMailingListResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
