<?php
/**
 * SubscribersApi
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Moosend API
 *
 * TODO: Add a description
 *
 * OpenAPI spec version: 1.0
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Api;

use \Swagger\Client\ApiClient;
use \Swagger\Client\ApiException;
use \Swagger\Client\Configuration;
use \Swagger\Client\ObjectSerializer;

/**
 * SubscribersApi Class Doc Comment
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class SubscribersApi
{
    /**
     * API Client
     *
     * @var \Swagger\Client\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \Swagger\Client\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\Swagger\Client\ApiClient $apiClient = null)
    {
        if ($apiClient === null) {
            $apiClient = new ApiClient();
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \Swagger\Client\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \Swagger\Client\ApiClient $apiClient set the API client
     *
     * @return SubscribersApi
     */
    public function setApiClient(\Swagger\Client\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation addingMultipleSubscribers
     *
     * Adding multiple subscribers
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $mailing_list_id The ID of the mailing list to add subscribers to. (required)
     * @param \Swagger\Client\Model\AddingMultipleSubscribersRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\AddingMultipleSubscribersResponse
     */
    public function addingMultipleSubscribers($format, $apikey, $mailing_list_id, $body)
    {
        list($response) = $this->addingMultipleSubscribersWithHttpInfo($format, $apikey, $mailing_list_id, $body);
        return $response;
    }

    /**
     * Operation addingMultipleSubscribersWithHttpInfo
     *
     * Adding multiple subscribers
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $mailing_list_id The ID of the mailing list to add subscribers to. (required)
     * @param \Swagger\Client\Model\AddingMultipleSubscribersRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\AddingMultipleSubscribersResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function addingMultipleSubscribersWithHttpInfo($format, $apikey, $mailing_list_id, $body)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling addingMultipleSubscribers');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling addingMultipleSubscribers');
        }
        // verify the required parameter 'mailing_list_id' is set
        if ($mailing_list_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $mailing_list_id when calling addingMultipleSubscribers');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling addingMultipleSubscribers');
        }
        // parse inputs
        $resourcePath = "/subscribers/{MailingListID}/subscribe_many.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($mailing_list_id !== null) {
            $resourcePath = str_replace(
                "{" . "MailingListID" . "}",
                $this->apiClient->getSerializer()->toPathValue($mailing_list_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\AddingMultipleSubscribersResponse',
                '/subscribers/{MailingListID}/subscribe_many.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\AddingMultipleSubscribersResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\AddingMultipleSubscribersResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation addingSubscribers
     *
     * Adding subscribers
     *
     * @param string $format  (required)
     * @param string $mailing_list_id The ID of the mailing list to add the new member. (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param \Swagger\Client\Model\AddingSubscribersRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\AddingSubscribersResponse
     */
    public function addingSubscribers($format, $mailing_list_id, $apikey, $body)
    {
        list($response) = $this->addingSubscribersWithHttpInfo($format, $mailing_list_id, $apikey, $body);
        return $response;
    }

    /**
     * Operation addingSubscribersWithHttpInfo
     *
     * Adding subscribers
     *
     * @param string $format  (required)
     * @param string $mailing_list_id The ID of the mailing list to add the new member. (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param \Swagger\Client\Model\AddingSubscribersRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\AddingSubscribersResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function addingSubscribersWithHttpInfo($format, $mailing_list_id, $apikey, $body)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling addingSubscribers');
        }
        // verify the required parameter 'mailing_list_id' is set
        if ($mailing_list_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $mailing_list_id when calling addingSubscribers');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling addingSubscribers');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling addingSubscribers');
        }
        // parse inputs
        $resourcePath = "/subscribers/{MailingListID}/subscribe.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($mailing_list_id !== null) {
            $resourcePath = str_replace(
                "{" . "MailingListID" . "}",
                $this->apiClient->getSerializer()->toPathValue($mailing_list_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\AddingSubscribersResponse',
                '/subscribers/{MailingListID}/subscribe.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\AddingSubscribersResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\AddingSubscribersResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getSubscriberByEmailAddress
     *
     * Get subscriber by email address
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $mailing_list_id The ID of the mailing list where the subscriber belongs. (required)
     * @param string $email The email of the subscriber. (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\GetSubscriberByEmailAddressResponse
     */
    public function getSubscriberByEmailAddress($format, $apikey, $mailing_list_id, $email)
    {
        list($response) = $this->getSubscriberByEmailAddressWithHttpInfo($format, $apikey, $mailing_list_id, $email);
        return $response;
    }

    /**
     * Operation getSubscriberByEmailAddressWithHttpInfo
     *
     * Get subscriber by email address
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $mailing_list_id The ID of the mailing list where the subscriber belongs. (required)
     * @param string $email The email of the subscriber. (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\GetSubscriberByEmailAddressResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSubscriberByEmailAddressWithHttpInfo($format, $apikey, $mailing_list_id, $email)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling getSubscriberByEmailAddress');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling getSubscriberByEmailAddress');
        }
        // verify the required parameter 'mailing_list_id' is set
        if ($mailing_list_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $mailing_list_id when calling getSubscriberByEmailAddress');
        }
        // verify the required parameter 'email' is set
        if ($email === null) {
            throw new \InvalidArgumentException('Missing the required parameter $email when calling getSubscriberByEmailAddress');
        }
        // parse inputs
        $resourcePath = "/subscribers/{MailingListID}/view.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // query params
        if ($email !== null) {
            $queryParams['Email'] = $this->apiClient->getSerializer()->toQueryValue($email);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($mailing_list_id !== null) {
            $resourcePath = str_replace(
                "{" . "MailingListID" . "}",
                $this->apiClient->getSerializer()->toPathValue($mailing_list_id),
                $resourcePath
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\GetSubscriberByEmailAddressResponse',
                '/subscribers/{MailingListID}/view.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\GetSubscriberByEmailAddressResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\GetSubscriberByEmailAddressResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getSubscriberById
     *
     * Get subscriber by id
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $mailing_list_id The ID of the mailing list to search the subscriber in. (required)
     * @param string $subscriber_id The id of the subscriber being searched. (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\GetSubscriberByIdResponse
     */
    public function getSubscriberById($format, $apikey, $mailing_list_id, $subscriber_id)
    {
        list($response) = $this->getSubscriberByIdWithHttpInfo($format, $apikey, $mailing_list_id, $subscriber_id);
        return $response;
    }

    /**
     * Operation getSubscriberByIdWithHttpInfo
     *
     * Get subscriber by id
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $mailing_list_id The ID of the mailing list to search the subscriber in. (required)
     * @param string $subscriber_id The id of the subscriber being searched. (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\GetSubscriberByIdResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSubscriberByIdWithHttpInfo($format, $apikey, $mailing_list_id, $subscriber_id)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling getSubscriberById');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling getSubscriberById');
        }
        // verify the required parameter 'mailing_list_id' is set
        if ($mailing_list_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $mailing_list_id when calling getSubscriberById');
        }
        // verify the required parameter 'subscriber_id' is set
        if ($subscriber_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $subscriber_id when calling getSubscriberById');
        }
        // parse inputs
        $resourcePath = "/subscribers/{MailingListID}/find/{SubscriberID}.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($mailing_list_id !== null) {
            $resourcePath = str_replace(
                "{" . "MailingListID" . "}",
                $this->apiClient->getSerializer()->toPathValue($mailing_list_id),
                $resourcePath
            );
        }
        // path params
        if ($subscriber_id !== null) {
            $resourcePath = str_replace(
                "{" . "SubscriberID" . "}",
                $this->apiClient->getSerializer()->toPathValue($subscriber_id),
                $resourcePath
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\GetSubscriberByIdResponse',
                '/subscribers/{MailingListID}/find/{SubscriberID}.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\GetSubscriberByIdResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\GetSubscriberByIdResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation gettingSubscribers
     *
     * Getting subscribers
     *
     * @param string $format  (required)
     * @param string $mailing_list_id The ID of the mailing list where the subscribers belong. (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $status Specifies what type of subscriber statistics results will be returned. (required)
     * @param double $page Specifies the page of subscriber statistics results will be returned. (optional)
     * @param double $page_size Specifies the page size of subscriber statistics results will be returned. (optional)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\GettingSubscribersResponse
     */
    public function gettingSubscribers($format, $mailing_list_id, $apikey, $status, $page = null, $page_size = null)
    {
        list($response) = $this->gettingSubscribersWithHttpInfo($format, $mailing_list_id, $apikey, $status, $page, $page_size);
        return $response;
    }

    /**
     * Operation gettingSubscribersWithHttpInfo
     *
     * Getting subscribers
     *
     * @param string $format  (required)
     * @param string $mailing_list_id The ID of the mailing list where the subscribers belong. (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $status Specifies what type of subscriber statistics results will be returned. (required)
     * @param double $page Specifies the page of subscriber statistics results will be returned. (optional)
     * @param double $page_size Specifies the page size of subscriber statistics results will be returned. (optional)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\GettingSubscribersResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function gettingSubscribersWithHttpInfo($format, $mailing_list_id, $apikey, $status, $page = null, $page_size = null)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling gettingSubscribers');
        }
        // verify the required parameter 'mailing_list_id' is set
        if ($mailing_list_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $mailing_list_id when calling gettingSubscribers');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling gettingSubscribers');
        }
        // verify the required parameter 'status' is set
        if ($status === null) {
            throw new \InvalidArgumentException('Missing the required parameter $status when calling gettingSubscribers');
        }
        // parse inputs
        $resourcePath = "/lists/{MailingListID}/subscribers/{Status}.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // query params
        if ($page !== null) {
            $queryParams['Page'] = $this->apiClient->getSerializer()->toQueryValue($page);
        }
        // query params
        if ($page_size !== null) {
            $queryParams['PageSize'] = $this->apiClient->getSerializer()->toQueryValue($page_size);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($mailing_list_id !== null) {
            $resourcePath = str_replace(
                "{" . "MailingListID" . "}",
                $this->apiClient->getSerializer()->toPathValue($mailing_list_id),
                $resourcePath
            );
        }
        // path params
        if ($status !== null) {
            $resourcePath = str_replace(
                "{" . "Status" . "}",
                $this->apiClient->getSerializer()->toPathValue($status),
                $resourcePath
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\GettingSubscribersResponse',
                '/lists/{MailingListID}/subscribers/{Status}.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\GettingSubscribersResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\GettingSubscribersResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation removingASubscriber
     *
     * Removing a subscriber
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $mailing_list_id The ID of the mailing list to remove the subscriber from. (required)
     * @param \Swagger\Client\Model\RemovingASubscriberRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\RemovingASubscriberResponse
     */
    public function removingASubscriber($format, $apikey, $mailing_list_id, $body)
    {
        list($response) = $this->removingASubscriberWithHttpInfo($format, $apikey, $mailing_list_id, $body);
        return $response;
    }

    /**
     * Operation removingASubscriberWithHttpInfo
     *
     * Removing a subscriber
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $mailing_list_id The ID of the mailing list to remove the subscriber from. (required)
     * @param \Swagger\Client\Model\RemovingASubscriberRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\RemovingASubscriberResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function removingASubscriberWithHttpInfo($format, $apikey, $mailing_list_id, $body)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling removingASubscriber');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling removingASubscriber');
        }
        // verify the required parameter 'mailing_list_id' is set
        if ($mailing_list_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $mailing_list_id when calling removingASubscriber');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling removingASubscriber');
        }
        // parse inputs
        $resourcePath = "/subscribers/{MailingListID}/remove.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($mailing_list_id !== null) {
            $resourcePath = str_replace(
                "{" . "MailingListID" . "}",
                $this->apiClient->getSerializer()->toPathValue($mailing_list_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\RemovingASubscriberResponse',
                '/subscribers/{MailingListID}/remove.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\RemovingASubscriberResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\RemovingASubscriberResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation removingMultipleSubscribers
     *
     * Removing multiple subscribers
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $mailing_list_id The ID of the mailing list to remove the subscribers from. (required)
     * @param \Swagger\Client\Model\RemovingMultipleSubscribersRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\RemovingMultipleSubscribersResponse
     */
    public function removingMultipleSubscribers($format, $apikey, $mailing_list_id, $body)
    {
        list($response) = $this->removingMultipleSubscribersWithHttpInfo($format, $apikey, $mailing_list_id, $body);
        return $response;
    }

    /**
     * Operation removingMultipleSubscribersWithHttpInfo
     *
     * Removing multiple subscribers
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $mailing_list_id The ID of the mailing list to remove the subscribers from. (required)
     * @param \Swagger\Client\Model\RemovingMultipleSubscribersRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\RemovingMultipleSubscribersResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function removingMultipleSubscribersWithHttpInfo($format, $apikey, $mailing_list_id, $body)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling removingMultipleSubscribers');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling removingMultipleSubscribers');
        }
        // verify the required parameter 'mailing_list_id' is set
        if ($mailing_list_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $mailing_list_id when calling removingMultipleSubscribers');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling removingMultipleSubscribers');
        }
        // parse inputs
        $resourcePath = "/subscribers/{MailingListID}/remove_many.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($mailing_list_id !== null) {
            $resourcePath = str_replace(
                "{" . "MailingListID" . "}",
                $this->apiClient->getSerializer()->toPathValue($mailing_list_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\RemovingMultipleSubscribersResponse',
                '/subscribers/{MailingListID}/remove_many.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\RemovingMultipleSubscribersResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\RemovingMultipleSubscribersResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation unsubscribingSubscribersFromAccount
     *
     * Unsubscribing subscribers from account
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param \Swagger\Client\Model\UnsubscribingSubscribersFromAccountRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\UnsubscribingSubscribersFromAccountResponse
     */
    public function unsubscribingSubscribersFromAccount($format, $apikey, $body)
    {
        list($response) = $this->unsubscribingSubscribersFromAccountWithHttpInfo($format, $apikey, $body);
        return $response;
    }

    /**
     * Operation unsubscribingSubscribersFromAccountWithHttpInfo
     *
     * Unsubscribing subscribers from account
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param \Swagger\Client\Model\UnsubscribingSubscribersFromAccountRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\UnsubscribingSubscribersFromAccountResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function unsubscribingSubscribersFromAccountWithHttpInfo($format, $apikey, $body)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling unsubscribingSubscribersFromAccount');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling unsubscribingSubscribersFromAccount');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling unsubscribingSubscribersFromAccount');
        }
        // parse inputs
        $resourcePath = "/subscribers/unsubscribe.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\UnsubscribingSubscribersFromAccountResponse',
                '/subscribers/unsubscribe.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\UnsubscribingSubscribersFromAccountResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\UnsubscribingSubscribersFromAccountResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation unsubscribingSubscribersFromMailingList
     *
     * Unsubscribing subscribers from mailing list
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $mailing_list_id The ID of the mailing list to add subscribers to. (required)
     * @param \Swagger\Client\Model\UnsubscribingSubscribersFromMailingListRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\UnsubscribingSubscribersFromMailingListResponse
     */
    public function unsubscribingSubscribersFromMailingList($format, $apikey, $mailing_list_id, $body)
    {
        list($response) = $this->unsubscribingSubscribersFromMailingListWithHttpInfo($format, $apikey, $mailing_list_id, $body);
        return $response;
    }

    /**
     * Operation unsubscribingSubscribersFromMailingListWithHttpInfo
     *
     * Unsubscribing subscribers from mailing list
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $mailing_list_id The ID of the mailing list to add subscribers to. (required)
     * @param \Swagger\Client\Model\UnsubscribingSubscribersFromMailingListRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\UnsubscribingSubscribersFromMailingListResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function unsubscribingSubscribersFromMailingListWithHttpInfo($format, $apikey, $mailing_list_id, $body)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling unsubscribingSubscribersFromMailingList');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling unsubscribingSubscribersFromMailingList');
        }
        // verify the required parameter 'mailing_list_id' is set
        if ($mailing_list_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $mailing_list_id when calling unsubscribingSubscribersFromMailingList');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling unsubscribingSubscribersFromMailingList');
        }
        // parse inputs
        $resourcePath = "/subscribers/{MailingListID}/unsubscribe.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($mailing_list_id !== null) {
            $resourcePath = str_replace(
                "{" . "MailingListID" . "}",
                $this->apiClient->getSerializer()->toPathValue($mailing_list_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\UnsubscribingSubscribersFromMailingListResponse',
                '/subscribers/{MailingListID}/unsubscribe.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\UnsubscribingSubscribersFromMailingListResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\UnsubscribingSubscribersFromMailingListResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation unsubscribingSubscribersFromMailingListAndASpecifiedCampaign
     *
     * Unsubscribing subscribers from mailing list and a specified campaign
     *
     * @param string $format  (required)
     * @param string $campaign_id The ID of the campaign that was sent to the specific mailing list. (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $mailing_list_id The ID of the mailing list to remove the subscriber from. (required)
     * @param \Swagger\Client\Model\UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignResponse
     */
    public function unsubscribingSubscribersFromMailingListAndASpecifiedCampaign($format, $campaign_id, $apikey, $mailing_list_id, $body)
    {
        list($response) = $this->unsubscribingSubscribersFromMailingListAndASpecifiedCampaignWithHttpInfo($format, $campaign_id, $apikey, $mailing_list_id, $body);
        return $response;
    }

    /**
     * Operation unsubscribingSubscribersFromMailingListAndASpecifiedCampaignWithHttpInfo
     *
     * Unsubscribing subscribers from mailing list and a specified campaign
     *
     * @param string $format  (required)
     * @param string $campaign_id The ID of the campaign that was sent to the specific mailing list. (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $mailing_list_id The ID of the mailing list to remove the subscriber from. (required)
     * @param \Swagger\Client\Model\UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function unsubscribingSubscribersFromMailingListAndASpecifiedCampaignWithHttpInfo($format, $campaign_id, $apikey, $mailing_list_id, $body)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling unsubscribingSubscribersFromMailingListAndASpecifiedCampaign');
        }
        // verify the required parameter 'campaign_id' is set
        if ($campaign_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $campaign_id when calling unsubscribingSubscribersFromMailingListAndASpecifiedCampaign');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling unsubscribingSubscribersFromMailingListAndASpecifiedCampaign');
        }
        // verify the required parameter 'mailing_list_id' is set
        if ($mailing_list_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $mailing_list_id when calling unsubscribingSubscribersFromMailingListAndASpecifiedCampaign');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling unsubscribingSubscribersFromMailingListAndASpecifiedCampaign');
        }
        // parse inputs
        $resourcePath = "/subscribers/{MailingListID}/{CampaignID}/unsubscribe.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($campaign_id !== null) {
            $resourcePath = str_replace(
                "{" . "CampaignID" . "}",
                $this->apiClient->getSerializer()->toPathValue($campaign_id),
                $resourcePath
            );
        }
        // path params
        if ($mailing_list_id !== null) {
            $resourcePath = str_replace(
                "{" . "MailingListID" . "}",
                $this->apiClient->getSerializer()->toPathValue($mailing_list_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignResponse',
                '/subscribers/{MailingListID}/{CampaignID}/unsubscribe.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updatingASubscriber
     *
     * Updating a subscriber
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $mailing_list_id The ID of the mailing list that contains the subscriber (required)
     * @param string $subscriber_id The id of the subscriber to be updated (required)
     * @param \Swagger\Client\Model\UpdatingASubscriberRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\UpdatingASubscriberResponse
     */
    public function updatingASubscriber($format, $apikey, $mailing_list_id, $subscriber_id, $body)
    {
        list($response) = $this->updatingASubscriberWithHttpInfo($format, $apikey, $mailing_list_id, $subscriber_id, $body);
        return $response;
    }

    /**
     * Operation updatingASubscriberWithHttpInfo
     *
     * Updating a subscriber
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $mailing_list_id The ID of the mailing list that contains the subscriber (required)
     * @param string $subscriber_id The id of the subscriber to be updated (required)
     * @param \Swagger\Client\Model\UpdatingASubscriberRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\UpdatingASubscriberResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatingASubscriberWithHttpInfo($format, $apikey, $mailing_list_id, $subscriber_id, $body)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling updatingASubscriber');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling updatingASubscriber');
        }
        // verify the required parameter 'mailing_list_id' is set
        if ($mailing_list_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $mailing_list_id when calling updatingASubscriber');
        }
        // verify the required parameter 'subscriber_id' is set
        if ($subscriber_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $subscriber_id when calling updatingASubscriber');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling updatingASubscriber');
        }
        // parse inputs
        $resourcePath = "/subscribers/{MailingListID}/update/{SubscriberID}.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($mailing_list_id !== null) {
            $resourcePath = str_replace(
                "{" . "MailingListID" . "}",
                $this->apiClient->getSerializer()->toPathValue($mailing_list_id),
                $resourcePath
            );
        }
        // path params
        if ($subscriber_id !== null) {
            $resourcePath = str_replace(
                "{" . "SubscriberID" . "}",
                $this->apiClient->getSerializer()->toPathValue($subscriber_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\UpdatingASubscriberResponse',
                '/subscribers/{MailingListID}/update/{SubscriberID}.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\UpdatingASubscriberResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\UpdatingASubscriberResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
