<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Class NF_VimeoUploader_Fields_Dropzone
 */
class NF_VimeoUploader_Fields_Dropzone extends NF_Abstracts_Input {

  /**
   * The ticket response from the Vimeo API containing the Vimeo
   * upload target and the ticket complete URI.
   *
   * @var object
   */
  private $_ticket;


  /**
   * Params to be sent in Vimeo request
   *
   * @var array
   */
  protected $_params;

  /* Ninja Forms class variables */
  protected $_name = 'vimeo_uploader_dropzone';

  protected $_section = 'vimeo_uploader';

  protected $_type = 'vimeo_uploader_dropzone';

  protected $_icon = 'upload';

  protected $_settings_exclude = array('input_limit_set', 'disable_input', 'placeholder', 'default');

  protected $_templates = 'vimeo_uploader_dropzone';

  public function __construct() {
    parent::__construct();

    add_filter( 'ninja_forms_field_settings_groups', array( $this, 'add_setting_group' ) );
    add_action( 'manage_posts_custom_column', array( $this, 'add_submission_custom_columns' ), 10, 2 );

    add_filter('ninja_forms_localize_fields', array( $this, 'fetch_ticket') );
    add_filter('ninja_forms_localize_fields_preview', array( $this, 'fetch_ticket') );

    add_action( 'ninja_forms_enqueue_scripts', array( $this, 'load_assets') );

    add_filter('ninja_forms_display_field', array( $this, 'should_display_field') );


    // Can add settings to this field if you'd like.
    // http://developer.ninjaforms.com/codex/settings-configuration/

    $this->_nicename = __( 'Video Dropzone', 'ninja-forms-vimeo-uploader' );
  }

  /**
   * Adds a settings group to the field drawer
   * @param [type] $groups [description]
   */
  public function add_setting_group( $groups ) {
    $groups[ 'vimeo_upload_settings' ] = array(
        'id' => 'vimeo_upload_settings',
        'label' => __( 'Vimeo Upload Settings', 'ninja-forms-vimeo-uploader' ),
    );

    return $groups;
  }


  /**
   * Don't show the field if the user does not have the proper permissions.
   *
   * @param  [type] $field [description]
   * @return [type]        [description]
   */
  public function should_display_field( $field ) {
    if ( $field->get_setting('type') != 'vimeo_uploader_dropzone') {
      return TRUE;
    }

    $form_id = $field->get_setting('parent_id');
    $actions = Ninja_Forms()->form( $form_id )->get_actions();

    if ( ! empty( $actions) ) {
      foreach ( $actions as $action ) {
        if ( $action->get_setting('type') == 'vimeo_uploader' ) {
          $cap = $action->get_setting('vimeo_uploader_min_user_role');

          $capability = apply_filters('nf-vimeo-uploader/upload-capability', $cap );

          if ( $capability !== 'guest' ) {
            if ( ! current_user_can( $capability ) ) {
              echo __('You do not have permission to upload a video.', 'ninja-forms-vimeo-uploader');
              return FALSE;
            }
          }
        }
      }
    }

    return TRUE;
  }


  /**
   * Adds localized vars to the nfForms javascript object.
   *
   * @param  [type] $field [description]
   * @return [type]        [description]
   */
  public function fetch_ticket( $field ) {

    $field_type = is_array($field) ? $field['settings']['type'] : $field->get_settings('type');

    // Only care about dropzones
    if ( $field_type !== 'vimeo_uploader_dropzone') {
      return $field;
    }

    try {
      $uploader = new NF_VimeoUploader_Actions_VimeoUploader;
      $ticket = $uploader->get_streaming_upload_ticket();
    } catch (Exception $e) {
      echo $e->getMessage();
      return $field;
    }

    if ( is_array($field) ) {
      $field['settings']['complete_uri'] = $ticket->complete_uri;
      $field['settings']['upload_link']  = $ticket->upload_link_secure;
      $field['settings']['dropzone_message'] = apply_filters( 'nf-vimeo-uploader/dropzone-message', __('Drop video file here to upload', 'ninja-forms-vimeo-uploader') );
      $field['settings']['upload_complete_message'] = apply_filters('nf-vimeo-uploader/upload-complete-message', __('Your video has been uploaded.', 'ninja-forms-vimeo-uploader') );
    } else {
      $settings = array(
        'complete_uri'            => $ticket->complete_uri,
        'upload_link'             => $ticket->upload_link_secure,
        'dropzone_message'        => apply_filters( 'nf-vimeo-uploader/dropzone-message', __('Drop video file here to upload', 'ninja-forms-vimeo-uploader') ),
        'upload_complete_message' => apply_filters('nf-vimeo-uploader/upload-complete-message', __('Your video has been uploaded.', 'ninja-forms-vimeo-uploader') ),
      );
      $field->update_settings( $settings );
    }

    // $capability = apply_filters('nf-vimeo-uploader/upload-capability', $data['minimum_user_role']);

    // if ($capability !== 'guest') {
    //   if ( ! current_user_can( $capability ) ) {
    //     return __('You do not have permission to upload a video.', 'ninja-forms-vimeo-uploader');
    //   }
    // }

    return $field;
  }


  /**
   * Load assets for this field
   *
   * @return void
   */
  public function load_assets($data) {

    $fields = Ninja_Forms()->form( $data['form_id'] )->get_fields();

    foreach ( $fields as $field ) {
      if ( $field->get_setting('type') == 'vimeo_uploader_dropzone' ) {
        wp_register_script('resumable', NF_VimeoUploader::$url . 'includes/assets/js/resumable.js', array('jquery') );
        wp_register_script('progressbar', NF_VimeoUploader::$url . 'includes/assets/js/progressbar.min.js', array('jquery') );
        wp_register_script('nf-vimeo-uploader', NF_VimeoUploader::$url . 'includes/assets/js/nf-vimeo-uploader.js', array('jquery', 'nf-front-end', 'resumable', 'progressbar') );

        wp_enqueue_script('resumable' );
        wp_enqueue_script('progressbar');
        wp_enqueue_script('nf-vimeo-uploader' );

        wp_enqueue_style( 'ninja-forms-vimeo-uploader', NF_VimeoUploader::$url . 'includes/assets/css/style.css' );
      }
    }
  }


  /**
   * Outputs the Vimeo video link to the
   * Video Dropzone column on the admin Submissions page
   *
   * @param [type] $column [description]
   * @param [type] $sub_id [description]
   */
  public function add_submission_custom_columns($column, $sub_id) {
    $sub = Ninja_Forms()->form()->get_sub( $sub_id );

    if ( is_numeric( $column ) ) {
      $value = $sub->get_field_value( $column );
      $field = Ninja_Forms()->form()->get_field( $column );

      if ( $field->get_setting( 'type' ) == 'vimeo_uploader_dropzone') {
        $extra = $sub->get_extra_value( 'vimeo_uploader' );

        if ( ! empty( $extra['vimeo_url'] ) ) {
          printf('<br /><a href="%1$s" title="View on Vimeo" target="_blank">%2$s</a>', $extra['vimeo_url'], $extra['vimeo_url']);
        }
      }
    }
  }
}
