<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Class NF_VimeoUploader_Database_Upgrade
 */
final class NF_VimeoUploader_Database_Upgrade {

  public function __construct() {
    add_filter( 'ninja_forms_upgrade_settings', array( $this, 'convert_form_settings_to_action' ) );
    add_filter( 'ninja_forms_upgrade_field', array( $this, 'upgrade_dropzone_field' ) );
    add_filter( 'ninja_forms_upgrade_action_vimeouploader', array( $this, 'upgrade_action_settings') );
    add_filter( 'ninja_forms_after_upgrade_settings', array( $this, 'upgrade_plugin_settings') );
  }

  /**
   * Copy over the access token here.
   *
   * @param  [type] $import [description]
   * @return [type]         [description]
   */
  public function upgrade_plugin_settings($import) {

    $plugin_settings = get_option( 'ninja_forms_settings' );

    if ( isset( $plugin_settings['nf_vimeo_uploader_access_token'] ) && ! empty( $plugin_settings['nf_vimeo_uploader_access_token'] ) ) {

      Ninja_Forms()->update_settings(
        array(
          'vimeo_uploader_access_token' => $plugin_settings['nf_vimeo_uploader_access_token']
        )
      );
    }

    return $import;
  }

  /**
   * Convert our old form settings to the new format for NF Vimeo Uploader 3
   * @param  [type] $form_data [description]
   * @return [type]            [description]
   */
  public function convert_form_settings_to_action( $form_data ) {
    $dropzone_pointer;
    $title;
    $description;

    foreach ( $form_data['fields'] as $i => $field ) {
        switch( $field['type'] ){
            case 'vimeo_uploader_title':
                $title = '{field:vimeo_uploader_title_' . $field[ 'id' ] . '}';
                break;
            case 'vimeo_uploader_description':
                $description = '{field:vimeo_uploader_description_' . $field[ 'id' ] . '}';
                break;
            case 'vimeo_uploader_file_dropzone':
                $form_data[ 'fields' ][ $i ][ 'type' ] = 'vimeo_uploader_dropzone';
                $dropzone_pointer = $i;
                break;
        }
    }

    if ( isset( $dropzone_pointer ) ) {

        $dropzone = $form_data[ 'fields' ][ $dropzone_pointer ];

        $new_action = array(
            'type'   => 'vimeo_uploader',
            'label'  => __( 'Upload to Vimeo', 'ninja-forms-vimeo-uploader' ),
            'active' => TRUE,
            'vimeo_uploader_min_user_role' => $dropzone['data']['minimum_user_role'],
            'vimeo_uploader_video_privacy' => $dropzone['data']['video_privacy_settings'],
            'vimeo_uploader_add_to_collection' => $dropzone['data']['add_to_vimeo_album'],
            'vimeo_uploader_title_processed' => ( isset( $title ) ) ? $title : '',
            'vimeo_uploader_description_processed' => ( isset( $description ) ) ? $description : ''
        );

      // convert /users/485292/albums/3272658*|*Hidden Test
      if ( isset( $dropzone['data']['vimeo_albums'] ) && ! empty( $dropzone['data']['vimeo_albums'] ) ) {
        $matches = array();

        preg_match_all('%albums\/([a-zA-Z0-9]+)%', $dropzone['data']['vimeo_albums'], $matches);

        if ( isset( $matches[1] ) && ! empty( $matches[1] ) ) {
          $collections = array();

          foreach( $matches[1] as $album_id ) {
            $collections[] = 'https://vimeo.com/album/' . $album_id;
          }

          $collection_urls = implode($collections, ',');

          $new_action['vimeo_uploader_collections'] = $collection_urls;
        }
      }

      $form_data[ 'actions' ][] = $new_action;
    }

    return $form_data;
  }


  /**
   * Rename and remove old data associate with the dropzone field
   * which now belongs with an action
   *
   * @param  [type] $field [description]
   * @return [type]        [description]
   */
  public function upgrade_dropzone_field( $field ) {
    if ( $field['type'] == 'vimeo_uploader_dropzone' ) {
      unset($field['add_to_vimeo_album']);
      unset($field['vimeo_albums']);
      unset($field['minimum_user_role']);
      unset($field['video_privacy_settings']);
    }

    return $field;
  }

  /**
   * Re-add the underscore, which is remove by NF core for some reason...
   * @param  [type] $action_settings [description]
   * @return [type]                  [description]
   */
  public function upgrade_action_settings( $action_settings ) {
    $action_settings['type'] = 'vimeo_uploader';
    return $action_settings;
  }
}
