<?php

if ( ! defined( 'ABSPATH' ) ) exit;

class NF_VimeoUploader_Config_MergeTags extends NF_Abstracts_MergeTags {
  protected $id = 'vimeo_uploader';

  private $vimeo_url = '';

  public function __construct() {
    parent::__construct();
    $this->title = __( 'Vimeo Uploader', 'ninja-forms-vimeo-uploader' );

    $this->merge_tags = array(
      'vimeo_url' => array(
          'id' => 'vimeo_url',
          'tag' => '{vimeo_uploader:vimeo_url}',
          'label' => __( 'Vimeo URL', 'ninja-forms-vimeo-uploader' ),
          'callback' => 'get_vimeo_url'
      ),
    );
  }

  public function set_vimeo_url( $vimeo_url = '' ) {
    $this->vimeo_url = $vimeo_url;
  }

  public function get_vimeo_url() {
    return $this->vimeo_url;
  }
}
